<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.
	
	Translator Swedish: Anders Rundkvist (Sweden)
	
	02.01.2022
*/

// New Variables

    $version    = "V 4.10.9";
    $encoding   = "utf-8";
    $language   = "Svenska";
    $lang_short = "sv";
    $cssStyle	= "mygbook-style-4108.css";
    
// Cookie Note to User

  	$cmsg[0] = 'Om du väljer ett annat språk kommer dina inställningar att sparas i en cookie. (Innehåll i cookien: "de", "en", "fr", "it", "nl", "sv", "pl", "pt", "cz" eller "sk".) - Cookien tas automatiskt bort när du stänger ned din webbläsare.';
    
// Text Thank-You-E-Mail to guest

	$thankYou[0] = 'Kära gäst,<br /><br />tack för ditt inlägg i "'.$_SERVER['SERVER_NAME'].'".<br /><br />Jag hoppas på att få höra av dig igen snart!<br /><br />Med vänlig hälsning,<br />Administratören';

// EU GDPR

    $dsgvo[0] = 'Jag godkänner lagring och bearbetning av mina uppgifter <span class="nowrap">enligt EU-GDPR.</span>';
    $dsgvo[1] = 'Integritetspolicy';

// Admin Messages

    $amsg[0] = 'Admin - Kontrollpanel';
    $amsg[1] = 'Logga in!';
    $amsg[2] = 'Inlägg';
    $amsg[3] = 'Inlägg och kommentarer';
    $amsg[4] = 'Egenskaper';
    $amsg[5] = 'Admin- + Login data';
    $amsg[6] = 'Generell Konfiguration';
    $amsg[7] = 'CSS Stil:';
    $amsg[8] = 'Standard stil';
    $amsg[9] = 'Skapa ny stil';
    $amsg[10] = 'Ta bort stil';
    $amsg[11] = 'Redigera stil';
    $amsg[12] = 'Mall';
    $amsg[13] = 'Standard mall';
    $amsg[14] = 'Skapa ny mall';
    $amsg[15] = 'Ta bort mall';
    $amsg[16] = 'Redigera mall';
    $amsg[17] = 'Emojis';
    $amsg[18] = 'Visa emojis';
    $amsg[19] = 'Lägg till emoji';
    $amsg[20] = 'Förbjudna ord';
    $amsg[21] = 'Visa förbjudna ord';
    $amsg[22] = 'Lägg till förbjudet ord';
    $amsg[23] = 'Säkerhetskopia';
    $amsg[24] = 'Skapa säkerhetskopia';
    $amsg[25] = 'Återställningsfiler';
    $amsg[26] = 'Diverse';
    $amsg[27] = 'Statistik';
    $amsg[28] = 'Gästbokskydd';
    $amsg[29] = 'Logga ut';
    $amsg[30] = 'Gästboksinlägget har frisläppts.';
    $amsg[31] = 'Aktiveringskoden är fel, inget inlägg har blivit aktiverat.';
    $amsg[32] = 'Paus';
    $amsg[33] = 'Redigera inlägg';
    $amsg[34] = 'Guestbook entry you write a comment';
    $amsg[35] = 'Visa nyckelord';
    $amsg[36] = 'Lägg till nyckelord';
    $amsg[37] = 'IP blockeringar';
    $amsg[38] = 'Spamfilter';
    $amsg[39] = 'Inga spärrade IP-adresser';
    $amsg[40] = 'Visa lista på blockerade IP-adresser';
    $amsg[41] = 'NEJ';
    $amsg[42] = 'Alla gästboksinlägg frisläppta?';
    $amsg[43] = 'Blockerade:';
    $amsg[44] = 'Senaste Säkerhetskopiering:';
    $amsg[45] = 'Inga spamord förekommer.';
    $amsg[46] = 'Lista med nyckelord som identifierar en post som skräppost.';
    $amsg[47] = 'Aktivera spamdetektering med nyckelord?';
    $amsg[48] = 'Denna funktion måste aktiveras<br />in den "Generella Konfigurationen".';
    $amsg[49] = 'Nyckelord';
    $amsg[50] = 'Ange önskat nyckelord';
    $amsg[51] = 'Spamblockerade IP-adresser:';
    $amsg[52] = 'Inga IP-adresser är för närvarande blockerade.';
    $amsg[53] = 'IP-adresser som anges här raderas automatiskt efter '.$delete_spamIps.' dagar.<br />Om du vill spara vissa IP-adresser under en längre tid,<br />klicka på den gröna bocken för den aktuella IP-adressen.';
    $amsg[54] = 'IP:';
    $amsg[55] = 'Datum:';
    $amsg[56] = 'Tid:';
    $amsg[57] = 'Ta bort IP:';
    $amsg[58] = 'Ta bort?';
    $amsg[59] = 'Aktivera banner';
    $amsg[60] = 'IP raderas efter '.$delete_spamIps.' dagar. Förhindra?';
    $amsg[61] = 'IP raderas inte automatiskt! Vill du ändra det?';
    $amsg[62] = 'Lägg till IP:';
    $amsg[63] = 'Ta bort / Spara';
    $amsg[64] = 'Redigera banner';
    $amsg[65] = 'Spara den bifogade säkerhetskopian.';
    $amsg[66] = 'Säkerhetskopieringen av databasposterna i gästboken<br />har skapats.';
    $amsg[67] = 'En kopia av säkerhetskopian skickades via e-post.';
    $amsg[68] = 'Spara e-postbilagan på ett säkert ställe.';
    $amsg[69] = 'Välj bland de angivna filerna.';
    $amsg[70] = 'Följande säkerhetskopieringsfiler är tillgängliga:';
    $amsg[71] = 'Filnamn:';
    $amsg[72] = 'Blockering av gästbokspost!';
    $amsg[73] = 'Markerad för återställning';
    $amsg[74] = '<p class="zentriert">När du återställer gästboksposter från en säkerhetskopia</p><p class="zentriert">raderas alla befintliga databasposter!</p>';
    $amsg[75] = 'Frisläpp av gästboksposten!';   
    $amsg[76] = 'Lägg till säkerhetskopian som laddades upp med FTP,<br />till listan:';    
    $amsg[77] = 'Alla filer som finns i katalogen "backup"<br />registreras i databasen.';    
    $amsg[78] = 'Spara filnamn';    
    $amsg[79] = 'Du fyllde inte i alla fält.';    
    $amsg[80] = 'Under "Generell Konfiguration" har du aktiverat alternativet:<br />"Ta bort säkerhetskopior från servern efter att ha skickat dem via e-post".<br /><br />Den nyskapade säkerhetskopieringen raderades därför.<br / ><br />Det är därför som säkerhetskopian som skickas via e-post ska sparas separat på en säker plats.';    
    $amsg[81] = 'En ny säkerhetskopia hittades,<br />som ännu inte är registrerad i databasen.<br /><br />Välj filen i rullgardinsmenyn<br /> och klicka på "Spara filnamn".';
    $amsg[82] = 'Hjälp (på engelska)';
    $amsg[83] = 'Under "Generell Konfiguration" har du aktiverat alternativet:<br />"Ta bort säkerhetskopior från servern efter att ha skickat dem via e-post".<br /><br />Därför raderades alla myPHP Guestbook säkerhetskopior på servern,<br />inklusive säkerhetskopian som bara användes för att återställa gästboksinläggen.';
    $amsg[84] = 'Inlägg';
    $amsg[85] = 'från';
    $amsg[86] = 'skrev den';
    $amsg[87] = 'Ingen säkerhetskopia tillgänglig än.<br />Du bör skapa en säkerhetskopia av dina gästboksposter regelbundet.';
    $amsg[88] = 'Obs!\\n\\nFörutom databasinmatningen raderas också bildfilen från servern.\\n\\nHandlingen kan inte avbrytas!\\n\\nVill du fortsätta?';
    $amsg[89] = 'Släpp lös text?';
    $amsg[90] = 'Släpp lös bild?';
    $amsg[91] = 'Uppladdade bilder';
    $amsg[92] = 'Redigera filöverföringar';
    $amsg[93] = 'Här kan du se och redigera bilderna i gästboken.';
    $amsg[94] = 'Lägg till en ny bild manuellt';
    $amsg[95] = 'Välj filen som ska raderas..\\n\\nObservera!\\n\\nÅtgärden kan inte avbrytas!\\n\\nVill du fortsätta?';
    $amsg[96] = 'Redigera post';
    $amsg[97] = 'Titel:';
    $amsg[98] = 'Här kan du se och redigera bilderna i gästboken.';
    $amsg[99] = 'Uppladdningsfunktionen för bilder i gästboksinlägg är inte aktiverad.';
    $amsg[100] = 'Om du vill använda den här funktionen måste du aktivera "BBCodes" och "Bilder i gästboksinlägg" under "Generell Konfiguration".';
    $amsg[101] = 'Redigera gästbilddatabasposten.<br />Korrigera justeringen av *jpg-filer om det behövs.';
    $amsg[102] = 'Lägg till en ny bild i databasen';
    $amsg[103] = 'Inställningar för uppladdningar';
    $amsg[104] = 'Här kan du göra inställningar för filuppladdningar.';
    $amsg[105] = '<br />Maximal storlek på filen som ska laddas upp i MB:<br /><span class="size-10">(1 - 6 MB | Inställningen är beroende på serverkonfiguration. -<br /><strong class="red">Se även anteckningen under "Info"!</strong>)</span>';
    $amsg[106] = '<br />Bildens maximala bredd i pixlar:<br /><span class="size-10">(Den övre gränsen är för närvarande inställd på';
    $amsg[107] = '<br />och varierar beroende på den valda bredden på gästboken)</span>';
    $amsg[108] = '<br />Bildens maximala höjd i pixlar:';
    $amsg[109] = '<br />Bildkvalitet i procent:<br /><span class="size-10">(70 - 80% rekommenderas)</span>';
    $amsg[110] = 'Här kan du ändra mallens grundinställningar.';
    $amsg[111] = 'Aktivera citering av inlägg:';
    $amsg[112] = 'Inga bilder tillgängliga än.';
    $amsg[113] = 'Val av webbsäkra färger och gråtoner';
    $amsg[114] = 'Webbsäkra färger och gråtoner';
    $amsg[115] = 'De 216 färgerna och 256 gråtoner som anses vara "webbsäkra".';
    $amsg[116] = 'Om du inte anger en färg anges "transparent" automatiskt.';
    $amsg[117] = '<br />Maximalt antal tillåtna filöverföringar <br /> per inlägg:<br /><span class="size-10">(20 minuters IP-blockering för uppladdningar över gränsen.)</span>';
    $amsg[118] = 'Stäng fönstret';
    $amsg[119] = 'Info';
    $amsg[120] = 'E-postadress';
    $amsg[121] = 'obligatoriskt fält.<br />E-postadresser ska...';
    $amsg[122] = 'är inte ett';
    $amsg[123] = 'är ett';
    $amsg[124] = 'visas:';
    $amsg[125] = 'inte visas:';
    $amsg[126] = 'Inmatningsfält för "Plats"';
    $amsg[127] = 'Inmatningsfält för "Land"';
    $amsg[128] = '<strong>Inaktivera</strong> inmatningsfält för "Ämne":';
    $amsg[129] = 'Ursprung';
    $amsg[130] = 'E-postkonfiguration';
    $amsg[131] = 'Avsändaradress för alla e-postmeddelanden som skickas automatiskt<br />av programmet och texten som skickas till gästen via e-post<br />efter ett inlägg i gästboken.';
    $amsg[132] = 'Redigera e-postadress';
    $amsg[133] = 'Tyska';
    $amsg[134] = 'Engelska';
    $amsg[135] = 'E-posttext';
    $amsg[136] = 'För att kunna ändra denna text så måste:<br /><strong>"Skicka e-post till gäst"</strong> under <strong>"Generell Konfiguration"</strong><br />vara aktiverat.';
    $amsg[137] = 'E-postsändning aktiverad?';
    $amsg[138] = 'Redigera texten';
    $amsg[139] = 'Platshållare för "Plats | Land".';
    $amsg[140] = 'Platshållare för "från:"';
    $amsg[141] = 'Åtgärden slutfördes framgångsrikt';
    $amsg[142] = 'Visa länk till admindelen på gästboksidorna:';
    $amsg[143] = 'Platshållare för radbrytning i HTML-tagg "&#60;br /&#62;"';
    $amsg[144] = 'Tryck på valfri tangent på tangentbordet';
    $amsg[145] = 'Ta bort sparade IP-adresser från gamla inlägg?';
    $amsg[146] = 'Ändra avsändarens e-postadress<br />eller texten för "Tack för e-post"?';
    $amsg[147] = 'Texten till "Tack för e-post" samt avsändaren för alla e-postmeddelanden som automatiskt skickas av programmet kan ändras under länken: <div class="text-center"><br />"<a href="?action=thanks_email&#38;show=guest_mail&#38;'.session_name().'='.session_id().'" title="Klicka på länken för att ändra">E-postkonfiguration</a>"</div>.';
    $amsg[148] = 'Länk till sida för gästboksinlägg:';
    $amsg[149] = '<p>Att välja alternativknappar avgör om länken ovanför och under gästboksposterna till sidan för nya poster ska visas som klickbar text eller som en knapp eller inte alls (bloggläge).</p>
<p>I motsvarande textfält kan du ange hur den klickbara texten eller knappens etikett ska läsas. </p>
<p>Texten kan bestå av högst 35 tecken.</p>
<p>Om du inte anger någon text används standardtexten från språkfilen.</p>
För ytterligare förklaringar, se länken <a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-LinkButton" title="Länk öppnar Hjälp-filen">"Hjälp", avsnitt IV.3.2.2</a>.';
    $amsg[150] = 'Säkerhetsförslag';
    $amsg[151] = 'E-postadressen som visas som <strong>avsändare</strong> för alla e-postmeddelanden som automatiskt skickas av programmet.';
    $amsg[152] = 'E-postadressen som används som avsändare av e-postmeddelanden som automatiskt skickas av programmet (e-postrubriken "Från") bör helst inte vara identisk med administratörens e-postadressen.';
    $amsg[153] = 'Ta en titt i din e-postinkorg.';
    $amsg[154] = 'Inloggningen är inaktiverad!';
    $amsg[155] = '<b>Obs!</b><br /><br />Det gjordes ';
    $amsg[156] = ' felaktiga försök att logga in på admindelen.<br /><br />Inloggningsområdet har blockerats och bör förbli låst i några dagar för att skydda det från ytterligare försök till intrång från obehöriga.<br /><br />inloggningen aktiveras automatiskt efter ';
    $amsg[157] = ' dagar. Om du vill öppna upp din inloggning tidigare klickar du på följande länk:';
    $amsg[158] = 'Inläggen har sparats.';
    $amsg[159] = '<strong>Inaktivera</strong> kryssrutan "Skicka e-post till gäst"<br />när någon kommenterar gästens inlägg:';
    $amsg[160] = 'Skicka e-post till gäst';
    $amsg[161] = 'Om det här alternativet är aktiverat visas en kryssruta under textfältet för ett nytt inlägg där gästen kan välja om den automatiskt vill informeras via e-post om en kommentar görs till dennes gästboksinlägg.<br /><br /><strong>Obs!</strong>Om inmatningsfältet för att ange en e-postadress är dolt, avaktiveras också alternativet "Skicka e-post till gäst" automatiskt!';
    $amsg[162] = 'Ditt gästboksinlägg';
    $amsg[163] = 'Hej!<br /><br />Ett svar på ditt inlägg i gästboken på "'.$_SERVER['SERVER_NAME'].'" har postats. Besök gästboken för att se svaret.<br /><br />Med vänliga hälsningar<br />Administratören';
    $amsg[164] = 'Gästen kommer att informeras om administratörens kommentar via e-post.';
    $amsg[165] = 'Skicka e-post till gäst om hans meddelande kommenteras av admin?';
    $amsg[166] = 'Skicka e-post till gäst om hans meddelande citeras?';
    $amsg[167] = 'JA';
    $amsg[168] = 'NEJ, redan gjort.';
    $amsg[169] = 'Textlänk';
    $amsg[170] = 'Html knapp';
    $amsg[171] = 'Text för länken eller knappen:';
    $amsg[172] = 'Ta bort länk (bloggläge)';
    $amsg[173] = 'Holländska';
    $amsg[174] = 'Portugisiska';
    $amsg[175] = 'Citatfunktion';
    $amsg[176] = 'Om gästboken körs i det så kallade "Bloggläget" kan citatfunktionen inte aktiveras och inaktiveras automatiskt.';
    $amsg[177] = 'Administratörsblogg';
    $amsg[178] = 'Här kan du skriva ett nytt meddelande.';
    $amsg[179] = 'Använd gästboken i bloggläge?';
    $amsg[180] = 'Bloggläge';
    $amsg[181] = '<p>Länkarna på den offentliga sidan med gästboksinläggen ("index.php") och sidan för nya inlägg ("insert.php") är dolda.</p>
<p>Inmatningsformuläret ("insert.php") och sidan för bilduppladdningar ("pic.upload.php") är inte längre åtkomliga på webben.</p>
<p>Nya inlägg och uppladdningar av bilder är endast möjligt via administratören här i kontrollpanelen.</p>
Ställ in bloggläget under länken "<a href="?action=guestbook_options&#38;'.session_name().'='.session_id().'" title="Klicka på länken för att ändra">Generell Konfiguration</a>".';
    $amsg[182] = 'Misstanke om skräppost: Gästboksinlägget börjar med en länk.';
    $amsg[183] = 'Språket som används motsvarar valet under \'Generell Konfiguration\'.';
    $amsg[184] = 'Aktuell språkinställning:';
    $amsg[185] = 'Betygsfunktion';
    $amsg[186] = 'Ikon för grafisk betygsfunktion';
    $amsg[187] = 'Text för betygsfunktionen';
    $amsg[188] = 'Här kan du aktivera betygsfunktionen, med vilken gästen kan tilldela mellan 1 och 5 stjärnor för en post i gästboken, som sedan visas i hans eller hennes bidrag.
<p>Om du klickar på betyget i posten i gästboken visas en kort beskrivande text, beroende på inställningen med eller utan att visa genomsnittet av alla betyg.</p>
<p>I inmatningsfältet nedan kan du ange vad gästen ska betygsätta, t.ex. din webbplats, bilder publicerade där osv.</p>
<p>Upp till 35 tecken kan anges. Texten ska vara så kort som möjligt.</p>
Om du inte anger någon text används standardinställningen från språkfilen.';
    $amsg[189] = 'Några exempel på CSS-kod för individuella justeringar i länk- och teckensnittsfärger, skuggfärger etc. finns under länken "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-EditStyle">Hjälp", Sektion IV. 3.4.2, "Redigera CSS-stil</a>"';
    $amsg[190] = 'Alla inställningar för dessa variabler görs via inmatningsfälten under länken: "<a href="?action=edit_template&#38;'.session_name().'='.session_id().'">Redigera mall</a>".';
    $amsg[191] = 'För olika teckensnittsfärger på "index.php" och "insert.php" se exemplet under länken "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-EditStyle">Hjälp", Sektion IV. 3.4.2, "Redigera CSS-stil</a>"';
    $amsg[192] = 'Dokumentation';
    $amsg[193] = 'avaktivera';
    $amsg[194] = 'aktivera <strong class="red">utan</strong> medelvärde';
    $amsg[195] = 'aktivera <strong class="red">med</strong> medelvärde';
    $amsg[196] = '<p class="size-14"><strong>Ditt administratörslösenord är inte optimalt säkrat.</strong></p>';
    $amsg[197] = '<p class="red size-14"><strong>Du bör ange ditt lösenord igen,<br />så att det sparas med ett säkrare hashvärde.</strong></p>';
    $amsg[198] = 'inaktiverad';
    $amsg[199] = 'Observera sekretess!';
    $amsg[200] = 'Du bör ange ett nytt lösenord för att logga in.';
    $amsg[201] = 'Tabellen med inloggningsdata är skadad.';
	$amsg[202] = 'Klicka för att ändra.';
	$amsg[203] = 'Ladda upp bildfilen i formatet (*.jpeg, *.png eller *.gif) till katalogen "img_guest" på servern. - <strong>Var uppmärksam på bildens bredd och höjd och minska den vid behov innan du laddar upp den.</strong> (Enligt den valda mallen ska bildens bredd vara max:';
	$amsg[204] = 'Den nya filen visas och kan väljas i rullgardinsmenyn nedan. Klicka på knappen "Spara filnamn" som visas.';
	$amsg[205] = 'Filens data matas automatiskt in i databasen. Du kan sedan redigera den förformulerade titeln genom att klicka på redigeringsikonen: <img class="img-ok" title="Redigera post" src="../images/edit.png" width="14" height="14" alt="Redigera post" />';
	$amsg[206] = 'Länk avaktiverad!';
	$amsg[207] = '<p>Om du klickar på en länk från administratörspanelen till en annan URL överförs session-ID till referensen och är synlig för mottagaren via loggfilen.</p>
<p>Som ett resultat finns det en risk att en tredje part kan få tillgång till administratörsdelen, även om det bara under en begränsad tid innan sessionen förstörs.</p>
För att utesluta risker inaktiveras därför länkar inom denna del.';
	$amsg[208] = 'Ändra namnet på fältet "Ämne":';
	$amsg[209] = '<p>Även om gästboken inte är aktiverad kan du skriva inlägg här och spara dem i databasen.</p>Dessa inlägg är dock bara synliga för allmänheten efter att gästboken har aktiverats.';
	$amsg[210] = 'Sessionens livstid';
	$amsg[211] = 'Sessionen förstörd';
	$amsg[212] = 'Typsnittsfamilj';
	$amsg[213] = 'Typsnittsstorlek';
	$amsg[214] = '<span class="aligncenter"><strong>Notera:</strong></span><br />Om bildskärmens bredd är mindre än 501 pixlar ställs teckenstorleken automatiskt in till 14px.';
	$amsg[215] = 'Länkfärg';
	$amsg[216] = 'Hoverfärg';
	$amsg[217] = 'Platshållare för typsnittsfamiljen';
	$amsg[218] = 'Platshållare för typsnittsstorleken';
	$amsg[219] = 'Platshållare för länkfärg';
	$amsg[220] = 'Platshållare för länkens hoverfärg';
	$amsg[221] = 'Testa e-post';
	$amsg[222] = 'E-postmeddelandet skickades.';
	$amsg[223] = 'Kontrollera din e-postinkorg.';
	$amsg[224] = 'E-postmeddelandet skickades inte.';
	$amsg[225] = 'Skicka testbrev';
	$amsg[226] = 'Ska formulär för nya inlägg<br />ha samma bredd som gästboken?<br /><span class="size-10">(Standard: maxbredd = 550px)</span>';
	$amsg[227] = 'automatiskt:';
	$amsg[228] = 'nu:';
	$amsg[229] = 'Använd denna säkerhetskopia';
	$amsg[230] = 'Endast text, ingen banner';
	$amsg[231] = 'Om du bara vill ha en välkomsttext utan en banner, markera motsvarande kryssruta och klicka på "OK".';
	$amsg[232] = 'En text utan banner finns redan.<br />Redigera den befintliga texten efter dina önskemål.';
	$amsg[233] = 'Lägg till en välkomsttext utan en banner';
	$amsg[234] = 'Visa länk till sekretesspolicy:';
	$amsg[235] = 'URL till sekretesspolicyn:';
	$amsg[236] = 'Meddelande om dataskydd:';
	$amsg[237] = 'Om du har en sida med sekretesspolicy på din webbplats har du möjlighet att här visa länken till den sidan på gästbokens två sidor "index.php" och "insert.php".
<p>Aktivera motsvarande alternativ och ange URL till sidan med dataskyddsdeklarationen i fältet nedan.</p>
Om du vill veta mer om hur och när scriptet använder cookies och bearbetar IP-adresser och vilka alternativ du har för att påverka detta, se avsnitt III.5. in Hjälpen, "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-Cookie">Sekretess och myPHP gästbok</a>".';
	$amsg[238] = 'Öppna menyn';
	$amsg[239] = 'Meny';
	$amsg[240] = 'Testa länk';
	$amsg[241] = 'Gästen måste godkänna behandlingen<br />av sina inmatningar genom att markera en kryssruta:';
	$amsg[242] = 'För närvarande online:';
	$amsg[243] = 'Ange giltig hexadecimal färgkod!\\n\\n(# och 3 eller 6 siffror)';
	$amsg[244] = 'Färgprov för denna kod';
	$amsg[245] = 'Opacitet';
	$amsg[246] = 'E-postadressen till admin bör vara ett separat e-postkonto som annars inte används och är okänt för andra människor.';
	$amsg[247] = 'Starkt lösenord';
	$amsg[248] = 'Svagt lösenord';
	$amsg[249] = 'Gör lösenordet synligt:';
	$amsg[250] = 'Rotera bilden';
	$amsg[251] = 'Ingen förändring';
	$amsg[252] = '90° till höger';
	$amsg[253] = '90° till vänster';
	$amsg[254] = 'Åtgärden lyckades.';
	$amsg[255] = 'Om en bild visas oförändrad efter en rotation, rensa webbläsarens cache och ladda sidan igen.';
	$amsg[256] = 'Aktivering rekommenderas i Europeiska unionen!';
	$amsg[257] = 'Aktivera sökfunktionen:';
	$amsg[258] = 'Aktivera permalänkar:';
	$amsg[259] = 'Platshållare för den länkade permalänkikonen.';
	$amsg[260] = 'Om sökfunktionen eller gästens språkval är aktiverat, bör mallen vara minst 500 pixlar eller bredare.<br /><br />För mer information se under länken "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-search">Hjälp", Sektion IV. 3.2.2.d, "Aktivera sökfunktionen</a>"';
    $amsg[261] = 'Din PHP och MySQL version';
    $amsg[262] = 'Du använder PHP version';
    $amsg[263] = 'Du använder MySQL version';
    $amsg[264] = 'EU-GDPR';
    $amsg[265] = 'Spara IP i '.$delete_spamIps.' dagar, om en post<br />avvisats som skräppost?';
    $amsg[266] = 'Spara IP-adresser efter skräppost är inaktiverat.';
    $amsg[267] = 'Utökad integritet';
    $amsg[268] = 'Vill du fullständigt förhindra bearbetning av IP-adresser och inställningar av cookies i gästboken?';
    $amsg[269] = 'Om den här kryssrutan är markerad kommer följande funktioner i <span class="italic nowrap">myPHP Guestbook</span> vara inaktiverade:';
    $amsg[270] = 'Om den här kryssrutan är markerad och du klickar på "spara" kommer följande funktioner i  <span class="italic nowrap">myPHP Guestbook</span> avaktiveras:';
    $amsg[271] = 'OBS!';
    $amsg[272] = 'Gästens språkval';
    $amsg[273] = 'Sökfunktionen';
    $amsg[274] = 'Statistiken om gästbokens besök';
    $amsg[275] = 'Gästens uppladdning av bildfiler';
    $amsg[276] = 'Insamling och tillfällig blockering av IP-adresser under vilka spam-poster har gjorts';
    $amsg[277] = 'Skydd mot automatiska massinlägg (översvämningsblockering)';
    $amsg[278] = 'Avaktiverade funktioner kan bara återaktiveras individuellt.';
    $amsg[279] = 'Alla lagrade IP-adresser och IP-hash raderas.';
    $amsg[280] = 'Det raderar också alla IP-adresser och IP-haschar som lagras i databasen.';
    $amsg[281] = 'Radera emojis automatiskt från en post<br />om fler än '.$maxSmilies.' stycken används?';
    $amsg[282] = 'Om en gäst har laddat upp nya bildfiler och lagt in dem i sitt inlägg, kom ihåg att också ladda ner filerna i katalogen "img_guest" från servern till din dator för säkerhetskopiering.';
    $amsg[283] = 'Om du får problem med uppladdningen med funktionen ovan laddar du istället upp filen via FTP till katalogen "banner".';
    $amsg[284] = 'Om du får problem med uppladdningen med funktionen ovan laddar du istället upp filen via FTP till katalogen "img_guest".';
    $amsg[285] = 'Tvåfaktorautentisering';
    $amsg[286] = 'Second Password';
    $amsg[287] = 'Ange följande kod för att logga in på admindelen:';
    $amsg[288] = 'Koden är giltig i 3 minuter innan den går ut.';
    $amsg[289] = 'Mer ...';
    $amsg[290] = 'Öppna filen "<span class="blue">settings.inc.php</span>" för ytterligare konfigurationsmöjligheter i katalogen "<span class="blue">includes</span>" och läs förklaringarna under "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-MoreKonfig">Hjälp ==> Ytterligare konfigurationsalternativ</a>".';
	$amsg[291] = 'Om du inte anger en färg matas "vit" automatiskt in.';
	$amsg[292] = 'Citering av meddelanden från gästen';
	$amsg[293] = '';
	$amsg[294] = '';
	$amsg[295] = '';
	$amsg[296] = '';
	$amsg[297] = '';
	$amsg[298] = '';
	$amsg[299] = '';
    $amsg[300] = 'Användarnamn finns redan!<br />Välj ett annat användarnamn.';
    $amsg[301] = 'E-postadress finns redan!<br />Välj en annan e-postadress.';
    $amsg[302] = 'Om du aktiverar det här alternativet har du möjlighet att visa din egen banner och, om du vill, en individuell hälsningstext på gästboksidorna.<br /><br />Denna funktion är inte tillgänglig från "include" mappen.<br /><br />För mer info se under länken "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-banner">Hjälp", Sektion IV. 3.5, "Banner och egen välkomsttext</a>"';
    $amsg[303] = 'Redigera administratörsuppgifter här:';
    $amsg[304] = 'Här kan du skapa en moderator:';
    $amsg[305] = 'Moderatorer och deras rättigheter';
    $amsg[306] = 'Moderatorer kan logga in på adminpanelen med begränsade rättigheter.
<p>Moderatorer kan blockera eller släppa gästboksposter och publicerade bilder och kommentera poster, men de <strong> kan inte radera eller redigera poster eller bilder</strong>.</p>
<p>De kan också skapa säkerhetskopior och återställa poster från säkerhetskopior, samt visa statistik och "Hjälpfilen".</p>
<p>Med dessa begränsningar är det tillåtet för moderatorer att komma åt länkade sidor i navigeringen under "Inmatningar", "Säkerhetskopiering" och "Övrigt".</p>
<p>Alla andra adminalternativ är inaktiverade eller otillgängliga för moderatorer.</p>
<p>Du kan ange att en moderator som du som administratör också automatiskt kommer att informeras av programmet om nya gästboksposter och filuppladdningar via e-post.</p>
Testa en moderators möjligheter genom att skapa en testmoderator.';
    $amsg[307] = 'Befintliga moderatorer:';
    $amsg[308] = 'Flagga';
    $amsg[309] = 'Redigera eller ta bort valt inlägg';
    $amsg[310] = 'OBS!\\n\\nÅtgärden kan inte avbrytas!\\n\\nVill du fortsätta?';
    $amsg[311] = 'Språk';
    $amsg[312] = 'Redigera inlägg från';
    $amsg[313] = '';
    $amsg[314] = 'Inget val har gjorts!';
    $amsg[315] = 'Välj bara ett inlägg för redigering!';
    $amsg[316] = 'Lägg till ny moderator';
    $amsg[317] = 'Ange nytt lösenord valfritt';
    $amsg[318] = 'Ange endast bokstäver, siffror och<br />: - , . ? ! ( ) i fältet "användarnamn".';
    $amsg[319] = 'Kontrollera om uppdatering finns för myPHP Guestbook';
    $amsg[320] = 'Versionen av <span class="italic">myPHP Guestbook</span> som du använder kunde inte fastställas.<br />Kontrollera variabeln "&#36;version" i filen "'.$lang_short.'.php", katalogen "lang".';
    $amsg[321] = 'Du använder <span class="italic">myPHP Guestbook</span> '.$version.'.<br />Den nuvarande versionen är';
    $amsg[322] = 'Du bör göra en uppdatering';
    $amsg[323] = 'Till nedladdningssidan för "www.php-guestbook.de"<br />klicka på knappen nedan.';
    $amsg[324] = 'Till nedladdningssidan för <span class="italic">myPHP Guestbook</span>';
    $amsg[325] = 'Du använder redan den aktuella versionen av <span class="italic">myPHP Guestbook</span>.';
    $amsg[326] = 'Kontrollera uppdatering';
    $amsg[327] = 'Kommentera inlägg';
    $amsg[328] = '<p>Om du tillåter överföring av stora filer med 2 till 3 MB, bör den maximala körtiden för ett skript vara mer än 60 sekunder och användaren bör använda en motsvarande snabb internetanslutning.</p>
<p>Den maximala körbara bearbetningstiden för ett skript är begränsad av praktiskt taget alla webbhotell. Allt som inte kan bearbetas av skriptet inom denna tid kommer att avbrytas under redigeringsprocessen.</p>';
    $amsg[329] = 'Den maximala körtiden för ett skript är satt av ditt webbhotell till';
    $amsg[330] = 'sekunder';
    $amsg[331] = '';
    $amsg[332] = 'OBS!';
    $amsg[333] = 'Den maximala storleken som en uppladdad fil kan ha har ställts in av ditt webbhotell till';
    $amsg[334] = 'Den maximala storleken som en uppladdad fil kan ha har ställts in av ditt webbhotell till mindre än';
    $amsg[335] = 'Individuellt språkval av gästen ...';
    $amsg[336] = 'avaktivera';
    $amsg[337] = 'aktivera <strong class="red">utan</strong> cookievarning:';
    $amsg[338] = 'aktivera <strong class="red">med</strong> cookievarning:';   
    $amsg[339] = 'rekommenderad inställning';   
    $amsg[340] = 'Klicka här för mer information';   
    $amsg[341] = 'Redigera banner';
    $amsg[342] = 'Visning och redigering av en enskild banner med hälsningstext är inte aktiverad.';
    $amsg[343] = 'Om du vill använda den här funktionen måste du aktivera "Aktivera banner"<br />under "Generell Konfiguration".';
    $amsg[344] = 'En ny grafikfil hittades i katalogen "banner".';
    $amsg[345] = 'Alla grafiska filer i katalogen "banner" är registrerade i databasen.';
    $amsg[346] = 'Bredd';
    $amsg[347] = 'Höjd';
    $amsg[348] = 'URL för banner';
    $amsg[349] = 'Individuell<br />hälsningstext';
    $amsg[350] = 'tecken';
    $amsg[351] = 'Välj denna post';
    $amsg[352] = 'Ingen banner registrerad i databasen.';
    $amsg[353] = 'Banners som finns i databasen visas här och kan redigeras';
    $amsg[354] = 'max.';
    $amsg[355] = 'Inmatning vald?';
    $amsg[356] = 'Redigera';
    $amsg[357] = 'Ta bort inlägg och fil';
    $amsg[358] = 'Lägg till uppladdad grafik till bannerlistan';
    $amsg[359] = 'Länk till hemsidan. - Klicka!';
    $amsg[360] = '[b]Välkommen till gästboken på min hemsida.[/b]\r\n\r\nHär kan du publicera din åsikt eller frågor om ämnet på denna webbplats eller bara lämna en kort hälsning. Jag ser fram emot feedbacken från varje besökare.\r\n\r\nPositiv och negativ kritik hjälper till att fördjupa det som har uppnåtts och förbättra det som har varit mindre framgångsrikt.';
	$amsg[361] = 'Denna funktion är inte tillgänglig när du<br />använder filerna från katalogen "include".';
	$amsg[362] = 'Ej tillgängligt när du använder filerna från "include" katalogen.';
	$amsg[363] = 'Slovakiska';
	$amsg[364] = 'Tjeckiska';
	$amsg[365] = 'Inloggningslås';
	$amsg[366] = 'Aktivera eller redigera denna banner';
	$amsg[367] = 'Skicka e-post efter ett nytt inlägg<br />även till den här moderatorn?';
	$amsg[368] = 'Ange en ny uppladdad bild i databasen:';
	$amsg[369] = 'En ny bildfil hittades i katalogen "img_guest".';
	$amsg[370] = 'Alla bildfiler i katalogen "img_guest" är registrerade i databasen.';
	$amsg[371] = 'Banner';
	$amsg[372] = 'Visa banner';
	$amsg[373] = 'Lägg till banner';
	$amsg[374] = 'Hur du lägger till din egen banner';
	$amsg[375] = 'Ladda upp din banner i formatet (*.jpeg, *.png eller *.gif) till katalogen "banner" på servern.';
	$amsg[376] = 'Om den nya filen inte visas omedelbart i rullgardinsmenyn nedan efter uppladdning, ladda om den här sidan i din webbläsare.';
	$amsg[377] = 'Filnamnet på den nya bannern visas i rullgardinsmenyn nedan och kan sen väljas. Klicka på knappen "Spara filnamn".';
	$amsg[378] = 'Bannerns data matas automatiskt in i databasen. Du kan sedan redigera de förformulerade texterna fritt genom att klicka på redigeringsikonen: <img class="img-ok" title="Ändra banner" src="../images/edit.png" width="14" height="14" alt="Redigera banner" />.';
	$amsg[379] = '<p>Text i detta fält kan inte översättas automatiskt av programmet och visas därför endast på det språk som administratören har ställt in.</p>Om språkvalet är aktiverat och en användare väljer ett annat språk ignoreras texten i detta fält och texten från den valda språkfilen visas istället.';
	$amsg[380] = 'Ingen post tillgänglig!';
          
// End of Admin-Messages
    
// Error-Messages

    $emsg[0] = 'Du har inte fyllt i alla fält';
    $emsg[1] = 'Felaktigt användarnamn eller lösenord â€“ Bekräfta och försök igen';
    $emsg[2] = 'E-postadressen saknas eller är ogiltig';
    $emsg[3] = 'Lösenorden matchar inte';
    $emsg[4] = 'Ett fel uppstod när säkerhetskopian skapades';
    $emsg[5] = 'Du valde ingen säkerhetskopia';
    $emsg[6] = 'Säkerhetskopieringsfilen kunde inte hittas, kontrollera innehållet i mappen backup.';
    $emsg[9] = 'Fyll i ditt namn';
    $emsg[10] = 'Du har inte skrivit någon text ännu';
    $emsg[11] = 'Ett fel har uppstått!';
    $emsg[12] = 'Din åtkomst är fortfarande blockerad på grund av skräppostskyddet!';
    $emsg[13] = 'Den nuvarande nedladdningsversionen av <span class="italic">myPHP Guestbook</span><br />kunde inte genomföras.<br /><br />Försök igen senare.';
    $emsg[14] = 'Din leverantör tillhandahåller inte nödvändiga tillägg<br />för att använda den här funktionen';
    $emsg[15] = 'Om du vill ladda upp bildfiler i gästboken under aktiverat bloggläge eller om du vill använda BBCodes eller Emojis måste du tillåta användning av cookies i din webbläsare.';
    $emsg[16] = 'Inget inlägg valt.';
    $emsg[17] = 'Gästboken är för närvarande avstängd';
    $emsg[18] = 'Ange endast siffror i fältet "(max.) bredd i gästboken"';
    $emsg[19] = 'Inmatningen "transparent" är inte tillåten för bakgrundsfärger!<br />Sparat värde har inte ändrats.';
    $emsg[20] = 'Bakgrundsgradientfärger måste anges!<br />Sparat värde har inte ändrats.';
    $emsg[21] = 'Ogiltig MIME-typ! Endast bildfiler i formatet';
    $emsg[22] = 'Ange endast siffror i fältet "Inlägg per sida"';
    $emsg[23] = 'Ange endast siffror i fältet "Antal länkar på frontsidan"';
    $emsg[24] = 'Ange endast positiva heltal i fältet "Översvämmningsblockering i minuter", min. 0';
    $emsg[25] = 'Ange endast siffror i fältet "Uppdateringsförbud för statistik i minuter"';
    $emsg[26] = 'Filen är för stor, högst 20 kB!';
    $emsg[27] = 'Den valda BBCode används redan';
    $emsg[28] = 'En stil med samma namn finns redan';
    $emsg[29] = 'En mall med samma namn finns redan';
    $emsg[30] = 'Inga otillåtna ord tillgängliga';
    $emsg[31] = 'Inga Emojis tillgängliga';
    $emsg[32] = 'Din inmatning innehåller för många tecken.';
    $emsg[33] = 'Din inmatning innehåller för få tecken. Minst:';
    $emsg[34] = 'För datumet anger du endast siffror åtskilda av prickar eller bindestreck.';
    $emsg[35] = 'För tiden anger du bara siffror åtskilda av ett kolon.';
    $emsg[36] = 'Tyvärr, inlägget existerar inte eller har låsts.';
    $emsg[37] = 'Ange endast siffror i fältet "Maximal ordlängd", minst 30 och max 125';
    $emsg[38] = 'Filnamnet är för långt';
    $emsg[40] = 'Ange endast siffror i fältet "Antal skräppostpunkter", min. 1 och max. 20';
    $emsg[41] = 'Ange endast siffror i fältet "Antal misstänkta länkar i bidrag", minst 0 och max. 20';
    $emsg[42] = 'Du har inte valt en fil eller filen har redan lagts in i databasen.';
    $emsg[43] = 'Otillåten inmatning för IP, endast små bokstäver, siffror, kolon eller punkter.';
    $emsg[44] = 'Inlägg inte komplett.';
    $emsg[45] = 'Du har inte valt en säkerhetskopia.';
    $emsg[46] = '- Välj bara en fil att återställa!';
    $emsg[47] = 'OBS!\\n\\nOm det finns tre filer kommer den äldsta säkerhetskopian att raderas från de befintliga filerna!\\n\\nVill du fortsätta?';
    $emsg[48] = 'Ogiltiga tecken för teckenstorlek';
    $emsg[49] = 'Varning! Caps Lock är på.';
    $emsg[50] = 'OBS!\\n\\Om du tar bort statistiken sätts summan av alla besökares\\noch sidvisningar också till noll.\\n\\nVill du fortsätta';
    $emsg[51] = 'Den sista stilen i databasen kan inte raderas av säkerhetsskäl!';
    $emsg[52] = 'Den sista mallen i databasen kan inte raderas av säkerhetsskäl!';
    $emsg[53] = 'Ange en URL i inmatningsfältet';
    $emsg[54] = 'Den angivna webbadressen är ogiltig';
    $emsg[55] = 'För att infoga BBCodes och emojis i ditt inlägg måste Javascript vara aktiverat.';
    $emsg[56] = 'Fel inmatning. Endast versaler, siffror och ? ! +';
    $emsg[57] = 'För att skydda mot skräppost är det inte tillåtet att ange webbadresser (länkar) utan att använda inmatningsmask. -- Använd BBCode-knappen med länksymbolen.';
    $emsg[58] = 'För att skydda mot skräppost får du inte ange webbadresser (länkar) i ett inlägg.';
    $emsg[59] = 'Storlek på filuppladdning i MB: Endast siffror, minst 1, max. 6'; 
    $emsg[60] = 'Ange endast siffror i fälten "bredd" och "höjd".';
    $emsg[61] = 'Ange endast bokstäver, siffror<br />eller: - , . ? ! i fältet "Bildtitel".';
    $emsg[62] = 'En färg måste anges för teckensnitten.<br /> - Inmatningen "transparent" är inte möjlig för teckensnittsfärger.';
    $emsg[63] = 'tecken';
    $emsg[64] = 'Ange endast bokstäver, siffror och punkter i fältet "Filnamn".';
    $emsg[65] = 'Ange endast siffror i fältet "maxbredd på bilden", minst 10, max';
    $emsg[66] = 'Ange endast siffror i fältet "bildens högsta höjd", minst 10, max 1000';
    $emsg[67] = 'Ange endast siffror i fältet "Bildkvalitet", minst 10, max 100';
    $emsg[68] = 'Inget GD-bibliotek tillgängligt, bilduppladdning är inte möjlig.';
    $emsg[69] = 'I fälten "bakgrundsfärg" och<br />fälten för teckensnittsfärg är endast bokstäver, siffror eller # tillåtna.';
    $emsg[70] = 'Du måste godkänna behandlingen av dina ändringar!';
    $emsg[71] = 'Ingen giltig färgbeteckning, se länken nedan:<br />"Val av webbsäkra färger och gråtoner"';
    $emsg[72] = 'I fältet "(max.) Bredd på gästboken" måste du skriva in ett värde.';
    $emsg[73] = 'Max. bredd på gästboken. Inte mindre än 280px.';
    $emsg[74] = 'En färg måste anges i fältet "Teckensnittsfärg".<br />- Valet "transparent" är inte möjligt för teckensnittsfärger.';
    $emsg[75] = 'Ange bara siffror i fältet "max. Antal bildöverföringar", min. 1, max. 10';
	$emsg[76] = 'Ange bara bokstäver, siffror och : - , . \' / ( ) i fältet "Stad"';
	$emsg[77] = 'Ange bara bokstäver, siffror och : - , . \' / ( ) i fältet "Land"';
	$emsg[78] = 'I "Ursprung" endast bokstäver, siffror och : - , . \' / | ( )<br />Stad och land åtskilda av |';
	$emsg[79] = 'I fälten för gästbokens titel, länken till inmatningssidan,<br />texten för betygsfunktionen och titeln på fältet "Ämne"<br />ange bara bokstäver, siffror eller : - , . ? ! () \' /';
	$emsg[80] = 'Ogiltig inmatning av en webbadress. Kontrollera inmatningar i de markerade fälten.';
	$emsg[81] = 'Ange bara bokstäver, siffror och \' - . () i fältet "Namn".';
	$emsg[82] = 'Information om en kommentar till ditt inlägg skickas bara när du anger en e-postadress.';
	$emsg[83] = 'Max textinmatning, 35 tecken.';
	$emsg[84] = 'Kontrollera URL: en i konfigurationsfilen!';
	$emsg[85] = 'Se även anteckningar under';
	$emsg[86] = 'Ogiltiga titeltecken, använd endast bokstäver, siffror och ? ! \' : . , -';
	$emsg[87] = 'Ogiltiga tecken i texten, dessa är inte tillåtna < > { } "';
	$emsg[88] = 'Den senaste befintliga filen kan inte raderas!';
	$emsg[89] = 'Fel med databasinmatning av administratörens e-postadress!';
	$emsg[90] = 'Ange igen och spara din Admin-epostadress.';
	$emsg[91] = 'Söktermen är för kort. Åtminstone';
	$emsg[92] = 'Ogiltig inmatning. Endast bokstäver, siffror och ? ! \' : . , -';
	$emsg[93] = 'Sökfunktionen är begränsad till';
	$emsg[94] = 'försök på 1 timme!';
	$emsg[95] = 'Minst en länk har ingen ankartext.';
	$emsg[96] = 'Du har inte angett någon plats.';
	$emsg[97] = 'Du har inte angett något land.';
	$emsg[98] = '<strong>OBS!:</strong> Inte fler än '.$maxSmilies.' Emojis tillåtna.<br />Vissa Emojis togs därför bort automatiskt.';
	$emsg[99] = 'Inget lösenordssession hittades.';
	$emsg[100] = 'Åtgärda felen som visas nedan!';

// End of Error-Messages

// Frontend - Phrasen
    
    $fmsg[0] = 'Ange dina personuppgifter här.';
    $fmsg[1] = 'Användarnamn';
    $fmsg[2] = 'Gästbokadministration';
    $fmsg[3] = 'Begär nytt lösenord';
    $fmsg[4] = 'Tillbaka';
    $fmsg[5] = 'Gör ett nytt inlägg:';
    $fmsg[6] = 'Du har ett nytt gästboksinlägg';
    $fmsg[7] = 'Namn:';
    $fmsg[8] = 'E-post';
    $fmsg[9] = 'Hemsida:';
    $fmsg[10] = 'Meddelande:';
    $fmsg[11] = 'För att hålla gästboken fri från skräppost granskas ditt meddelande av administratören innan det läggs ut.';
    $fmsg[12] = 'Det är '.$count_entries.' inlägg i denna gästbok';
    $fmsg[13] = 'Lägg till ett nytt inlägg';
    $fmsg[14] = 'Nästa';
    $fmsg[15] = 'Visa fler ...';
    $fmsg[16] = 'Skicka inlägg';
    $fmsg[17] = 'Början av bakgrundsfärggradient:';
    $fmsg[18] = 'Slut på bakgrundsfärggradient:';
    $fmsg[19] = 'Gästbok';
    $fmsg[20] = 'Lösenord';
    $fmsg[21] = 'Viktigt:';
    $fmsg[22] = 'Klicka på en emoji för att infoga den.';
    $fmsg[23] = 'Hem';
    $fmsg[24] = 'Egenskaper';
    $fmsg[25] = 'Stil';
    $fmsg[26] = 'Standardstil';
    $fmsg[27] = 'Skapa stil';
    $fmsg[28] = 'Ta bort stil';
    $fmsg[29] = 'Redigera stil';
    $fmsg[30] = 'Mall';
    $fmsg[31] = 'Standardmall';
    $fmsg[32] = 'Skapa mall';
    $fmsg[33] = 'Ta bort mall';
    $fmsg[34] = 'Redigera mall';
    $fmsg[35] = 'Emojis';
    $fmsg[37] = 'Visa emojis';
    $fmsg[38] = 'Lägg till emoji';
    $fmsg[39] = 'Otillåtna ord';
    $fmsg[40] = 'Visa otillåtna ord';
    $fmsg[41] = 'Lägg till otillåtet ord';
    $fmsg[42] = 'Säkerhetskopiering';
    $fmsg[43] = 'Skapa säkerhetskopia';
    $fmsg[44] = 'Återställ säkerhetskopia';
    $fmsg[45] = 'Diverse';
    $fmsg[46] = 'Statistik';
    $fmsg[47] = 'Hjälp';
    $fmsg[49] = 'Logga ut';
    $fmsg[50] = 'Öppna startsidan';
    $fmsg[52] = 'Ange dina personuppgifter här.';
    $fmsg[53] = 'Nytt lösenord:';
    $fmsg[54] = 'Upprepa lösenord:';
    $fmsg[55] = 'Spara';
    $fmsg[56] = 'Emoji:';
    $fmsg[57] = 'Nuvarande språkinställning: <strong>'.$language.'</strong>. Nationsflagga:';
    $fmsg[58] = 'Välj en stil för din gästbok.';
    $fmsg[59] = 'Din nuvarande stil:';
    $fmsg[60] = 'Välj en mall för din gästbok.';
    $fmsg[61] = 'Välj den stil som du vill ta bort.<br />Denna åtgärd kan inte ångras.';
    $fmsg[62] = 'Ta bort';
    $fmsg[63] = 'Din nuvarande mall:';
    $fmsg[64] = 'Välj den mall som du vill ta bort.<br />Denna åtgärd kan inte ångras.';
    $fmsg[65] = 'Ange bara siffror i fältet bredd';
    $fmsg[66] = 'Ange bara siffror i fältet höjd';
    $fmsg[67] = 'Bredd:<br />(i px)';
    $fmsg[68] = 'Höjd:<br />(i px)';
    $fmsg[69] = 'Välj den stil du vill redigera.';
    $fmsg[70] = 'Redigera';
    $fmsg[71] = 'Ändra CSS-koden hur du vill.';
    $fmsg[72] = 'CSS-stil:';
    $fmsg[73] = 'Välj den mall du vill redigera.';
    $fmsg[78] = 'HTML-koden du anger här är bara för ett inlägg, så den bör vara så kort som möjligt.';
    $fmsg[79] = 'Platshållare för användarens namn, som gjorde ett inlägg.';
    $fmsg[80] = 'Platshållare för den länkade e-postikonen.';
    $fmsg[81] = 'Platshållare för ikonen för länkad hemsida.';
    $fmsg[82] = 'Platshållare för tidpunkten för inlägget.';
    $fmsg[83] = 'Platshållare för texten i posten, som användaren skrev.';
    $fmsg[84] = 'Platshållare för administratörens kommentar<br />(om tillgängligt).';
    $fmsg[85] = 'Platshållare för den länkade kommentarikonen.';
    $fmsg[86] = 'Platshållare för gästbokens maxbredd.';
    $fmsg[87] = 'Platshållare för "Inlägg"';
    $fmsg[88] = 'Platshållare för "från"';
    $fmsg[89] = 'Platshållare för "Namn / tid bakgrundsfärg".';
    $fmsg[90] = 'Platshållare för "Bakgrundsfärg för inmatning"';
    $fmsg[91] = 'För bakgrundsfärgsgradienter måste start och slutvärden anges.<br />Att ange "transparent" är inte tillåtet.';
    $fmsg[92] = 'Gästbokens bakgrundsfärg:';
    $fmsg[93] = 'Gästbokens justering:';
    $fmsg[94] = 'Gästbokens bredd:';
    $fmsg[95] = 'Platshållare för "publicerad den"';
    $fmsg[96] = 'Teckensnittsfärg';
    $fmsg[97] = 'Välj ett språk';
    $fmsg[98] = 'Namn / tid bakgrundsfärg:';
    $fmsg[99] = 'Inläggets bakgrundsfärg:';
    $fmsg[100] = 'Gästbok bakgrundsbild URL:';
    $fmsg[101] = 'Ikon för e-post:';
    $fmsg[102] = 'Ikon för hemsida:';
    $fmsg[103] = 'Lås upp';
    $fmsg[104] = 'Välj alla';
    $fmsg[105] = 'Avaktivera';
    $fmsg[106] = 'Kommentar';
    $fmsg[107] = 'Upplåst';
    $fmsg[108] = 'Avaktiverad';
    $fmsg[109] = 'Nytt gästboksinlägg';
    $fmsg[110] = 'Innehållsformulär till gästboken';
    $fmsg[113] = 'Generell Konfiguration';
    $fmsg[114] = 'Gästbokens titel:';
    $fmsg[115] = 'Inlägg per sida:';
    $fmsg[116] = 'Antal länkar i webbläsaren:';
    $fmsg[117] = 'Översvämmningsblockering i minuter:';
    $fmsg[118] = 'Uppdateringsförbud för statistik i minuter:';
    $fmsg[119] = 'Skicka e-post vid nytt inlägg till admin<br />och om aktiverat till moderator(er):';
    $fmsg[120] = 'Emojis i inlägg:';
    $fmsg[121] = 'BBCodes i inlägg:';
    $fmsg[122] = 'Gästboksstatistik:';
    $fmsg[123] = 'Inlägg måste godkännas:';
    $fmsg[124] = 'Tillåt inte HTML-kod:<br /><span class="size-10 red">(Blockering rekommenderas starkt!)</span>';
    $fmsg[125] = 'kommer inte att visas offentligt';
    $fmsg[126] = 'Otillåtet ord är redan tillgängligt';
    $fmsg[127] = 'Ange otillåtet ord nedan.<br />Detta kommer att ersättas med stjärnor (***).';
    $fmsg[128] = 'Otillåtet ord:';
    $fmsg[129] = 'Bild borttagen.';
    $fmsg[130] = 'Ta bort säkerhetskopian igen';
    $fmsg[131] = 'Här kan du ladda upp dina egna emojis.';
    $fmsg[132] = 'Ladda upp';
    $fmsg[133] = 'Skriv din kommentar till inlägget här.';
    $fmsg[134] = 'Ta bort kommentar';
    $fmsg[135] = 'Felaktig åtkomstdata';
    $fmsg[136] = 'Logga in';
    $fmsg[137] = 'Tabell:';
    $fmsg[138] = 'Integritetspolicy';
    $fmsg[139] = 'Namn eller alias'; 
    $fmsg[141] = 'Skapa din egen gästbokstil här';
    $fmsg[142] = 'Namn på stilen:';
    $fmsg[143] = 'Kod:';
    $fmsg[144] = 'Skapa din egen gästboksmall här.<br />För att använda den här funktionen behöver du lite kunskaper om HTML.';
    $fmsg[145] = 'Namn på mallen:';
    $fmsg[148] = 'Under återställningen från säkerhetskopian inträffade ett eller flera fel';
    $fmsg[149] = 'Återställningen från säkerhetskopian lyckades.';
    $fmsg[150] = 'Tillbaka till inloggningen';
    $fmsg[151] = 'E-postadressen';
    $fmsg[152] = 'Återställningsfil:';
    $fmsg[153] = 'Återställning';
    $fmsg[154] = 'Gästboksstatistik:';
    $fmsg[155] = 'Totalt antal besökare:';
    $fmsg[156] = 'Totalt antal förfrågningar:';
    $fmsg[157] = 'Statistik för de '.$recording_days.' senaste dagarna för din gästbok:';
    $fmsg[158] = 'Datum:';
    $fmsg[159] = 'Besökare:';
    $fmsg[160] = 'Förfrågningar:';
    $fmsg[161] = 'Ta bort statistik';
    $fmsg[162] = 'Du har inte aktiverat statistiken.<br />Under "Egenskaper -&#62; Generell Konfiguration" kan du aktivera statistiken.';
    $fmsg[164] = 'Här kan du se listan med censurerade ord i gästboken.';
    $fmsg[165] = 'Otillåtet ord';
    $fmsg[166] = 'Ta bort alla markerade';
    $fmsg[168] = 'Alla Emojis som kan ses på inläggssidan visas här.';
    $fmsg[169] = 'Redigera:';
    $fmsg[170] = 'Datum | Tid:';
    $fmsg[171] = 'Platshållare för ett inläggs datum.';
    $fmsg[172] = 'Citat:';
    $fmsg[173] = 'Gästbok aktiverad';
    $fmsg[174] = 'Aktivera minsta / högsta inmatningslängd:';
    $fmsg[175] = 'Maximal inmatningslängd i tecken:';
    $fmsg[176] = 'Minsta inmatningslängd i tecken:';
    $fmsg[179] = 'Förhandsvisning';
    $fmsg[180] = 'Vänster';
    $fmsg[181] = 'Centrerad';
    $fmsg[182] = 'Höger';
    $fmsg[185] = 'Fet';
    $fmsg[186] = 'Kursiv';
    $fmsg[187] = 'Understruken';
    $fmsg[188] = 'Skuggad';
    $fmsg[189] = 'Inlägget du svarar på';
    $fmsg[190] = 'Svara på inlägget med';
    $fmsg[191] = 'Citat';
    $fmsg[192] = 'Lista';
    $fmsg[193] = 'Beskrivning';
    $fmsg[194] = 'Länk till detta inlägg';
    $fmsg[195] = 'Visa alla inlägg';
    $fmsg[196] = '<strong>Inaktivera</strong> fältet för e-postadress:';
    $fmsg[197] = 'Install';
    $fmsg[199] = 'Klicka';
    $fmsg[200] = 'SVARA';
    $fmsg[201] = '<strong>Inaktivera</strong> fältet för hemsideadress:';
    $fmsg[202] = '';
    $fmsg[203] = 'Maximal ordlängd:<br />(rekommenderad ~35 | med HTML aktiverad upp till 125):';
    $fmsg[205] = '';
    $fmsg[206] = 'Skicka ett tackmeddelande med e-post till användaren:';
    $fmsg[207] = 'Hemsidans adress är ogiltig';
    $fmsg[208] = 'Redigera HTML kod';
    $fmsg[210] = 'Tack för dina kommentarer på';
    $fmsg[211] = 'Misstanke om skräppost: Namn utan vokaler.';
    $fmsg[212] = 'Det här gästboksinlägget väntar på godkännande. Genom att klicka på följande länk kommer inlägget att synas i gästboken:';
    $fmsg[216] = 'Glömt ditt lösenord?';
    $fmsg[217] = 'Om du inte har begärt ett nytt lösenord är det möjligt att någon försöker komma in i administrationssidan utan tillstånd. Logga in där omedelbart och ändra lösenordet samt användarnamn och e-postadress för admin.';
    $fmsg[220] = 'Visa bilder i gästboksinlägg,<br />aktivera bilduppladdning:<br /><span class="size-10">(BBCodes måste aktivera)</span>';
    $fmsg[221] = 'Nytt lösenord för att logga in på administratörssidan';
    $fmsg[222] = '';
    $fmsg[223] = 'Du har begärt ett nytt lösenord för att logga in på administratörssidan i myPHP Guestbook.<br /><br />Det nya lösenordet är:';
    $fmsg[226] = 'Inget inlägg publicerat för tillfället.';
    $fmsg[227] = 'Det finns ett inlägg i denna gästbok';
    $fmsg[228] = 'Postat den:';
    $fmsg[229] = 'Omdirigera till ny URL i fältet för hemsida! - Skräppost';
    $fmsg[230] = 'Postat inlägg:';
    $fmsg[231] = 'Ett nytt inlägg i gästboken har tagits bort, avsändaren har blockerats:';
    $fmsg[232] = 'Borttaget inlägg i gästboken - skräppost';
    $fmsg[233] = 'Inaktiverat gästboksinlägg - Misstanke om skräppost';
    $fmsg[234] = 'Ett nytt inlägg i gästboken inaktiverades:';
    $fmsg[235] = 'Avsändar-IP:';
    $fmsg[236] = 'Detta inlägg är för närvarande inaktiverat.';
    $fmsg[237] = 'Lås upp inlägg inklusive eventuella bilder som kan ha lagts upp?';
    $fmsg[238] = 'Antal spampoäng:';
    $fmsg[239] = 'Detta inlägg har tagits bort, avsändarens IP-adress har blockerats.';
    $fmsg[240] = 'Detta inlägg är för närvarande inaktiverat på grund av skräppost.';
    $fmsg[241] = 'Blockera inlägget?';
    $fmsg[242] = 'Misstanke om skräppost: Länkarna som författaren placerade i sitt inlägg överstiger det misstänkta antalet med -';
    $fmsg[243] = 'Skräppost: Författaren använde mindre än 4 sekunder för sitt inlägg.';
    $fmsg[244] = 'Misstanke om spam: Författaren använde minst 4 sekunder, men mindre än 9 sekunder för sitt inlägg.';
    $fmsg[245] = 'Misstanke om spam: Författaren använde mer än 1 timme för sitt inlägg.';
    $fmsg[246] = 'Misstanke om spam: Mer än 30 tangenttryckningar per sekund.';
    $fmsg[247] = 'Tidssamtal - anmälan skickas:';
    $fmsg[248] = 'sek.';
    $fmsg[249] = 'Antal tangenttryckningar:';
    $fmsg[250] = 'tangenttryckningar/sek.:';
    $fmsg[251] = 'Spam: ett eller flera dolda inmatningsfält användes.';
    $fmsg[252] = 'Misstanke om spam: Använder otillåtna ord!';
    $fmsg[253] = 'De otillåtna orden är:';
    $fmsg[254] = 'Antal användningar i texten:';
    $fmsg[255] = 'Antal spampoäng,<br />som leder till att ett inlägg avvisas:<br /><span style="font-size:10px;font-weight:normal;">(rekommenderat: 4-5 / möjligt: min. 1 och max. 20)</span>';
    $fmsg[256] = 'Upptäck och förhindra spam<br />med cencurerade ord i inlägg:';
    $fmsg[257] = 'Upptäck och förhindra skräppost genom<br />antalet länkar i inlägg::';
    $fmsg[258] = 'Antal oönskade länkar i inlägg:<br /><span style="font-size:10px;font-weight:normal;">(rekommenderat: upp till 2 / minst 0 och max 20)</span>';
    $fmsg[259] = 'Utvärdering av skräppostfunktioner';
    $fmsg[260] = 'Använt dolt fält: + 5 poäng<br />Skrivit inlägg &#60; 4 sec.: + 5 p.<br />Skrivit inlägg &#60; 9 sec.: + 1 poäng<br />Skrivit inlägg &#62; 1 t + 1 poäng<br />&#62; 30 tangenttryckningar/sek.: + 1 poäng<br />Ingen eller fel referens: + 3 p.<br />Varje spamord: + 1 poäng<br />Varje länk över gränsen: + 1 p.<br />Inlägg startar med en länk: + 1 p.<br />Namn utan vokaler: + 1 p.<br />Omdirigering i hemsidans fält: + 4 poäng.';
    $fmsg[261] = 'Aktivering endast möjlig om minst ett sökord finns.';
    $fmsg[262] = '<b>OBS!</b><br /><br />Gästboksinlägget inaktiverades!';
    $fmsg[263] = '<b>OBS!</b><br /><br />Aktiveringskoden är ogiltig, inget inlägg inaktiverades!';
    $fmsg[264] = '<b>OBS!</b><br /><br />Gästboksinlägget inklusive eventuellt upplagda bilder har aktiverats!';
    $fmsg[265] = '<b> OBS!</b><br /><br />Aktiveringskoden är ogiltig, inget inlägg har aktiverats!';
    $fmsg[266] = 'Länk öppnar ett nytt fönster';
    $fmsg[267] = 'Detta inlägg har tagits bort.';
    $fmsg[268] = 'Emojis';
    $fmsg[269] = 'Ångra';
    $fmsg[270] = 'Byt språk?';
    $fmsg[271] = 'Javascript måste vara aktiverat.';
    $fmsg[272] = '';
    $fmsg[273] = 'Fäll upp';
    $fmsg[274] = 'Grå';
    $fmsg[275] = 'Ta bort säkerhetskopior från servern<br />efter att du skickat dem via e-post?';
    $fmsg[276] = 'OBS!\\n\\nKom ihåg att ändra motsvarande CSS-stil när du ändrar mallen!\\n\\nFortsätt?';
    $fmsg[277] = 'OBS!\\n\\nKom ihåg att ändra motsvarande mall när du ändrar CSS-stil.\\n\\nFortsätt?';
    $fmsg[278] = 'Misstanke om skräppost: Direkt förfrågan av inmatningsformuläret (ingen referrer).';
    $fmsg[279] = 'Statistik sen ';
    $fmsg[280] = 'Genomstuken';
    $fmsg[281] = 'Justera';
    $fmsg[282] = 'Högerjustera';
    $fmsg[283] = 'Upphöjd';
    $fmsg[284] = 'Punkter';
    $fmsg[285] = 'Numrering';
    $fmsg[286] = 'Horisontell linje';
    $fmsg[287] = 'Infoga länk';
    $fmsg[288] = 'Infoga e-postadress';
    $fmsg[289] = 'Färg';
    $fmsg[290] = 'Gul';
    $fmsg[291] = 'Orange';
    $fmsg[292] = 'Lime';
    $fmsg[293] = 'Rosa';
    $fmsg[294] = 'Brun';
    $fmsg[295] = 'Storlek';
    $fmsg[296] = 'Inmatningsfält gästbok';
    $fmsg[297] = 'Ange en ankartext för länken:';
    $fmsg[298] = 'Texten som anges här<br />blir länken som du ska klicka på i inlägget.';
    $fmsg[299] = 'Ange fullständig webbadress';
    $fmsg[300] = 'Inmatning klar,<br />infoga i ditt inlägg';
    $fmsg[301] = 'Ange e-postadressen,<br />som ska visas i ditt inlägg:';
    $fmsg[302] = 'Du har inte angett en ankartext.<br /><br />Försök igen ...';
    $fmsg[303] = 'Inmatningen kan vara upp till 80 tecken lång.';
    $fmsg[304] = '';
    $fmsg[305] = 'Du har inte angett en e-postadress.<br /><br />Försök igen ...';
    $fmsg[306] = 'Röd';
    $fmsg[307] = 'Grön';
    $fmsg[308] = 'Blå';
    $fmsg[309] = 'Centrera';
    $fmsg[310] = 'Infoga bild';
    $fmsg[311] = 'skicka ett e-postbrev';
    $fmsg[312] = '<strong>Du kan söka:</strong><ul><li>Användarnamn,</li><li>Datum,</li><li>Text i inlägg och kommentarer</li></ul>';
    $fmsg[313] = 'Ämne:';
    $fmsg[314] = 'högsta tillåtna längd på din post:';
    $fmsg[315] = 'tecken';
    $fmsg[316] = 'Återstående tecken:';
    $fmsg[317] = 'Förkorta ditt inlägg med';
    $fmsg[318] = 'Den här bilden måste<br />fortfarande granskas.';
    $fmsg[319] = 'Det här gästboksinlägget är aktiverat, eventuellt kvarhållna bilder är fortfarande blockerade.';
    $fmsg[320] = 'Lås upp bild(er)?';
    $fmsg[321] = 'Citera detta inlägg';
    $fmsg[322] = 'Svara på detta inlägg';
    $fmsg[323] = 'Lås upp text + bild';
    $fmsg[324] = 'Lås upp endast texten';
    $fmsg[325] = 'Ta bort inlägg';
    $fmsg[326] = 'Lås inlägg';
    $fmsg[327] = 'Ramfärg på inlägg:';
    $fmsg[328] = '<p class="text-center"><strong class="red">OBS!</strong><br /><br />När du ändrar mallen, kom ihåg att också ändra<br />motsvarande standard CSS-stil!</p>';
    $fmsg[329] = '<p class="text-center"><strong class="red">OBS!</strong><br /><br />När du ändrar CSS-stil, kom ihåg att också ändra<br />motsvarande standardmall!!</p>';
    $fmsg[330] = 'Platshållare för "Gästbokens bakgrundsfärg".';
    $fmsg[331] = 'Följande variabler kan användas i CSS-koden:';
    $fmsg[332] = 'Platshållare för justering av gästboken';
    $fmsg[333] = 'Platshållare för teckensnittsfärg';
    $fmsg[334] = 'Obligatoriskt fält';
    $fmsg[335] = 'Användning av BBCodes inte tillgängligt.';
    $fmsg[336] = 'Användning av Emojis inte tillgängligt.';
    $fmsg[337] = 'frivilligt';
    $fmsg[338] = 'Aktivera skräppostskydd';
    $fmsg[339] = 'För att återaktivera skräppostskyddet,<br />öppna filen "settings.inc.php" i mappen<br />"includes" och ställ in värdet "SPAM_PROTECT"<br />från "false" till "true".< br /><br />Spara sedan den ändrade filen<br />"settings.inc.php" och ladda upp den igen till servern.';
    $fmsg[340] = '<strong>OBS!</strong> Skräppostskyddet är inaktiverat!*';
    $fmsg[341] = 'Aktivera bildöverföringskontroll';
    $fmsg[342] = 'För att aktivera verifiering och aktivering av uppladdade<br />bildfiler av Admin igen,<br />öppna filen "settings.inc.php" i mappen<br />"includes" och ställ in värdet "PIC_CHECK"<br />från "false" till "true".<br /><br />Spara sedan den ändrade filen<br />"settings.inc.php" och ladda upp den igen till servern.';
    $fmsg[343] = '<strong>OBS!</strong> Uppladdade bildfiler syns direkt<br />utan godkännande av administratören!';
    $fmsg[344] = 'Låsa bild(er)?';
    $fmsg[345] = 'Följande variabler kan användas i mallen:';
    $fmsg[346] = 'Plats:';
    $fmsg[347] = 'Land:';
    $fmsg[348] = 'Ditt inlägg';
    $fmsg[349] = 'från ';
    $fmsg[350] = 'Markera denna ruta för att få ett meddelande via e-post om någon kommenterar ditt inlägg:';
    $fmsg[351] = 'Ditt inlägg aktiveras så snart administratören fått en chans att granska det.';
    $fmsg[352] = 'Webbplatsbetyg:';
    $fmsg[353] = 'Stjärna';
    $fmsg[354] = $fmsg[3541] = 'Stjärnor';
    $fmsg[355] = 'Ta bort betyg';
    $fmsg[356] = 'Platshållare för betygsfunktionen';
    $fmsg[357] = 'av 5 stjärnor';
    $fmsg[358] = 'Genomsnitt';
    $fmsg[359] = 'av';
    $fmsg[360] = 'betyg';
    $fmsg[361] = 'Detta nya lösenord är giltigt i';
    $fmsg[362] = 'minuter och avaktiveras sedan automatiskt av säkerhetsskäl.';
    $fmsg[363] = 'Sök';
    $fmsg[364] = 'Ta bort sökning';
    $fmsg[365] = 'Återställ';
    $fmsg[366] = 'Upptäckt';

// END of Frontend - Phrasen  
    
// File-Upload - Phrasen
       
    $pmsg[1] = '<p class="text-center"><strong>Innan vi går vidare...</strong></p>
<p class="text-justify">Bilder och bildfiler skyddas av upphovsrätten. Därför får endast självgjorda bilder laddas upp och publiceras i ditt bidrag.</p>
<p>Genom att klicka på knappen "Bekräfta användarvillkor" bekräftar du att</p>
<ul>
<li>... du laddar bara upp bilder och använder dem i ditt inlägg där du har obegränsade användningsrättigheter</li>
<li>... du använder inga filer som kommer från tredje part. Lägg inte ut några bilder som kopierats från Internet eller någon annanstans utan tillstånd.</li>
</ul>
<p class="text-justify"><strong>Det är förbjudet att lägga upp pornografiska, sexistiska, oanständiga, rasistiska, våldsamma eller på annat sätt stötande bilder.</strong></p>
<p>&nbsp;</p>
<p class="text-justify"><strong>OBS!</strong> Vid överföring av filer tas innehållet i EXIF-informationen bort av säkerhetsskäl, vilket även inkluderar information om kamera eller inspelningsdata, eventuell upphovsrättsinformation som kan inkluderas etc. Dessutom kommer de överförda grafikfilerna att ändras för att passa gästbokens layout. Motiven kan hittas senare av sökmotorer.</p>';
	$pmsg[2] = 'Bekräfta användarvillkor';
	$pmsg[3] = 'Avbryt';
	$pmsg[4] = 'Så här lägger du till en bild i ditt inlägg:';
	$pmsg[5] = 'Den maximala storleken på den ursprungliga bildfilen kan vara:';
	$pmsg[6] = 'Tillåtna filformat är:';
	$pmsg[7] = '<p>Ju större fil, desto längre uppladdningstid! Beroende på filstorlek och internetanslutning kan uppladdningstiden vara 1 minut eller mer.</p>
<p class="text-center"><strong>Slutet och tiden för laddningsprocessen visas,<br/>- så ha tålamod.</strong></p>';
	$pmsg[8] = 'Lagring inte möjlig.<br /><strong> Kontakta administratören.';
	$pmsg[9] = 'Filen överskrider uppladdningsstorleken<br />i php.ini';
	$pmsg[10] = 'Om du inte har möjlighet att ändra storlek på filen kan du skicka den till mig via e-post, så jag lägger in den åt dig.';
	$pmsg[11] = '<strong>Filen har endast laddats upp delvis!</strong><br />Försök igen.';
	$pmsg[12] = 'Ingen fil vald!';
	$pmsg[13] = '<strong>Ogiltigt filformat!</strong><br />Endast bildfiler i formaten .jpg, .jpeg, .png, .JPG, .JPEG';
	$pmsg[14] = '<strong>Filen är för stor!</strong>';
	$pmsg[15] = 'Ange beskrivning av den uppladdade bilden:';
	$pmsg[16] = '<p>Du har inte accepterat användarvillkoren för filöverföringen eller så har ett fel uppstått i bekräftelsen.</p><p>Försök igen.</p>';
	$pmsg[17] = 'myPHP Guestbook filöverföring';
	$pmsg[18] = '<b>OBS!</b>
<br /><br />
En bildfil laddades upp i gästboken den <b>'.GB_DATE.'</b> klockan '.date("H:i").'.
<br /><br />
<b>Det rekommenderas starkt att kontrollera filen innan du släpper lös den!</b><br /><br />
Bilden ska visas längst ner på sidan och kan annars nås genom att klicka på följande länk:';
	$pmsg[19] = 'Filen laddades upp.';
	$pmsg[20] = '<p><strong>Klicka på knappen "Generera kod" för att lägga till de taggar i ditt inlägg som krävs för den efterföljande visningen av din bild.</strong></p><br />
<p class="text-center red">Koden mellan de två taggarna: <strong>"[img]... [/img]"</strong><br />bör <strong>inte ändras efter det</strong>!</p>';
	$pmsg[21] = 'Generera kod';
	$pmsg[22] = '<strong>Ogiltig MIME-typ!</strong><br />Endast bild.jpg eller bild.png!';
	$pmsg[23] = 'Ladda upp';
	$pmsg[24] = 'Vad vill du göra härnäst?';
	$pmsg[25] = 'Ladda upp en bild till';
	$pmsg[26] = 'Avsluta proceduren och stäng fönstret';
	$pmsg[27] = 't.ex. plats eller motiv, fotografens namn eller liknande ...<br />Texten i inmatningsfältet kan ändras efter behag.';
	$pmsg[28] = '<strong>Felaktigt filnamn, uppladdning avbruten.</strong><br />Byt namn på filen.';
	$pmsg[29] = '<strong>Ett fel har uppstått. </strong><br />Försök igen.';
	$pmsg[30] = 'Högst';
	$pmsg[31] = 'bild(er) per inlägg';
	$pmsg[32] = '(ladda upp en i taget)';
	$pmsg[33] = 'gränsen nådd';
	$pmsg[34] = 'Bilden är för liten (min. 10px hög och bred)';
	$pmsg[35] = 'Laddar upp ...';

?>