<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.
	
	02.01.2022
*/

// New Variables

    $version    = "V 4.10.9";
    $encoding   = "utf-8";
    $language   = "English";
    $lang_short = "en";
    $cssStyle	= "mygbook-style-4108.css";
    
// Cookie Note to User

  	$cmsg[0] = 'If you choose another language, you agree that your setting will be stored in a cookie. (Content of the cookie: "de", "en", "fr", "it", "nl", "pl", "pt", "sv", "cz" or "sk".) - The cookie is automatically deleted when you close your browser.';
    
// Text Thank-You-E-Mail to guest

	$thankYou[0] = 'Dear Guest,<br /><br />thank you for your entry in my guestbook of "'.$_SERVER['SERVER_NAME'].'".<br /><br />I hope to hear more from you soon!<br /><br />With kind regards,<br />Administrator';

// EU GDPR

    $dsgvo[0] = 'I agree to the storage and processing of my data according <span class="nowrap">to the EU-GDPR.</span>';
    $dsgvo[1] = 'Privacy Policy';

// Admin Messages

    $amsg[0] = 'Admin-Control-Panel';
    $amsg[1] = 'Please login!';
    $amsg[2] = 'Entries';
    $amsg[3] = 'Entries and comments';
    $amsg[4] = 'Properties';
    $amsg[5] = 'Admin- + Login data';
    $amsg[6] = 'General Configuration';
    $amsg[7] = 'CSS Style:';
    $amsg[8] = 'Standard style';
    $amsg[9] = 'Create new style';
    $amsg[10] = 'Delete style';
    $amsg[11] = 'Edit style';
    $amsg[12] = 'Template';
    $amsg[13] = 'Standard template';
    $amsg[14] = 'Create new template';
    $amsg[15] = 'Delete template';
    $amsg[16] = 'Edit template';
    $amsg[17] = 'Smileys';
    $amsg[18] = 'Show smileys';
    $amsg[19] = 'Add smiley';
    $amsg[20] = 'Badwords';
    $amsg[21] = 'Show badwords';
    $amsg[22] = 'Add badword';
    $amsg[23] = 'Backup';
    $amsg[24] = 'Create backup';
    $amsg[25] = 'Backup-List';
    $amsg[26] = 'Miscellaneous';
    $amsg[27] = 'Statistic';
    $amsg[28] = 'Guestbook protection';
    $amsg[29] = 'Logout';
    $amsg[30] = 'Guestbook entry has been released.';
    $amsg[31] = 'The activation code is wrong, no entry has been activated.';
    $amsg[32] = 'Break';
    $amsg[33] = 'Edit entry';
    $amsg[34] = 'Guestbook entry you write a comment';
    $amsg[35] = 'Show spamwords';
    $amsg[36] = 'Add spamwords';
    $amsg[37] = 'IP blocks';
    $amsg[38] = 'Spamfilter';
    $amsg[39] = 'Inputs for all IPs possible?';
    $amsg[40] = 'Show list of blocked IPs';
    $amsg[41] = 'NO';
    $amsg[42] = 'All entries in the guestbook released?';
    $amsg[43] = 'blocked:';
    $amsg[44] = 'Last BackUp:';
    $amsg[45] = 'No spamwords present.';
    $amsg[46] = 'The list of keywords, which will identify an entry as Spam.';
    $amsg[47] = 'Spam-detection activated by keywords?';
    $amsg[48] = 'This function must be activated<br />in the "General Configuration".';
    $amsg[49] = 'Spam-Word';
    $amsg[50] = 'Enter the desired keyword below,<br />which marks the post as spam-suspicious.';
    $amsg[51] = 'Spam-blocked IPs to the entry page:';
    $amsg[52] = 'No IPs are currently blocked.';
    $amsg[53] = 'IPs entered here are automatically deleted after '.$delete_spamIps.' days.<br />If you want to save certain IPs for a longer period of time,<br />please click on the green check mark for the IP in question.';
    $amsg[54] = 'IP:';
    $amsg[55] = 'Date:';
    $amsg[56] = 'Time:';
    $amsg[57] = 'Delete IP:';
    $amsg[58] = 'Delete?';
    $amsg[59] = 'Activate banner';
    $amsg[60] = 'IP will be deleted after '.$delete_spamIps.' days. Prevent?';
    $amsg[61] = 'IP will not be deleted automatically! Change it?';
    $amsg[62] = 'Add IP:';
    $amsg[63] = 'Delete/Save';
    $amsg[64] = 'Edit banner';
    $amsg[65] = 'Please save the attached backup file.';
    $amsg[66] = 'The backup of the database entries in the guestbook<br />has been created successfully.';
    $amsg[67] = 'A copy of the backup file was sent by e-mail.';
    $amsg[68] = 'Please save the e-mail attachment in a safe place.';
    $amsg[69] = 'Select from the indicated files.';
    $amsg[70] = 'The following backup files are available:';
    $amsg[71] = 'File name:';
    $amsg[72] = 'Blocking of guestbook entry!';
    $amsg[73] = 'Marked restoring';
    $amsg[74] = '<p class="zentriert">When restoring guestbook entries from a backup</p><p class="zentriert">all existing database entries will be deleted!</p>';
    $amsg[75] = 'Release of the guestbook entry!';   
    $amsg[76] = 'Add the backup file, that was uploaded to the backup directory by FTP,<br />to the backup list:';    
    $amsg[77] = 'All files contained in the directory "backup"<br />are recorded in the database.';    
    $amsg[78] = 'Save file name';    
    $amsg[79] = 'You did not fill in all fields.';    
    $amsg[80] = 'Under "General Configuration" you have activated the option:<br />"Delete backups from the server after sending them by e-mail".<br /><br />The backup file just created was therefore deleted.<br /><br />That is why the backup file sent by e-mail should be saved separately in a safe place.';    
    $amsg[81] = 'A new backup file was found,<br />which is not yet registered in the database.<br /><br />Select the file in the drop-down-menu<br />and click on "Save file name".';
    $amsg[82] = 'Help';
    $amsg[83] = 'Under "General Configuration" you have activated the option:<br />"Delete backups from the server after sending them by e-mail".<br /><br />Therefore, all myPHP Guestbook backups on the server were deleted,<br />including the backup just used to restore the guestbook entries.';
    $amsg[84] = 'Post';
    $amsg[85] = 'from';
    $amsg[86] = 'posted on';
    $amsg[87] = 'No Backup available yet.<br />You should create a Backup of your guestbook entries regularly.';
    $amsg[88] = 'Attention!\\n\\nIn addition to the database entry, the image file is also deleted from the server.\\n\\nThe action cannot be cancelled!\\n\\nContinue?';
    $amsg[89] = 'Text released?';
    $amsg[90] = 'Image released?';
    $amsg[91] = 'Posted images';
    $amsg[92] = 'Edit file uploads';
    $amsg[93] = 'Here you can see and edit the images in the guestbook.';
    $amsg[94] = 'Add a new image manually?';
    $amsg[95] = 'Select the file to be deleted.\\n\\nAttention!\\n\\nThe action cannot be cancelled!\\n\\nContinue?';
    $amsg[96] = 'Edit entry';
    $amsg[97] = 'Titel:';
    $amsg[98] = 'Here you can see and edit the images in the guestbook.';
    $amsg[99] = 'The upload function for images in guestbook entries is not activated.';
    $amsg[100] = 'If you want to use this feature, you have to activate "BBCodes" and "Images in guestbook entries" under "General Configuration".';
    $amsg[101] = 'Edit guest image database entry.<br />Correct the alignment of *jpg files if necessary.';
    $amsg[102] = 'Add a new image in database';
    $amsg[103] = 'Upload properties';
    $amsg[104] = 'Here you can make settings for the file upload.';
    $amsg[105] = '<br />Maximum size of the file to be uploaded in MB:<br /><span class="size-10">(1 - 6 MB | Entry effective depending on server configuration. -<br /><strong class="red">See also the note under "Info"!</strong>)</span>';
    $amsg[106] = '<br />Maximum width of the image in pixels:<br /><span class="size-10">(The upper limit is currently set at';
    $amsg[107] = '<br />and varies according to the chosen width of the guestbook)</span>';
    $amsg[108] = '<br />Maximum height of the image in pixels:';
    $amsg[109] = '<br />Image quality in percent:<br /><span class="size-10">(recommended 70 - 80%)</span>';
    $amsg[110] = 'Here you can change basic settings of the template.';
    $amsg[111] = 'Activate quoting of posts:';
    $amsg[112] = 'No images available yet.';
    $amsg[113] = 'Selection of web-safe colors and shades of gray';
    $amsg[114] = 'Web-safe colors and shades of gray';
    $amsg[115] = 'The 216 colors and 256 shades of grey that are considered "web-safe".';
    $amsg[116] = 'If you do not specify a color, "transparent" is automatically entered.';
    $amsg[117] = '<br />Maximum number of allowed file uploads<br />per posting:<br /><span class="size-10">(20 min. IP lock for uploads above the limit.)</span>';
    $amsg[118] = 'Close window';
    $amsg[119] = 'Info';
    $amsg[120] = 'E-mail address';
    $amsg[121] = 'required field,<br />e-mail addresses are ...';
    $amsg[122] = 'is not a';
    $amsg[123] = 'is a';
    $amsg[124] = 'displayed:';
    $amsg[125] = 'not displayed:';
    $amsg[126] = 'Input field for "Place"';
    $amsg[127] = 'Input field for "Country"';
    $amsg[128] = '<strong>Disable</strong> input field for "Subject":';
    $amsg[129] = 'Origin';
    $amsg[130] = 'E-Mail Configuration';
    $amsg[131] = 'Here you specify the sender address for all e-mails sent automatically<br />by the program and the text, that will be sent to the guest by e-mail<br />after an entry in the guestbook.';
    $amsg[132] = 'Edit e-mail address';
    $amsg[133] = 'German';
    $amsg[134] = 'English';
    $amsg[135] = 'Text e-mail';
    $amsg[136] = 'In order to change the "Thank-you e-mail", the option:<br /><strong>"Thank-you e-mail"</strong> under <strong>"General Configuration"</strong><br />must be activated.';
    $amsg[137] = 'E-mail dispatch activated?';
    $amsg[138] = 'Edit e-mail';
    $amsg[139] = 'Placeholder for "Place | Country".';
    $amsg[140] = 'Placeholder for "from: "';
    $amsg[141] = 'Action completed successfully';
    $amsg[142] = 'Show link to Admin Area on guestbook pages:';
    $amsg[143] = 'Placeholder for HTML tag line break "&#60;br /&#62;"';
    $amsg[144] = 'Press any key on your keyboard';
    $amsg[145] = 'Delete saved IPs from old entries?';
    $amsg[146] = 'Change e-mail sender\'s address<br />or text for "Thank-you e-mail"?';
    $amsg[147] = 'The text for the "Thank-you e-mail" as well as the sender for all e-mails automatically sent by the program can be changed under the link: <div class="text-center"><br />"<a href="?action=thanks_email&#38;show=guest_mail&#38;'.session_name().'='.session_id().'" title="For changing click the link">E-Mail Configuration</a>"</div>.';
    $amsg[148] = 'Link to page for guestbook entries:';
    $amsg[149] = '<p>Selecting the radio buttons determines whether the link above and below the guestbook entries to the page for new entries should appear as clickable text or as a button or not at all (blog mode).</p>
<p>In the corresponding text field you can enter how the clickable text or the button\'s label should read.</p>
<p>The text can be up to 35 characters long.</p>
<p>If you do not enter any text, the default from the language file is used.</p>
For additional explanations, see the link <a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-LinkButton" title="Link opens the \'Help\'-file">"Help", Section IV.3.2.2</a>.';
    $amsg[150] = 'Security advice';
    $amsg[151] = 'The e-mail address displayed as the <strong>sender</strong> of all e-mails automatically sent by the program.';
    $amsg[152] = 'The e-mail address that is used as the sender of the e-mails automatically sent by the program (e-mail header "From") should preferably not be identical to the admin e-mail address.';
    $amsg[153] = 'Please have a look at your e-mail inbox.';
    $amsg[154] = 'Login is deactivated!';
    $amsg[155] = '<b>Attention!</b><br /><br />There were ';
    $amsg[156] = ' incorrect attempts to login to the Admin Area.<br /><br />The login area has been blocked and should remain locked for a few days to protect it from further attempts to intrude unauthorized.<br /><br />The login will be activated automatically after ';
    $amsg[157] = ' days. If you want to release your login again earlier, please click on the following link:';
    $amsg[158] = 'The entries have been saved.';
    $amsg[159] = '<strong>Disable</strong> check box for "Info e-mail" for guest<br />at commenting on his entry:';
    $amsg[160] = 'Information e-mail to guest';
    $amsg[161] = 'If this option is activated, a checkbox will be shown under the text field for a new post, with which the guest can choose whether he wants to be informed automatically by e-mail about a comment on his guestbook entry.<br /><br /><strong>Attention:</strong> If the input field for entering an e-mail address is hidden, the option "Info e-mail to guest" is also automatically deactivated!';
    $amsg[162] = 'Your guestbook entry';
    $amsg[163] = 'Hello.<br /><br />A reply to your comment in the guestbook at "'.$_SERVER['SERVER_NAME'].'" has been posted. To view the reply please visit the guestbook.<br /><br />Best Regards<br />Administrator';
    $amsg[164] = 'The guest will be informed about the Admin\'s comment by e-mail.';
    $amsg[165] = 'E-mail to guest if his message is commented by Admin?';
    $amsg[166] = 'E-mail to guest if his message is quoted?';
    $amsg[167] = 'YES';
    $amsg[168] = 'NO, already done.';
    $amsg[169] = 'Text link';
    $amsg[170] = 'Html button';
    $amsg[171] = 'Text of the link or button:';
    $amsg[172] = 'Remove link (Blog mode)';
    $amsg[173] = 'Dutch';
    $amsg[174] = 'Portuguese';
    $amsg[175] = 'Quote function';
    $amsg[176] = 'If the guestbook is operated in the so-called "Blog mode", the quote function cannot be activated or is automatically deactivated.';
    $amsg[177] = 'Admin blog';
    $amsg[178] = 'Here you can post a new message.';
    $amsg[179] = 'Guestbook in blog mode?';
    $amsg[180] = 'Blog mode';
    $amsg[181] = '<p>The links on the public page with the guestbook entries ("index.php") and the page for new inputs ("insert.php") are hidden.</p>
<p>The input form ("insert.php") and the page for image uploads ("pic.upload.php") are no longer accessible on the web.</p>
<p>New entries and image uploads are only possible through the Administrator here in the control panel.</p>
Setting the blog mode under the link "<a href="?action=guestbook_options&#38;'.session_name().'='.session_id().'" title="Click the link for changing">General Configuration</a>", there: "Link to the entry page".';
    $amsg[182] = 'Suspicion of spam: The guestbook entry starts with a link.';
    $amsg[183] = 'The language used corresponds to the selection under \'General Configuration\'.';
    $amsg[184] = 'Current language setting:';
    $amsg[185] = 'Rating function';
    $amsg[186] = 'Rating function graphic';
    $amsg[187] = 'Text for the rating function';
    $amsg[188] = 'Here you can activate the rating function, with which the guest can assign between 1 and 5 stars for an entry in the guestbook, which are then displayed in his or her contribution.
<p>Clicking on the rating in the guestbook entry displays a short descriptive text, depending on the setting with or without displaying the average of all ratings.</p>
<p>In the input field below you can enter what the guest should rate, e.g. your website, photos published there, etc.</p>
<p>Up to 35 characters can be entered. The text should be as short as possible.</p>
If you do not enter any text, the default from the language file is used.';
    $amsg[189] = 'Some CSS code examples for individual adjustments in the link and font colors, shadow colors etc. can be found under the link "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-EditStyle">Help", Section IV. 3.4.2, "Edit CSS style</a>"';
    $amsg[190] = 'All settings for these variables are made via the input fields under the link: "<a href="?action=edit_template&#38;'.session_name().'='.session_id().'">Edit template</a>".';
    $amsg[191] = 'For different font colors on the "index.php" and the "insert.php" see the example under the link "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-EditStyle">Help", Section IV. 3.4.2, "Edit CSS style</a>"';
    $amsg[192] = 'Documentation';
    $amsg[193] = 'deactivate';
    $amsg[194] = 'activate <strong class="red">without</strong> average value';
    $amsg[195] = 'activate <strong class="red">with</strong> average value';
    $amsg[196] = '<p class="size-14"><strong>Your Admin password is not optimally secured.</strong></p>';
    $amsg[197] = '<p class="red size-14"><strong>You should now enter your Password again,<br />so that it is saved with a more secure hash value.</strong></p>';
    $amsg[198] = 'disabled';
    $amsg[199] = 'Please note Privacy!';
    $amsg[200] = 'You should enter a new Password to login.';
    $amsg[201] = 'The table with the login data is damaged.';
	$amsg[202] = 'Click to change.';
	$amsg[203] = 'Load the image file (format *.jpeg, *.png or *.gif) into the directory "img_guest" on the server. - <strong>Pay attention to the width and height of the image and reduce it if necessary before uploading.</strong> (According to the currently selected template the width of the image should be max.:';
	$amsg[204] = 'The new file is displayed at the drop-down menu below and can be selected. Click on the "Save file name" button that appears.';
	$amsg[205] = 'The data of the file are automatically entered into the database. You can then edit the pre-formulated title by clicking on the edit icon: <img class="img-ok" title="Edit entry" src="../images/edit.png" width="14" height="14" alt="Edit entry" />';
	$amsg[206] = 'Link deactivated!';
	$amsg[207] = '<p>If you click on a link from the Admin panel to another URL, the session ID is transferred with the referrer and is visible to the recipient via the log file.</p>
<p>As a result, there is a risk that this third party may gain access to the Admin Area, even if only for a limited period of time before the session is destroyed.</p>
In order to exclude any risk, links in this area are therefore deactivated.';
	$amsg[208] = 'Change title of the "Subject" field:';
	$amsg[209] = '<p>Even if the guestbook is not activated, you can write entries here and save them in the database.</p>However, these entries are only visible to the public after activation of the guestbook.';
	$amsg[210] = 'Session lifetime';
	$amsg[211] = 'Session destroyed';
	$amsg[212] = 'Font family';
	$amsg[213] = 'Font size';
	$amsg[214] = '<span class="aligncenter"><strong>Note:</strong></span><br />If the monitor width is less than 501px, the font size is automatically set to 14px.';
	$amsg[215] = 'Link Color';
	$amsg[216] = 'Hover Color';
	$amsg[217] = 'Placeholder for font family';
	$amsg[218] = 'Placeholder for font size';
	$amsg[219] = 'Placeholder for Link color';
	$amsg[220] = 'Placeholder for Link hover color';
	$amsg[221] = 'Test E-Mail';
	$amsg[222] = 'E-mail dispatch successful.';
	$amsg[223] = 'Please check your e-mail inbox.';
	$amsg[224] = 'E-mail dispatch not successful.';
	$amsg[225] = 'Send test e-mail';
	$amsg[226] = 'Form for new entries<br />same width as guestbook?<br /><span class="size-10">(Default: max-width = 550px)</span>';
	$amsg[227] = 'automatically:';
	$amsg[228] = 'now:';
	$amsg[229] = 'Use this Backup';
	$amsg[230] = 'Text only, no banner';
	$amsg[231] = 'If you only want a welcome text without a banner, mark the corresponding checkbox and click "OK".';
	$amsg[232] = 'A text without banner is already available.<br />Edit the existing text according to your wishes.';
	$amsg[233] = 'Add welcome text only without a banner';
	$amsg[234] = 'Show link to Privacy policy:';
	$amsg[235] = 'URL to the Privacy policy:';
	$amsg[236] = 'Data protection notice:';
	$amsg[237] = 'If you offer a page with a Privacy policy on your website, you have the possibility here to display the link to this page on the two pages of the guestbook "index.php" and "insert.php".
<p>Activate the corresponding option and enter the URL to the page with the data protection declaration in the field below.</p>
If you would like to know more about how and when the script uses cookies and processes IPs, and what options you have to influence this, see sections III.5. in Help, "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-Cookie">Privacy and the myPHP Guestbook</a>".';
	$amsg[238] = 'Open the menu';
	$amsg[239] = 'Menu';
	$amsg[240] = 'Test link';
	$amsg[241] = 'The guest must agree to the processing<br />of his inputs by marking a checkbox:';
	$amsg[242] = 'Currently online:';
	$amsg[243] = 'Please enter valid hexadecimal color code!\\n\\n(hash and 3 or 6 digits)';
	$amsg[244] = 'Color sample for this code';
	$amsg[245] = 'Opacity';
	$amsg[246] = 'The Admin e-mail address should be a separate e-mail account, which is otherwise not used and unknown to other people.';
	$amsg[247] = 'Good Password';
	$amsg[248] = 'Bad Password';
	$amsg[249] = 'Make Password visible:';
	$amsg[250] = 'Rotate image';
	$amsg[251] = 'No change';
	$amsg[252] = '90° to the right';
	$amsg[253] = '90° to the left';
	$amsg[254] = 'Action successful.';
	$amsg[255] = 'If an image is displayed unchanged after a rotation, clear the browser cache and reload the page.';
	$amsg[256] = 'Activation recommended in European Union!';
	$amsg[257] = 'Activate search function:';
	$amsg[258] = 'Activate Permalinks:';
	$amsg[259] = 'Placeholder for the linked permalink icon.';
	$amsg[260] = 'If the Search function as well as the Language selection by the guest are activated, the template should be at least 500px or wider.<br /><br />For further details see under the link "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-search">Help", Section IV. 3.2.2.d, "Activate search function</a>"';
    $amsg[261] = 'Your PHP and MySQL version';
    $amsg[262] = 'You are using PHP version';
    $amsg[263] = 'You are using MySQL version';
    $amsg[264] = 'EU-GDPR';
    $amsg[265] = 'Save IP for '.$delete_spamIps.' days, if an entry<br />was rejected because of spam?';
    $amsg[266] = 'Saving IPs after spam entries is disabled.';
    $amsg[267] = 'Extended Privacy';
    $amsg[268] = 'Completely prevent the processing of IPs and<br />the setting of cookies on the guest\'s terminal?';
    $amsg[269] = 'If this checkbox is checked, the following functions of the <span class="italic nowrap">myPHP Guestbook</span> are deactivated:';
    $amsg[270] = 'If you mark this checkbox and click on "Save", the following functions of the <span class="italic nowrap">myPHP Guestbook</span> will be deactivated:';
    $amsg[271] = 'Attention!';
    $amsg[272] = 'The language selection by the guest';
    $amsg[273] = 'The search function';
    $amsg[274] = 'The statistics about the guestbook hits';
    $amsg[275] = 'The upload of image files by the guest';
    $amsg[276] = 'The recording and temporary blocking of IPs under which spam entries have been made';
    $amsg[277] = 'Protection against automatic mass entries (flood blocking)';
    $amsg[278] = 'Deactivated functions can only be reactivated individually.';
    $amsg[279] = 'All stored IPs and IP-hashes deleted.';
    $amsg[280] = 'It also deletes all IPs and IP hashes stored in the database.';
    $amsg[281] = 'Automatically delete Emojis from an entry<br />if more than '.$maxSmilies.' pieces are used?';
    $amsg[282] = 'If a guest has uploaded new image files and inserted them into his entry, remember to also download the files in the directory "img_guest" from the server to your computer for backup.';
    $amsg[283] = 'If there are problems with the upload using the function above, upload the file via FTP to the "banner" directory.';
    $amsg[284] = 'If there are problems with the upload using the function above, upload the file via FTP to the "img_guest" directory.';
    $amsg[285] = 'Two-factor authentication';
    $amsg[286] = 'Second Password';
    $amsg[287] = 'Enter the following code to login to the Admin Area:';
    $amsg[288] = 'The code is valid for 3 minutes before it expires.';
    $amsg[289] = 'More ...';
    $amsg[290] = 'Because of further configuration possibilities open the file "<span class="blue">settings.inc.php</span>" in the directory "<span class="blue">includes</span>" and read the explanations under "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-MoreKonfig">Help ==> Further configuration options</a>".';
	$amsg[291] = 'If you do not specify a color, "white" is automatically entered.';
	$amsg[292] = 'the quoting of messages by the guest';
	$amsg[293] = '';
	$amsg[294] = '';
	$amsg[295] = '';
	$amsg[296] = '';
	$amsg[297] = '';
	$amsg[298] = '';
	$amsg[299] = '';
    $amsg[300] = 'Username already exists!<br />Please choose a different username.';
    $amsg[301] = 'E-mail address already exists!<br />Please choose a different e-mail address.';
    $amsg[302] = 'If you activate this option, you have the possibility to display your own banner and, if you wish, an individual greeting text on the guestbook pages.<br /><br />This function is not available when using the files from the "include" download.<br /><br />For further details see under the link "<a href="?action=help&#38;'.session_name().'='.session_id().'#anchor-banner">Help", Section IV. 3.5, "Banner and own welcome text</a>"';
    $amsg[303] = 'Edit your Admin credentials here<br />and your Admin e-mail address:';
    $amsg[304] = 'Here you can concede reduced<br />"Moderator rights":';
    $amsg[305] = 'Reduced moderator rights';
    $amsg[306] = 'Moderators can log in to the Admin panel with limited rights.
<p>Moderators can block or release guestbook entries and posted images and comment on entries, but they <strong>cannot delete or edit entries or images</strong>.</p>
<p>They can also create backups and restore entries from backups, as well as view statistics and the "Help" file.</p>
<p>With these restrictions it is allowed to moderators to access the linked pages in the navigation under "Entries", "Backup" and "Miscellaneous".</p>
<p>All other Admin options are disabled or inaccessible for moderators.</p>
<p>You can specify that a moderator like you as Admin will also be informed automatically by the program about new guestbook entries and file uploads via e-mail.</p>
Test the possibilities of a moderator by entering a test person.';
    $amsg[307] = 'Existing moderators:';
    $amsg[308] = 'Flag';
    $amsg[309] = 'Edit or delete selected entry';
    $amsg[310] = 'Attention!\\n\\nThe action cannot be cancelled!\\n\\nContinue?';
    $amsg[311] = 'Language';
    $amsg[312] = 'Edit entry from';
    $amsg[313] = '';
    $amsg[314] = 'No selection has been made!';
    $amsg[315] = 'Please select only one entry for editing!';
    $amsg[316] = 'Add new moderator';
    $amsg[317] = 'Enter new Password optional';
    $amsg[318] = 'Please enter only letters, digits and<br />: - , . ? ! ( ) in the "username" field.';
    $amsg[319] = 'Update check myPHP Guestbook';
    $amsg[320] = 'The version of <span class="italic">myPHP Guestbook</span> you are using could not be determined.<br />Check the variable "&#36;version" in the file "'.$lang_short.'.php", folder "lang".';
    $amsg[321] = 'You are using <span class="italic">myPHP Guestbook</span> '.$version.'.<br />The current version is';
    $amsg[322] = 'You should perform an update';
    $amsg[323] = 'To the download page of "www.php-guestbook.de"<br />click the button below.';
    $amsg[324] = 'To the download page of <span class="italic">myPHP Guestbook</span>';
    $amsg[325] = 'You are already using the current version of <span class="italic">myPHP Guestbook</span>.';
    $amsg[326] = 'Update Check';
    $amsg[327] = 'Comment entry';
    $amsg[328] = '<p>If you allow the upload of large files with more than ~&nbsp;2&nbsp;to&nbsp;3&nbsp;MB, the maximum runtime of a script should be more than 60 seconds and the user should use a correspondingly fast internet connection.</p>
<p>The maximum executable processing time of a script is limited with practically all providers. Anything that cannot be processed by the script within this time will be canceled in the editing process.</p>';
    $amsg[329] = 'The maximum runtime of a script is set by your provider to';
    $amsg[330] = 'seconds';
    $amsg[331] = '';
    $amsg[332] = 'Attention';
    $amsg[333] = 'The maximum size that an uploaded file can have has been set by your provider to';
    $amsg[334] = 'The maximum size that an uploaded file can have has been set by your provider to less than';
    $amsg[335] = 'Individual language selection by the guest ...';
    $amsg[336] = 'deactivate';
    $amsg[337] = 'activate <strong class="red">without</strong> cookie hint:';
    $amsg[338] = 'activate <strong class="red">with</strong> cookie hint:';   
    $amsg[339] = 'recommended setting';   
    $amsg[340] = 'Click here for more information';   
    $amsg[341] = 'Edit entry for the banner.';
    $amsg[342] = 'The display and editing of an individual banner with greeting text is not activated.';
    $amsg[343] = 'If you want to use this feature, you must activate "Activate banner" under "General Configuration".';
    $amsg[344] = 'A new graphic file was found in the directory "banner".';
    $amsg[345] = 'All graphic files in the "banner" directory are registered in the database.';
    $amsg[346] = 'Width';
    $amsg[347] = 'Height';
    $amsg[348] = 'URL for banner';
    $amsg[349] = 'Individual<br />greeting text';
    $amsg[350] = 'characters';
    $amsg[351] = 'Select this entry';
    $amsg[352] = 'No banner recorded in the database.';
    $amsg[353] = 'The banners entered in the database are displayed here and can be edited';
    $amsg[354] = 'max.';
    $amsg[355] = 'Entry selected?';
    $amsg[356] = 'Edit';
    $amsg[357] = 'Delete entry and file';
    $amsg[358] = 'Add uploaded graphic to the banner list';
    $amsg[359] = 'Link to the homepage. - Click!';
    $amsg[360] = '[b]Welcome to the guestbook of my homepage.[/b]\r\n\r\nHere you can publish your opinion or questions about the topic of this website or just leave a short greeting. I look forward to the feedback from every visitor.\r\n\r\nPositive and negative criticism help to deepen what has been achieved and improve what has been less successful.';
	$amsg[361] = 'This function is not available when<br />using the files from the "include" download.';
	$amsg[362] = 'Not available when using the files from the "include" download.';
	$amsg[363] = 'Slovak';
	$amsg[364] = 'Czech';
	$amsg[365] = 'Login lock';
	$amsg[366] = 'Activate or edit this banner';
	$amsg[367] = 'E-Mail after new post<br />also to this moderator?';
	$amsg[368] = 'Enter a new uploaded image in the database:';
	$amsg[369] = 'A new image file was found in the directory "img_guest".';
	$amsg[370] = 'All image files in the "img_guest" directory are registered in the database.';
	$amsg[371] = 'Banner';
	$amsg[372] = 'Show banner';
	$amsg[373] = 'Add banner';
	$amsg[374] = 'How to add your own banner';
	$amsg[375] = 'Load your banner (format *.jpeg, *.png or *.gif) into the directory "banner" on the server.';
	$amsg[376] = 'If the new file is not immediately displayed at the drop-down menu below after uploading, reload this page in your browser.';
	$amsg[377] = 'The file name of the new banner is displayed in the drop-down menu below and can be selected. Click on the button "Save file name".';
	$amsg[378] = 'The banner data are automatically entered into the database. You can then edit the pre-formulated texts freely by clicking on the edit icon: <img class="img-ok" title="Edit entry" src="../images/edit.png" width="14" height="14" alt="Edit entry" />.';
	$amsg[379] = '<p>Inputs in this field cannot be translated automatically by the program and are therefore only displayed in the language set by the Admin.</p>If the language selection is enabled and a user selects another language, entries in this field are ignored and the text from the selected language file is displayed instead.';
	$amsg[380] = 'No entry available!';
          
// End of Admin-Messages
    
// Error-Messages

    $emsg[0] = 'You have not filled in all fields';
    $emsg[1] = 'Incorrect User Name or Password – Please Confirm and try again';
    $emsg[2] = 'E-mail address is missing or invalid';
    $emsg[3] = 'Passwords do not match';
    $emsg[4] = 'An error occurred while creating the backup';
    $emsg[5] = 'You did not choose any backup file';
    $emsg[6] = 'The backup file could not be found, check the contents of the backup folder.';
    $emsg[9] = 'Please enter your name';
    $emsg[10] = 'You did not write any text yet';
    $emsg[11] = 'An error has occurred!';
    $emsg[12] = 'Your access is still blocked due to Spam protection!';
    $emsg[13] = 'The current download version of <span class="italic">myPHP Guestbook</span><br />could not be determined.<br /><br />Please try again later.';
    $emsg[14] = 'Your provider does not provide the necessary extensions<br />to use this feature';
    $emsg[15] = 'If you want to upload image files in the guestbook under activated blog mode or if you want to use BBCodes or Emojis, you have to allow the use of cookies in your browser.';
    $emsg[16] = 'No entry selected.';
    $emsg[17] = 'The guestbook is currently deactivated';
    $emsg[18] = 'Please enter only digits in the "(max.) width of the guestbook" field';
    $emsg[19] = 'Input "transparent" not allowed for background gradient colors!<br />Saved value not changed.';
    $emsg[20] = 'Background gradient colors must be entered!<br />Saved value not changed.';
    $emsg[21] = 'Invalid MIME type! Only image files in the formats';
    $emsg[22] = 'Please enter only digits in the "Entries per page" field';
    $emsg[23] = 'Please enter only digits in the "Number of links at the browsing function" field';
    $emsg[24] = 'Please enter only positive integers in the "Flood ban in minutes" field, min. 0';
    $emsg[25] = 'Please enter only digits in the "Reload ban for statistic in minutes" field';
    $emsg[26] = 'The file is too big, maximum 20 KB!';
    $emsg[27] = 'The chosen BBCode is already in use';
    $emsg[28] = 'A style with the same name exists already';
    $emsg[29] = 'A template with the same name exists already';
    $emsg[30] = 'No badwords available';
    $emsg[31] = 'No Emojis available';
    $emsg[32] = 'Your input contains too many characters.';
    $emsg[33] = 'Your input contains too few characters, min.:';
    $emsg[34] = 'For the date, enter only digits separated by dots or hyphens.';
    $emsg[35] = 'For the time, only enter digits separated by a colon.';
    $emsg[36] = 'Sorry, the entry does not exist or has been locked.';
    $emsg[37] = 'Please enter only digits in the "Maximum word length" field, min. 30 and max. 125';
    $emsg[38] = 'File name too long';
    $emsg[40] = 'Please enter only digits in the "Number of spam points" field, min. 1 and max. 20';
    $emsg[41] = 'Please enter only digits in the "Number of unsuspicious links in contributions" field, min. 0 and max. 20';
    $emsg[42] = 'You have not selected a file or the file has already been entered in the database.';
    $emsg[43] = 'Inadmissible input for IP, only lowercase letters, figures, colons or dots.';
    $emsg[44] = 'Input not completely.';
    $emsg[45] = 'You have not selected a backup file.';
    $emsg[46] = '- Please select only one file to restore!';
    $emsg[47] = 'Attention!\\n\\nIf there are three entries, the oldest backup file will be deleted from the existing entries!\\n\\nContinue?';
    $emsg[48] = 'Invalid characters for the font size';
    $emsg[49] = 'Warning! Caps lock is ON.';
    $emsg[50] = 'Attention!\\n\\If you delete the statistics, the sums of all visitors\\nand page views are also set to zero.\\n\\nContinue?';
    $emsg[51] = 'The last style in the database cannot be deleted for security reasons!';
    $emsg[52] = 'The last template in the database cannot be deleted for security reasons!';
    $emsg[53] = 'Please enter an URL in input field';
    $emsg[54] = 'The URL entered is invalid';
    $emsg[55] = 'To insert BBCodes and emojis in your post Javascript must be activated.';
    $emsg[56] = 'Incorrect input. Only upper case letters, digits and ? ! +';
    $emsg[57] = 'To protect against spam, it is not allowed to enter URLs (links) without using the input mask. -- Please use the BBCode button with the link symbol.';
    $emsg[58] = 'To protect against spam, you are not allowed to enter URLs (links) in a post.';
    $emsg[59] = 'Size file upload in MB: Only digits, min. 1, max. 6'; 
    $emsg[60] = 'Please enter only digits in the "width"- and "height"-fields.';
    $emsg[61] = 'Please enter only letters, digits<br />or  : - , . ? ! in the "Image title" field.';
    $emsg[62] = 'A color must be entered for the fonts.<br />- Input "transparent" not possible for font colors.';
    $emsg[63] = 'characters';
    $emsg[64] = 'Please enter only letters, digits and points in the "Filename" field.';
    $emsg[65] = 'Please enter only digits in the "max. width of the image" field, min. 10, max.';
    $emsg[66] = 'Please enter only digits in the "max. height of the image" field, min. 10, max. 1000';
    $emsg[67] = 'Please enter only digits in the "Image quality" field, min. 10, max. 100';
    $emsg[68] = 'No GD library available, image upload not possible.';
    $emsg[69] = 'In the "background color" fields and the<br />Font color fields only letters, digits or #.';
    $emsg[70] = 'You must agree to the processing of your input!';
    $emsg[71] = 'No valid color designation, see the link below:<br />"Choice of web-safe colors and grey tones"';
    $emsg[72] = 'In the field "(max.) width of the guestbook" you have to make an entry.';
    $emsg[73] = 'Max. width of the guestbook not smaller than 280px.';
    $emsg[74] = 'A color must be entered in the "Font color" field.<br />- Entry "transparent" is not possible for font color.';
    $emsg[75] = 'Please enter only digits in the "max. number image uploads" field, min. 1, max. 10';
	$emsg[76] = 'Please enter only letters, digits and : - , . \' / ( ) in the "Town" field';
	$emsg[77] = 'Please enter only letters, digits and : - , . \' / ( ) in the "Country" field';
	$emsg[78] = 'In "Origin" only letters, digits and : - , . \' / | ( )<br />Town and Country separated by |';
	$emsg[79] = 'In the fields for the title of the guestbook, the link to the entry page,<br />the text for the rating function and the title of the field "Subject"<br />enter only letters, digits or : - , . ? ! () \' /';
	$emsg[80] = 'Invalid entry of a URL. Check inputs in the marked fields.';
	$emsg[81] = 'Please enter only letters, digits and \' - . () in the "Name" field.';
	$emsg[82] = 'Info about a comment to your entry only when entering an e-mail address.';
	$emsg[83] = 'Text input max. 35 characters.';
	$emsg[84] = 'Check the URL in the configuration file!';
	$emsg[85] = 'See also notes under';
	$emsg[86] = 'Invalid title characters, only letters, digits and ? ! \' : . , -';
	$emsg[87] = 'Illegal characters in the text, not allowed < > { } "';
	$emsg[88] = 'The last existing file cannot be deleted!';
	$emsg[89] = 'Error with the database entry of the Admin e-mail address!';
	$emsg[90] = 'Please re-enter and save your Admin e-mail address.';
	$emsg[91] = 'The search term is too short. At least';
	$emsg[92] = 'Invalid input. Only letters, digits and ? ! \' : . , -';
	$emsg[93] = 'The search is limited to';
	$emsg[94] = 'attempts in 1 hour!';
	$emsg[95] = 'At least one link has no anchor text.';
	$emsg[96] = 'You have not specified a place.';
	$emsg[97] = 'You have not specified a country.';
	$emsg[98] = '<strong>Note:</strong> No more than '.$maxSmilies.' Emojis allowed.<br />Some Emojis were therefore automatically removed.';
	$emsg[99] = 'No Password session found.';
	$emsg[100] = 'Fix the errors shown below!';

// End of Error-Messages

// Frontend - Phrasen
    
    $fmsg[0] = 'Enter your personal data here.';
    $fmsg[1] = 'Username';
    $fmsg[2] = 'Guestbook Administration';
    $fmsg[3] = 'Request new password';
    $fmsg[4] = 'Back';
    $fmsg[5] = 'Post a new message:';
    $fmsg[6] = 'You have a new guestbook entry';
    $fmsg[7] = 'Name:';
    $fmsg[8] = 'E-mail';
    $fmsg[9] = 'Homepage:';
    $fmsg[10] = 'Message:';
    $fmsg[11] = 'To help keep the guestbook free of spam, your message will be reviewed by the Administrator before posting.';
    $fmsg[12] = 'There are '.$count_entries.' entries in this guestbook';
    $fmsg[13] = 'Add a new post';
    $fmsg[14] = 'Next';
    $fmsg[15] = 'more ...';
    $fmsg[16] = 'Post Message';
    $fmsg[17] = 'Start of background-color gradient:';
    $fmsg[18] = 'End of background-color gradient:';
    $fmsg[19] = 'Guestbook';
    $fmsg[20] = 'Password';
    $fmsg[21] = 'Important:';
    $fmsg[22] = 'Click on Emoji to insert.';
    $fmsg[23] = 'Home';
    $fmsg[24] = 'Properties';
    $fmsg[25] = 'Style';
    $fmsg[26] = 'Standard style';
    $fmsg[27] = 'Create style';
    $fmsg[28] = 'Delete style';
    $fmsg[29] = 'Edit style';
    $fmsg[30] = 'Template';
    $fmsg[31] = 'Standard template';
    $fmsg[32] = 'Create template';
    $fmsg[33] = 'Delete template';
    $fmsg[34] = 'Edit template';
    $fmsg[35] = 'Emojis';
    $fmsg[37] = 'Show emojis';
    $fmsg[38] = 'Add emoji';
    $fmsg[39] = 'Badwords';
    $fmsg[40] = 'Show badwords';
    $fmsg[41] = 'Add badword';
    $fmsg[42] = 'Backup';
    $fmsg[43] = 'Create backup';
    $fmsg[44] = 'Restore backup';
    $fmsg[45] = 'Miscellaneous';
    $fmsg[46] = 'Statistic';
    $fmsg[47] = 'Help';
    $fmsg[49] = 'Logout';
    $fmsg[50] = 'Open frontend';
    $fmsg[52] = 'Enter your personal data here.';
    $fmsg[53] = 'New Password:';
    $fmsg[54] = 'Repeat Password:';
    $fmsg[55] = 'Save';
    $fmsg[56] = 'Emoji:';
    $fmsg[57] = 'Current language setting: <strong>'.$language.'</strong>. National flag:';
    $fmsg[58] = 'Please choose a style for your guestbook, which will be showed at the next reload.';
    $fmsg[59] = 'Your current style:';
    $fmsg[60] = 'Please choose a template for your guestbook, which will be showed at the next reload.';
    $fmsg[61] = 'Please choose the style, which you want to delete.<br />This process can not be undone.';
    $fmsg[62] = 'Delete';
    $fmsg[63] = 'Your current template:';
    $fmsg[64] = 'Please choose the template, which you want to delete.<br />This process can not be undone.';
    $fmsg[65] = 'Please enter only digits in the width-field';
    $fmsg[66] = 'Please enter only digits in the height-field';
    $fmsg[67] = 'Width:<br />(in px)';
    $fmsg[68] = 'Height:<br />(in px)';
    $fmsg[69] = 'Please choose the style you want to edit.';
    $fmsg[70] = 'Edit';
    $fmsg[71] = 'Change the CSS code however you want.';
    $fmsg[72] = 'CSS style:';
    $fmsg[73] = 'Please choose the template you want to edit.';
    $fmsg[78] = 'The HTML code you enter here is only for one post, so it should be as short as possible.';
    $fmsg[79] = 'Placeholder for the name of the user, that made an entry.';
    $fmsg[80] = 'Placeholder for the linked e-mail icon.';
    $fmsg[81] = 'Placeholder for the linked homepage icon.';
    $fmsg[82] = 'Placeholder for the time of the entry.';
    $fmsg[83] = 'Placeholder for the text of the entry, the user wrote.';
    $fmsg[84] = 'Placeholder for the comment of the Administrator<br />(if available).';
    $fmsg[85] = 'Placeholder for the linked quote icon.';
    $fmsg[86] = 'Placeholder for the max. guestbook width.';
    $fmsg[87] = 'Placeholder for "Post"';
    $fmsg[88] = 'Placeholder for "from"';
    $fmsg[89] = 'Placeholder for "Name / time background color".';
    $fmsg[90] = 'Placeholder for "Entry background color"';
    $fmsg[91] = 'For background color gradients, start and end values must be entered.<br />Enter "transparent" is not allowed.';
    $fmsg[92] = 'Guestbook background color:';
    $fmsg[93] = 'Guestbook alignment:';
    $fmsg[94] = 'Width of the guestbook:';
    $fmsg[95] = 'Placeholder for "posted on"';
    $fmsg[96] = 'Font color';
    $fmsg[97] = 'Select a language';
    $fmsg[98] = 'Name / time background color:';
    $fmsg[99] = 'Entry background color:';
    $fmsg[100] = 'Guestbook background picture URL:';
    $fmsg[101] = 'E-mail graphic:';
    $fmsg[102] = 'Homepage graphic:';
    $fmsg[103] = 'Unlock';
    $fmsg[104] = 'Select all';
    $fmsg[105] = 'Deactivate';
    $fmsg[106] = 'Comment';
    $fmsg[107] = 'Unlocked';
    $fmsg[108] = 'Deactivated';
    $fmsg[109] = 'New guestbook entry';
    $fmsg[110] = 'Features Entry form to the guestbook';
    $fmsg[113] = 'General Settings';
    $fmsg[114] = 'Title of the guestbook:';
    $fmsg[115] = 'Entries per page:';
    $fmsg[116] = 'Number of links in the browsing function:';
    $fmsg[117] = 'Flood ban in minutes:';
    $fmsg[118] = 'Reload ban for statistic in minutes:';
    $fmsg[119] = 'E-mail in case of new post to Admin<br />and -if activated- to Moderator(s):';
    $fmsg[120] = 'Emojis in entries:';
    $fmsg[121] = 'BBCodes in entries:';
    $fmsg[122] = 'Guestbook statistic:';
    $fmsg[123] = 'Entries must be approved:';
    $fmsg[124] = 'Disallow HTML Code:<br /><span class="size-10 red">(Blocking strongly recommended!)</span>';
    $fmsg[125] = 'will not be publicly displayed';
    $fmsg[126] = 'Badword is already available';
    $fmsg[127] = 'Enter the desired badword below,<br />which will be replaced with stars (***).';
    $fmsg[128] = 'Badword:';
    $fmsg[129] = 'Image removed.';
    $fmsg[130] = 'Delete backup file again';
    $fmsg[131] = 'Here you are able to upload your own Emojis,<br />enter therefor the necessary data.';
    $fmsg[132] = 'Create';
    $fmsg[133] = 'Enter your comment on the entry here.';
    $fmsg[134] = 'Delete comment';
    $fmsg[135] = 'Incorrect access data';
    $fmsg[136] = 'Login';
    $fmsg[137] = 'Table:';
    $fmsg[138] = 'Privacy Policy';
    $fmsg[139] = 'Name or alias'; 
    $fmsg[141] = 'Create here your own guestbook style';
    $fmsg[142] = 'Name of the style:';
    $fmsg[143] = 'Code:';
    $fmsg[144] = 'Create here your own guestbook template.<br />To use this feature you need some HTML experience.';
    $fmsg[145] = 'Template name:';
    $fmsg[148] = 'During the recovery from the backup, one or more errors occurred';
    $fmsg[149] = 'The recovery from the backup was successful.';
    $fmsg[150] = 'Back to the login';
    $fmsg[151] = 'E-mail address';
    $fmsg[152] = 'Backup File:';
    $fmsg[153] = 'Recovery';
    $fmsg[154] = 'Guestbook Statistic:';
    $fmsg[155] = 'Total visitors:';
    $fmsg[156] = 'Total requests:';
    $fmsg[157] = 'Statistic of the last '.$recording_days.' days of your guestbook:';
    $fmsg[158] = 'Date:';
    $fmsg[159] = 'Visitors:';
    $fmsg[160] = 'Requests:';
    $fmsg[161] = 'Delete statistic';
    $fmsg[162] = 'You have not activated the statistics.<br />Under "Properties -&#62; General Configuration" you can activate the statistics.';
    $fmsg[164] = 'Here you can see the list of words censored in the guestbook.';
    $fmsg[165] = 'Badword';
    $fmsg[166] = 'Delete all checked';
    $fmsg[168] = 'All Emojis that can be seen on the entry page are shown here.';
    $fmsg[169] = 'Edit:';
    $fmsg[170] = 'Date | Time:';
    $fmsg[171] = 'Placeholder for the date of an entry.';
    $fmsg[172] = 'Quotation:';
    $fmsg[173] = 'Guestbook activated';
    $fmsg[174] = 'Activate minimum / maximum entry length:';
    $fmsg[175] = 'Maximum entry length in characters:';
    $fmsg[176] = 'Minimum entry length in characters:';
    $fmsg[179] = 'Preview';
    $fmsg[180] = 'Left';
    $fmsg[181] = 'Centered';
    $fmsg[182] = 'Right';
    $fmsg[185] = 'Text bold';
    $fmsg[186] = 'Text cursive';
    $fmsg[187] = 'Text underline';
    $fmsg[188] = 'Text shadow';
    $fmsg[189] = 'The entry you\'re replying';
    $fmsg[190] = 'Reply to the message by';
    $fmsg[191] = 'Quotation';
    $fmsg[192] = 'List';
    $fmsg[193] = 'Description';
    $fmsg[194] = 'Link to this post';
    $fmsg[195] = 'Browse all entries';
    $fmsg[196] = '<strong>Disable</strong> input field for e-mail address:';
    $fmsg[197] = 'Install';
    $fmsg[199] = 'Click';
    $fmsg[200] = 'REPLY';
    $fmsg[201] = '<strong>Disable</strong> input field for homepage address:';
    $fmsg[202] = '';
    $fmsg[203] = 'Maximum word length:<br />(recommended ~35 | with activated HTML up to 125):';
    $fmsg[205] = '';
    $fmsg[206] = 'Send a "Thank-you e-mail" to the user:';
    $fmsg[207] = 'Homepage address is invalid';
    $fmsg[208] = 'Edit HTML Code';
    $fmsg[210] = 'Thanks for your comments at';
    $fmsg[211] = 'Spam suspicion: Name without vowels.';
    $fmsg[212] = 'This guestbook entry is awaiting approval. Clicking the following link will allow visibility in the guestbook:';
    $fmsg[216] = 'Forgot your Password?';
    $fmsg[217] = 'If you have not requested a new Password, it is possible that someone tries to enter the Admin Area without permission. Log in there immediately and change the Password as well as the user name and Admin e-mail address.';
    $fmsg[220] = 'Show images in guestbook entries,<br />activate image upload:<br /><span class="size-10">(BBCodes must be activated)</span>';
    $fmsg[221] = 'New Password for logging in to the Admin Area';
    $fmsg[222] = '';
    $fmsg[223] = 'You have requested a new Password to login to the Admin Area of the myPHP Guestbook.<br /><br />The new Password is:';
    $fmsg[226] = 'No entry published at the moment.';
    $fmsg[227] = 'There is one entry in this guestbook';
    $fmsg[228] = 'Posted on:';
    $fmsg[229] = 'Redirect to new URL in homepage field! - Spam';
    $fmsg[230] = 'Posted entry:';
    $fmsg[231] = 'A new entry in the guestbook has been discarded, the sender has been blocked:';
    $fmsg[232] = 'Discarded guestbook entry - Spam';
    $fmsg[233] = 'Deactivated guestbook entry - Spam suspicion';
    $fmsg[234] = 'A new entry in guestbook was deactivated:';
    $fmsg[235] = 'Sender-IP:';
    $fmsg[236] = 'This guestbook entry is currently deactivated.';
    $fmsg[237] = 'Unlock entry including any images that may have been posted?';
    $fmsg[238] = 'Number of Spam-Points:';
    $fmsg[239] = 'This guestbook entry has been discarded, the IP of the sender has been blocked.';
    $fmsg[240] = 'This guestbook entry is currently deactivated due to spam.';
    $fmsg[241] = 'Block the guestbook entry?';
    $fmsg[242] = 'Suspicion of spam: The links placed by the author in his entry exceed the unsuspected number by -';
    $fmsg[243] = 'Spam: The author took less than 4 seconds for his entry.';
    $fmsg[244] = 'Suspicion of spam: The author took at least 4 seconds, but less than 9 seconds for his entry.';
    $fmsg[245] = 'Suspicion of spam: The author took more than 1 hour for his entry.';
    $fmsg[246] = 'Suspected spam: More than 30 keystrokes per second.';
    $fmsg[247] = 'Time side call - entry submit:';
    $fmsg[248] = 'sec.';
    $fmsg[249] = 'Number of keystrokes:';
    $fmsg[250] = 'keystrokes/sec.:';
    $fmsg[251] = 'Spam: one or more hidden input fields were used.';
    $fmsg[252] = 'Spam suspicion: Posting with spamwords!';
    $fmsg[253] = 'The spam words found are:';
    $fmsg[254] = 'Number of uses in the text:';
    $fmsg[255] = 'Number of spam-points,<br />that lead to a post being rejected:<br /><span style="font-size:10px;font-weight:normal;">(recommended: 4-5 / possible: min. 1 and max. 20)</span>';
    $fmsg[256] = 'Detecting and preventing spam<br />with keywords in posts:';
    $fmsg[257] = 'Detect and prevent spam by<br />the number of links in posts:';
    $fmsg[258] = 'Number of unsuspected links in posts:<br /><span style="font-size:10px;font-weight:normal;">(recommended: up to 2 / possible: min. 0 and max. 20)</span>';
    $fmsg[259] = 'Evaluation of spam features';
    $fmsg[260] = 'Used hidden input: + 5 points<br />Entry starts with a link: + 1 pt.<br />Redirection in homepage field: + 4 pts.<br />Submit entry &#60; 4 sec.: + 5 pts.<br />Submit entry &#60; 9 sec.: + 1 pt.<br />Submit entry &#62; 1 h + 1 pt.<br /><strong class="red size-20">*</strong> &#62; 30 keystrokes/sec.: + 1 pt.<br /><strong class="red size-20">*</strong>No or wrong referrer: + 3 pts.<br /><strong class="red size-20">*</strong>Each spamword: + 1 pt.<br /><strong class="red size-20">*</strong>Each link above limit: + 1 pt.<br /><strong class="red size-20">*</strong>Name without vowel(s): + 1 pt.<hr /><strong class="red size-20">*</strong> May be disabled, see <a class="red" href="?action=help&#38;'.session_name().'='.session_id().'#anchor-disableSpam">HERE</a>';
    $fmsg[261] = 'Activation only possible if at least one keyword exists.';
    $fmsg[262] = '<b>Attention!</b><br /><br />The guestbook entry was deactivated!';
    $fmsg[263] = '<b>Attention!</b><br /><br />The activation code is invalid, no entry was deactivated!';
    $fmsg[264] = '<b>Attention!</b><br /><br />The guestbook entry including possibly posted images has been activated!';
    $fmsg[265] = '<b> Attention!</b><br /><br />The activation code is invalid, no entry has been activated!';
    $fmsg[266] = 'Link opens a new window';
    $fmsg[267] = 'This guestbook entry has been discarded.';
    $fmsg[268] = 'Emojis';
    $fmsg[269] = 'Cancel';
    $fmsg[270] = 'Change language?';
    $fmsg[271] = 'Javascript must be activated.';
    $fmsg[272] = '';
    $fmsg[273] = 'Fold up';
    $fmsg[274] = 'gray';
    $fmsg[275] = 'Delete backups from the server<br />after sending them by e-mail?';
    $fmsg[276] = 'Attention!\\n\\nWhen changing the template, please remember\\nto change the corresponding CSS-style!\\n\\nContinue?';
    $fmsg[277] = 'Attention!\\n\\nWhen changing the CSS style, please remember\\nto change the corresponding template.\\n\\nContinue?';
    $fmsg[278] = 'Spam suspicion: Direct call of the input form (no Referrer).';
    $fmsg[279] = 'Statistics since ';
    $fmsg[280] = 'crossed-out text';
    $fmsg[281] = 'justify';
    $fmsg[282] = 'right-justified text';
    $fmsg[283] = 'superscript';
    $fmsg[284] = 'List with bullets';
    $fmsg[285] = 'List with numbers';
    $fmsg[286] = 'dividing line';
    $fmsg[287] = 'Add a link';
    $fmsg[288] = 'Add an e-mail address';
    $fmsg[289] = 'Color';
    $fmsg[290] = 'yellow';
    $fmsg[291] = 'orange';
    $fmsg[292] = 'lime';
    $fmsg[293] = 'pink';
    $fmsg[294] = 'brown';
    $fmsg[295] = 'Size';
    $fmsg[296] = 'Input fields guestbook';
    $fmsg[297] = 'Enter an anchor text for the link:';
    $fmsg[298] = 'The text entered here is the<br />link to be clicked on in the post.';
    $fmsg[299] = 'Please enter complete URL';
    $fmsg[300] = 'Entry complete,<br />insert the entries into your post';
    $fmsg[301] = 'Enter the e-mail address,<br />which should appear in your post:';
    $fmsg[302] = 'You have not entered an anchor text.<br /><br />Try again ...';
    $fmsg[303] = 'The entry can be up to 80 characters long.';
    $fmsg[304] = '';
    $fmsg[305] = 'You have not entered an e-mail address.<br /><br />Try again ...';
    $fmsg[306] = 'red';
    $fmsg[307] = 'green';
    $fmsg[308] = 'blue';
    $fmsg[309] = 'centered text';
    $fmsg[310] = 'Add an image';
    $fmsg[311] = 'send an e-mail';
    $fmsg[312] = '<strong>You can search for:</strong><ul><li>Usernames,</li><li>Date,</li><li>Text in messages and comments</li></ul>';
    $fmsg[313] = 'Subject:';
    $fmsg[314] = 'maximum permissible length of your entry:';
    $fmsg[315] = 'characters';
    $fmsg[316] = 'Characters remaining:';
    $fmsg[317] = 'Please, shorten your entry by';
    $fmsg[318] = 'This image must<br />still be released.';
    $fmsg[319] = 'This guestbook entry is activated, possibly contained images are still blocked.';
    $fmsg[320] = 'Unlock image(s)?';
    $fmsg[321] = 'Quote this message';
    $fmsg[322] = 'Reply to this message';
    $fmsg[323] = 'Unlock text + image';
    $fmsg[324] = 'Unlock only text';
    $fmsg[325] = 'Delete entry';
    $fmsg[326] = 'Lock entry';
    $fmsg[327] = 'Posting frame color:';
    $fmsg[328] = '<p class="text-center"><strong class="red">Attention!</strong><br /><br />When changing the template, please remember to change<br />also the corresponding standard CSS-style!</p>';
    $fmsg[329] = '<p class="text-center"><strong class="red">Attention!</strong><br /><br />When changing the CSS style, please remember to change<br />also the corresponding standard template!</p>';
    $fmsg[330] = 'Placeholder for "Guestbook background color".';
    $fmsg[331] = 'The following variables can be used in the CSS code:';
    $fmsg[332] = 'Placeholder for guestbook alignment';
    $fmsg[333] = 'Placeholder for font color';
    $fmsg[334] = 'Required field';
    $fmsg[335] = 'Use of BBCodes not possibly.';
    $fmsg[336] = 'Use of Emojis not possibly.';
    $fmsg[337] = 'optional';
    $fmsg[338] = 'Enable spam protection';
    $fmsg[339] = 'To reactivate spam protection,<br />open the file "settings.inc.php" in the folder<br />"includes" and set the constant "SPAM_PROTECT"<br />from "false" to "true".<br /><br />Then save the modified file<br />"settings.inc.php" and upload it back to the server.';
    $fmsg[340] = '<strong>Attention!</strong> Spam protection is deactivated!*';
    $fmsg[341] = 'Enable image upload check';
    $fmsg[342] = 'To enable the verification and activation of uploaded<br />image files by the Admin again,<br />open the file "settings.inc.php" in folder<br />"includes" and set the constant "PIC_CHECK"<br />from "false" to "true".<br /><br />Then save the modified file<br />"settings.inc.php" and upload it back to the server.';
    $fmsg[343] = '<strong>Attention!</strong> Uploaded files are immediately<br />visible without approval by the Admin!';
    $fmsg[344] = 'Lock image(s)?';
    $fmsg[345] = 'The following variables can be used in the template:';
    $fmsg[346] = 'Place:';
    $fmsg[347] = 'Country:';
    $fmsg[348] = 'Your Message';
    $fmsg[349] = 'from ';
    $fmsg[350] = 'Check to be notified by e-mail if a reply is posted:';
    $fmsg[351] = 'Your message will be activated as soon as the Administrator gets a chance to review.';
    $fmsg[352] = 'Website rating:';
    $fmsg[353] = 'Star';
    $fmsg[354] = $fmsg[3541] = 'Stars';
    $fmsg[355] = 'Delete rating';
    $fmsg[356] = 'Placeholder for the rating function';
    $fmsg[357] = 'of 5 stars';
    $fmsg[358] = 'Average';
    $fmsg[359] = 'of';
    $fmsg[360] = 'ratings';
    $fmsg[361] = 'This new Password remains valid for';
    $fmsg[362] = 'minutes and is then automatically deactivated for security reasons.';
    $fmsg[363] = 'Search';
    $fmsg[364] = 'Delete search';
    $fmsg[365] = 'Reset';
    $fmsg[366] = 'Detected';

// END of Frontend - Phrasen  
    
// File-Upload - Phrasen
       
    $pmsg[1] = '<p class="text-center"><strong>Before we go...</strong></p>
<p class="text-justify">Photos and image files are protected by copyright. Therefore, only self-made images may be uploaded and published in your contribution.</p>
<p>By clicking the "Confirm Terms of Use" button, you confirm that </p>
<ul>
<li>...you only upload images and use them in your entry to which you have unrestricted rights of use and</li>
<li>...you do not use any files that originate from third parties, in particular do not post any images copied from the Internet or elsewhere without permission.</li>
</ul>
<p class="text-justify"><strong>Posting of pornographic, sexist, obscene, racist, violent or otherwise offensive images is prohibited.</strong></p>
<p>&nbsp;</p>
<p class="text-justify"><strong>Attention:</strong> When uploading files, the contents of an EXIF header are removed for security reasons, which also includes, for example, information on camera or recording data, any copyright information that may be included, etc. In addition, the uploaded graphic files will be resized to fit the layout of the guestbook. The motifs may be found later on by search engines.</p>';
	$pmsg[2] = 'Confirm Terms of Use';
	$pmsg[3] = 'Cancel';
	$pmsg[4] = 'Here\'s how you add an image to your post:';
	$pmsg[5] = 'The maximum size of the original application file may be:';
	$pmsg[6] = 'Allowed file formats are:';
	$pmsg[7] = '<p>The larger a file, the longer the loading time! Depending on file size and Internet connection, the upload time may be 1 minute or more.</p>
<p class="text-center"><strong>The end and success of the loading process are displayed,<br />- so please be patient.</strong></p>';
	$pmsg[8] = 'Storage not possible.<br /><strong>Please contact the Admin.';
	$pmsg[9] = 'File exceeds the upload size<br />in php.ini';
	$pmsg[10] = 'If you don\'t have the ability to resize the file, you can send it to me by e-mail, I will insert it for you.';
	$pmsg[11] = '<strong>File only partially uploaded!</strong><br />Please try again.';
	$pmsg[12] = 'No file selected!';
	$pmsg[13] = '<strong>Invalid file format!</strong><br />Only image files in the formats .jpg, .jpeg, .png, .JPG, .JPEG';
	$pmsg[14] = '<strong>File too big!</strong>';
	$pmsg[15] = 'Enter description of uploaded image:';
	$pmsg[16] = '<p>You have not accepted the terms of use for the file upload or an error has occurred in the confirmation.</p><p>Please try again.</p>';
	$pmsg[17] = 'myPHP Guestbook file upload';
	$pmsg[18] = '<b>Attention!</b>
<br /><br />
An image file was uploaded in the guestbook on <b>'.GB_DATE.'</b> at '.date("H:i").' o\'clock.
<br /><br />
<b>It is strongly recommended to check the file for harmlessness before releasing it!</b><br /><br />
The image should be displayed at the bottom of the page and can otherwise be accessed by clicking on the following link:';
	$pmsg[19] = 'The file was successfully uploaded.';
	$pmsg[20] = '<p><strong>Please click on the "Generate code" button to insert the tags into your post that are required for the subsequent display of your image.</strong></p><br />
<p class="text-center red">The code between the two tags: <strong>"[img]... [/img]"</strong><br />should <strong>not be changed after that</strong>!</p>';
	$pmsg[21] = 'Generate code';
	$pmsg[22] = '<strong>Invalid MIME type!</strong><br />Only image.jpg or image.png!';
	$pmsg[23] = 'Upload';
	$pmsg[24] = 'What do you want to do next?';
	$pmsg[25] = 'Upload another image';
	$pmsg[26] = 'Exit procedure and close window';
	$pmsg[27] = 'e.g. place or motif, name of the photographer or similar...<br />The entry in the input field can be changed at will.';
	$pmsg[28] = '<strong>Conspicuous file name, upload aborted.</strong><br />Please rename the file.';
	$pmsg[29] = '<strong>An error has occurred. </strong><br />Please try again.';
	$pmsg[30] = 'Maximum of';
	$pmsg[31] = 'image(s) per contribution';
	$pmsg[32] = '(upload one after the other)';
	$pmsg[33] = 'limit reached';
	$pmsg[34] = 'Image too small (min. 10px high and wide)';
	$pmsg[35] = 'In progress ...';

?>