<?php
/*
    myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
    myPHP Guestbook was an open source project of Networkarea.ch

    Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

    Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

    This file is a part of myPHP Guestbook.
    myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
    GNU General Public License as published by the Free Software Foundation; either version 3 of the 
    License, or (at your option) any later version.

    myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
    even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    See the GNU General Public License for more details.

	02.01.2022
*/

    // Neue Variablen

    $version    = "V 4.10.9";
    $encoding   = "utf-8";
    $language   = "English";
    $lang_short = "en";
    $flag		= "en";
    
    (BEST_PW) ? $atmsg = "You can continue the installation or update." : $atmsg = "You should first switch to a <strong>higher PHP version</strong> before proceeding with the installation or update.";

    //Intro
    
    $stmsg[0] = 'Installation and update tool for SQL database connection<br />from myPHP Guestbook '.$version.'';
    $stmsg[1] = '<p>With this file you can either install or reinstall the myPHP Guestbook for the first time or just update from one of the earlier guestbook versions from 3.0 to the latest version '.$version.'.</p>
<p>Before you start, please read and carefully follow the instructions in the ReadMe file.</p>
<p>In order for the myPHP Guestbook to run correctly, the script must be processed on your server <strong>with at least PHP 7.0.x or higher</strong>, in addition to an SQL database (MySQL 5.+ or 8.0). (Installations under PHP 5.0 to 5.6 are no longer tested. Maybe they work, maybe they don\'t. Installations under PHP 4.x are guaranteed not to work.) Your server is currently working with <strong>PHP '.phpversion().'</strong>. '.$atmsg.'</p>';
    $stmsg[2] = '<p>For an <strong>initial or new installation</strong> you should upload all files from the guestbook folder downloaded from "www.php-guestbook.de" to your webspace.</p>
<p>For an <strong>update</strong>, all other new files from the package must also be uploaded to your webspace, <strong style="color:red">with the exception of the file "config.inc.php" in the folder "includes"</strong> and the tables in the database, as they were needed and created for the guestbook versions 3.x, must still be available.</p>';
    $stmsg[3] = 'Please choose:';
    $stmsg[4] = 'I\'d like to do a complete reinstallation of the myPHP Guestbook '.$version.':';
    $stmsg[5] = 'My database is at least up to date with one of the versions 3.x.<br />I would therefore only like to update the database to version '.$version.':';
    $stmsg[6] = 'complete installation myPHP Guestbook '.$version.'';
    $stmsg[7] = 'Database update for myPHP Guestbook '.$version.'';
    $stmsg[8]  = '';
    $stmsg[9]  = '';
    $stmsg[10]  = '';
    
    // Installer - Phrasen

    $imsg[0]  = 'myPHP Guestbook Installation Tool';
    $imsg[1]  = 'URL';
    $imsg[2]  = 'Document Root'; 
    $imsg[3]  = 'The URL & the server path of your myPHP Guestbook installation on your server.<br />Do not change, please.';
    $imsg[4]  = 'Database Host';
    $imsg[5]  = 'Hostname of your MySQL database.<br />Often localhost, some hosters use separate database servers.<br />Enter here the database server that was named to you by your hoster.';
    $imsg[6]  = 'Database Username';
    $imsg[7]  = 'Database Password';
    $imsg[8]  = 'Databasename';
    $imsg[9]  = 'Username, Password and Databasename of your database<br />(Your hoster will tell you this data.)';
    $imsg[10]  = 'Database Table-Prefix';
    $imsg[11]  = 'The Prefix from the myPHP-Guestbook-Tables in database.';
    $imsg[12]  = 'Choose a language';
    $imsg[13]  = 'The language to be used by myPHP-Guestbook.<br />(German | English | French | Italian | Dutch | Polish | Portuguese | Swedish | Slovak | Czech)<br /><strong>The selection made here determines the displayed language (German - English) for the rest of the installation.</strong><br />After the installation a selection of different national flags can be made in the admin panel.';
    $imsg[14]  = 'E-mail address:';
    $imsg[15]  = 'The guestbook Administrator e-mail address';
    $imsg[16]  = 'Admin username:';
    $imsg[17]  = 'Your Admin username. <strong style="color:red;">For security please change individually!</strong>';
    $imsg[18]  = 'Admin-Password';
    $imsg[19]  = 'Your Admin-Password.';
    $imsg[20]  = 'Folder and file tests:';
    $imsg[21]  = 'available';
    $imsg[22]  = 'writable';
    $imsg[23]  = 'not writable';
    $imsg[24]  = 'not available';
    $imsg[25]  = 'GD Support:';
    $imsg[26]  = 'BC Math Support:';
    $imsg[27]  = 'Complete';
    $imsg[28]  = 'Cannot connect to ';
    $imsg[29]  = 'with the supplied username and password';
    $imsg[30]  = 'Go Back';
    $imsg[31]  = 'Step 1';
    $imsg[32]  = 'Write configuration file and check database connection...<br /><br />';
    $imsg[33]  = ' <strong style="color:green; font-size:16px;">Complete!</strong><br /><br />Now to '; 
    $imsg[34]  = ' Step 2';
    $imsg[35]  = 'Installation complete now.<br /><strong style="color:red;">For security reasons, delete the complete folder "install" from your server.</strong>';
    $imsg[36]  = 'Go to Admin-Control-Panel';
    $imsg[37]  = 'Go to Guestbook Frontend';
    $imsg[38]  = 'or';
    $imsg[39]  = 'Install';
    $imsg[40]  = 'Cannot select database';
    $imsg[41]  = 'MySQLi Support:'; 
    $imsg[42]  = 'Cancel installation, the necessary MySQLi extension is not available';
    $imsg[43]  = 'GZip Support';
    $imsg[44]  = 'The necessary MySQLi extension is not available.';
    $imsg[45]  = 'Please, check the availability of MySQLi with "phpinfo(INFO_MODULES)"';
    $imsg[46]  = 'Your browser is not able to display embedded frames:<br />You can access the embedded page via the following link:';
    $imsg[47]  = 'The guestbook installer cannot create the configuration file for access to the database. Please enter the necessary data directly. Proceed as follows:
<p>Verify the database credentials seen in the text box below. These are the first four variables after the copyright notice:<ul><li>SQL-Server ("database host"),</li><li>Database Name,</li><li>Database Username and</li><li>Database Password.</li></ul></p>
<p>Correct the access data if necessary.</p>
<p>Open the file "config.inc.php" from the directory "includes" with an editor.</p>
<p>Copy the <strong>complete</strong> code from the text box and paste it into the "config.inc.php" file</p>
<p>Save this change and upload the "config.inc.php" file to the "includes" directory on the server.</p>';
    $imsg[48]  = 'After this is finished, you can continue with ';
    $imsg[49]  = 'The Zip module seems to be unavailable.<br />The installation can still be done, but backups are not compressed.';
    $imsg[50]  = 'The module GDLIB seems to be unavailable.<br />The installation can still be done, but no photo upload with automatic resizing is possible.';
    $imsg[51]  = 'Please, upload the folders from the download package by using FTP.';
    $imsg[52]  = 'Please read the section: "Special Folder Rights" in the attached "ReadMe.pfd".';
    $imsg[53]  = 'The time zone of your<br />internet presence';        
    $imsg[54]  = 'Select your home country here, according to whose time zone the entries in the guestbook will be saved.<br />If you don\'t find anything suitable, select "others".<br />For changes after installation, see "Help" in the Admin Control Panel.';        
    $imsg[55]  = 'You have not filled all the fields';        
    $imsg[56]  = 'To avoid errors during installation, only the following entries are permitted for the SQL database password and the Administrator password:<br /><br />lower and upper case letters (without diacritics Ö,Ü,Ä etc.), digits and ! ? ( )';
    $imsg[57]  = '<b>Great!</b><br /><br />The PHP e-mail function is active. The automatic e-mail distribution with the myPHP-Guestbook program works.<br /><br />Enjoy the guestbook.<br />Wolfgang Leverberg<br />';
	$imsg[58]  = '<p>Then check your e-mail inbox. The program sent an automatically generated test mail to the admin e-mail address you entered. This checks if the "mail()"function of PHP is active on your server.</p>
<p><strong>Attention!</strong> If you have installed the software locally on your computer, you will usually receive an error message:<br /><br /><strong style="color:red;text-align:center;">Warning: mail():...</strong></p>
<p>This is because a local server cannot send e-mails. You can ignore the error message, which should normally no longer appear on the "real" server.</p>
<p>If you can\'t detect any incoming test mail in spite of installation on your "real" web server and despite correct input of your e-mail address, the "mail()"function seems to have been deactivated by your provider.</p>
<p>In this case, a number of functions of the myPHP guestbook are restricted. For example, you will not receive an e-mail with a new guestbook entry, with spam attempts or photo uploads, the backups created with the program cannot be sent to you automatically and you cannot have a new password sent to you for login if you have forgotten the old one, etc.</p>
<p>If you do not receive any e-mails from the program, contact your provider and ask if they are ready to enable the "mail()"function.</p>';
	$imsg[59]  = 'Test e-mail';
	$imsg[60]  = 'Link zur Startseite der Homepage';
	$imsg[61]  = 'Link to the homepage. - Click!';
	$imsg[62]  = '[b]Ich begrüße Sie im Gästebuch meiner Homepage.[/b]\r\n\r\nHier können Sie Ihre Meinung oder Fragen zu dem Thema dieser Website veröffentlichen oder einfach nur einen kurzen Gruß hinterlassen. Ich freue mich über jedes Feedback eines Besuchers.\r\n\r\nPositive und negative Kritik helfen dabei, gut Gelungenes zu vertiefen und weniger gut Gelungenes zu verbessern.';
	$imsg[63]  = '[b]Welcome to the guestbook of my homepage.[/b]\r\n\r\nHere you can publish your opinion or questions about the topic of this website or just leave a short greeting. I look forward to the feedback from every visitor.\r\n\r\nPositive and negative criticism help to deepen what has been achieved and improve what has been less successful.';
	$imsg[64]  = 'Your new guestbook is now installed! :coke: \r\n\r\nPlease delete the installation folder from your server for security reasons. :) \r\n\r\nCheck and change the configuration settings in the admin panel according to your needs and wishes.\r\n\r\nCurrently the template "[b][i]wide 2[/b][/i]" is set. If you switch to another template, please remember [b]to set the corresponding CSS-style[/b]!\r\n\r\n[shadow]Do you like the script? Then please write an entry in my [url=https://www.php-guestbook.de/start.gbook.php]guestbook[/url].[/shadow] :pollex:';
	$imsg[65]  = 'This entry can be deleted in the admin panel!';
	$imsg[66]  = '<strong>Password should contain at least the following:</strong>';
	$imsg[67]  = 'A <strong>lowercase</strong> letter';
	$imsg[68]  = 'A <strong>capital (uppercase)</strong> letter';
	$imsg[69]  = 'A <strong>number</strong>';
	$imsg[70]  = 'Minimum <strong>11 characters</strong>';
	$imsg[71]  = 'To avoid problems during the installation, use as special characters in the admin password only ( ) ! ?<br />You can re-set the password in the admin panel after the installation is successfully completed and there you can also use other special characters.';
	$imsg[72]  = 'Please enter only letters, digits and<br />: - , . ? ! ( ) in the "Admin username" field.';
	$imsg[73]  = '<p>A connection to the database has already been established, so that an installation of the <span style="font-style:italic;">myPHP-Guestbook</span> may already exist. The variables required for using the<span style="font-style:italic;">myPHP-Guestbook</span> are also available.</p>
<p>You can simply proceed and thus delete and rewrite both, the already existing configuration file ("conig.inc.php") with the connection data to the database, as well as the presumably existing database tables.</p>
<p>In doing so, you have the option to enter a new prefix for the <span style="font-style:italic;">myPHP-Guestbook</span> tables in the database below. In this case, any existing old tables are retained and additional new tables are created. - But the program will then only access the new tables.</p>
<p>However, you can also skip the creation of the configuration file and just recreate all database tables with unchanged prefix.</p>
<p>If you only want to have the database tables rewritten, click on';
	$imsg[74]  = 'For the SQL database password, please use only lowercase and uppercase letters, digits and # ! ? ( )';
    $imsg[75]  = 'To avoid errors during the installation, only the following characters are allowed for the admin password:<br /><br />Lower or upper case letters (without diacritics Ö,Ü,Ä etc.), digits and ! ? ( )<br />No hash(#).';
	$imsg[76]  = 'For the admin password please do not use hash(#), only lower and upper case letters, numbers and ( ) ! ?';
	$imsg[77]  = 'this Link';
	$imsg[78]  = '<p>A connection to the database has already been established and you have decided to recreate only the database tables to the <span style="font-style:italic;">myPHP-Guestbook</span>.</p>
<p>To do this, please fill in the fields below and then click "Install".</p>
<p>If you have changed your mind and would rather do a complete reinstallation including a new creation of the configuration file, click on';
	$imsg[79]  = 'The inputs were recorded for storage in the database.<br />';
        
    $emsg[0]  = 'You have not filled in all fields';
    $fmsg[196]  = 'Now enter your user name and password with which you want to log in to the admin control panel in the future.<br />The e-mail address is required so that you can be notified of new guestbook entries or file uploads and BackUps can be sent.';
    
	//Database Update Stand 4.10.7+
	
	$dbmsg[0]  = 'Your database is now up to date for use with the myPHP Guestbook script '.$version.'.';
	$dbmsg[1]  = 'An error has occurred.<br />Please contact me: <a href="mailto:post@php-guestbook.de">post@php-guestbook.de</a></a>';
	$dbmsg[2]  = 'Database extension to myPHP-Guestbook';
	$dbmsg[3]  = '<p>This script is designed to change the database tables and their entries, as they exist after installing myPHP Guestbook from one of the versions <strong>3.x</strong> to '.$version.'. <strong>For the older guestbook versions 1. x and 2. x the script is unsuitable!</strong></p>';
	$dbmsg[4]  = '<p><strong>If you have previously used a version 4.6.3 or lower:</strong> With this script the database will be extended to your guestbook. This means that both additional tables are created and existing tables are rewritten with the addition of additional columns. With an update from version 4.6.3 or lower, new columns will be added to the table with the guestbook entries, furthermore, it will remain unchanged in its structure, so that under normal circumstances all previous entries will be retained after the update.</p>';
	$dbmsg[5]  = '<p>However, the intervention in an existing database always carries the potential danger of data loss or other functional problems. Therefore, please read the "ReadMe"file and follow these instructions:</p>';
	$dbmsg[6]  = 'I do not take over any guarantee for possible loss of data or other malfunctions by using this script, no matter what kind. Anyone who is concerned about this should abort at this point and live with what they currently have!';
	$dbmsg[7]  = 'The script has been tested several times and runs under PHP 7.0.x up to and including PHP 8.1.x on an Apache without errors.';
	$dbmsg[8]  = 'In order to take precautions for all cases, please make a back up of the guestbook entries before starting this script and save them safely!';
	$dbmsg[9]  = 'If you have myPHPAdmin, mySqlDumper or a similar program at your provider\'s disposal, you should make a complete backup copy of the existing database.';
	$dbmsg[10] = '';
	$dbmsg[11] = '<p>Already with the call of the script it was checked if the necessary database connection can be established and if MySQLi is available in your PHP configuration. It turned out that...</p>';
	$dbmsg[12] = '.. the MySQLi extension of PHP is not available on your server, which is mandatory for proper operation of the guestbook script.';
	$dbmsg[13] = 'Therefore, you must abort at this point until you have clarified this with your provider.';
	$dbmsg[14] = '.. MySQLi is available on your server, but ..';
	$dbmsg[15] = '..  there is no connection to the database, so the update cannot be executed.';
	$dbmsg[16] = 'Check the file "config.inc.php" in the "includes" folder.';
	$dbmsg[17] = '.. everything was fine; the database connection could be established and the automatic check showed that the MySQLi extension of PHP is available on your server.';
	$dbmsg[18] = 'Now make sure which version of <span style="font-style:italic;">myPHP Guestbook</span> you currently have installed and then select the version you need from the various database updates. - <strong>Proceed carefully! Choosing a "wrong" database update can cause problems!</strong> In particular, if you have already installed a guestbook version from 4.4.0 or higher and are now erroneously performing one of the following two database updates, which are intended for the guestbook versions up to 4.3. and smaller, this would lead to a loss of all entries in the table "_pictures", in which the linked photo uploads are recorded.';
	$dbmsg[19] = 'Here we go';
	$dbmsg[20] = 'I currently have one of the myPHP Guestbook versions';
	$dbmsg[21] = 'Customize myPHP Guestbook database from';
	$dbmsg[22] = 'to';
	$dbmsg[23] = 'Deletes and rewrites from the existing tables:';
	$dbmsg[24] = 'new tables are created.';
	$dbmsg[25] = 'New columns are added to the existing tables:';
	$dbmsg[26] = 'In the table "*_entries" the status of the entries is set to "1".';
	$dbmsg[27] = 'The existing entries in the old table "*_properties" for "Admin e-mail","Language selection" and "Username" are taken over, the rest is rewritten.';
	$dbmsg[28] = 'From the existing entries in the table "*_properties" will be changed: "Title of the guestbook", "Maximum word length", "Number of links with the scrolling function", "Password" and the check for "Minimum/maximum entry length" will be activated, the other default settings will be retained.';
	$dbmsg[29] = 'to';
	$dbmsg[30] = 'from';
	$dbmsg[31] = 'installed.<br />I would therefore like to make adjustments to';
	$dbmsg[32] = 'From the existing entries in the table "*_properties" will be changed: "Title of the guestbook", "Maximum word length" and "Password", the other default settings will be retained.';
	$dbmsg[33] = 'I currently have the myPHP Guestbook version';
	$dbmsg[34] = 'From the existing entries in the table "*_properties" will be changed: "Title of the guestbook" and "Password", the other settings will be retained.';
	$dbmsg[35] = 'Adapt database';
	$dbmsg[36] = 'An error has occurred.';
	$dbmsg[37] = 'Please contact me';
	$dbmsg[38] = 'Your database is now up to date for use with the myPHP Guestbook script';
	$dbmsg[39] = '<strong style="color:red">Mark the <span style="font-style:italic;">myPHP Guestbook</span> version you have installed.</strong>';
	$dbmsg[40] = 'You have not selected a guestbook version.';
	$dbmsg[41] = 'Back to start page';
	$dbmsg[42] = 'I want to update to '.$version.' and currently have the following version installed:';
	$dbmsg[43] = 'Adapt database tables to '.$version.'.';
	$dbmsg[44] = 'new table will be created.';
	$dbmsg[45] = '<p><strong>Now log in to the admin panel and click on the link: "Admin Data".</strong></p><p><strong>If you see that your password is not sufficiently protected,<br />re-enter the password, click "Save" and then reload the page.</strong></p>';
	$dbmsg[46] = '<strong>Please note: When updating from V. 4.10.0 or higher to '.$version.', this script is not required because changes to the database are not necessary for error-free operation. With v. 4.10.4 only three CSS styles for the visual design of the buttons were slightly changed and with v. 4.10.7 a new style and a new template were added.</strong>';
//	$dbmsg[46] = '';
	$dbmsg[47] = 'You have not entered an admin name.';
	$dbmsg[48] = 'For better protection of your password, it is <strong>mandatory</strong> to enter an admin user name and an admin password for login to the admin panel when updating from version 4.6.3 or lower.';
	$dbmsg[49] = 'You have not entered an admin password.';
	$dbmsg[50] = 'From the existing entries in the table "*_properties" will be changed: "Title of the guestbook", the other settings will be retained.';
	$dbmsg[51] = 'Several table columns are changed from "NOT NULL" to "NULL" in the tables: "*_entries", "*_properties", "*_login", "*_banner", "*_template", "*_ip_ban", "*_pictures", "*_thankyou", "*_login_counter".';
	$dbmsg[52] = 'A new entry is added to each of the tables "*_template" and "*_style" to install another template in black, based on the already existing template "Wide 2". The existing templates and styles will not be changed.';
	
?>