<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate");
	header("Pragma: no-cache");

	require_once("includes/functions.inc.php");

	//Exclusion of permanently blocked IPs according to the table with redirection to the guestbook
	$ip_sperre = $gbook->query("SELECT `id` FROM `".$table."_forbidden_ip` WHERE `ip` = '".$_SERVER['REMOTE_ADDR']."'") or die();

	if ($ip_sperre != ""){
		$sperre = $ip_sperre->num_rows;
	}

	$showErrors = $mark_name = $mark_email = $mark_hp = $mark_town = $mark_country = $mark_subject = $mark_text = $mark_name2 = $mark_email2 = $mark_hp2 = $mark_town2 = $mark_country2 = $mark_subject2 = $mark_text2 = $mark_priv2 = $mark_info2 = "";
	$bad = $good = $count_entries = $separated_red = $separated_gray = $origin = $slash = $output = $user_info = $js_limit = $text_quote = $email_quote = $textareaMarg = $privMargLe = $hpSpam = $emailRepeat = $emojiNote = $textCounter = "";
	$div_c = $div_t = $div_hp = $div_em = "dsR3";
	$class_stars01 = $class_stars02 = $class_stars03 = $class_stars04 = $class_stars05 = "stars";
	$free_email = $id_quote = $new_marker = 0;
	$short_town = 30;
	$maxlenght = "<br />";
	$startzeit = $time = time();
	$ratingMarg = "marg-15-5";
	$emailSpam = "<div class=\"dsR3\">
					<label>E-Mail:</label><br /> 
					<input id=\"repeat_email\" type=\"text\" name=\"repeat_email\" size=\"25\" value=\"\" />
				</div>";

	$_POST['betreff'] 		= isset($_POST['betreff']) ? $_POST['betreff'] : "";
	$_POST['email'] 		= isset($_POST['email']) ? $_POST['email'] : "";
	$_POST['homepage'] 		= isset($_POST['homepage']) ? $_POST['homepage'] : "";
	$_POST['town'] 			= isset($_POST['town']) ? $_POST['town'] : "";
	$_POST['country'] 		= isset($_POST['country']) ? $_POST['country'] : "";
	$_POST['email_quote'] 	= isset($_POST['email_quote']) ? $_POST['email_quote'] : "";
	$_POST['quote_id'] 		= isset($_POST['quote_id']) ?  $_POST['quote_id'] : "";
	$_POST['quote_marker'] 	= isset($_POST['quote_marker']) ? $_POST['quote_marker'] : "";

	$_POST['free_email'] 	= isset($_POST['free_email']) ? $_POST['free_email'] : 0;
	$_POST['star'] 			= isset($_POST['star']) ? $_POST['star'] : 0;

	$_POST['comment_info'] 	= (isset($_POST['comment_info']) && ($_POST['comment_info'] == 1)) ? 1 : 0;
	$_POST['agree'] 		= (isset($_POST['agree']) && ($_POST['agree'] == 1)) ? 1 : 0;

	$woher 		= isset($_SERVER['HTTP_REFERER']) ? htmlspecialchars($_SERVER['HTTP_REFERER']) : "";
	$hostname 	= isset($_SERVER['SERVER_NAME']) ? htmlspecialchars($_SERVER['SERVER_NAME']) : "";
	$quoteFirst = isset($quoteFirst) ? $quoteFirst : true;

	$sql_properties = $gbook->query("SELECT `admin_email`, `antiflood_ban`, `bbcode`, `check_email`, `check_homepage`, `deactivate_html`, `default_style`, `default_template`, `entry_length_limit`, `entry_length_maximum`, `entry_length_minimum`, `guestbook_status`, `no_spam_entries`, `spam_marker`, `no_spam_links`, `max_links`, `guestbook_title`,  
											`images_in_entries`, `max_word_length`, `notification_entries`, `release_entries`, `smilies`, `thanks_email`, `statistic`, `statistic_ban`, `quote_func`, `check_subject`, `check_town`, `check_country`, `check_free`, `button_link`, `rating`, `rating_text`, `title_subject`, `administration`, `check_banner`, `privacy_hint`, `privacy_url` 
									 FROM `".$table."_properties`") or die();
	$properties = $sql_properties->fetch_assoc();
	$default_style = $properties['default_style'];

	$properties['rating_text'] = $properties['rating_text'] === NULL ? "" : $properties['rating_text'];
	$properties['title_subject'] = $properties['title_subject'] === NULL ? "" : $properties['title_subject'];
	$properties['privacy_url'] = $properties['privacy_url'] === NULL ? "" : $properties['privacy_url'];

	$entry_release = time()-($properties['antiflood_ban']*60);
	$gbook->query("DELETE FROM `".$table."_ip_ban` WHERE `time` <= '$entry_release' AND `type` = 'entry'");

	$ip_release = time()-($delete_spamIps*86400);
	$gbook->query("DELETE FROM `".$table."_forbidden_ip` WHERE `www_time` <= '$ip_release' AND `no_del` != '1'");

	$upload_release = time()-1200;
	$gbook->query("DELETE FROM `".$table."_upload_counter` WHERE `upload_time` <= '$upload_release'");

	if ($properties['button_link'] > 1 OR $sperre){
		header("Location: ".$url."index.php");
		die();
	}

	require_once("includes/lang.inc.php"); 

	$placeholderEMail = $placeholderCountry = $placeholderTown = $fmsg[337];
	$entrie_headline = $fmsg[5];

	SCROLL_TO_TOP ? $scrollTop = 'onclick="mygbTop()"' : $scrollTop = '';

	if (isset($_GET['action']))	{
		$_GET['action'] = strip_tags(trim($_GET['action']));
		$_GET['action'] = $gbook->real_escape_string($_GET['action']);
		$_GET['action'] = ($_GET['action'] == "quote") ? "quote" : "";
	}
	else {
		$_GET['action'] = "";
	}

	$_GET['id'] = ($_GET['action'] == "quote" && isset($_GET['id']) && preg_match("/^\d{1,6}$/", $_GET['id'])) ? trim($_GET['id']) : "";

	$id_quote = preg_match("/^\d{1,6}$/", $_POST['quote_id']) ? $_POST['quote_id'] : 0;
	$_GET['id'] = $id_quote == 0 ? $_GET['id'] : $id_quote;

	if ($properties['quote_func']) {
		if (!empty($_GET['id'])) {
			session_start();

			$quote_entries = $gbook->prepare("SELECT `comment`, `email`, `date`, `id`, `name`, `text`, `time`, `marker`, `check_time`  FROM  `".$table."_entries`  WHERE  `id` = ?");
			$quote_entries->bind_param('i', $_GET['id']);
			$quote_entries->execute();
			$quote_entries->store_result();
			$quote_entries->bind_result($comment_quote, $email_quote, $date_quote, $id_quote, $name_quote, $text_quote, $time_quote, $marker_quote, $usTime_quote);

			while ($quote_entries->fetch()) {
				if (!empty($comment_quote)) {
					$comment_quote = preg_replace("/\[img\](.*?)\[\/img\]/si", " ![IMAGE]! ", $comment_quote);
					$comment_quote = "[comment]".$comment_quote."[/comment]";
				}
				else {
					$comment_quote = "";
				}

				$email_quote = noSpam02($email_quote);

				if (!empty($name_quote)) {
					$name_quote = nobadwords($name_quote);
					$name_headline = stripslashes(htmlentities(strip_tags($name_quote), ENT_QUOTES, "UTF-8"));
				}
				else {
					$name_headline = $name_quote = 'Admin';
				}

				$text_quote = nobadwords($text_quote);
				$text_quote = str_replace("  ", " ", $text_quote);
				$text_quote = preg_replace("/\[img\](.*?)\[\/img\]/si", " ![IMAGE]! ", $text_quote);

				$usTime_quote = intval($usTime_quote);

				if ($dateFormat !== "us" && $dateFormat !== "sv") {
					!empty($usTime_quote) ? $time_quote = date("H:i", $usTime_quote) : ((!empty($time_quote) && preg_match("/^[0-9:]*$/is", $time_quote)) ? "" : $time_quote = "n.a.");
					!empty($usTime_quote) ? $date_quote = date("d.m.Y", $usTime_quote) : ((!empty($date_quote) && preg_match("/^[0-9.\/-]*$/is", $date_quote)) ? "" : $date_quote = "n.a.");
				}
				elseif ($dateFormat === "sv") {
					!empty($usTime_quote) ? $time_quote = date("H:i", $usTime_quote) : ((!empty($time_quote) && preg_match("/^[0-9:]*$/is", $time_quote)) ? "" : $time_quote = "n.a.");
					!empty($usTime_quote) ? $date_quote = date("Y-m-d", $usTime_quote) : ((!empty($date_quote) && preg_match("/^[0-9.\/-]*$/is", $date_quote)) ? "" : $date_quote = "n.a.");
				}
				else {
					!empty($usTime_quote) ? $time_quote = date("h:i A", $usTime_quote) : ((!empty($time_quote) && preg_match("/^[0-9:]*$/is", $time_quote)) ? "" : $time_quote = "n.a.");
					!empty($usTime_quote) ? $date_quote = date("m-d-Y", $usTime_quote) : ((!empty($date_quote) && preg_match("/^[0-9.\/-]*$/is", $date_quote)) ? "" : $date_quote = "n.a.");
				}

				if (($marker_quote == 1 || $marker_quote == 2) && !empty($email_quote)) {
					$free_email = 1;
					$marker_quote == 1 ? $new_marker = 3 : $new_marker = 0;
				}
				else {
					$email_quote = "";
				}
			}

			$quote_entries->free_result();
			$quote_entries->close();

			if (isset($text_quote) AND $text_quote != "") {
				$_SESSION['entrie_quote'] = "[zitat=".$name_quote." ".$amsg[86]." ".$date_quote." | ".$time_quote."]".$text_quote."".$comment_quote."[/zitat]";
				$entrie_headline = ''.$fmsg[190].' <span class="italic">'.$name_headline.' <span class="nowrap">('.$date_quote.', '.$time_quote.'):</span></span>';
			}
		}
		else {
			$_GET['id'] = "";

			if (isset($_SESSION['entrie_quote'])) {
				unset($_SESSION['entrie_quote']);
			}
		}
	}

	if ($properties['release_entries'] == 1 || $properties['release_entries'] == 3) {
		$user_info = "<p class=\"text-center small-02\">(".$fmsg[351].")</p>";
	}

	if ($properties['check_town'] != 1 && $properties['check_country'] == 1) {
		$div_t = "i-max";
	}
	elseif ($properties['check_town'] == 1 && $properties['check_country'] != 1) {
		$div_c = "i-max";
	}
	elseif ($properties['check_town'] != 1 && $properties['check_country'] != 1) {
		$div_t = "i-left";
		$div_c = "i-right";
	}

	if (($properties['check_homepage'] == 0 && $properties['check_email'] == 4) OR ($properties['check_homepage'] == 1 && $properties['check_email'] < 4)) {
		$div_em = $div_hp = "i-max";
	}
	elseif ($properties['check_homepage'] == 0 && $properties['check_email'] < 4) {
		$div_em = "i-left";
		$div_hp = "i-right";
	}

	if ($properties['check_homepage'] == 0 && ($properties['check_email'] == 2 OR $properties['check_email'] == 3)) {
		$asteriskMail = " mark-mail";
		$asteriskHPcorr = " mark-hp";
		$hidden_email_01 = "";
		$hidden_email_02 = "<span class=\"mark-mail\" style=\"display:inline-block;position:relative;left:-3px;\"></span> <span class=\"small-02\">".$fmsg[151]." ".$fmsg[125].".</span>";
	}
	elseif ($properties['check_homepage'] == 1 && ($properties['check_email'] == 2 OR $properties['check_email'] == 3)) {
		$asteriskMail = "";
		$asteriskHPcorr = "";
		$hidden_email_01 = " <span class=\"small-02\" style=\"font-weight:normal;\">(".$fmsg[125].")</span>";
		$hidden_email_02 = "";
	}
	else {
		$asteriskMail = $asteriskHPcorr = $hidden_email_01 = $hidden_email_02 = "";
	}

	$properties['statistic'] ? require_once("includes/stats.inc.php") : "";

	if ($properties['entry_length_limit']){
		$maxlenght 	= "<p class=\"aligncenter marg-five ".$fontsizeClass."\">(".$fmsg[316]." <span id=\"charleft\">".$properties['entry_length_maximum']."</span>)</p>";
		$textCounter = "textCounter();";
		$jsMaxInput = $properties['entry_length_maximum'];
		$jsMinInput = $properties['entry_length_minimum']-1;
	}

	$sql_template = $gbook->query("SELECT `bgcolor`, `bgimage`, `fontcolor`, `html`, `image_email`, `image_homepage`, `divalign`, `tablewidth`, `tdcolor`, `td2color`, `image_star`, `fontfamily`, `fontsize`, `linkcolor`, `hovercolor`, `insert_width` FROM `".$table."_template` WHERE `id` = '".$properties['default_template']."'");
	$template = $sql_template->fetch_assoc();
	$star_ico = $template['image_star'];

	($template['insert_width'] == 1) ? $formWidth = "myphpgb" : $formWidth = "insert-width";

	$gbFontSize = $template['fontsize'];
	$checkSize = substr($gbFontSize, -2);
	$myFontSize = str_replace($checkSize,"",$gbFontSize);

	(($myFontSize < 15 && $myFontSize > 5) || $myFontSize < 1) ? $fontsizeClass = 'normal-size' : '';

	if ($myFontSize > 18 OR ($myFontSize < 5 && $myFontSize > 1.1)) {
		$linkSymClass = 'external-large';
		$fontsizeClass = 'small-03';
	}

	(empty($properties['rating_text'])) ? ($rating_entry = $fmsg[352]) : ($rating_entry = $properties['rating_text']);
	($setLang !== $langFile) ? ($rating_entry = $fmsg[352]) : "";

	header("X-Robots-Tag: noindex");
	include("header.php");

	(empty($template['bgimage'])) ? $insertBody = "<body onload=\"NewWindow\"><div>" : $insertBody = "<body style=\"background-image:url(".$template['bgimage'].")\" onload=\"NewWindow\"><div>";

	echo "".$insertBody."";

	if ($properties['check_banner']) {
		$sql_banner = $gbook->query("SELECT `filename`, `title`, `width`, `height`, `link_text`, `url`, `status` FROM `".$table."_banner` WHERE `status` > 0");
		list($bannerFilename,$bannerTitle,$bannerWidth,$bannerHeight,$bannerText,$bannerURL,$bannerStatus) = $sql_banner->fetch_row();

		echo"
			<div class=\"".$formWidth." gb-align\">";

		if ($bannerStatus == 1) {
			$bannerFilename = $bannerFilename === NULL ? "" : stripslashes(htmlentities(strip_tags($bannerFilename), ENT_QUOTES, "UTF-8"));
			$bannerTitle 	= $bannerTitle === NULL ? "" : stripslashes(htmlentities(strip_tags($bannerTitle), ENT_QUOTES, "UTF-8"));
			$bannerURL 		= $bannerURL === NULL ? "" : stripslashes(htmlentities(strip_tags($bannerURL), ENT_QUOTES, "UTF-8"));

			echo"
				<div class=\"myphpgb-banner\" style=\"width:98%;\"><a href=\"".$bannerURL."\" title=\"".$bannerTitle."\"><img class=\"centered\" style=\"box-shadow:none !important;\" title=\"".$bannerTitle."\" src=\"".$url."banner/".$bannerFilename."\" alt=\"".$bannerTitle."\" width=\"".$bannerWidth."\" height=\"".$bannerHeight."\" /></a></div>";
		}

		if (!empty($bannerText)) {
			$bannerText	= $bannerText === NULL ? "" : htmlentities($bannerText, ENT_QUOTES, "UTF-8");
			$bannerText = nl2br($bannerText);
			$bannerText = stripslashes($bannerText);
			$bannerText = bbcode($bannerText);

			echo"
				<div class=\"banner-text\" style=\"width:98%;\">".$bannerText."</div>";
		}
		echo"
			</div><br />";
	}

	if ($properties['guestbook_status']){
		echo"
			<span id=\"anchor-gbooktop02\"></span>";

		if (isset($_POST['send']) OR isset($_POST['preview'])){
			$error_msg = $gb_rating = $gb_rating01 = $gb_rating02 = "";

			$woher		 = htmlspecialchars(strip_tags($_POST['woher']), ENT_QUOTES);
			$email_quote = stripslashes(htmlspecialchars(strip_tags($_POST['email_quote']), ENT_QUOTES));
			$email_quote = noInjektion($email_quote);

			$comment_info = ($_POST['comment_info'] == 1) ? 1 : 0;
			$free_email = ($_POST['free_email'] == 1) ? 1 : 0;

			$startzeit = preg_match("/^\d{9,10}$/",$_POST['startzeit']) ? $_POST['startzeit'] : time();
			$id_quote = preg_match("/^\d{1,6}$/", $_POST['quote_id']) ? $_POST['quote_id'] : $id_quote;
			$new_marker = preg_match("/^[0-3]{1}$/", $_POST['quote_marker']) ? $_POST['quote_marker'] : $new_marker;
			$_POST['star'] = preg_match("/^[0-6]{1}$/", $_POST['star']) ? $_POST['star'] : 0;

			($_POST['star'] > 0) ? (($_POST['star'] == 5) ? ($class_stars01=$class_stars02=$class_stars03=$class_stars04="stars-active") : (($_POST['star'] == 4) ? ($class_stars01=$class_stars02=$class_stars03="stars-active") : (($_POST['star'] == 3) ? ($class_stars01=$class_stars02="stars-active") : (($_POST['star'] == 2) ? ($class_stars01="stars-active") : "")))) : "";

			$_POST['name'] = trim($_POST['name']);
			$_POST['town'] = trim($_POST['town']);
			$_POST['country'] = trim($_POST['country']);
			$_POST['betreff'] = trim($_POST['betreff']);
			$_POST['text'] = trim($_POST['text']);

			if ($properties['bbcode'] && (($properties['no_spam_links'] && $properties['max_links']) || !$properties['no_spam_links'])) {
				$check_url = $_POST['text'];
				$http_count	 = substr_count(strtolower($check_url), 'http://', 0);
				$https_count = substr_count(strtolower($check_url), 'https://', 0);
				$ftp_count	 = substr_count(strtolower($check_url), 'ftp://', 0);
				$www_count 	 = substr_count(strtolower($check_url), 'www.', 0);
				$http2_count = substr_count(strtolower($check_url), 'http://www.', 0);
				$https2_count= substr_count(strtolower($check_url), 'https://www.', 0);
				$ftp2_count  = substr_count(strtolower($check_url), 'ftp://www.', 0);

				$url_count = $http_count + $https_count + $ftp_count + $www_count - $http2_count - $https2_count - $ftp2_count;

				$check_url02 = preg_replace("#\[url=(.*?)\](.*?)\[/url\]#si", "", $_POST['text']);

				$http_count02	= substr_count(strtolower($check_url02), 'http://', 0);
				$https_count02 	= substr_count(strtolower($check_url02), 'https://', 0);
				$ftp_count02	= substr_count(strtolower($check_url02), 'ftp://', 0);
				$www_count02 	= substr_count(strtolower($check_url02), 'www.', 0);

				$url_count02 = $http_count02 + $https_count02 + $ftp_count02 + $www_count02;

				$url_count02 > 0 ? $error_url = true : $error_url = false;
			}
			else {
				$url_count = 0;
				$check_url02 = $_POST['text'];

				$http_count02	= substr_count(strtolower($check_url02), 'http://', 0);
				$https_count02 	= substr_count(strtolower($check_url02), 'https://', 0);
				$ftp_count02	= substr_count(strtolower($check_url02), 'ftp://', 0);
				$www_count02 	= substr_count(strtolower($check_url02), 'www.', 0);

				$url_count02 = $http_count02 + $https_count02 + $ftp_count02 + $www_count02;

				$error_url = false;
			}

			if (empty($_POST['name'])) {
				$mark_name = " no-insert";
				$mark_name2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$emsg[9]."\"";
				$error_msg .= "<p class=\"error\">- ".$emsg[9]."</p>";
			}
			elseif (!preg_match("/^[0-9a-zA-Z".$allowed_characters."' ().-]*$/is", $_POST['name'])) {
				$mark_name = " no-insert";
				$mark_name2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$emsg[81]."\"";
				$error_msg .= "<p class=\"error\">- ".$emsg[81]."</p>";
			}

			if ($properties['check_town'] != 1 && !empty($_POST['town'])) {
				if (!preg_match("/^[0-9a-zA-Z".$allowed_characters."\/ '():.,-]*$/is", $_POST['town'])) {
					$mark_town = " no-insert";
					$mark_town2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$emsg[76]."\"";
					$error_msg .= "<p class=\"error\">- ".$emsg[76]."</p>";
				}
			}

			if ($properties['check_town'] == 2 && empty($_POST['town'])) {
				$mark_town = " no-insert";
				$mark_town2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$emsg[96]."\"";
				$error_msg .= "<p class=\"error\">- ".$emsg[96]."</p>";
			}

			if ($properties['check_country'] != 1 && !empty($_POST['country'])) {
				if (!preg_match("/^[0-9a-zA-Z".$allowed_characters."\/ '():.,-]*$/is", $_POST['country'])) {
					$mark_country = " no-insert";
					$mark_country2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$emsg[77]."\"";
					$error_msg .= "<p class=\"error\">- ".$emsg[77]."</p>";
				}
			}

			if ($properties['check_country'] == 2 && empty($_POST['country'])) {
				$mark_country = " no-insert";
				$mark_country2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$emsg[97]."\"";
				$error_msg .= "<p class=\"error\">- ".$emsg[97]."</p>";
			}

			if (!empty($_POST['town']) && !empty($_POST['country'])) {
				$slash = " | ";
			}

			if ($properties['check_email'] != 4){
				$_POST['email'] = trim($_POST['email']);
				$_POST['email'] = noInjektion($_POST['email']);

				if (($properties['check_email'] == 1 || $properties['check_email'] == 2) AND !validate_mail($_POST['email'])) {
					$mark_email = " no-insert";
					$mark_email2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$emsg[2]."\"";
					$error_msg .= "<p class=\"error\">- ".$emsg[2]."</p>";
				}
				elseif($_POST['email'] != "" AND !validate_mail($_POST['email'])){
					$mark_email = " no-insert";
					$mark_email2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$emsg[2]."\"";
					$error_msg .= "<p class=\"error\">- ".$emsg[2]."</p>";
				}
				elseif($_POST['comment_info'] == 1 AND !validate_mail($_POST['email'])) {
					$mark_email = " no-insert";
					$mark_info2 = " no-check error-tooltip cor-tt02\" data-tooltip=\"".$emsg[82]."";
					$mark_email2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$emsg[2]."\"";
					$error_msg .= "<p class=\"error\">- ".$emsg[82]."</p>";
				}
			}
			else {
				$_POST['email'] = "";
			}

			if ($properties['check_homepage'] == 0) {
				$_POST['homepage'] = trim($_POST['homepage']);

				if ($_POST['homepage'] != "") {
					$hpcount_http = substr_count(strtolower($_POST['homepage']), 'http://', 0);
					$hpcount_https = substr_count(strtolower($_POST['homepage']), 'https://', 0);
					$hpcount_ftp = substr_count(strtolower($_POST['homepage']), 'ftp://', 0);
					(strlen($_POST['homepage'])>4) ? $hpcount_www = substr_count(strtolower($_POST['homepage']), 'www.', 0, 4) : $hpcount_www = 0;

					if ($hpcount_http == 0 && $hpcount_https == 0 && $hpcount_ftp == 0 && $hpcount_www == 1) {
						$_POST['homepage'] = "http://".$_POST['homepage']."";
					}
				}

				if ($_POST['homepage'] != "" && $_POST['homepage'] != "http://" && !validate_url($_POST['homepage'])) {
					$mark_hp = " no-insert";
					$mark_hp2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$fmsg[207]."\"";
					$error_msg .= "<p class=\"error\">- ".$fmsg[207]."</p>";
				}
			}
			else {
				$_POST['homepage'] = "";
			}

			if ($_POST['betreff'] != "") {
				$_POST['betreff'] = preg_replace("/\s+/", " ", $_POST['betreff']);
			}

			$url_insert = "".$_POST['name']."".$_POST['town']."".$_POST['country']."".$_POST['betreff']."";

			$http_insert	= substr_count(strtolower($url_insert), 'http://', 0);
			$https_insert 	= substr_count(strtolower($url_insert), 'https://', 0);
			$www_insert 	= substr_count(strtolower($url_insert), 'www.', 0);
			$ftp_insert 	= substr_count(strtolower($url_insert), 'ftp://', 0);

			$insert_count = $http_insert + $https_insert + $www_insert + $ftp_insert;

			if ($insert_count > 0) {
				$mark_name = $mark_town = $mark_country = $mark_subject = " no-insert";
				$mark_name2 = " class=\"error-margTop error-tooltip\" data-tooltip=\"".$emsg[80]."\"";
				$error_msg .= "<p class=\"error\">- ".$emsg[80]."</p>";
			}

			if ($properties['smilies'] == 2) {
				$maxSmilies = (!isset($maxSmilies) || intval($maxSmilies) < 1) ? 1 : intval($maxSmilies);
				$smiliesCount = 0;
				$count_emojis = array();

				$check_smilies = $gbook->query("SELECT `bbcode` FROM `".$table."_smilies`");

				while ($smilies_number = $check_smilies->fetch_assoc()) {
					$count_emojis[] = $smilies_number['bbcode'];
				}

				foreach ($count_emojis as $emoji_value) {
					$smiliesCount += substr_count($_POST['text'], $emoji_value, 0);

					if($smiliesCount > $maxSmilies) {
						$_POST['text'] = str_replace($emoji_value, "", $_POST['text']);
						$_POST['text'] = str_replace("  ", " ", $_POST['text']);
					}
				}

				if($smiliesCount > $maxSmilies) {
					$emojiNote = "<br /><p class=\"delete-Emoji\">".$emsg[98]."</p>";
				}
			}

			if (empty($_POST['text'])) {
				$mark_text = " class=\"no-insert\"";
				$mark_text2 = " class=\"error-margTop error-tooltip cor-tt\" data-tooltip=\"".$emsg[10]."\"";
				$error_msg .= "<p class=\"error\">- ".$emsg[10]."</p>";
			}

			if ($properties['privacy_hint'] > 1 && (!isset($_POST['agree']) || $_POST['agree'] != 1)) {
				$mark_priv2 = " no-check error-tooltip cor-tt02\" data-tooltip=\"".$emsg[70]."";
				$error_msg .= "<p class=\"error\">- ".$emsg[70]."</p>";
			}

			if ($properties['entry_length_limit']) {
				$count_text = $_POST['text'];
				$count_text = strip_tags($count_text);
				$orig 		= array("ö","Ö","ä","Ä","ü","Ü","ß","€","@","\\r","\\n","\r\n");
				$fake 		= " ";
				$count_text = str_replace($orig, $fake, $count_text);

				!empty($count_text) ? $text_length = strlen($count_text) : $text_length = 0;
				$still_poss_lenght = ($properties['entry_length_maximum'] - $text_length);

				($still_poss_lenght < $properties['entry_length_maximum']) ? ($maxlenght = "<p class=\"aligncenter marg-five\">(".$fmsg[316]." <span id=\"charleft\">".$still_poss_lenght."</span>)</p>") : ($maxlenght = "<p class=\"aligncenter marg-five\">(".$fmsg[316]." <span id=\"charleft\">".$properties['entry_length_maximum']."</span>)</p>");
				($still_poss_lenght < 0) ? ($imposs_lenght = "<p class=\"aligncenter marg-five\">- ".$fmsg[317]." ".-$still_poss_lenght." ".$fmsg[315].".</p>") : "";

				if ($text_length > $properties['entry_length_maximum']) {
					$mark_text = " class=\"no-insert\"";
					$mark_text2 = " class=\"error-margTop error-tooltip cor-tt\" data-tooltip=\"".$emsg[32]."".$imposs_lenght."\"";
					$error_msg .= "<p class=\"error\">- ".$emsg[32]."".$imposs_lenght."</p>";
				}

				if ($text_length < $properties['entry_length_minimum'] AND $_POST['text'] != "") {
					$mark_text = " class=\"no-insert\"";
					$mark_text2 = " class=\"error-margTop error-tooltip cor-tt\" data-tooltip=\"".$emsg[33]." ".$properties['entry_length_minimum']."\"";
					$error_msg .= "<p class=\"error\">- ".$emsg[33]." ".$properties['entry_length_minimum']."</p>";
				}
			}

			if ($url_count02 > 0) {
				$mark_text = " class=\"no-insert\"";

				if ($error_url) {
					$mark_text2 = " class=\"error-margTop error-tooltip cor-tt\" data-tooltip=\"".$emsg[57]."\"";
					$error_msg .= "<p class=\"error\">- ".$emsg[57]."</p>";
				}
				else {
					$mark_text2 = " class=\"error-margTop error-tooltip cor-tt\" data-tooltip=\"".$emsg[58]."\"";
					$error_msg .= "<p class=\"error\">- ".$emsg[58]."</p>";
				}
			}

			if ($url_count > 0) {
				$linkCheck = $_POST['text'];
				$emptyAnchor = preg_match("/(.*?)\[url=(.*?)\]\[\/url\](.*?)$/si", $linkCheck);
				$spaceAnchor = preg_match("/(.*?)\[url=(.*?)\]\s+\[\/url\](.*?)$/si", $linkCheck);

				if ($emptyAnchor === 1 OR $spaceAnchor === 1) {
					$mark_text = " class=\"no-insert\"";
					$mark_text2 = " class=\"error-margTop error-tooltip cor-tt\" data-tooltip=\"".$emsg[95]."\"";
					$error_msg .= '<p class="error">- '.$emsg[95].'</p>';
				}
			}

			if (!$error_msg == "") {
				$startzeit	= intval($_POST['startzeit']);
				$showErrors = "<div id=\"error-prhint\" style=\"margin:20px 0 -10px;\"><p class=\"error\">- ".$emsg[100]."</p>".$emojiNote."</div>
								<div id=\"error-IP\" style=\"margin:20px 0 -10px;\">".$error_msg."".$emojiNote."</div>";
			}
			else {
				if (isset($_POST['send'])) {
					$shortIP = anonymizeIp($masterIP);

					$sql_select_ip = $gbook->query("SELECT `id` FROM `".$table."_ip_ban` WHERE `ip` = '$shortIP' AND `type` = 'entry'");
					$select_ip = $sql_select_ip->num_rows;

					if ($select_ip > 0) {
						echo "<div class=\"".$formWidth." gb-align\"><p class=\"error\">".$emsg[12]."</p></div>";

						if (isset($_SESSION['entrie_quote'])) {
							unset($_SESSION['entrie_quote']);
						}
					}
					else {
						(SPAM_PROTECT) ? include("includes/spamfilter.php") : $filtered = 0;

						if ($filtered > ($properties['spam_marker']-1)) {
							include ("includes/spam.mail.php");

							if ($properties['release_entries'] < 2) {
								$gbook->query("INSERT INTO `".$table."_forbidden_ip` (`ip`, `datum`, `uhrzeit`, `www_time`, `no_del`) VALUES ('".$_SERVER['REMOTE_ADDR']."',  '".GB_DATE."', '".date("H:i")."', '".time()."', '0')");
							}
							elseif (!empty($properties['antiflood_ban'])) {
								$gbook->query("INSERT INTO `".$table."_ip_ban` (`ip`, `time`, `type`) VALUES ('$shortIP',  '$time',  'entry')");
							}

							if (isset($_SESSION['entrie_quote'])) {
								unset($_SESSION['entrie_quote']);
							}

							echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."index.php\">";
							die();
						}
						elseif ($filtered > 0 AND $filtered < $properties['spam_marker']) {
							$status = 0;

							if ($quoteFirst) {
								$_POST['text'] = isset($_SESSION['entrie_quote']) ? $_SESSION['entrie_quote'].$_POST['text'] : $_POST['text'];
							}
							else {
								$_POST['text'] = isset($_SESSION['entrie_quote']) ? $_POST['text'].$_SESSION['entrie_quote'] : $_POST['text'];
							}

							if (!empty($properties['antiflood_ban'])) {
								$gbook->query("INSERT INTO  `".$table."_ip_ban` (`ip`, `time`, `type`) VALUES ('$shortIP',  '$time',  'entry')");
							}

							include ("includes/spam.mail.php");

							if ($free_email == 1 && $id_quote > 0) {
								$sql_quote = $gbook->prepare("UPDATE `".$table."_entries` SET `marker` = ? WHERE `id` = ?");
								$sql_quote->bind_param('ii', $new_marker,$id_quote);
								$sql_quote->execute();
								$sql_quote->close();

								$co_betreff = "".$amsg[162]." - ".$_SERVER['SERVER_NAME']."\n";
								$co_nachricht = "".$amsg[163]."";

								include ("includes/mail.header.inc.php");																					

								mail($email_quote, $co_betreff, $co_nachricht, $header);
							}

							$_POST['name']		= $gbook->real_escape_string($_POST['name']);
							$_POST['town']		= $gbook->real_escape_string($_POST['town']);
							$_POST['country']	= $gbook->real_escape_string($_POST['country']);
							$_POST['email']		= $gbook->real_escape_string($_POST['email']);
							$_POST['homepage']	= $gbook->real_escape_string($_POST['homepage']);
							$_POST['betreff']	= $gbook->real_escape_string($_POST['betreff']);
							$_POST['text']		= $gbook->real_escape_string($_POST['text']);
							$_POST['star']		= intval($_POST['star']) > 5 ? 5 : intval($_POST['star']);
							$_POST['agree']		= intval($_POST['agree']);

							$origin  = $_POST['town'];
							$origin .= $slash;
							$origin .= $_POST['country'];

							($_POST['betreff'] != "") ? ($entry  = "[b]".$_POST['betreff']."[/b]\r\n\r\n") : $entry  = "";		                
							$entry .= $_POST['text'];

							$sql_insert_entry  = $gbook->query("INSERT INTO `".$table."_entries` (`comment`, `date`, `email`, `homepage`, `icq`, `ip`, `status`, `name`, `activation_code`, `text`, `time`, `origin`, `marker`, `stars`, `check_time`) VALUES (NULL, '".GB_DATE."', '".$_POST['email']."', '".$_POST['homepage']."', '".$_POST['agree']."', NULL, '".$status."', '".$_POST['name']."', '$activation_hashcode', '".$entry."', '".date("H:i")."', '".$origin."', '".$comment_info."', '".$_POST['star']."', '".time()."')");

							if (isset($_SESSION['entrie_quote'])) {
								unset($_SESSION['entrie_quote']);
							}

							if ($sql_insert_entry) {
								echo "<div class=\"post-release\">".$fmsg[11]."</div>";
								echo "<meta http-equiv=\"Refresh\" content=\"5; url=".$url."index.php#anchor-gbooktop\">";
							}
							else {
								echo "<div class=\"".$formWidth." gb-align break\"><p class=\"error\">".$emsg[11]."</p></div>";
							}
						}
						else {
							if ($properties['release_entries'] == 1 || $properties['release_entries'] == 3) {
								$status = 0;
							}
							else {
								(!PIC_CHECK && $properties['bbcode'] == 1 && $properties['images_in_entries'] == 1) ? $status = 2 : $status = 1;
							}

							if ($quoteFirst) {
								$_POST['text'] = isset($_SESSION['entrie_quote']) ? $_SESSION['entrie_quote'].$_POST['text'] : $_POST['text'];
							}
							else {
								$_POST['text'] = isset($_SESSION['entrie_quote']) ? $_POST['text'].$_SESSION['entrie_quote'] : $_POST['text'];
							}

							if (!empty($properties['antiflood_ban'])) {
								$gbook->query("INSERT INTO  `".$table."_ip_ban` (`ip`, `time`, `type`) VALUES ('$shortIP',  '$time',  'entry')");
							}

							include ("includes/spam.mail.php");

							if ($free_email == 1 && $id_quote > 0) {
								$sql_quote = $gbook->prepare("UPDATE `".$table."_entries` SET `marker` = ? WHERE `id` = ?");
								$sql_quote->bind_param('ii', $new_marker,$id_quote);
								$sql_quote->execute();
								$sql_quote->close();

								$co_betreff = "".$amsg[162]." - ".$_SERVER['SERVER_NAME']."\n";
								$co_nachricht = "".$amsg[163]."";

								include ("includes/mail.header.inc.php");																					

								mail($email_quote, $co_betreff, $co_nachricht, $header);
							}

							$_POST['name']		= $gbook->real_escape_string($_POST['name']);
							$_POST['town']		= $gbook->real_escape_string($_POST['town']);
							$_POST['country']	= $gbook->real_escape_string($_POST['country']);
							$_POST['email']		= $gbook->real_escape_string($_POST['email']);
							$_POST['homepage']	= $gbook->real_escape_string($_POST['homepage']);
							$_POST['betreff']	= $gbook->real_escape_string($_POST['betreff']);
							$_POST['text']		= $gbook->real_escape_string($_POST['text']);
							$_POST['star']		= intval($_POST['star']) > 5 ? 5 : intval($_POST['star']);
							$_POST['agree']		= intval($_POST['agree']);

							$origin  = $_POST['town'];
							$origin .= $slash;
							$origin .= $_POST['country'];

							($_POST['betreff'] != "") ? ($entry  = "[b]".$_POST['betreff']."[/b]\r\n\r\n") : $entry  = "";		                
							$entry .= $_POST['text'];

							$sql_insert_entry  = $gbook->query("INSERT INTO `".$table."_entries` (`comment`, `date`, `email`, `homepage`, `icq`, `ip`, `status`, `name`, `activation_code`, `text`, `time`, `origin`, `marker`, `stars`, `check_time`) VALUES (NULL, '".GB_DATE."', '".$_POST['email']."', '".$_POST['homepage']."', '".$_POST['agree']."', NULL, '".$status."', '".$_POST['name']."', '$activation_hashcode', '".$entry."', '".date("H:i")."', '".$origin."', '".$comment_info."', '".$_POST['star']."', '".time()."')");

							if ($sql_insert_entry) {
								if ($status > 0 && $_POST['star'] > 0 && $properties['rating'] == 2) {
									$sql_count_ratings = $gbook->query("SELECT `id` FROM `".$table."_entries`  WHERE `stars` != 0 AND `status` != 0");
									$count_ratings = $sql_count_ratings->num_rows;
									$sum_ratings = $count_ratings;

									$sql_count_stars = $gbook->query("SELECT SUM(`stars`) AS `stars` FROM `".$table."_entries` WHERE `status` != 0");
									$count_stars = $sql_count_stars->fetch_array();
									$sum_stars = $count_stars['stars'];

									($sum_ratings > 0 && $sum_stars > 0) ? $average_stars = $sum_stars / $sum_ratings : $average_stars = 0;

									$gbook->query("UPDATE `".$table."_rating` SET `count_rating` = '".$sum_ratings."', `average_rating` = '".$average_stars."'");
								}

								$properties['images_in_entries'] ? $gbook->query("DELETE FROM `".$table."_upload_counter` WHERE `ip` = '$shortIP'") : "";

								if (isset($_SESSION['entrie_quote'])) {
									unset($_SESSION['entrie_quote']);
								}

								if ($properties['release_entries'] == 1 || $properties['release_entries'] == 3) {
									echo "<div class=\"post-release\">".$fmsg[351]."</div>";
									echo "<meta http-equiv=\"Refresh\" content=\"5; url=".$url."index.php#anchor-gbooktop\">";
								}
								else {
									echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."index.php#anchor-gbooktop\">";
								}
							}
							else {
								echo "<div class=\"".$formWidth." gb-align break\"><p class=\"error\">".$emsg[11]."</p><br /></div>";

								if (isset($_SESSION['entrie_quote'])) {
									unset($_SESSION['entrie_quote']);
								}
							}
						}
					}
				}

				if (isset($_POST['preview'])) {
					$quotes = array("<\$quote_ico\$>","<\$new_quote\$>");
					$email_quote = noSpam02($email_quote);

					$bad  = array("(",")","{","}","@");
					$good = array("&#40;","&#41;","&#123;","&#125;","&#64;");

					$name = $_POST['name'];
					$name = nobadwords($name);
					$name = stripslashes(htmlentities(strip_tags($name), ENT_QUOTES, "UTF-8"));
					$name = str_replace($bad, $good, $name);

					$town = $_POST['town'];
					$town = nobadwords($town);
					$town = stripslashes(htmlentities(strip_tags($town), ENT_QUOTES, "UTF-8"));
					$town = shortWords($town, $short_town);

					$country = $_POST['country'];
					$country = nobadwords($country);
					$country = stripslashes(htmlentities(strip_tags($country), ENT_QUOTES, "UTF-8"));

					$email = $_POST['email'];
					$email = stripslashes(htmlspecialchars(strip_tags($_POST['email']), ENT_QUOTES));
					$email = noInjektion($email);
					$email = noSpam02($email);

					$homepage = $_POST['homepage'];
					$homepage = stripslashes(htmlentities(strip_tags($homepage), ENT_QUOTES, "UTF-8"));

					$subject = $_POST['betreff'];
					$subject = nobadwords($subject);
					$subject = shortWords($subject, $properties['max_word_length']);
					$subject = stripslashes(htmlentities(strip_tags($subject), ENT_QUOTES, "UTF-8"));
					$subject = str_replace($bad, $good, $subject);

					($properties['rating']) ? ($stars = intval($_POST['star'])) : ($stars = $_POST['star'] = "0");

					if($_POST['betreff'] != "")	{
						$subject = "<strong>".$subject."</strong>
									<br /><br />
									";
					}
					
					if ($quoteFirst) {
						$text = isset($_SESSION['entrie_quote']) ? $_SESSION['entrie_quote'].$_POST['text'] : $_POST['text'];
					}
					else {
						$text = isset($_SESSION['entrie_quote']) ? $_POST['text'].$_SESSION['entrie_quote'] : $_POST['text'];
					}

					$text = preg_replace('/(\r\n)(\\1{1,1})\\1*/sS', '$1$2', $text);
					$text = nobadwords($text);
					$text = shortWords($text, $properties['max_word_length']);

					if ($properties['deactivate_html']){
						$text = htmlentities(strip_tags($text), ENT_QUOTES, "UTF-8");
					}

					$text  = nl2br($text);
					$text  = stripslashes($text);

					if ($properties['quote_func']) {
						$text = quote($text);
					}

					if ($properties['bbcode']) {
						$text = bbcode($text);

						if ($properties['images_in_entries']) {
							$text = pictures($text);
						}
					}

					if ($properties['smilies']) {
						$text = smilies($text);
					}

					$text = preg_replace('/(.)(\\1{1,2})\\1*/sS', '$1$2', $text);
					$text = str_replace($bad, $good, $text);

					$post  = $subject;
					$post .= $text;

					$town = ($town != "" && $properties['check_town'] != 1) ? $town : "";		                
					$country = ($country != "" && $properties['check_country'] != 1) ? $country : "";		                
					$origin  = $town;
					$origin .= $slash;
					$origin .= $country;

					$sql_count_entries	= $gbook->query("SELECT  `id`  FROM  `".$table."_entries`  WHERE  `status` != '0'");
					$count_entries 		= $sql_count_entries->num_rows;
					$count_entries 		= $count_entries+1;

					if ($properties['rating'] && $stars > 0) {
						$gbrat = 1;
						$gb_rating01 = array();

						while ($gbrat <= $stars) {
							$gb_rating01[] = "<img src=\"".$url."images/icons/stars/".$star_ico."\" width=\"16\" height=\"16\" alt=\"\" />";
							$gbrat ++;
						}

						$gbrat02 = 5;
						$gb_rating02 = array();

						while ($gbrat02 > $stars) {
							$gb_rating02[] = "<img src=\"".$url."images/icons/stars/star.png\" width=\"16\" height=\"16\" alt=\"\" />";
							$gbrat02 --;
						}

						$separated_red = implode("", $gb_rating01);

						($gb_rating02 != "" && $stars < 5) ? $separated_gray = implode("", $gb_rating02) : $separated_gray = "";

						$gb_rating = "<div class=\"star-rating\">".$separated_red."".$separated_gray."</div>";
					}

					($dateFormat === "us" && $setLang === "en") ? $time = date("h:i A") : $time = date("H:i");

					$template_data = $template['html'];
					$template_data = str_replace("<\$comment\$>", "", $template_data);
					$template_data = str_replace("<\$date\$>", GB_DATE, $template_data);
					$template_data = str_replace("<\$id\$>", $count_entries, $template_data);
					$template_data = str_replace("<\$permalink\$>", "", $template_data);
					$template_data = str_replace("<\$name\$>", $name, $template_data);
					$template_data = str_replace("<\$text\$>", $post, $template_data);
					$template_data = str_replace("<\$time\$>", $time, $template_data);
					$template_data = str_replace("<\$nr\$>", "$amsg[84]", $template_data);
					$template_data = str_replace("<\$wh\$>", "$amsg[85]", $template_data);
					$template_data = str_replace("<\$done\$>", "$amsg[86]", $template_data);
					$template_data = str_replace($quotes, "", $template_data);
					$template_data = str_replace("<\$rating\$>", "$gb_rating", $template_data);

					if ($origin != "") {
						$template_data = str_replace("<\$origin\$>", "".$origin."", $template_data);
						$template_data = str_replace("<\$from\$>", "$fmsg[349]", $template_data);
						$template_data = str_replace("<\$br\$>", "<br />", $template_data);
					}
					else {
						$template_data = str_replace("<\$origin\$>", "", $template_data);
						$template_data = str_replace("<\$from\$>", "", $template_data);
						$template_data = str_replace("<\$br\$>", "", $template_data);
					}

					if ($_POST['email'] == "" OR $properties['check_email'] > 1) {
						$template_data = str_replace("<\$email_icon\$>", "", $template_data);
					}
					else {
						$template_data = str_replace("<\$email_icon\$>", "<a href=\"mailto:".$email."\" title=\"".$email."\"><img class=\"ico\" src=\"".$url."images/icons/email/".$template['image_email']."\" alt=\"".$email."\" /></a>", $template_data);
					}

					if ($_POST['homepage'] == "" || $_POST['homepage'] == "http://") {
						$template_data = str_replace("<\$homepage_icon\$>", "", $template_data);
					}
					else {
						$template_data = str_replace("<\$homepage_icon\$>", "<a href=\"".$homepage."\" title=\"".$homepage."\" rel=\"external\"><img class=\"ico\" src=\"".$url."images/icons/homepage/".$template['image_homepage']."\" alt=\"".$homepage."\" /></a>", $template_data);
					}

					echo"
						<br /><br />
						<div class=\"".$formWidth." insert-table gb-align\">".$emojiNote."</div>
						".$template_data."";
				}
			}
		}

	echo "
		<div class=\"".$formWidth." insert-table gb-align\">
			".$showErrors."
			<p class=\"text-center\"><br /><strong>".$entrie_headline."</strong></p>".$user_info."
		</div>
		<div class=\"break\"></div>
		<form action=\"".$url."insert.php#anchor-gbooktop02\" method=\"post\" name=\"insert\">";

	echo"
		<div class=\"".$formWidth." insert-table gb-align\">
		<div class=\"i-wrapper\">
			<label for=\"inputName\" class=\"lineheight\"><strong>".$fmsg[139].":</strong></label>
			<div id=\"msName\"".$mark_name2."><input id=\"inputName\" class=\"insert".$mark_name."\" type=\"text\" name=\"name\" oninput=\"checkName()\" size=\"25\" maxlength=\"27\" placeholder=\"(".$fmsg[334].")\" value=\"";

			if (isset($_POST['name']) AND $_POST['name'] != "") {
				echo stripslashes(htmlspecialchars(strip_tags($_POST['name']), ENT_QUOTES));
			}

			echo "\" /></div>
		</div>";

		if((isset($properties['check_town']) && $properties['check_town'] != 1) OR (isset($properties['check_country']) && $properties['check_country'] != 1)) {
			echo"
			<div class=\"i-wrapper\">
				<div class=\"".$div_t."\">";

				if($properties['check_town'] != 1){
					echo"
					<label for=\"inputOrt\" class=\"lineheight\"><strong>".$fmsg[346]."</strong></label>";

					if ($properties['check_town'] == 2) {
						$placeholderTown = $fmsg[334];
					}

					echo"
					<div id=\"msOrt\"".$mark_town2."><input id=\"inputOrt\" class=\"insert".$mark_town."\" type=\"text\" name=\"town\" oninput=\"checkTown()\" size=\"15\" maxlength=\"60\" placeholder=\"(".$placeholderTown.")\" value=\"";

					if (isset($_POST['town']) AND $_POST['town'] != "") {
						echo stripslashes(htmlspecialchars(strip_tags($_POST['town']), ENT_QUOTES));
					}

					echo"\" /></div>";
				}

			echo"
				</div>
				<div class=\"".$div_c."\">";

				if($properties['check_country'] != 1) {
					echo"
					<label for=\"inputLand\" class=\"lineheight\"><strong>".$fmsg[347]."</strong></label>";

					if ($properties['check_country'] == 2) {
						$placeholderCountry = $fmsg[334];
					}

					echo"
					<div id=\"msLand\"".$mark_country2."><input id=\"inputLand\" class=\"insert".$mark_country."\" type=\"text\" name=\"country\" oninput=\"checkCountry()\" size=\"15\" maxlength=\"35\" placeholder=\"(".$placeholderCountry.")\" value=\"";

					if (isset($_POST['country']) AND $_POST['country'] != "") {
						echo stripslashes(htmlspecialchars(strip_tags($_POST['country']), ENT_QUOTES));
					}

					echo"\" /></div>";
				}

			echo"
				</div>
			<div class=\"break\"></div>
			</div>";
		}

		if ((isset($properties['check_email']) AND $properties['check_email'] != 4) OR (isset($properties['check_homepage']) && $properties['check_homepage'] == 0)) {
			echo"
			<div class=\"i-wrapper\">
				<div class=\"".$div_em."\">";

				if ($properties['check_email'] < 4) {
					echo"
					<label for=\"inputMail\" class=\"lineheight".$asteriskMail."\"><strong>".$fmsg[8].":</strong>".$hidden_email_01."</label>";

					if($properties['check_email'] == 1 || $properties['check_email'] == 2) {
						$placeholderEMail = $fmsg[334];
					}

					echo"
					<div id=\"msMail\"".$mark_email2."><input id=\"inputMail\" class=\"insert".$mark_email."\" type=\"text\" name=\"email\" oninput=\"checkEM()\" size=\"25\" maxlength=\"50\" placeholder=\"(".$placeholderEMail.")\" value=\"";

					if (isset($_POST['email']) AND $_POST['email'] != "") {
						echo stripslashes(htmlspecialchars(strip_tags($_POST['email']), ENT_QUOTES));
					}

					echo"\" /></div>";

					$emailRepeat = "Repeat";

					$emailSpam = "<div class=\"dsR3\">
									<label>Repeat E-Mail:</label><br /> 
									<input id=\"repeat_email\" type=\"text\" name=\"repeat_email\" size=\"25\" value=\"\" />
								</div>";
				}

			echo"
				</div>
				<div class=\"".$div_hp."\">";

				if($properties['check_homepage'] == 0) {
					echo"
					<label for=\"inputHP\" class=\"lineheight".$asteriskHPcorr."\"><strong>".$fmsg[9]."</strong></label>
					<div id=\"msHP\"".$mark_hp2."><input id=\"inputHP\" class=\"insert".$mark_hp."\" type=\"text\" name=\"homepage\" oninput=\"checkHP()\" size=\"25\" maxlength=\"150\" placeholder=\"(".$fmsg[337].")\" value=\"";

					if (isset($_POST['homepage']) AND $_POST['homepage'] != "") {
						echo stripslashes(htmlspecialchars(strip_tags($_POST['homepage']), ENT_QUOTES));
					}

					echo "\" /></div>";

					$hpSpam = "<div class=\"i-right dsR3\">
									<label>Repeat Website URL:</label><br />
									<input id=\"website_url\" type=\"text\" name=\"website_url\" size=\"25\" value=\"\" />
								</div>";

					$emailSpam = "<div class=\"i-left dsR3\">
									<label>$emailRepeat E-Mail:</label><br /> 
									<input id=\"repeat_email\" type=\"text\" name=\"repeat_email\" size=\"25\" value=\"\" />
								</div>";
				}

			echo"
				</div>
			<div class=\"break\"></div>
			</div>";
		}

		echo "
			".$emailSpam."
			".$hpSpam."";

		if (isset($properties['check_subject']) && $properties['check_subject'] == 0) {
			echo "<div class=\"i-wrapper\">
					<label for=\"inputSubj\" class=\"lineheight\"><strong>";
	
					empty($properties['title_subject']) ? $subjectTitle = $fmsg[313] : $subjectTitle = $properties['title_subject'];
					$setLang !== $langFile ? $subjectTitle = $fmsg[313] : "";
	
				echo"".$subjectTitle."</strong></label>
					<input id=\"inputSubj\" class=\"insert".$mark_subject."\" type=\"text\" name=\"betreff\" size=\"25\" maxlength=\"70\" placeholder=\"(".$fmsg[337].")\" value=\"";
	
					if (isset($_POST['betreff']) AND $_POST['betreff'] != "") {
						echo stripslashes(htmlspecialchars(strip_tags($_POST['betreff']), ENT_QUOTES));
					}
	
					echo "\" />
				<div class=\"break\"></div>
			</div>";
		}
		else {
			$_POST['betreff'] = "";
			echo "<div class=\"marg-TopBot10\"></div>";
		}

		echo "".$hidden_email_02."";

		if ($properties['bbcode'] OR $properties['smilies'] OR $properties['rating']) {
			$ratingMarg = "margtop-five";
			$textareaMarg = " style=\"margin-top:5px;\"";
			($formWidth == "myphpgb" && $template['tablewidth'] > 665) ? $spriteMarg = "sp-marg2" : $spriteMarg = "sp-marg";
			($formWidth == "myphpgb" && $template['tablewidth'] > 799) ? $descLarg = "<div class=\"desclarg\"></div>" : $descLarg = "";

			echo "
			<div class=\"bbc-space marg-15-5\">";

				if ($properties['bbcode']) {
					echo"
						<span class=\"lh-35 bbc2\">
							<a class=\"sprite-bold ".$spriteMarg."\" title=\"".$fmsg[185]."\" href=\"javascript:insert('[b]','[/b]');\">&nbsp;</a>
							<a class=\"sprite-italic ".$spriteMarg."\" title=\"".$fmsg[186]."\" href=\"javascript:insert('[i]','[/i]');\">&nbsp;</a>
							<a class=\"sprite-underline ".$spriteMarg."\" title=\"".$fmsg[187]."\" href=\"javascript:insert('[u]','[/u]');\">&nbsp;</a>
							<a class=\"sprite-shadow ".$spriteMarg."\" title=\"".$fmsg[188]."\" href=\"javascript:insert(' [shadow]','[/shadow] ');\">&nbsp;</a>
							<a class=\"sprite-crossed ".$spriteMarg."\" title=\"".$fmsg[280]."\" href=\"javascript:insert(' [cross]','[/cross] ');\">&nbsp;</a>
							<a class=\"sprite-justify ".$spriteMarg."\" title=\"".$fmsg[281]."\" href=\"javascript:insert(' [justify]',' [/justify] ');\">&nbsp;</a>
							<a class=\"sprite-center ".$spriteMarg."\" title=\"".$fmsg[309]."\" href=\"javascript:insert(' [center]',' [/center] ');\">&nbsp;</a>
							<a class=\"sprite-right ".$spriteMarg."\" title=\"".$fmsg[282]."\" href=\"javascript:insert(' [right]',' [/right] ');\">&nbsp;</a>
							<a class=\"sprite-sup ".$spriteMarg."\" title=\"".$fmsg[283]."\" href=\"javascript:insert('[sup]','[/sup]');\">&nbsp;</a>
							<a class=\"sprite-quote ".$spriteMarg."\" title=\"".$fmsg[191]."\" href=\"javascript:insert(' [quote]',' [/quote] ');\">&nbsp;</a>
							<a class=\"sprite-code ".$spriteMarg."\" title=\"Code\" href=\"javascript:insert(' [code]',' [/code] ');\">&nbsp;</a>
							<a class=\"sprite-list ".$spriteMarg."\" title=\"".$fmsg[284]."\" href=\"javascript:insert(' [list] [-]', ' [/-] [-] [/-] [/list] ');\">&nbsp;</a>
							<a class=\"sprite-numlist ".$spriteMarg."\" title=\"".$fmsg[285]."\" href=\"javascript:insert(' [numlist] [-]', ' [/-] [-] [/-] [/numlist] ');\">&nbsp;</a>
							<a class=\"sprite-hr ".$spriteMarg."\" title=\"".$fmsg[286]."\" href=\"javascript:insert('[hr]','');\">&nbsp;</a>";

							if (($properties['no_spam_links'] && $properties['max_links']) || !$properties['no_spam_links']) {
								echo"
									<a class=\"sprite-link ".$spriteMarg."\" title=\"".$fmsg[287]."\" href=\"".$url."bbcodes.php\" onclick=\"return PopUp(390,350,this.href);\">&nbsp;</a>";
							}

							if ($properties['check_email'] != 4) {
								echo"
									<a class=\"sprite-email ".$spriteMarg."\" title=\"".$fmsg[288]."\" href=\"".$url."bbcodes.php?action=step4\" onclick=\"return PopUp(390,340,this.href)\">&nbsp;</a>";
							}

							if ($properties['images_in_entries']) {
								echo"
									<a class=\"sprite-img ".$spriteMarg."\" title=\"".$fmsg[310]."\" onclick=\"javascript:NewWindow('pic.upload.php','upload','510','740','custom','front');return true;\">&nbsp;</a>";
							}

					echo"
						</span>
						<span class=\"lh-35 up-5 nowrap\">
							<span class=\"select-wrapper\">
								<select class=\"select\" name=\"Color\" size=\"1\" onchange=\"InsertColorSize(' [color=' + this.form.Color.options[this.form.Color.selectedIndex].value + ']',' [/color] ');this.selectedIndex=0\">
									<option>".$fmsg[289]."</option>
									<option value=\"gray\">".$fmsg[274]."</option>
									<option value=\"red\">".$fmsg[306]."</option>
									<option value=\"green\">".$fmsg[307]."</option>
									<option value=\"blue\">".$fmsg[308]."</option>
									<option value=\"yellow\">".$fmsg[290]."</option>
									<option value=\"orange\">".$fmsg[291]."</option>
									<option value=\"lime\">".$fmsg[292]."</option>
									<option value=\"pink\">".$fmsg[293]."</option>
									<option value=\"brown\">".$fmsg[294]."</option>
								</select>
							</span>
							<span class=\"select-wrapper\" style=\"margin:0 -10px;\">
								<select class=\"select\" name=\"Size\" size=\"1\" onchange=\"InsertColorSize(' [size=' + this.form.Size.options[this.form.Size.selectedIndex].value + ']',' [/size] ');this.selectedIndex=0\">
									<option>".$fmsg[295]."</option>
									<option value=\"8\">8px</option>
									<option value=\"10\">10px</option>
									<option value=\"12\">12px</option>
									<option value=\"14\">14px</option>
									<option value=\"16\">16px</option>
									<option value=\"18\">18px</option>
									<option value=\"20\">20px</option>
								</select>
							</span>
						</span>
						";
				}

				if ($properties['smilies']) {
					$sql_smilies_count = $gbook->query("SELECT `id` FROM `".$table."_smilies`");
					$count_smilies = $sql_smilies_count->num_rows;

					if ($count_smilies > 0 AND $properties['bbcode']) {
						echo"<div class=\"mobile\"></div>".$descLarg."
							";
					}

					echo"<span class=\"lh-35 emoj\">
						";

					($properties['bbcode']) ? ($emojiLimit = $emojis_and_bbcodes) : ($emojiLimit = $only_emojis);
					$sql_smilies = $gbook->query("SELECT `bbcode`, `filename`, `height`, `name`, `width` FROM `".$table."_smilies` ORDER BY `id` ASC LIMIT 0,".$emojiLimit."");

					while ($smilies = $sql_smilies->fetch_assoc()) {
						echo"<a class=\"no-pad\" href=\"javascript:insert(' ".$smilies['bbcode']." ','');\"><img class=\"smilies\" src=\"".$url."images/smilies/".$smilies['filename']."\" width=\"".$smilies['width']."\" height=\"".$smilies['height']."\" title=\"".$smilies['bbcode']."\" alt=\"".$smilies['name']."\" /></a>
							";
					}

					if ($count_smilies > $emojiLimit) {
						echo "<a class=\"sprite-more\" title=\"".$fmsg[15]."\" href=\"javascript:NewWindow('".$url."smilies.php','Emojis','380','750','custom','front');\">&nbsp;</a>
							";
					}

					echo"</span>";
				}

				echo"
					</div>
					<div class=\"break\"></div>
					<noscript class=\"small-03 aligncenter\" style=\"margin-bottom:15px;\">".$emsg[55]."</noscript>";

				if ($properties['rating']) {
					echo"
						<div class=\"rating-ie ".$ratingMarg."\">
							<div style=\"float:left;margin-right:10px;\">".$rating_entry."</div>";

						echo"
							<div class=\"rating-stars\">";

							echo"
								<input type=\"radio\" class=\"".$class_stars01." dsR3\" name=\"star\" id=\"s00\" title=\"Select all\" value=\"6\"";

								if (isset($_POST['star']) AND $_POST['star'] == "6") {
									echo" checked=\"checked\" /><label class=\"la-stars dsR3\" for=\"s00\">Select all</label>";
								}
								else {
									echo" /><label class=\"la-stars dsR3\" for=\"s00\">Select all</label>";
								}

							echo"
								<input type=\"radio\" class=\"".$class_stars01."\" name=\"star\" id=\"s01\" title=\"1 ".$fmsg[353]."\" onclick=\"changeStyle01();\" value=\"1\"";

								if (isset($_POST['star']) AND $_POST['star'] == "1") {
									echo" checked=\"checked\" /><label class=\"la-stars\" for=\"s01\" title=\"1 ".$fmsg[353]."\"></label>";
								}
								else {
									echo" /><label class=\"la-stars\" for=\"s01\" title=\"1 ".$fmsg[353]."\"></label>";
								}

							echo"
								<input type=\"radio\" class=\"".$class_stars02."\" name=\"star\" id=\"s02\" title=\"2 ".$fmsg[354]."\" onclick=\"changeStyle02();\" value=\"2\"";

								if (isset($_POST['star']) AND $_POST['star'] == "2") {
									echo" checked=\"checked\" /><label class=\"la-stars\" for=\"s02\" title=\"2 ".$fmsg[354]."\"></label>";
								}
								else {
									echo" /><label class=\"la-stars\" for=\"s02\" title=\"2 ".$fmsg[354]."\"></label>";
								}

							echo"
								<input type=\"radio\" class=\"".$class_stars03."\" name=\"star\" id=\"s03\" title=\"3 ".$fmsg[354]."\" onclick=\"changeStyle03();\" value=\"3\"";

								if (isset($_POST['star']) AND $_POST['star'] == "3") {
									echo" checked=\"checked\" /><label class=\"la-stars\" for=\"s03\" title=\"3 ".$fmsg[354]."\"></label>";
								}
								else {
									echo" /><label class=\"la-stars\" for=\"s03\" title=\"3 ".$fmsg[354]."\"></label>";
								}

							echo"
								<input type=\"radio\" class=\"".$class_stars04."\" name=\"star\" id=\"s04\" title=\"4 ".$fmsg[354]."\" onclick=\"changeStyle04();\" value=\"4\"";

								if (isset($_POST['star']) AND $_POST['star'] == "4") {
									echo" checked=\"checked\" /><label class=\"la-stars\" for=\"s04\" title=\"4 ".$fmsg[354]."\"></label>";
								}
								else {
									echo" /><label class=\"la-stars\" for=\"s04\" title=\"4 ".$fmsg[354]."\"></label>";
								}

							echo"
								<input type=\"radio\" class=\"".$class_stars05."\" name=\"star\" id=\"s05\" title=\"5 ".$fmsg[3541]."\" onclick=\"changeStyle05();\" value=\"5\"";

								if (isset($_POST['star']) AND $_POST['star'] == "5") {
									echo" checked=\"checked\" /><label class=\"la-stars\" for=\"s05\" title=\"5 ".$fmsg[3541]."\"></label>";
								}
								else {
									echo" /><label class=\"la-stars\" for=\"s05\" title=\"5 ".$fmsg[3541]."\"></label>";
								}

							echo"
								<input type=\"radio\" class=\"reset\" name=\"star\" id=\"s06\" title=\"".$fmsg[355]."\" onclick=\"changeStyle06();\" value=\"0\" /><label class=\"la-stars\" for=\"s06\" title=\"".$fmsg[355]."\"></label>
							</div>
						</div>";
				}
				else{
					// Attention! It's a fake!
					echo"
						<div class=\"dsR3\">
							<label>I'm not a bot:</label>
							<input type=\"checkbox\" name=\"star\"";

									if (isset($_POST['star']) AND $_POST['star'] == '6') {
										echo " checked=\"checked\"";
									}

								echo" value=\"6\" />
						</div>";
				}
		}
		else {
			// The same fake!
			echo"
				<div class=\"dsR3\">
					<label>I'm not a bot:</label>
					<input type=\"checkbox\" name=\"star\"";

							if (isset($_POST['star']) AND $_POST['star'] == '6') {
								echo " checked=\"checked\"";
							}

							echo" value=\"6\" />
				</div>";
		}

		echo"
			<div class=\"break\"></div>
			<div id=\"msText\"".$mark_text2."><textarea id=\"text\" name=\"text\"".$mark_text." oninput=\"".$textCounter."checkText()\" rows=\"12\" cols=\"25\" placeholder=\"(".$fmsg[348].")\" ".$textareaMarg.">";

			if (isset($_POST['text'])) {
				if ($properties['deactivate_html']) {
					echo stripslashes(htmlspecialchars(strip_tags($_POST['text']), ENT_QUOTES));
				}
				else {
					echo "".$_POST['text']."";
				}
			}

		echo "</textarea></div>
			$maxlenght";

		echo"
			<div style=\"width:97%;\">";

				if (!$properties['check_free']) {
					echo"
						<div id=\"msReply\" class=\"gb-info ".$fontsizeClass."".$mark_info2."\">
							<table class=\"info-table\">
								<tr>
									<td>".$fmsg[350]."</td>
									<td style=\"width:25px;\"><label class=\"gbcontainer\"><input type=\"checkbox\" name=\"comment_info\" onclick=\"input_reply()\"";

										if (isset($_POST['comment_info']) AND $_POST['comment_info'] == '1') {
											echo " checked=\"checked\"";
										}

									echo" value=\"1\" /><span class=\"checkgb\" onclick=\"input_reply()\"></span></label></td>
								</tr>
							</table>
						</div>";
				}

				if ($properties['privacy_hint'] > 1) {
					echo"
						<div id=\"msPrivacy\" class=\"gb-info ".$fontsizeClass."".$mark_priv2."\">
							<table class=\"info-table\">
								<tr>
									<td>";
										if ($properties['privacy_hint'] == 2) {
											echo "". $dsgvo[0]."";
										}
										elseif ($properties['privacy_hint'] == 3) {
											$properties['privacy_url'] = htmlspecialchars(strip_tags($properties['privacy_url']), ENT_QUOTES);
		
											echo "". $dsgvo[0]." <span class=\"nowrap marg-left10\">[ <a class=\"external gb-entry nowrap\" rel=\"external\" title=\"".$fmsg[266]."\" href=\"".$properties['privacy_url']."\">".$dsgvo[1]."</a> ]</span>";
										}

								echo "</td>
									<td style=\"width:25px;\"><label class=\"gbcontainer\"><input type=\"checkbox\" name=\"agree\" onclick=\"input_privacy()\"";

										if (isset($_POST['agree']) AND $_POST['agree'] == '1') {
											echo " checked=\"checked\"";
										}

									echo" value=\"1\" /><span class=\"checkgb\" onclick=\"input_privacy()\"></span></label></td>
								</tr>
							</table>
						</div>";
				}

				echo"
					<table id=\"checkAgree\" class=\"button-table\">
						<tr>
							<td style=\"width:33%;\"><input class=\"button-gb gb-button-left\" type=\"submit\" name=\"send\" ".$scrollTop." value=\"".$fmsg[16]."\" /></td>
							<td><input class=\"button-gb gb-button-middle\" type=\"submit\" name=\"preview\" ".$scrollTop." value=\"".$fmsg[179]."\" /></td>
							<td style=\"width:33%;\">
								<a class=\"button-gb insert-button gb-button-right\" ".$scrollTop." href=\"".$url."index.php#anchor-gbooktop\">".$fmsg[269]."</a>
								<input type=\"hidden\" name=\"startzeit\" value=\"".intval($startzeit)."\" /><input type=\"hidden\" name=\"woher\" value=\"".$woher."\" />";

								if ($properties['quote_func'] && !$properties['check_free']) {
									echo"
									<input type=\"hidden\" name=\"free_email\" value=\"".intval($free_email)."\" /><input type=\"hidden\" name=\"email_quote\" value=\"".$email_quote."\" /><input type=\"hidden\" name=\"quote_marker\" value=\"".intval($new_marker)."\" />";
								}

						echo"<input type=\"hidden\" name=\"quote_id\" value=\"".intval($id_quote)."\" />
							</td>
						</tr>
					</table>
				</div>
		</div>
		</form>
		<div class=\"break\"></div>
		";
	}
	else {
		echo "<div class=\"".$formWidth." insert-table gb-align\">
				<p class=\"text-center\"><br /><strong>".$emsg[17]."</strong></p>
			</div>
			<div class=\"break\"></div>
			";
	}

	echo "</div>
		<div class=\"".$formWidth." insert-table gb-align text-center\">";

			if ($properties['administration'] OR $properties['privacy_hint'] == 1) {
				echo"
					<div class=\"privacy\">";

						if ($properties['privacy_hint'] == 1) {
							$privMargLe = " class=\"priv-left\"";
							$properties['privacy_url'] = htmlspecialchars(strip_tags($properties['privacy_url']), ENT_QUOTES);

							echo "<a class=\"external gb-entry nowrap\" rel=\"external\" title=\"".$fmsg[266]."\" href=\"".$properties['privacy_url']."\">".$dsgvo[1]."</a>";
						}

						if ($properties['administration']) {
							echo "<span".$privMargLe."><a class=\"external gb-entry nowrap\" rel=\"external\" title=\"".$fmsg[2]."\" href=\"".$url."admin/admin.php\">".$fmsg[2]."</a></span>";
						}

				echo "</div>";
			}

		echo"
			<p class=\"margtop-dyn center\" style=\"width:110px;\"><a href=\"https://www.php-guestbook.de\" title=\"Download myPHP Guestbook ".$version."\" rel=\"external\"><img title=\"Download 'myPHP Guestbook ".$version."'\" src=\"".$url."images/myphpGuestbook.png\" width=\"110\" height=\"20\" alt=\"myPHP Guestbook\" /></a></p>
		</div>
		<script>var searchSubMin=$minInputSearch-1;var searchSubMax=$maxInputSearch;var textSubMin=$jsMinInput;var textSubMax=$jsMaxInput;</script>
		<script src=\"js/gbook.func-00-05032021.js\"></script>";
echo"
	</body>
	</html>";
?>