<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	01.05.2021
*/

// Settings
define('SPAM_PROTECT', true);			// No.1: Activate Spam filter 																	(Enable => true || Disable => false)	### TRUE IS RECOMMENDED SETTING! ### 
define('PIC_CHECK', true);				// No.2: Display uploaded photos only after approval by Admin									(Enable => true || Disable => false)	### TRUE IS RECOMMENDED SETTING! ###
define('CLEAN_CODE', true);				// No.3: Delete activation/deactivation codes for guestbook entries older than 30 days.			(Enable => true || Disable => false)
define('SCROLL_TO_TOP', true);			// No.4: Javascript function "scrollIntoView" on index- and insert.php							(Enable => true || Disable => false)
define('SCROLL_ON_INDEX', true);		// No.5: Enables a button on the index page to scroll to the top of the guestbook entries.		(Enable => true || Disable => false)

define('DISABLE_MYSQLI_CHECK', true); 	// No.6: Disable the display of error reports for MySQLi.										(Disable => true || Enable => false) 	### TRUE IS RECOMMENDED SETTING! ### 
										//       ### NOTE! THIS IS A FEATURE TO SUPPORT YOUR DEVELOPMENT AND SHOULD NEVER
										//       BE USED ON PRODUCTION SYSTEMS (e.g. systems connected to internet)! ###

define('ID_REG', true);					// No.7: Enables the PHP function "session_regenerate_id" for signing in to the Admin Area.		(Enable => true || Disable => false)
										//       In case of unstable network, e.g. Mobile or WiFi network, the Session may be lost.
										//       If you often have problems with logging, disable this feature. (=> false)

define('GB_SEC_AUTH', false);			// No.8: 2-factor authentication to log in to the Admin Area.									(Enable => true || Disable => false)
										//       If you activate this feature, after entering your Username and Password, 
										//       you will receive an e-mail with a further access code generated automatically. 
										//       You must enter this 2nd code within 3 minutes in order to log in.
										//       ### NOTE! Before you do this, make sure that automatic emailing through PHP 
										//       has not been restricted by your provider! ### //

//===================================================================================================================================================================================================//

$emojis_and_bbcodes = 12;			// No.9:  Number of Emojis displayed on insert.php with activated BBCodes
$only_emojis = 19;					// No.10: Number of Emojis displayed on insert.php without activated BBCodes
$delete_spamIps = 7;				// No.11: Number of days that an IP blocked due to Spam remains stored in the database before being deleted.
$session_lifetime = 30;				// No.12: Maximum duration of the Admin-Session: 30 min. => Every time you click on a link in the Admin Area, the deadline starts again.
$recording_days = 15;				// No.13: Number of days that are stored and displayed in the statistics.
$allowed_attemps = 5; 				// No.14: Allowed incorrect attempts to log in as Admin before the login form is locked.
$barrier_days = 7;					// No.15: Number of days after which the login form is automatically unblocked.
$pw_minutes = 30;					// No.16: Number of minutes that a new Password requested with the "Password-forgotten function" remains valid.
$maxInputSearch = 40;				// No.17: Maximum number of characters that can be entered in the search field.
$minInputSearch = 4;				// No.18: Minimum number of characters that must be entered in the search field.
$maxSearch = 10;					// No.19: Number of permitted uses of the search function in one hour.
$maxSmilies = 10;					// No.20: Total number of Emojis allowed in a Post (If control is activated under "General configuration" in Admin Panel).
$quoteFirst = true;					// No.21: For a quoted entry: Should the quote be displayed first and then the reply? 			==> true
									//		  Or vice versa, first the reply and then the quote? 									==> false

?>