<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	03.03.2021
*/

$search_release = time()-3600;	// 60 minutes IP lock for new search
$gbook->query("DELETE FROM `".$table."_search_counter` WHERE `search_time` <= '$search_release'");

$shortIP = anonymizeIp($masterIP);
$delSessionSearch = time()-180;

$sql_count_search = $gbook->query("SELECT `counter` FROM `".$table."_search_counter` WHERE `ip` = '$shortIP'") or die();
($sql_count_search != "") ? list($numberSearch) = $sql_count_search->fetch_row() : $numberSearch = 0;
($numberSearch <= $maxSearch) ? $freeCounter = true : $freeCounter = false;

if (!$freeCounter) {
	if (isset($_POST['send_suche']) OR (isset($_SESSION['mysearch']) && !empty($_SESSION['mysearch']))) {
		$searchResult = "<div id=\"searchError\" class=\"search-error\" style=\"height:1px;cursor:pointer;\" onclick=\"deleteError();\"><p id=\"msSearch\" class=\"search-tooltip\" data-tooltip=\"".$emsg[93]." ".$maxSearch." ".$emsg[94]."\"></p></div>";
	}

	if (isset($_SESSION['mysearch'])) {
		unset($_SESSION['mysearch']);
//		session_destroy();
	}
}
else {	
	$_POST['search'] = isset($_POST['search']) ? $_POST['search'] : "";

	if (isset($_POST['send_suche']) && trim($_POST['search']) != "") {
		$mySearch = trim($_POST['search']);
		$mySearch = preg_replace("/'+/", "'", $mySearch);  // only one single quotation mark, not multiple
		$mySearch = preg_replace("/-+/", "-", $mySearch);  // as above, also applies to double dashes
		$mySearch = preg_replace("/\s+/", " ", $mySearch); // no double whitespaces, incorrect user input
		$mySearch = substr($mySearch, 0, $maxInputSearch);

		$countMySearch = strlen($mySearch);

		$select_counter_search = $gbook->query("SELECT `id` FROM `".$table."_search_counter` WHERE `ip` = '$shortIP'");
		$search_ip = $select_counter_search->num_rows;

		if ($search_ip > 0) {
			$gbook->query("UPDATE `".$table."_search_counter` SET `counter` = `counter` + 1  WHERE `ip` = '$shortIP'");
		}
		else {
			$gbook->query("INSERT INTO `".$table."_search_counter` (`ip`, `search_time`, `counter`) VALUES ('$shortIP','".time()."','1')");
		}

		if ($countMySearch < $minInputSearch) {
			$errorSearch = "<div id=\"searchError\" class=\"search-error\" style=\"height:1px;\"><p id=\"msSearch\" class=\"search-tooltip\" data-tooltip=\"".$emsg[91]." ".$minInputSearch." ".$emsg[63]."\"></p></div>";
		}
		elseif (!preg_match("/^[0-9a-zA-Z".$allowed_characters." '?!:.,-]*$/is", $mySearch)) {
			$errorSearch = "<div id=\"searchError\" class=\"search-error\" style=\"height:1px;\"><p id=\"msSearch\" class=\"search-tooltip\" data-tooltip=\"".$emsg[92]."\"></p></div>";
		}

		if (!empty($errorSearch)){
			$searchResult = $errorSearch;
			$mySearch = "";
			$inputClass = " incheck";
			$oninput = 'oninput="fixError();"';
		}
		else {
			if ($mySearch != "") {
				if (!$gbook->set_charset('utf8')) {
					printf("<div style=\"font-size:18px;text-align:center;font-weight:bold;color:red;\"><p>Error loading character set utf8.</p><p>Use of the search function is not possible.</p></div>");
					isset($thisGBPage['myPHPGBook']) ? $noSearch = '<meta http-equiv="Refresh" content="4; url='.$url02.'gbook.php">' : $noSearch = '<meta http-equiv="Refresh" content="4; url='.$url.'index.php">';
					die($noSearch);
				}
				else {
					$_SESSION['mysearch'] = $mySearch; 					// search term is only saved in a session on the server
					$_SESSION['start_search'] = time();

					$search = $mySearch;
	
					$mySearch = $gbook->real_escape_string($mySearch); 	// not necessary for prepared statements
					$mySearch = "%{$mySearch}%";
	
					$mySearchResult = $gbook->prepare("SELECT `id` FROM `".$table."_entries` WHERE `status` != '0' AND (`comment` LIKE ? OR `date` LIKE ? OR `name` LIKE ? OR `text` LIKE ?)");
					$mySearchResult->bind_param('ssss', $mySearch,$mySearch,$mySearch,$mySearch);
					$mySearchResult->execute();
					$mySearchResult->store_result();
	
					$numSearch = $mySearchResult->num_rows;
	
					$mySearchResult->close();
	
					isset($thisGBPage['myPHPGBook']) ? header("Location: ".$url02."gbook.php") : header("Location: ".$url."index.php");
				}
			}
		}
	}

	if ((!isset($_POST['send_suche']) OR $_POST['search'] == "") AND isset($_SESSION['mysearch'])) {
		$mySearch = trim($_SESSION['mysearch']);
	
		if ($mySearch != "") {
			$inputClass = " incheck";
			$search = $mySearch;
	
			$mySearch = $gbook->real_escape_string($mySearch); 			// see above
			$mySearch = "%{$mySearch}%";
	
			$mySearchResult = $gbook->prepare("SELECT `id` FROM `".$table."_entries` WHERE `status` != '0' AND (`comment` LIKE ? OR `date` LIKE ? OR `name` LIKE ? OR `text` LIKE ?)");
			$mySearchResult->bind_param('ssss', $mySearch,$mySearch,$mySearch,$mySearch);
			$mySearchResult->execute();
			$mySearchResult->store_result();
	
			$numSearch = $mySearchResult->num_rows;
	
			$mySearchResult->close();
		}
	}
	
	if (isset($_SESSION['start_search']) && ($_SESSION['start_search'] < $delSessionSearch) && (isset($_SESSION['mysearch']) && !empty($_SESSION['mysearch']))) {
		unset($_SESSION['mysearch'], $_SESSION['start_search']);
//		session_destroy();
		$mySearch = $inputClass = "";
	}
}

if (isset($_POST['reset'])) {
	unset($_SESSION['mysearch'], $_SESSION['start_search']);
//	session_destroy();
	$mySearch = $_POST['search'] = $errorSearch = $inputClass = "";

	isset($thisGBPage['myPHPGBook']) ? header("Location: ".$url02."gbook.php") : header("Location: ".$url."index.php");
}

?>