<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	###################################################################################

	The function "shortWords" (original designation "MakeBreakable")
	is courtesy of Werner Rumpeltesz, <http://www.gaijin.at>,
	modified/adapted for the program myPHP Guestbook

	###################################################################################

	02.01.2022
*/

// Include settings file
require_once("settings.inc.php");

// Some other settings that should not be changed
$langArray = array("de","en","fr","it","nl","pl","pt","cz","sk","sv");
$allowed_characters = 'ÀÁÂÃÄÅĄÆÇČĎÈÉÊËĚĘÌÍÎÏÐĽĹŁŇÑŃÒÓÔÕÖØŔŘŠŚŤŮÙÚÛÜÝŽŹŻÞßàáâãäåąæçčćďěèéêëęìíîïľĺłŁňñńðòóôõöøŕřšśťůùúûüýþÿžźż';
$masterIP = $_SERVER['REMOTE_ADDR'];
$fontsizeClass = 'small-02';
$linkSymClass = 'external';
$jsMaxInput = 10000;
$jsMinInput = 2;

// Empty variables
$timezone = $dateFormat = $main_path = $host = $username = $password = $database = "";

// Error reporting for MySQLi
if (DISABLE_MYSQLI_CHECK) {
	error_reporting(0);
	mysqli_report(MYSQLI_REPORT_OFF);
}
else {
//	error_reporting (E_ALL);
//	ini_set ('display_errors', 'On');
	mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
}

// Include configuration file
require_once("config.inc.php");
 
// Connecting to the database
$gbook = new mysqli($host, $username, $password, $database);
$gbook->connect_error ? die('<div style="width:100%;height:100%;background-color:#000000;margin:0;"><div style="font-size:24px;font-weight:bold;color:#e2e2e2;line-height:1.5em;text-align:center;margin:0;position:absolute;top:50%;left:50%;-ms-transform:translate(-50%,-50%);transform:translate(-50%,-50%);">Sorry, something is going wrong.<br />Please come back later.</div></div>') : "";
$gbook->set_charset('utf8');

// Generate "dead" sender e-mail address
$mail_abs = "noreply@".str_replace("www.", "", $_SERVER['SERVER_NAME'])."";

// Set date format and correct time zone for comments in myPHP-Guestbook; see "config.inc.php" (from myPHP-Guestbook v.4.5.6 +)
// The time zone must be supported by PHP, e.g. to be processed by the function "date_default_timezone_set()";
// For a list of supported time zones see: <http://php.net/manual/de/timezones.php>
if ($timezone != "") {
	(function_exists('date_default_timezone_set')) ? (date_default_timezone_set($timezone)) : (ini_set('date.timezone', $timezone));
}

$sql_date_format = $gbook->query("SELECT `flag` FROM `".$table."_properties`");
list($dateFormat) = $sql_date_format->fetch_row();

($dateFormat === "us") ? define('GB_DATE', date("m-d-Y")) : (($dateFormat === "sv") ? define('GB_DATE', date("Y-m-d")) : define('GB_DATE', date("d.m.Y")));

// Anonymize IP
function anonymizeIp($masterIP) {
	global $main_path;

	$matchIP = array('/[0-9]+\z/','/[\da-f]*:[\da-f]*:[\da-f]*$/');
	$replaceIP = array('0','0:0:0');
	$truncatedIP = preg_replace($matchIP,$replaceIP,$masterIP);
	return md5($main_path.$truncatedIP);
}

// Reading the CSS styles from the database
function getStyle()	{
	global $gbook, $table, $default_style, $template;

	$template['bgcolor']	= (isset($template['bgcolor'])) ? $template['bgcolor'] : '';
	$template['fontcolor']	= (isset($template['fontcolor'])) ? $template['fontcolor'] : '';
	$template['divalign']	= (isset($template['divalign'])) ? $template['divalign'] : '';
	$template['tablewidth']	= (isset($template['tablewidth'])) ? $template['tablewidth'] : '';
	$template['tdcolor']	= (isset($template['tdcolor'])) ? $template['tdcolor'] : '';
	$template['td2color']	= (isset($template['td2color'])) ? $template['td2color'] : '';
	$template['fontfamily']	= (isset($template['fontfamily'])) ? $template['fontfamily'] : '';
	$template['fontsize']	= (isset($template['fontsize'])) ? $template['fontsize'] : '';
	$template['linkcolor']	= (isset($template['linkcolor'])) ? $template['linkcolor'] : '';
	$template['hovercolor']	= (isset($template['hovercolor'])) ? $template['hovercolor'] : '';

	$sql_style = $gbook->query("SELECT `style` FROM `".$table."_style` WHERE `id` = '$default_style'");
	$style = $sql_style->fetch_assoc();

	$style['style'] = str_replace("<\$bodycolor\$>", $template['bgcolor'], $style['style']);
	$style['style'] = str_replace("<\$hovercolor\$>", $template['hovercolor'], $style['style']);
	$style['style'] = str_replace("<\$divalign\$>", $template['divalign'], $style['style']);
	$style['style'] = str_replace("<\$maxwidth\$>", $template['tablewidth'], $style['style']);
	$style['style'] = str_replace("<\$topcolor\$>", $template['tdcolor'], $style['style']);
	$style['style'] = str_replace("<\$entriecolor\$>", $template['td2color'], $style['style']);
	$style['style'] = str_replace("<\$fontfamily\$>", $template['fontfamily'], $style['style']);
	$style['style'] = str_replace("<\$fontsize\$>", $template['fontsize'], $style['style']);
	$style['style'] = str_replace("<\$fontcolor\$>", $template['fontcolor'], $style['style']);
	$style['style'] = str_replace("<\$linkcolor\$>", $template['linkcolor'], $style['style']);

	echo $style['style'];
}

// Read out the file names of a directory
function getFiles($directory) {
	if ($dh = opendir($directory)) {
		while (false !== ($file = readdir($dh))) {
			if ($file != "." && $file != ".." && $file != ".htaccess" && $file != "index.php" && $file != "ReadMe_Update_Sprachfiles.txt") {
				$files[] = $file;
			}
		}

		closedir($dh);
		return $files;
	}
}

// Emoji-BBCodes will be replaced by graphics.
function smilies(&$text_smilies) {
	global $gbook, $table, $url;

	$sql_smilies_function = $gbook->prepare("SELECT `bbcode`, `filename`, `height`, `name`, `width` FROM `".$table."_smilies`");
	$sql_smilies_function->execute();
	$sql_smilies_function->bind_result($em_bbcode, $em_file, $em_height, $em_name, $em_width);

	while ($sql_smilies_function->fetch()) {
		$text_smilies = str_replace($em_bbcode, '<img src="'.$url.'images/smilies/'.$em_file.'" alt="'.$em_name.'" width="'.$em_width.'" height="'.$em_height.'" />', $text_smilies);
	}

	$sql_smilies_function->close();

	return $text_smilies;
}

// Swearword filter
function nobadwords(&$text_nobadwords)	{
	global $gbook, $table;

	$sql_nobadwords_function = $gbook->prepare("SELECT `badword` FROM `".$table."_badwords`");
	$sql_nobadwords_function->execute();
	$sql_nobadwords_function->bind_result($gb_badword);

	while ($sql_nobadwords_function->fetch()) {
		$censor = "***";
		$text_nobadwords = str_ireplace($gb_badword, $censor, $text_nobadwords);
	}

	$sql_nobadwords_function->close();

	return $text_nobadwords;
}

// Encoding e-mail addresses in ASCII
function noSpam02(&$mail) {
	$content = trim($mail); 
	$encoded_content = (string)''; 
	for($i = 0; $i < strlen($content); $i++) { 
		$encoded_content .= '&#'.ord($content[$i]).';'; 
	}
	// some corrections for special characters
	$trans = array(
	"&#195;&#164;" => "&#228;", "&#195;&#132;" => "&#196;", "&#195;&#188;" => "&#252;", "&#195;&#156;" => "&#220;", "&#195;&#182;" => "&#246;", "&#195;&#150;" => "&#214;", "&#195;&#159;" => "&#223;", "&#195;&#160;" => "&#224;", 
	"&#195;&#161;" => "&#225;", "&#195;&#162;" => "&#226;", "&#195;&#163;" => "&#227;", "&#195;&#165;" => "&#229;", "&#195;&#166;" => "&#230;", "&#195;&#167;" => "&#231;", "&#195;&#168;" => "&#232;", "&#195;&#169;" => "&#233;", 
	"&#195;&#170;" => "&#234;", "&#195;&#171;" => "&#235;", "&#195;&#172;" => "&#236;", "&#195;&#173;" => "&#237;", "&#195;&#174;" => "&#238;", "&#195;&#175;" => "&#239;", "&#195;&#176;" => "&#240;", "&#195;&#177;" => "&#241;", 
	"&#195;&#178;" => "&#242;", "&#195;&#179;" => "&#243;", "&#195;&#180;" => "&#244;", "&#195;&#181;" => "&#245;", "&#195;&#184;" => "&#248;", "&#195;&#185;" => "&#249;", "&#195;&#186;" => "&#250;", "&#195;&#187;" => "&#251;", 
	"&#195;&#189;" => "&#253;", "&#195;&#190;" => "&#254;", "&#195;&#191;" => "&#255;", "&#196;&#133;" => "&#261;", "&#196;&#141;" => "&#269;", "&#196;&#135;" => "&#263;", "&#196;&#143;" => "&#271;", "&#196;&#155;" => "&#283;", 
	"&#196;&#153;" => "&#281;", "&#196;&#190;" => "&#318;", "&#196;&#186;" => "&#314;", "&#197;&#130;" => "&#322;", "&#197;&#136;" => "&#328;", "&#197;&#132;" => "&#324;", "&#197;&#149;" => "&#341;", "&#197;&#153;" => "&#345;", 
	"&#197;&#161;" => "&#353;", "&#197;&#155;" => "&#347;", "&#197;&#165;" => "&#357;", "&#197;&#175;" => "&#367;", "&#197;&#190;" => "&#381;", "&#197;&#186;" => "&#377;", "&#197;&#188;" => "&#379;");
	$encoded_content = strtr($encoded_content, $trans);

	return $encoded_content; 
}

// Stop e-mail injection
function noInjektion(&$mail) {
	return(str_ireplace(array("\\", "\\r", "\\n", "\\t", "%0A", "%0D", "%08", "%09", "&#", "content-Type:", "boundary", "content-transfer-encoding:", "mime-version:", "bcc:", "cc:", "reply-to:", "to:", "sender:", "from:"), "", $mail));
}

// Check word length and insert blanks if necessary
function shortWords($text_short, $length, $split = ' ', $charset = 'UTF-8')	{
	$result = '';
	$line = '';
	$count = 0;
	$wrappos = 0;
	$wrapcount = 0;
	$breakchars = " \r\n\t";
	$wrapchars = "-=,;!?:|]+/\\";
	$intag = false;
	$i = 0;

	$bbtag = array("[img]", "[/img]", "[url=", "[email=", "[zitat=",);
	$new_bbtag = array(" [img]", "[/img] ", " [url=", " [email=", " [zitat=",);

	$text_short	= str_replace($bbtag, $new_bbtag, $text_short);

	while ($i < mb_strlen($text_short, $charset)) {
		$char = mb_substr($text_short, $i, 1, $charset);

		if ($char == '[') {
			$intag = true;
		}

		if (!$intag) {
			if (mb_strpos($breakchars, $char, 0, $charset) !== false) {
				$line .= $char;
				$count = 0;
				$wrappos = 0;
				$wrapcount = 0;
				$i++;

				continue;
			}

			if (mb_strpos($wrapchars, $char, 0, $charset) !== false) {
				$wrappos = mb_strlen($line, $charset) + 1;
				$wrapcount = $count;
			}
		}

		if ($count >= $length) {
			if ($wrappos > 0) {
				$result .= mb_substr($line, 0, $wrappos, $charset).$split;
				$line = mb_substr($line, $wrappos, mb_strlen($line, $charset), $charset);
				$count -= $wrapcount + 1;
				$wrappos = 0;
			}
			else {
				$result .= $line.$split;
				$line = '';
				$count = 0;
				$wrappos = 0;
			}
		}

		if (!$intag) $count++;
			
		if ($char == ']') {
			$intag = false;
		}

		$line .= $char;
		$i++;
	}

	$result .= $line;

	return $result;	
}

// Set seed for random number generation
function makeRandomName() {
	if (function_exists('gettimeofday()')) { 
		list($usec, $sec) = explode(' ', microtime());
		$rdsign = (float)$sec + ((float)$usec*100000);
		return str_replace (".","",$rdsign);
	}
	else {
		$sec = time();
		$rdsign = (float)($sec*0.333);
		return str_replace (".","",$rdsign);
	}
}

// Prefix for Random ID
function prefix_id() {
	$idChctr	 = 'AaBbCcDdEeèéêFfGgHhIiJjKkLlMmNnOooôPpQpRrSsßTtUuúùûVvWwXxYyZz';
	$idChctr	.= '0123456789()!:=@?_+#~';
	$sumChctr	 = strlen($idChctr);
	$lenghtPrf	 = rand(10,45);
	$id_prefix   = '';

	for ($pfx = 1; $pfx < $lenghtPrf; $pfx++) {
		$id_prefix .= $idChctr[rand(0,$sumChctr-1)];
	}
	return $id_prefix;
}

// Preparing characters (in backup)
function prepare_backup($add_character) {
	if ($add_character !== NULL) {
		$add_character = addslashes($add_character);
		$add_character = str_replace("\015", "\\r", $add_character);
		$add_character = str_replace("\012", "\\n", $add_character);
		$add_character = str_replace("\011", "\\t", $add_character);
	}
	return $add_character;
}

// Convert BBCode to HTML
function bbcode(&$text) {
	global $thisGBPage, $fmsg, $fontsizeClass, $linkSymClass;

	$allowed_url_characters = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåąæçčćďèéêëěęìíîïľĺłðñňńòóôõöøŕřšśťůùúûüýþÿžźż&;%';
	$allowed_email_characters = 'ßàáâãäåąæçčćďèéêëěęìíîïľĺłðñňńòóôõöøŕřšśťůùúûüýþÿžźżÜÖÄ&;%';

	if (isset($thisGBPage['gbookAdmin'])) {
		$text = preg_replace("#\[url=(.*?)\](.*?)\[/url\]#si", "<a class=\"external\" title=\"\\1\" href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_hp').style.display='inline';return false;\">\\2</a>", $text);
	}

	$text = preg_replace("#\[url=(http:\/\/|https:\/\/|ftp:\/\/)([a-zA-Z'.$allowed_url_characters.'0-9 \.\,\/\?\=\-\_\#]{1,})\](.*?)\[/url\]#si", "<a class=\"".$linkSymClass." gb-entry\" title=\"".$fmsg[266]."\" href=\"\\1\\2\" rel=\"external\">\\3</a>", $text);
	$text = preg_replace("#\[email=([_a-zA-Z'.$allowed_email_characters.'0-9-]+(\.[_a-zA-Z'.$allowed_email_characters.'0-9-]+)*@([a-zA-Z'.$allowed_email_characters.'0-9-]+\.)+([a-zA-Z]{2,3}))\]#si", "<a class=\"gb-mail\" title=\"".$fmsg[311]."\" href=\"mailto:\\1\">\\1</a>", $text);
	$text = preg_replace("/\[color=red\](.*?)\[\/color\]/si", "<span class=\"red\">\\1</span>", $text);
	$text = preg_replace("/\[color=green\](.*?)\[\/color\]/si", "<span class=\"green\">\\1</span>", $text);
	$text = preg_replace("/\[color=blue\](.*?)\[\/color\]/si", "<span class=\"blue\">\\1</span>", $text);
	$text = preg_replace("/\[color=yellow\](.*?)\[\/color\]/si", "<span class=\"yellow\">\\1</span>", $text);
	$text = preg_replace("/\[color=orange\](.*?)\[\/color\]/si", "<span class=\"orange\">\\1</span>", $text);
	$text = preg_replace("/\[color=lime\](.*?)\[\/color\]/si", "<span class=\"lime\">\\1</span>", $text);
	$text = preg_replace("/\[color=pink\](.*?)\[\/color\]/si", "<span class=\"pink\">\\1</span>", $text);
	$text = preg_replace("/\[color=brown\](.*?)\[\/color\]/si", "<span class=\"brown\">\\1</span>", $text);
	$text = preg_replace("/\[color=gray\](.*?)\[\/color\]/si", "<span class=\"gray\">\\1</span>", $text);
	$text = preg_replace("/\[size=8\](.*?)\[\/size\]/si", "<span class=\"size-8\">\\1</span>", $text);
	$text = preg_replace("/\[size=10\](.*?)\[\/size\]/si", "<span class=\"size-10\">\\1</span>", $text);
	$text = preg_replace("/\[size=12\](.*?)\[\/size\]/si", "<span class=\"size-12\">\\1</span>", $text);
	$text = preg_replace("/\[size=14\](.*?)\[\/size\]/si", "<span class=\"size-14\">\\1</span>", $text);
	$text = preg_replace("/\[size=16\](.*?)\[\/size\]/si", "<span class=\"size-16\">\\1</span>", $text);
	$text = preg_replace("/\[size=18\](.*?)\[\/size\]/si", "<span class=\"size-18\">\\1</span>", $text);
	$text = preg_replace("/\[size=20\](.*?)\[\/size\]/si", "<span class=\"size-20\">\\1</span>", $text);
	$text = preg_replace("/\[b\](.*?)\[\/b\]/si", "<strong>\\1</strong>", $text);
	$text = preg_replace("/\[i\](.*?)\[\/i\]/si", "<span class=\"italic\">\\1</span>", $text);
	$text = preg_replace("/\[u\](.*?)\[\/u\]/si", "<span class=\"underline\">\\1</span>", $text);
	$text = preg_replace("/\[shadow\](.*?)\[\/shadow\]/si", "<span class=\"text-shadow\">\\1</span>", $text);
	$text = preg_replace("/\[cross\](.*?)\[\/cross\]/si", "<span class=\"text-crossed\">\\1</span>", $text);
	$text = preg_replace("/\[justify\](.*?)\[\/justify\]/si", "<div class=\"text-justify\">\\1</div>", $text);
	$text = preg_replace("/\[center\](.*?)\[\/center\]/si", "<div class=\"text-center\">\\1</div>", $text);
	$text = preg_replace("/\[right\](.*?)\[\/right\]/si", "<div class=\"text-right\">\\1</div>", $text);
	$text = preg_replace("/\[sup\](.*?)\[\/sup\]/si", "<sup> \\1</sup>", $text);
	$text = preg_replace("/\[quote\](.*?)\[\/quote\]/si", "<div class=\"".$fontsizeClass." zitat\"><p class=\"heading\">".$fmsg[172]."</p>\\1</div>", $text);
	$text = preg_replace("/\[code\](.*?)\[\/code\]/si", "<div class=\"code\"><p class=\"heading\">Code:</p><code>\\1</code></div>", $text);
	$text = preg_replace("/\[-\](.*?)\[\/-\]/si", "<li>\\1</li>", $text);
	$text = preg_replace("/\[list\](.*?)\[\/list\]/si", "<ul>\\1</ul>", $text);
	$text = preg_replace("/\[numlist\](.*?)\[\/numlist\]/si", "<ol>\\1</ol>", $text);
	$text = str_replace("[hr]", "<hr />", $text);

	return $text;
}

// Display uploaded images in posts
function pictures(&$text_pictures) {
	global $gbook, $table, $url;

	$sql_pictures_function = $gbook->prepare("SELECT `pic_name`, `width`, `height`, `title` FROM `".$table."_pictures`");
	$sql_pictures_function->execute();
	$sql_pictures_function->bind_result($pic_name, $pic_width, $pic_height, $pic_title);

	while ($sql_pictures_function->fetch()) {
		$pic_title = $pic_title === NULL ? "" : htmlspecialchars($pic_title);
		$text_pictures = str_replace('[img]'.$pic_name.'[/img]', '<div class="title-container" style="max-width:'.$pic_width.'px;"><img class="centered add-on" src="'.$url.'img_guest/'.$pic_name.'" alt="'.$pic_title.'" width="'.$pic_width.'" height="'.$pic_height.'" /><div class="pic-overlay"><span class="pic-title">'.$pic_title.'</span></div></div>', $text_pictures);
	}

	$sql_pictures_function->close();

	return $text_pictures;
}

// Quote function
function quote(&$text) {
	global $fmsg, $fontsizeClass;

	$text = preg_replace("/\[zitat=(.*?)\]/si", "<div class=\"".$fontsizeClass." zitat\"><p class=\"quote-heading\">\\1:</p>", $text);
	$text = str_replace("[/zitat]", "</div>", $text);
	$text = preg_replace("/\[comment\](.*?)\[\/comment\]/si", "<div class=\"quote-comment\"><p class=\"heading\">".$fmsg[106].":</p>\\1</div>", $text);
	$text = str_replace("![IMAGE]!", "<p class=\"pic-replace\">(".$fmsg[129].")</p>", $text);

	return $text;
}

// Validate e-mail address for correct syntax
// E-Mail regex from "https://emailregex.com/", modified for "myPHP Guestbook"
function validate_mail($mail) {
	$allowed_email_characters = 'ßàáâãäåąæçčćďèéêëěęìíîïľĺłðñňńòóôõöøŕřšśťůùúûüýþÿžźżÜÖÄ';
	$email = trim($mail);

	if(preg_match('/^(?!(?:(?:\x22?\x5C[\x00-\x7E]\x22?)|(?:\x22?[^\x5C\x22]\x22?)){255,})(?!(?:(?:\x22?\x5C[\x00-\x7E]\x22?)|(?:\x22?[^\x5C\x22]\x22?)){65,}@)(?:(?:[\x21\x23-\x27\x2A\x2B\x2D\x2F-\x39\x3D\x3F\x5E-\x7E'.$allowed_email_characters.']+)|(?:\x22(?:[\x01-\x08\x0B\x0C\x0E-\x1F\x21\x23-\x5B\x5D-\x7F]|(?:\x5C[\x00-\x7F]))*\x22))(?:\.(?:(?:[\x21\x23-\x27\x2A\x2B\x2D\x2F-\x39\x3D\x3F\x5E-\x7E'.$allowed_email_characters.']+)|(?:\x22(?:[\x01-\x08\x0B\x0C\x0E-\x1F\x21\x23-\x5B\x5D-\x7F]|(?:\x5C[\x00-\x7F]))*\x22)))*@(?:(?:(?!.*[^.]{64,})(?:(?:(?:xn--)?[a-z'.$allowed_email_characters.'0-9]+(?:-[a-z'.$allowed_email_characters.'0-9]+)*\.){1,126}){1,}(?:(?:[a-z][a-z0-9]*)|(?:(?:xn--)[a-z0-9]+))(?:-[a-z0-9]+)*)|(?:\[(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){7})|(?:(?!(?:.*[a-f0-9][:\]]){7,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,5})?)))|(?:(?:IPv6:(?:(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){5}:)|(?:(?!(?:.*[a-f0-9]:){5,})(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3})?::(?:[a-f0-9]{1,4}(?::[a-f0-9]{1,4}){0,3}:)?)))?(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))(?:\.(?:(?:25[0-5])|(?:2[0-4][0-9])|(?:1[0-9]{2})|(?:[1-9]?[0-9]))){3}))\]))$/iD', $email)) {
		return true;
	}
	else {
		return false;
	}
}

// Validate URL (only) for correct syntax
// URL regex from "http://urlregex.com/"
function validate_url($domainname) {
	$domainname = trim($domainname);
	$urlPartOne = $urlPartTwo = $urlPartThree = "";

	$findBlanks = " ";
	$blank = strpos($domainname, $findBlanks);

	if ($blank !== false) {
		$urlPartOne = ''.parse_url($domainname, PHP_URL_SCHEME).'://';
		$urlPartOne = ($urlPartOne == "://" OR $urlPartOne == "") ? "http://" : $urlPartOne;
		$urlPartTwo = ''.parse_url($domainname, PHP_URL_HOST).'/';
		$urlPartTwo = ($urlPartTwo == "/" OR $urlPartTwo == "") ? "" : $urlPartTwo;

		if ($urlPartOne != false && $urlPartTwo != false) {
			$urlPartThree = explode(''.$urlPartOne.''.$urlPartTwo.'', ''.$domainname.'');
			$urlPartThree = implode($urlPartThree);
		}

		$urlPartThree = str_replace(" ", "%20", $urlPartThree);

		if ($urlPartTwo != "") {
			$domainname = ''.$urlPartOne.''.$urlPartTwo.''.$urlPartThree.'';
		}
	}

	if(preg_match('%^(?:(?:https?|ftp)://)(?:\S+(?::\S*)?@|\d{1,3}(?:\.\d{1,3}){3}|(?:(?:[a-z\d\x{00a1}-\x{ffff}]+-?)*[a-z\d\x{00a1}-\x{ffff}]+)(?:\.(?:[a-z\d\x{00a1}-\x{ffff}]+-?)*[a-z\d\x{00a1}-\x{ffff}]+)*(?:\.[a-z\x{00a1}-\x{ffff}]{2,6}))(?::\d+)?(?:[^\s]*)?$%iu', $domainname)) {
		return true;
	}
	else {
		return false;
	}
}

?>