<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/
	if (!isset($_SESSION['sid']) && !isset($_SESSION['modsid'])) {
		header("Location: admin.php?action=login");
		die();
	}
	elseif (!isset($_SESSION['sid']) && isset($_SESSION['modsid'])) {
		unset($_SESSION['modsid']);
		session_destroy();

		echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."admin/admin.php?action=login\" />";
		die();
	}
	else {
		$error_gbook_options = $error_gbook_options2 = $error_gbook_options3 = $thyo_lang = $placeholder = $placeholder02 = $placeholder_privacy = $deactivate_html = $selectInfoLang = $selectCheckEntrie = $check_privacy = $gbook_activate = $warning_dsgvo = $warning02_dsgvo = $selectTableWidth = $input_privacy = $tippFullPrivacy = $update_properties4 = $deleteIpSuccess = $warning_town = $warning_country = "";

		$check_release = $gbook->query("SELECT `release_entries` FROM `".$table."_properties`");
		list($release_entries) = $check_release->fetch_row();

		if (isset($_POST['send1'])) {
			$error_msg = "";

			if ($_POST['entries_per_site'] != "" && !preg_match("/^[0-9]*$/is", $_POST['entries_per_site'])) {
				$error_msg .="".$emsg[22]."<br />";
			}

			if ($_POST['links_in_sitefunction'] != "" && !preg_match("/^[0-9]*$/is", $_POST['links_in_sitefunction'])) {
				$error_msg .= "".$emsg[23]."<br />";
			}

			if ((isset($_POST['link_entry']) && $_POST['link_entry'] != "" && !preg_match("/^[0-9a-zA-Z".$allowed_characters."\/ '():.,!?-]*$/is", $_POST['link_entry'])) OR (isset($_POST['guestbook_title']) && $_POST['guestbook_title'] != "" && !preg_match("/^[0-9a-zA-Z".$allowed_characters."\/ '():.,!?-]*$/is", $_POST['guestbook_title']))) {
				$error_msg .= "".$emsg[79]."<br />";
			}

			$count_link_name = (isset($_POST['link_entry'])) ? $_POST['link_entry'] : '';
			$orig = array("ö","Ö","ä","Ä","ü","Ü","ß");
			$fake = " ";
			$count_link_name = str_replace($orig, $fake, $count_link_name);
			$link_lenght = $count_link_name != "" ? strlen($count_link_name) : 0;

			if ($link_lenght > 35) {
				$error_msg .="".$emsg[83]."<br />";
			}

			if (isset($_POST['statistic_ban']) && $_POST['statistic_ban'] != "" && !preg_match("/^[0-9]*$/is", $_POST['statistic_ban'])) {
				$error_msg .= "".$emsg[25]."<br />";
			}

			if (isset($_POST['privacy_url']) && $_POST['privacy_url'] != "" && !validate_url($_POST['privacy_url'])) {
				$error_msg .= "".$emsg[54]."!<br />";
			}

			if ($_POST['guestbook_title'] == "" OR $_POST['entries_per_site'] == "" OR $_POST['links_in_sitefunction'] == "" OR (isset($_POST['statistic_ban']) && $_POST['statistic_ban'] == "")) {
				$error_msg .= "".$emsg[0]."<br />";
			}

			if (!$error_msg == "") {
				$error_gbook_options = '<p class="error">'.$error_msg.'</p><br /><br />';
			}
			else {
				$_POST['entries_per_site']		= (isset($_POST['entries_per_site'])) ? $_POST['entries_per_site'] : '10';
				$_POST['guestbook_status']		= (isset($_POST['guestbook_status'])) ? $_POST['guestbook_status'] : '0';
				$_POST['guestbook_title']		= (isset($_POST['guestbook_title'])) ? trim($_POST['guestbook_title']) : 'myPHP Guestbook';
				$_POST['links_in_sitefunction']	= (isset($_POST['links_in_sitefunction'])) ? $_POST['links_in_sitefunction'] : '9';
				$_POST['notification_entries']	= (isset($_POST['notification_entries'])) ? $_POST['notification_entries'] : '0';
				$_POST['release_entries']		= (isset($_POST['release_entries'])) ? $_POST['release_entries'] : '0';
				$_POST['statistic']				= (isset($_POST['statistic'])) ? $_POST['statistic'] : '0';
				$_POST['statistic_ban']			= (isset($_POST['statistic_ban'])) ? $_POST['statistic_ban'] : '720';
				$_POST['thanks_email']			= (isset($_POST['thanks_email'])) ? $_POST['thanks_email'] : '0';
				$_POST['link_entry']			= (isset($_POST['link_entry'])) ? trim($_POST['link_entry']) : '';
				$_POST['button_link']			= (isset($_POST['button_link'])) ? $_POST['button_link'] : '1';

				$select1_properties = $gbook->query("SELECT `quote_func` FROM `".$table."_properties`");
				$check1_properties = $select1_properties->fetch_assoc();

				($_POST['button_link'] == 2) ? ($_POST['quote_func'] = 0) : $_POST['quote_func'] = $check1_properties['quote_func'];
				$_POST['choose_lang']			= (isset($_POST['choose_lang'])) ? $_POST['choose_lang'] : '0';
				$_POST['administration']		= (isset($_POST['administration'])) ? $_POST['administration'] : '0';
				$_POST['check_banner']			= (isset($_POST['check_banner'])) ? $_POST['check_banner'] : '0';
				$_POST['flag']					= (isset($_POST['flag'])) ? $_POST['flag'] : 'de';

				if (preg_match("/^[a-z]*$/is", $_POST['flag'])) {
					($_POST['flag'] == "de" || $_POST['flag'] == "at" || $_POST['flag'] == "ch") ? $newLang = "de" : (($_POST['flag'] == "br" || $_POST['flag'] == "pt") ? $newLang = "pt" : (($_POST['flag'] == "cz" || $_POST['flag'] == "sk" || $_POST['flag'] == "nl" || $_POST['flag'] == "pl" || $_POST['flag'] == "sv" || $_POST['flag'] == "fr" || $_POST['flag'] == "it") ? $newLang = $_POST['flag'] : $newLang = "en"));
				}
				else {
					$newLang = "de";
				}

				$_POST['agree']			= (isset($_POST['agree']) && $_POST['agree'] == 2) ? 2 : 0;
				$_POST['privacy_hint']	= (isset($_POST['privacy_hint']) && $_POST['privacy_hint'] == 1) ? 1 : 0;
				$_POST['agree']			= (($_POST['agree'] == 2 && $_POST['privacy_hint'] == 1) ? 3 : (($_POST['agree'] == 2 && $_POST['privacy_hint'] == 0) ? 2 : 0));
				$_POST['privacy_hint']	= (($_POST['privacy_hint'] == 1 && $_POST['agree'] == 2) ? 3 : (($_POST['privacy_hint'] == 1 && $_POST['agree'] == 0) ? 1 : 0));
				$privacy_hint			= (($_POST['agree'] == 3 OR $_POST['privacy_hint'] == 3) ? 3 : (($_POST['privacy_hint'] == 1 && $_POST['agree'] == 0) ? 1 : (($_POST['privacy_hint'] == 0 && $_POST['agree'] == 2) ? 2 : 0)));

				$_POST['privacy_url']	= (isset($_POST['privacy_url'])) ? trim($_POST['privacy_url']) : '';
				$_POST['search_func']	= (isset($_POST['search_func'])) ? $_POST['search_func'] : '0';
				$_POST['permalink']		= (isset($_POST['permalink'])) ? $_POST['permalink'] : '0';

				$_POST['guestbook_title']	= $gbook->real_escape_string($_POST['guestbook_title']);
				$_POST['link_entry']     	= $gbook->real_escape_string($_POST['link_entry']);
				$_POST['privacy_url']    	= $gbook->real_escape_string($_POST['privacy_url']);

				if ($newLang != $lang_short) {
					$sql_check_input = $gbook->query("SELECT `id` FROM `".$table."_thankyou` WHERE `lang` = '".$newLang."'");
					($sql_check_input != "") ? $check_input = $sql_check_input->num_rows : $check_input = 0;

					if ($check_input < 1) {
						$gbook->query("INSERT INTO `".$table."_thankyou` (`status`, `thanks`, `lang`, `noreply`) VALUES ('1', NULL, '".$newLang."', '".$mail_abs."')");
					}
				}

				if ($_POST['release_entries'] == 0 && ($release_entries == 2 || $release_entries == 3)) {
					$insert_release = 2;
				}
				elseif ($_POST['release_entries'] == 1 && ($release_entries == 0 || $release_entries == 1)) {
					$insert_release = 1;
				}
				elseif ($_POST['release_entries'] == 1 && ($release_entries == 2 || $release_entries == 3)) {
					$insert_release = 3;
				}
				else {
					$insert_release = 0;
				}

				$_POST['statistic'] == 0 ? $gbook->query("DELETE FROM `".$table."_ip_ban` WHERE `type` = 'stats'") : "";
				$_POST['search_func'] == 0 ? $gbook->query("TRUNCATE TABLE ".$table."_search_counter") : "";

				$update1_properties = $gbook->query("UPDATE `".$table."_properties` SET
								      												 `entries_per_site`		= '".$_POST['entries_per_site']."', 
								      												 `guestbook_status`		= '".$_POST['guestbook_status']."', 
								      												 `guestbook_title`		= '".$_POST['guestbook_title']."', 
								      												 `language`				= '".$newLang."', 
								      												 `links_in_sitefunction`= '".$_POST['links_in_sitefunction']."', 
								      												 `notification_entries`	= '".$_POST['notification_entries']."', 
								      												 `release_entries`		= '".$insert_release."', 
								      												 `thanks_email`			= '".$_POST['thanks_email']."',
								      												 `statistic`			= '".$_POST['statistic']."', 
								      												 `statistic_ban`		= '".$_POST['statistic_ban']."', 
								      												 `quote_func`			= '".$_POST['quote_func']."',
								      												 `link_entry`			= '".$_POST['link_entry']."', 
								      												 `button_link`			= '".$_POST['button_link']."',
								      												 `choose_lang`			= '".$_POST['choose_lang']."',
								      												 `administration`		= '".$_POST['administration']."',
								      												 `check_banner`			= '".$_POST['check_banner']."',
								      												 `flag`					= '".$_POST['flag']."',
								      												 `privacy_hint`			= '".$privacy_hint."',
								      												 `privacy_url`			= '".$_POST['privacy_url']."',
								      												 `search_func`			= '".$_POST['search_func']."',
								      												 `permalink`			= '".$_POST['permalink']."'");

				if ($update1_properties){
					echo'<meta http-equiv="Refresh" content="0; url='.$url.'admin/admin.php?action=guestbook_options&#38;show=general_config&#38;'.session_name().'='.session_id().'" />';
				}
			}
		}

		if (isset($_POST['send2'])) {
			$error_msg2 = "";

			if ((SPAM_PROTECT && $_POST['spam_marker'] != "") && ((!preg_match("/^[0-9]*$/is", $_POST['spam_marker']) OR $_POST['spam_marker'] < 1 OR $_POST['spam_marker'] > 20))) {
				$error_msg2 .="".$emsg[40]."<br />";
			}

			if ((isset($_POST['no_spam_links']) && $_POST['no_spam_links'] == 1) && (isset($_POST['max_links']) && (!preg_match("/^[0-9]*$/is", $_POST['max_links']) OR $_POST['max_links'] < 0 OR $_POST['max_links'] > 20))) {
				$error_msg2 .="".$emsg[41]."<br />";
			}

			if (($_POST['antiflood_ban'] != "") && ((!preg_match("/^[0-9]*$/is", $_POST['antiflood_ban'])) OR ($_POST['antiflood_ban'] < 0))) {
				$error_msg2 .="".$emsg[24]."<br />";
			}

			if ($_POST['max_word_length'] != "" && (!preg_match("/^[0-9]*$/is", $_POST['max_word_length']) OR $_POST['max_word_length'] < 30 OR $_POST['max_word_length'] > 125)) {
				$error_msg2 .= "".$emsg[37]."<br />";
			}

			if ($_POST['antiflood_ban'] == "" OR $_POST['max_word_length'] == "" OR ((SPAM_PROTECT) && $_POST['spam_marker'] == "") OR ((isset($_POST['no_spam_links']) && $_POST['no_spam_links'] != 1) && (isset($_POST['max_links']) && $_POST['max_links'] == ""))) {
				$error_msg2 .= "".$emsg[0]."<br />";
			}

			if (!$error_msg2 == "") {
				$error_gbook_options2 = '<p class="error">'.$error_msg2.'</p><br /><br />';
			}
			else {
				$_POST['antiflood_ban']			= (isset($_POST['antiflood_ban'])) ? $_POST['antiflood_ban'] : '5';
				$_POST['save_spam_ip']			= (isset($_POST['save_spam_ip'])) ? $_POST['save_spam_ip'] : '0';
				$_POST['deactivate_html']		= (isset($_POST['deactivate_html'])) ? $_POST['deactivate_html'] : '0';
				$_POST['clean_backup']			= (isset($_POST['clean_backup'])) ? $_POST['clean_backup'] : '0';
				$_POST['entry_length_limit']	= (isset($_POST['entry_length_limit'])) ? $_POST['entry_length_limit'] : '0';
				$_POST['entry_length_maximum']	= (isset($_POST['entry_length_maximum'])) ? $_POST['entry_length_maximum'] : '1500';
				$_POST['entry_length_minimum']	= (isset($_POST['entry_length_minimum'])) ? $_POST['entry_length_minimum'] : '5';

				if (SPAM_PROTECT) {
					$_POST['no_spam_entries'] = (isset($_POST['no_spam_entries'])) ? $_POST['no_spam_entries'] : '0';
					$_POST['spam_marker']	  = (isset($_POST['spam_marker'])) ? $_POST['spam_marker'] : '4';
					$_POST['no_spam_links']	  = (isset($_POST['no_spam_links'])) ? $_POST['no_spam_links'] : '0';
					$_POST['max_links']		  = (isset($_POST['max_links'])) ? $_POST['max_links'] : '0';
					(isset($_POST['no_spam_links']) AND $_POST['no_spam_links'] != 1) ? ($_POST['max_links'] = 0) : ($_POST['max_links'] = $_POST['max_links']);
				}
				else {
					$select_spam_properties = $gbook->query("SELECT `no_spam_entries`, `spam_marker`, `no_spam_links`, `max_links` FROM `".$table."_properties`");
					$spam_properties = $select_spam_properties->fetch_assoc();

					$_POST['no_spam_entries'] = $spam_properties['no_spam_entries'];
					$_POST['spam_marker']	  = ($spam_properties['spam_marker'] > 0) ? $spam_properties['spam_marker'] : 1;
					$_POST['no_spam_links']	  = $spam_properties['no_spam_links'];
					$_POST['max_links']		  = $spam_properties['max_links'];
				}

				if ($_POST['save_spam_ip'] == 1 && ($release_entries == 1 || $release_entries == 3)) {
					$insert_release = 1;
				}
				elseif ($_POST['save_spam_ip'] == 0 && ($release_entries == 0 || $release_entries == 2)) {
					$insert_release = 2;
				}
				elseif ($_POST['save_spam_ip'] == 0 && ($release_entries == 1 || $release_entries == 3)) {
					$insert_release = 3;
				}
				else {
					$insert_release = 0;
				}

				$_POST['max_word_length'] = (isset($_POST['max_word_length'])) ? $_POST['max_word_length'] : '36';

				$_POST['antiflood_ban'] == 0 ? $gbook->query("DELETE FROM `".$table."_ip_ban` WHERE `type` = 'entry'") : "";
				$_POST['save_spam_ip'] == 0 ? $gbook->query("TRUNCATE TABLE `".$table."_forbidden_ip`") : "";

				$update2_properties = $gbook->query("UPDATE `".$table."_properties` SET
								      												 `antiflood_ban`		= '".$_POST['antiflood_ban']."', 
								      												 `deactivate_html`		= '".$_POST['deactivate_html']."', 
								      												 `clean_backup`			= '".$_POST['clean_backup']."', 
								      												 `entry_length_limit`	= '".$_POST['entry_length_limit']."', 
								      												 `entry_length_maximum`	= '".$_POST['entry_length_maximum']."', 
								      												 `entry_length_minimum`	= '".$_POST['entry_length_minimum']."', 
								      												 `no_spam_entries`		= '".$_POST['no_spam_entries']."', 
								      												 `spam_marker`			= '".$_POST['spam_marker']."', 
								      												 `no_spam_links`		= '".$_POST['no_spam_links']."', 
								      												 `max_links`			= '".$_POST['max_links']."', 
								      												 `max_word_length`		= '".$_POST['max_word_length']."',
								      												 `release_entries`		= '".$insert_release."'"); 

				if ($update2_properties){
					echo'<meta http-equiv="Refresh" content="0; url='.$url.'admin/admin.php?action=guestbook_options&#38;show=general_config&#38;'.session_name().'='.session_id().'#anchor-konfig2" />';
				}
			}
		}

		if (isset($_POST['send3'])) {
			$error_msg3 = "";

			if (!extension_loaded('gd') && (isset($_POST['images_in_entries']) && $_POST['images_in_entries'] != 0)) {
				$error_msg3 .= "".$emsg[68]."<br />";
			}

			if ((isset($_POST['rating_text']) && $_POST['rating_text'] != "" && !preg_match("/^[0-9a-zA-Z".$allowed_characters."\/ '():.,!?-]*$/is", $_POST['rating_text'])) OR (isset($_POST['title_subject']) && $_POST['title_subject'] != "" && !preg_match("/^[0-9a-zA-Z".$allowed_characters."\/ '():.,!?-]*$/is", $_POST['title_subject']))) {
				$error_msg3 .= "".$emsg[79]."<br />";
			}

			if (!$error_msg3 == "") {
				$error_gbook_options3 = '<p class="error">'.$error_msg3.'</p><br /><br />';
			}
			else {
				$_POST['bbcode']				= (isset($_POST['bbcode'])) ? $_POST['bbcode'] : '0';
				$_POST['check_email']			= (isset($_POST['check_email'])) ? $_POST['check_email'] : '0';
				$_POST['check_homepage']		= (isset($_POST['check_homepage'])) ? $_POST['check_homepage'] : '0';
				$_POST['images_in_entries']		= (isset($_POST['images_in_entries'])) ? $_POST['images_in_entries'] : '0';
				(($_POST['bbcode'] == 0) || (!extension_loaded('gd') && ($_POST['images_in_entries'] != 0))) ? ($_POST['images_in_entries'] = 0) : ($_POST['images_in_entries'] = $_POST['images_in_entries']);
				$_POST['quote_func']			= (isset($_POST['quote_func'])) ? $_POST['quote_func'] : '0';
				$_POST['smilies']				= (isset($_POST['smilies'])) ? $_POST['smilies'] : '0';
				$_POST['count_smilies']			= (isset($_POST['count_smilies'])) ? $_POST['count_smilies'] : '0';
				$_POST['check_subject']			= (isset($_POST['check_subject'])) ? $_POST['check_subject'] : '0';
				$_POST['check_town']			= (isset($_POST['check_town'])) ? $_POST['check_town'] : '0';
				$_POST['check_country']			= (isset($_POST['check_country'])) ? $_POST['check_country'] : '0';
				$_POST['check_free']			= (isset($_POST['check_free'])) ? $_POST['check_free'] : '0';
				($_POST['check_email'] == 4) ? ($_POST['check_free'] = 1) : ($_POST['check_free'] = $_POST['check_free']);
				$_POST['quote_func']			= (isset($_POST['quote_func'])) ? $_POST['quote_func'] : '0';

				$select2_properties = $gbook->query("SELECT `button_link` FROM `".$table."_properties`");
				$check2_properties = $select2_properties->fetch_assoc();

				($check2_properties['button_link'] == 2) ? ($_POST['quote_func'] = 0) : ($_POST['quote_func'] = $_POST['quote_func']);

				$_POST['rating']				= (isset($_POST['rating'])) ? $_POST['rating'] : '0';
				$_POST['rating_text']			= (isset($_POST['rating_text'])) ? trim($_POST['rating_text']) : '';
				$_POST['title_subject']			= (isset($_POST['title_subject'])) ? trim($_POST['title_subject']) : '';

				$_POST['rating_text']     	= $gbook->real_escape_string($_POST['rating_text']);
				$_POST['title_subject']    	= $gbook->real_escape_string($_POST['title_subject']);

				$_POST['images_in_entries'] == 0 ? $gbook->query("TRUNCATE TABLE ".$table."_upload_counter") : "";

				if ($_POST['smilies'] == 1 && $_POST['count_smilies'] == 2) {
					$smilies = 2;
				}
				elseif ($_POST['smilies'] == 1 && $_POST['count_smilies'] == 0) {
					$smilies = 1;
				}
				else {
					$smilies = 0;
				}

				$update_properties3 = $gbook->query("UPDATE `".$table."_properties` SET
								      												 `bbcode`				= '".$_POST['bbcode']."', 
								      												 `check_email`			= '".$_POST['check_email']."', 
								      												 `check_homepage`		= '".$_POST['check_homepage']."', 
								      												 `images_in_entries`	= '".$_POST['images_in_entries']."', 
								      												 `smilies`				= '".$smilies."', 
								      												 `quote_func`			= '".$_POST['quote_func']."',
								      												 `check_subject`		= '".$_POST['check_subject']."', 
								      												 `check_town`			= '".$_POST['check_town']."', 
								      												 `check_country`		= '".$_POST['check_country']."',
								      												 `check_free`			= '".$_POST['check_free']."',
								      												 `rating`				= '".$_POST['rating']."',
								      												 `rating_text`			= '".$_POST['rating_text']."',
								      												 `title_subject`		= '".$_POST['title_subject']."'");

				if ($update_properties3){
					echo'<meta http-equiv="Refresh" content="0; url='.$url.'admin/admin.php?action=guestbook_options&#38;show=general_config&#38;'.session_name().'='.session_id().'#anchor-konfig3" />';
				}
			}
		}

		if (isset($_POST['send4'])) {
			$deleteIP01 = $deleteIP02 = $deleteIP03 = $deleteIP04 = "";
			
			$_POST['full_privacy'] = isset($_POST['full_privacy']) ? $_POST['full_privacy'] : 0;

			($release_entries == 0 || $release_entries == 2) ? $insert_release = 2 : $insert_release = 3;

			if ($_POST['full_privacy'] == 1) {
				$update_properties4 = $gbook->query("UPDATE `".$table."_properties` SET 
																						`antiflood_ban`		= '0', 
																						`images_in_entries`	= '0', 
																						`quote_func`		= '0',
																						`release_entries`	= '".$insert_release."', 
																						`statistic`			= '0', 
																						`choose_lang`		= '0', 
																						`search_func`		= '0'");
																						
				$deleteIP01 = $gbook->query("TRUNCATE TABLE `".$table."_upload_counter`");
				$deleteIP02 = $gbook->query("TRUNCATE TABLE `".$table."_search_counter`");
				$deleteIP03 = $gbook->query("TRUNCATE TABLE `".$table."_forbidden_ip`");
				$deleteIP04 = $gbook->query("TRUNCATE TABLE `".$table."_ip_ban`");
			}

			if ($update_properties4){
				($deleteIP01 && $deleteIP02 && $deleteIP03 && $deleteIP04) ? $deleteIpSuccess = "<p class=\"text-center green size-14\"><strong>".$amsg[279]."</strong></p>" : $deleteIpSuccess = "";

				echo'<meta http-equiv="Refresh" content="4; url='.$url.'admin/admin.php?action=guestbook_options&#38;'.session_name().'='.session_id().'#anchor-konfig4" />';
			}
		}

		$sql_select_properties = $gbook->query("SELECT `antiflood_ban`, `bbcode`, `check_email`, `check_homepage`, `deactivate_html`, `clean_backup`, `default_template`, `entries_per_site`, `entry_length_limit`, `entry_length_maximum`, `entry_length_minimum`, `guestbook_status`, `no_spam_entries`, `spam_marker`, `no_spam_links`, `max_links`, `guestbook_title`, `images_in_entries`, `links_in_sitefunction`, `max_word_length`, 
														`notification_entries`, `release_entries`, `smilies`, `thanks_email`, `statistic`, `statistic_ban`, `quote_func`, `link_entry`, `check_subject`, `check_town`, `check_country`, `check_free`, `button_link`, `rating`, `rating_text`, `title_subject`, `choose_lang`, `administration`, `check_banner`, `flag`, `privacy_hint`, `privacy_url`, `search_func`, `permalink` 
										 		FROM `".$table."_properties`");
		$select_properties = $sql_select_properties->fetch_assoc();

		$select_properties['link_entry'] = $select_properties['link_entry'] === NULL ? "" : $select_properties['link_entry'];
		$select_properties['rating_text'] = $select_properties['rating_text'] === NULL ? "" : $select_properties['rating_text'];
		$select_properties['title_subject'] = $select_properties['title_subject'] === NULL ? "" : $select_properties['title_subject'];
		$select_properties['privacy_url'] = $select_properties['privacy_url'] === NULL ? "" : $select_properties['privacy_url'];

		$spamword_lock = $gbook->query("SELECT `id` FROM `".$table."_spam`");
		($spamword_lock != "") ? $spam_lock = $spamword_lock->num_rows : $spam_lock = 0;

		$sql_template = $gbook->query("SELECT `image_star` FROM `".$table."_template` WHERE `id` = '".$select_properties['default_template']."'");
		$template = $sql_template->fetch_assoc();
		$star_ico = $template['image_star']; 

		if (!empty($select_properties['choose_lang'])) {
			$selectInfoLang = "<a title=\"".$amsg[340]."\" class=\"cursor-help marg-le10\" href=\"javascript:{}\" onclick=\"document.getElementById('select_info').style.display='inline';return false;\"><img class=\"img-ok\" src=\"../images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a>";
			$selectCheckEntrie = "<a title=\"".$amsg[340]."\" class=\"cursor-help marg-le10\" href=\"javascript:{}\" onclick=\"document.getElementById('select_info').style.display='inline';return false;\"><img class=\"img-ok\" src=\"../images/ausruf.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a>";
		}

		if ($select_properties['privacy_hint'] == 1 OR $select_properties['privacy_hint'] == 3)  {
			if (empty($select_properties['privacy_url'])) {
				$check_privacy = '<img class="img-ok marg-le10" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="Check the entry!" />';
				$input_privacy = ' no-insert';
				$placeholder_privacy = ' placeholder="Enter URL to Privacy!"';
			}
			else {
				$check_privacy = ' <span class="marg-le10 nowrap">[ <a class="external textLink" href="'.$select_properties['privacy_url'].'" title="'.$fmsg[266].'" rel="external">'.$amsg[240].'</a> ]</span>';
				$input_privacy = '';
				$placeholder_privacy = '';
			}
		}

		if (empty($select_properties['guestbook_status'])) {
			$gbook_activate = '<img class="img-ok marg-le10 oldie" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="Guestbook deactivated!" />';
		}

		if (!empty($select_properties['choose_lang']) && !empty($select_properties['search_func'])) {
			$selectTableWidth = "<a title=\"".$amsg[340]."\" class=\"cursor-help2\" href=\"javascript:{}\" onclick=\"document.getElementById('tablewidth').style.display='inline';return false;\"><img class=\"img-ok\" src=\"../images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a>";
		}
	
		if ($widthWarning != "") {
			$selectTableWidth = "<a title=\"".$amsg[340]."\" class=\"cursor-help2\" href=\"javascript:{}\" onclick=\"document.getElementById('tablewidth').style.display='inline';return false;\"><img class=\"img-ok\" src=\"../images/ausruf.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a>";
		}

		echo "
			<div class=\"content-02\">";
			echo"
				<form method=\"post\" name=\"options\" action=\"".$url."admin/admin.php?action=guestbook_options&#38;".session_name()."=".session_id()."\">
					<fieldset style=\"background-color:#fafafa;\">
					<legend><strong class=\"size-14\">1. ".$fmsg[113]."</strong></legend>
					<br /><br />".$error_gbook_options."
					<div class=\"config-le\"><p>".$fmsg[57]."</p></div>
					<div class=\"config-ri\"><p class=\"nowrap\" style=\"margin-top:7px;\"><img class=\"img-ok\" src=\"".$url."includes/flags/".$select_properties['flag'].".png\" width=\"16\" height=\"11\" alt=\"".$language."\" /><select class=\"marg-side10\" name=\"flag\">";

						$lang_dir = "../includes/flags";

						$files = scandir($lang_dir);

						foreach ($files as $file) {
							if ($file != "." && $file != "..") {
								($file == "index.php") ? $file = "" : "";
								$lang = explode(".", $file);
							}
							if (isset($lang[0]) && $lang[0] != "") {
								echo "<option value=\"".$lang[0]."\"";
		
								if ($select_properties['flag'] == $lang[0])	{
									echo " selected=\"selected\"";
								}
								echo ">".$lang[0]."</option>";
							}
						}
						
				echo "</select><a title=\"".$amsg[340]."\" class=\"cursor-help marg-le15\" href=\"javascript:{}\" onclick=\"document.getElementById('flags').style.display='inline';return false;\"><img class=\"img-ok\" src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p>
					</div>
					<div class=\"break\"></div>";
	
				echo'
					<div id="flags" class="gb-lightbox" style="display:none">
						<div class="gb-lightbox-inner">';

							include("flag_info.php");

						echo'
							<div class="gblb-close"><img class="close-flag" src="'.$url.'images/not_ok.png" alt="Close" width="14" height="14" onclick="document.getElementById(\'flags\').style.display=\'none\';" /></div>
						</div>
					</div>';

				echo"
					<div class=\"config-le\"><p>".$fmsg[114]."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" name=\"guestbook_title\" size=\"20\" style=\"width:90%;\" maxlength=\"50\" value=\"".$select_properties['guestbook_title']."\" /></p></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[173].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"guestbook_status\"";

						if (isset($select_properties['guestbook_status']) AND $select_properties['guestbook_status']== 1) {
							echo " checked=\"checked\"";
						}

				echo " value=\"1\" /><span class=\"checkmark-02\"></span>".$gbook_activate."</p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[123]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"release_entries\"";

						if (isset($select_properties['release_entries']) AND ($select_properties['release_entries']== 1 || $select_properties['release_entries']== 3)) {
							echo " checked=\"checked\"";
						}

				echo " value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"	
					<div class=\"config-le\"><p>".$fmsg[119]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"notification_entries\"";

						if (isset($select_properties['notification_entries']) AND $select_properties['notification_entries']== 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[148]."</p></div>
					<div class=\"config-ri\"><p><a title=\"".$amsg[340]."\" class=\"cursor-help\" href=\"javascript:{}\" onclick=\"document.getElementById('entry_link').style.display='inline';return false;\"><img class=\"img-ok\" src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p></div>
					<div class=\"break\"></div>";
				echo"
					<div id=\"entry_link\" class=\"gb-lightbox\" style=\"display:none\">
						<div class=\"gb-lightbox-inner\">
							<span class=\"aligncenter\"><strong>".$amsg[148]."</strong></span>".$amsg[149]."
							<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('entry_link').style.display='none';\" /></div>
						</div>
					</div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:6px 0;\">".$amsg[169]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:6px 0;\"><input type=\"radio\" name=\"button_link\" onclick=\"input_activate_09();\"";

						if (isset($select_properties['button_link']) AND $select_properties['button_link'] == 0) {
							echo" checked=\"checked\"";
						}

				echo" value=\"0\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p>".$amsg[170]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"radio\" name=\"button_link\" onclick=\"input_activate_09();\"";

						if (isset($select_properties['button_link']) AND $select_properties['button_link'] == 1) {
							echo" checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:6px 0;\">".$amsg[172]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:6px 0;\"><input type=\"radio\" name=\"button_link\" onclick=\"input_activate_05();\"";

						if (isset($select_properties['button_link']) AND $select_properties['button_link'] == 2) {
							echo" checked=\"checked\"";
						}

				echo" value=\"2\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[171]."";

						($select_properties['link_entry'] == "") ? $showInfoLang01 = $selectInfoLang : $showInfoLang01 = $selectCheckEntrie;

				echo" ".$showInfoLang01."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" name=\"link_entry\" size=\"20\" style=\"width:90%;\" maxlength=\"35\"";

						if (isset($select_properties['button_link']) AND $select_properties['button_link'] == 2) {
							echo " disabled=\"disabled\"";
						}

					 echo" value=\"";

						if (!empty($select_properties['link_entry'])) {
							echo"".$select_properties['link_entry']."";
							$placeholder = "";
						}
						else {
							$placeholder = " placeholder=\"".$fmsg[13]."\"";
						}

				echo"\"$placeholder /></p></div>
					<div class=\"break\"></div>";
				echo"
					<div id=\"select_info\" class=\"gb-lightbox\" style=\"display:none\">
						<div class=\"gb-lightbox-inner\">
							<span class=\"aligncenter\"><strong>".$amsg[332]." !</strong></span>".$amsg[379]."
							<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('select_info').style.display='none';\" /></div>
						</div>
					</div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[115]."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" size=\"4\" name=\"entries_per_site\" value=\"".$select_properties['entries_per_site']."\" /></p></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[116]."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" size=\"4\" name=\"links_in_sitefunction\" value=\"".$select_properties['links_in_sitefunction']."\" /></p></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[206]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"thanks_email\"";

						if (isset($select_properties['thanks_email']) AND $select_properties['thanks_email']== 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span>".$checkGuestMail."<a title=\"".$amsg[340]."\" class=\"cursor-help2 oldie\" style=\"position:relative;top:3px;\" href=\"javascript:{}\" onclick=\"document.getElementById('email_lang').style.display='inline';return false;\"><img src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div id=\"email_lang\" class=\"gb-lightbox\" style=\"display:none\">
						<div class=\"gb-lightbox-inner\" style=\"max-width:350px;\">
							<span class=\"aligncenter\"><strong>".$amsg[146]."</strong></span><br />".$amsg[147]."
							<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('email_lang').style.display='none';\" /></div>
						</div>
					</div>";
				echo"
					<p>".$amsg[335]."</p>
					<div class=\"config-le text-right\"><p style=\"margin:6px 0;\">".$amsg[336].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:6px 0;\"><input type=\"radio\" name=\"choose_lang\"";

						if (isset($select_properties['choose_lang']) AND $select_properties['choose_lang'] == 0) {
							echo" checked=\"checked\"";
						}

				echo" value=\"0\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:6px 0;\">".$amsg[338]."<br /><span class=\"size-10\">(".$amsg[339].")</span></p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:14px 0;\"><input type=\"radio\" name=\"choose_lang\"";

						if (isset($select_properties['choose_lang']) AND $select_properties['choose_lang'] == 2) {
							echo" checked=\"checked\"";
						}

				echo" value=\"2\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:6px 0;\">".$amsg[337]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:6px 0;\"><input type=\"radio\" name=\"choose_lang\"";

						if (isset($select_properties['choose_lang']) AND $select_properties['choose_lang'] == 1) {
							echo" checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p><br />".$amsg[59].":<br /><span class=\"size-10\">(".$amsg[361].")</span></p></div>
					<div class=\"config-ri\"><br /><label class=\"container\"><p><input type=\"checkbox\" name=\"check_banner\"";

						if (isset($select_properties['check_banner']) AND $select_properties['check_banner']== 1) {
							echo " checked=\"checked\"";
						}

				echo " value=\"1\" /><span class=\"checkmark\"></span>".$checkBanner."<a title=\"".$amsg[340]."\" class=\"cursor-help2 oldie\" style=\"position:relative;top:3px;\" href=\"javascript:{}\" onclick=\"document.getElementById('banner').style.display='inline';return false;\"><img src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div id=\"banner\" class=\"gb-lightbox\" style=\"display:none\">
						<div class=\"gb-lightbox-inner\">
							<span class=\"aligncenter\"><strong>".$amsg[59]."</strong></span><br />".$amsg[302]."
							<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('banner').style.display='none';\" /></div>
						</div>
					</div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[257]."</p></div>
					<div class=\"config-ri\">";

						if (!$gbook->set_charset("utf8")) {
							echo " Error loading character set utf8: ".$gbook->error."<br />Use of the search function is not possible for security reasons.";
						}
						else {
							echo"<label class=\"container\"><p><input type=\"checkbox\" name=\"search_func\"";

								if (isset($select_properties['search_func']) AND $select_properties['search_func']== 1) {
									echo " checked=\"checked\"";
								}

							echo " value=\"1\" /><span class=\"checkmark\"></span>".$selectTableWidth."</p></label>";
						}

				echo "</div>
					<div class=\"break\"></div>";
				echo"
					<div id=\"tablewidth\" class=\"gb-lightbox\" style=\"display:none\">
						<div class=\"gb-lightbox-inner\" style=\"max-width:350px;\">
							<span class=\"aligncenter\"><strong>".$amsg[332]."!</strong></span><br />".$amsg[260]."
							<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('tablewidth').style.display='none';\" /></div>
						</div>
					</div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[258]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"permalink\"";

						if (isset($select_properties['permalink']) AND $select_properties['permalink']== 1) {
							echo " checked=\"checked\"";
						}

				echo " value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[142]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"administration\"";

						if (isset($select_properties['administration']) AND $select_properties['administration']== 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[241]."</p></div>
					<div class=\"config-ri\"><label class=\"container\" style=\"top:5px;\"><p><input type=\"checkbox\" name=\"agree\"";

						if (isset($select_properties['privacy_hint']) AND $select_properties['privacy_hint'] > 1) {
							echo " checked=\"checked\"";
						}
						else {
							$warning_dsgvo = '<img class="img-ok oldie" style="margin-left:20px;" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="'.$amsg[256].'" />';
						}

				echo " value=\"2\" /><span class=\"checkmark\"></span>".$warning_dsgvo."</p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[234]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"privacy_hint\" onclick=\"input_activate_11();input_privacy();\"";

						if (isset($select_properties['privacy_hint']) AND ($select_properties['privacy_hint'] == 1 OR $select_properties['privacy_hint'] == 3)) {
							echo" checked=\"checked\"";
						}
						else {
							$warning02_dsgvo = '<img class="img-ok oldie" style="margin-left:20px;" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="'.$amsg[256].'" />';
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span>".$warning02_dsgvo."<a title=\"".$amsg[340]."\" class=\"cursor-help2 oldie\" style=\"position:relative;top:3px;\" href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_privacy').style.display='inline';return false;\"><img src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div id=\"lightbox_privacy\" class=\"gb-lightbox\" style=\"display:none\">
						<div class=\"gb-lightbox-inner\">
							<span class=\"aligncenter\"><strong>".$amsg[236]."</strong></span><br />".$amsg[237]."
							<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_privacy').style.display='none';\" /></div>
						</div>
					</div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[235]."".$check_privacy."<span id=\"warningDSGVO\">&nbsp;</span></p></div>
					<div class=\"config-ri\"><p><input type=\"text\" id=\"data\" class=\"insert".$input_privacy."\" name=\"privacy_url\" onfocus=\"input_privacy_02();\" onblur=\"input_privacy_03()\" size=\"20\" style=\"width:90%;\" maxlength=\"150\"".$placeholder_privacy."";

						if (isset($select_properties['privacy_hint']) AND ($select_properties['privacy_hint'] == 0 OR $select_properties['privacy_hint'] == 2)) {
							echo " disabled=\"disabled\"";
						}

				 echo" value=\"";

						if (!empty($select_properties['privacy_url'])) {
							echo stripslashes(htmlspecialchars(strip_tags($select_properties['privacy_url']), ENT_QUOTES));
						}

				echo"\" /></p></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[122]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"statistic\" onclick=\"input_activate_12();\"";

						if (isset($select_properties['statistic']) AND $select_properties['statistic']== 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[118]."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" name=\"statistic_ban\" size=\"4\" maxlength=\"5\"";

						if (isset($select_properties['statistic']) AND $select_properties['statistic'] == 0) {
							echo " disabled=\"disabled\"";
						}

				echo" value=\"".$select_properties['statistic_ban']."\" /></p></div>
					<div class=\"break\"></div>";
				echo"
					<p class=\"aligncenter\"><br /><br /><input class=\"button\" style=\"font-weight:bold;\" type=\"submit\" name=\"send1\" value=\"".$fmsg[55]." 1\" /></p>
				</fieldset>
			</form>";

			echo"
			<form method=\"post\" name=\"options2\" action=\"".$url."admin/admin.php?action=guestbook_options&#38;".session_name()."=".session_id()."#anchor-konfig2\">
				<span class=\"sticky-anchor\" id=\"anchor-konfig2\"></span>
				<fieldset style=\"background-color:#f8e0e0;margin-top:12px;\">
				<legend><strong class=\"size-14\">2. ".$amsg[28]."</strong></legend><br />".$error_gbook_options2."";

				if (SPAM_PROTECT) {
					echo"
						<div class=\"config-le\"><p>".$fmsg[255]."</p></div>
						<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" size=\"4\" name=\"spam_marker\" value=\"".$select_properties['spam_marker']."\" /><a title=\"".$amsg[340]."\" class=\"cursor-help2\" href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_spam').style.display='inline';return false;\"><img class=\"img-ok\" src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p></div>
						<div class=\"break\"></div>";
					echo"
						<div id=\"lightbox_spam\" class=\"gb-lightbox\" style=\"display:none\">
							<div class=\"gb-lightbox-inner\" style=\"max-width:300px\">
								<span class=\"aligncenter\"><strong>".$fmsg[259]."</strong></span><br />".$fmsg[260]."
								<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_spam').style.display='none';\" /></div>
							</div>
						</div>";
					echo"
						<div class=\"config-le\"><p>".$amsg[265]."</p></div>
						<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"save_spam_ip\"";

							if (isset($select_properties['release_entries']) AND ($select_properties['release_entries']== 0 || $select_properties['release_entries']== 1)) {
								echo " checked=\"checked\"";
							}

					echo " value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
						<div class=\"break\"></div>";
					echo"
						<div class=\"config-le\"><p>".$fmsg[256]."</p></div>
						<div class=\"config-ri\">";

							if ($spam_lock == 0) {
								echo" <p><a title=\"".$amsg[340]."\" class=\"cursor\" href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_spamwords').style.display='inline';return false;\"><img class=\"img-ok\" src=\"".$url."images/ausruf.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p>";
							}
							else {
								echo"<label class=\"container\"><p><input type=\"checkbox\" name=\"no_spam_entries\"";
		
									if (isset($select_properties['no_spam_entries']) AND $select_properties['no_spam_entries'] == 1 AND $spam_lock) {
										echo" checked=\"checked\"";
									}
								echo" value=\"1\" /><span class=\"checkmark\"></span></p></label>";
							}

					echo "</div>
						<div class=\"break\"></div>";
					echo"
						<div id=\"lightbox_spamwords\" class=\"gb-lightbox\" style=\"display:none\">
							<div class=\"gb-lightbox-inner\" style=\"max-width:310px;\">
								<span class=\"aligncenter\"><strong>".$amsg[332]." !</strong></span><br />".$fmsg[261]."<strong> => <a class=\"layout\" href=\"admin.php?action=spamwords&#38;show=insert_spam&#38;".session_name()."=".session_id()."\">Click !</a></strong>
								<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_spamwords').style.display='none';\" /></div>
							</div>
						</div>";
					echo"
						<div class=\"config-le\"><p>".$fmsg[257]."</p></div>
						<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"no_spam_links\" onclick=\"input_activate_02();\"";

							if (isset($select_properties['no_spam_links']) AND $select_properties['no_spam_links']== 1) {
								echo " checked=\"checked\"";
							}

					echo" value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
						<div class=\"break\"></div>";
					echo"
						<div class=\"config-le\"><p>".$fmsg[258]."</p></div>
						<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" size=\"4\" name=\"max_links\"";

							if (isset($select_properties['no_spam_links']) AND $select_properties['no_spam_links'] != 1) {
								echo " disabled=\"disabled\"";
							}

					echo" value=\"".$select_properties['max_links']."\" /></p></div>
						<div class=\"break\"></div>";
				}
				else {
					echo"
						<div class=\"config-le\"><p class=\"red\">".$fmsg[340]."</p></div>
						<div class=\"config-ri\"><p><a title=\"".$amsg[340]."\" class=\"cursor-help\" href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_nospam').style.display='inline';return false;\"><img class=\"img-ok\" src=\"".$url."images/ausruf.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p></div>
						<div class=\"break\"></div>";
					echo"
						<div id=\"lightbox_nospam\" class=\"gb-lightbox\" style=\"display:none\">
							<div class=\"gb-lightbox-inner\" style=\"max-width:320px;\">
								<span class=\"aligncenter\"><strong>".$fmsg[338]."</strong></span><br />".$fmsg[339]."
								<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_nospam').style.display='none';\" /></div>
							</div>
						</div>";
				}

				echo"
					<div class=\"config-le\"><p>".$fmsg[117]."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" size=\"4\" name=\"antiflood_ban\" value=\"".$select_properties['antiflood_ban']."\" /></p></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[124]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"deactivate_html\"";

						if (isset($select_properties['deactivate_html']) AND $select_properties['deactivate_html']== 1) {
							echo " checked=\"checked\"";
						}
						else {
							$deactivate_html = '<img class="img-ok marg-le10 oldie" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="Check the entry!" />';
						}

				echo" value=\"1\" /><span class=\"checkmark-02\"></span>".$deactivate_html."</p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[174]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"entry_length_limit\" onclick=\"input_activate();\"";

						if ($select_properties['entry_length_limit']) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[175]."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" size=\"4\" name=\"entry_length_maximum\"";

						if (isset($select_properties['entry_length_limit']) AND $select_properties['entry_length_limit'] != 1) {
							echo " disabled=\"disabled\"";
						}

				echo" value=\"".$select_properties['entry_length_maximum']."\" /></p></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[176]."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" size=\"4\" name=\"entry_length_minimum\"";

						if (isset($select_properties['entry_length_limit']) AND $select_properties['entry_length_limit'] != 1) {
							echo " disabled=\"disabled\"";
						}

				echo" value=\"".$select_properties['entry_length_minimum']."\" /></p></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[203]."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" size=\"4\" name=\"max_word_length\" value=\"".$select_properties['max_word_length']."\" /></p></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[275]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"clean_backup\"";

						if (isset($select_properties['clean_backup']) AND $select_properties['clean_backup']== 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<p class=\"aligncenter\"><br /><br /><input class=\"button\" style=\"font-weight:bold;\" type=\"submit\" name=\"send2\" value=\"".$fmsg[55]." 2\" /></p>";
				echo"
				</fieldset>
			</form>";

			echo"
				<form method=\"post\" name=\"options3\" action=\"".$url."admin/admin.php?action=guestbook_options&#38;".session_name()."=".session_id()."#anchor-konfig3\">
					<span class=\"sticky-anchor\" id=\"anchor-konfig3\"></span>
					<fieldset style=\"background-color:#fafafa;margin-top:12px;\">
					<legend><strong class=\"size-14\">3. ".$fmsg[110]."</strong></legend><br />".$error_gbook_options3."";
				echo"
					<div class=\"config-le\"><p>".$fmsg[120]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"smilies\" onclick=\"input_activate_13();\"";

						if (isset($select_properties['smilies']) AND $select_properties['smilies'] > 0) {
							echo " checked=\"checked\"";
						}

				echo " value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[281]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"count_smilies\"";

						if (isset($select_properties['smilies']) AND $select_properties['smilies'] == 0) {
							echo " disabled=\"disabled\"";
						}
						elseif (isset($select_properties['smilies']) AND $select_properties['smilies'] == 2) {
							echo " checked=\"checked\"";
						}

				echo " value=\"2\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[121]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"bbcode\" onclick=\"input_activate_03();\"";

						if (isset($select_properties['bbcode']) AND $select_properties['bbcode'] == 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[220]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"images_in_entries\"";

						if (isset($select_properties['bbcode']) AND $select_properties['bbcode'] != 1) {
							echo " disabled=\"disabled\"";
						}
						elseif (isset($select_properties['bbcode']) AND $select_properties['bbcode'] == 1 AND isset($select_properties['images_in_entries']) AND $select_properties['images_in_entries']== 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";

				if ((!PIC_CHECK) AND isset($select_properties['images_in_entries']) AND $select_properties['images_in_entries']== 1) {
					echo"
						<div class=\"config-le\"><p class=\"red\">".$fmsg[343]."</p></div>
						<div class=\"config-ri\"><p><a title=\"".$amsg[340]."\" class=\"cursor-help\" href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_no_piccheck').style.display='inline';return false;\"><img class=\"img-ok\" src=\"".$url."images/ausruf.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p></div>
						<div class=\"break\"></div>";
					echo"
						<div id=\"lightbox_no_piccheck\" class=\"gb-lightbox\" style=\"display:none\">
							<div class=\"gb-lightbox-inner\">
								<span class=\"aligncenter\"><strong>".$fmsg[341]."</strong></span><br />".$fmsg[342]."
								<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_no_piccheck').style.display='none';\" /></div>
							</div>
						</div>";
				}

				echo"
					<div class=\"config-le\"><p>".$amsg[111]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"quote_func\"";

						if (isset($select_properties['button_link']) AND $select_properties['button_link'] == 2) {
							echo " disabled=\"disabled\"";
						}
						elseif (isset($select_properties['button_link']) AND $select_properties['button_link'] != 2 AND isset($select_properties['quote_func']) AND $select_properties['quote_func'] == 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span><a title=\"".$amsg[340]."\" class=\"cursor-help2 oldie\" style=\"position:relative;top:3px;\" href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_quote').style.display='inline';return false;\"><img src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div id=\"lightbox_quote\" class=\"gb-lightbox\" style=\"display:none\">
						<div class=\"gb-lightbox-inner\" style=\"max-width:300px;\">
							<span class=\"aligncenter\"><strong>".$amsg[175]."</strong></span><br />".$amsg[176]."
							<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_quote').style.display='none';\" /></div>
						</div>
					</div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[185].": [ <img class=\"img-ok\" src=\"".$url."images/icons/stars/".$star_ico."\" width=\"16\" height=\"16\" alt=\"Star\" /> ]</p></div>
					<div class=\"config-ri\"><p><a title=\"".$amsg[340]."\" class=\"cursor-help\" href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_rating').style.display='inline';return false;\"><img class=\"img-ok\" src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p></div>
					<div class=\"break\"></div>";
				echo"
					<div id=\"lightbox_rating\" class=\"gb-lightbox\" style=\"display:none\">
						<div class=\"gb-lightbox-inner\">
							<span class=\"aligncenter\"><strong>".$amsg[185]."</strong></span><br />".$amsg[188]."
							<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_rating').style.display='none';\" /></div>
						</div>
					</div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:6px 0;\">".$amsg[193].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:6px 0;\"><input type=\"radio\" name=\"rating\" onclick=\"input_activate_06();\"";

						if (isset($select_properties['rating']) AND $select_properties['rating'] == 0) {
							echo" checked=\"checked\"";
						}

				echo" value=\"0\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p>".$amsg[194].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"radio\" name=\"rating\" onclick=\"input_activate_07();\"";

						if (isset($select_properties['rating']) AND $select_properties['rating'] == 1) {
							echo" checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:6px 0;\">".$amsg[195].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:6px 0;\"><input type=\"radio\" name=\"rating\" onclick=\"input_activate_07();\"";

						if (isset($select_properties['rating']) AND $select_properties['rating'] == 2) {
							echo" checked=\"checked\"";
						}

				echo" value=\"2\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[187].":";

						($select_properties['rating_text'] == "") ? $showInfoLang02 = $selectInfoLang : $showInfoLang02 = $selectCheckEntrie;

				echo" ".$showInfoLang02."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" name=\"rating_text\" size=\"10\" style=\"width:90%;\" maxlength=\"35\"";

						if (isset($select_properties['rating']) AND $select_properties['rating'] == 0) {
							echo " disabled=\"disabled\"";
						}

				echo" value=\"";

						if (!empty($select_properties['rating_text'])) {
							echo"".$select_properties['rating_text']."";
							$placeholder02 = "";
						}
						else {
							$placeholder02 = " placeholder=\"".$fmsg[352]."\"";
						}

				echo"\"$placeholder02 /></p></div>
					<div class=\"break\"></div>";
				echo"
					<p>".$amsg[120]." <strong class=\"red\">".$amsg[122]."</strong> ".$amsg[121]."</p>
					<div class=\"config-le text-right\"><p style=\"margin:8px 0;\">".$amsg[124]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:8px 0;\"><input type=\"radio\" name=\"check_email\" onclick=\"input_activate_08();\"";

						if (isset($select_properties['check_email']) AND $select_properties['check_email'] == 0) {
							echo" checked=\"checked\"";
						}

				echo" value=\"0\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:8px 0;\">".$amsg[125]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:8px 0;\"><input type=\"radio\" name=\"check_email\" onclick=\"input_activate_08();\"";

						if (isset($select_properties['check_email']) AND $select_properties['check_email'] == 3) {
							echo" checked=\"checked\"";
						}

				echo" value=\"3\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<p>".$amsg[120]." <strong class=\"red\">".$amsg[123]."</strong> ".$amsg[121]."</p>
					<div class=\"config-le text-right\"><p style=\"margin:8px 0;\">".$amsg[124]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:8px 0;\"><input type=\"radio\" name=\"check_email\" onclick=\"input_activate_08();\"";

						if (isset($select_properties['check_email']) AND $select_properties['check_email'] == 1) {
							echo" checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:8px 0;\">".$amsg[125]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:8px 0;\"><input type=\"radio\" name=\"check_email\" onclick=\"input_activate_08();\"";

						if (isset($select_properties['check_email']) AND $select_properties['check_email'] == 2) {
							echo" checked=\"checked\"";
						}

				echo" value=\"2\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[196]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"radio\" name=\"check_email\" onclick=\"input_activate_04();\"";

						if (isset($select_properties['check_email']) AND $select_properties['check_email'] == 4) {
							echo" checked=\"checked\"";
						}

				echo" value=\"4\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<p>".$amsg[126]." ...</p>
					<div class=\"config-le text-right\"><p style=\"margin:8px 0;\">".$amsg[198].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:8px 0;\"><input type=\"radio\" name=\"check_town\" onclick=\"input_privacy_04();\"";

						if (isset($select_properties['check_town']) AND $select_properties['check_town'] == 1) {
							echo" checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:8px 0;\">".$fmsg[337].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:8px 0;\"><input type=\"radio\" name=\"check_town\" onclick=\"input_privacy_04();\"";

						if (isset($select_properties['check_town']) AND $select_properties['check_town'] == 0) {
							echo" checked=\"checked\"";
						}

				echo" value=\"0\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:8px 0;\">".$fmsg[334].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:8px 0;\"><input type=\"radio\" name=\"check_town\" onclick=\"input_privacy_04();\"";

						if (isset($select_properties['check_town']) AND $select_properties['check_town'] == 2) {
							echo" checked=\"checked\"";							

							$warning_town = '<img class="img-ok oldie" style="margin-left:10px;" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="'.$amsg[199].'" />';
						}

				echo" value=\"2\" /><span class=\"radiocheckmark\"></span><span id=\"warningTown\">".$warning_town."</span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<p>".$amsg[127]." ...</p>
					<div class=\"config-le text-right\"><p style=\"margin:8px 0;\">".$amsg[198].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:8px 0;\"><input type=\"radio\" name=\"check_country\" onclick=\"input_privacy_05();\"";

						if (isset($select_properties['check_country']) AND $select_properties['check_country'] == 1) {
							echo" checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:8px 0;\">".$fmsg[337].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:8px 0;\"><input type=\"radio\" name=\"check_country\" onclick=\"input_privacy_05();\"";

						if (isset($select_properties['check_country']) AND $select_properties['check_country'] == 0) {
							echo" checked=\"checked\"";
						}

				echo" value=\"0\" /><span class=\"radiocheckmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le text-right\"><p style=\"margin:8px 0;\">".$fmsg[334].":</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p style=\"margin:8px 0;\"><input type=\"radio\" name=\"check_country\" onclick=\"input_privacy_05();\"";

						if (isset($select_properties['check_country']) AND $select_properties['check_country'] == 2) {
							echo" checked=\"checked\"";

							$warning_country = '<img class="img-ok oldie" style="margin-left:10px;" src="../images/ausruf.png" width="14" height="14" alt="Check!" title="'.$amsg[199].'" />';
						}

				echo" value=\"2\" /><span class=\"radiocheckmark\"></span><span id=\"warningCountry\">".$warning_country."</span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$fmsg[201]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"check_homepage\"";

						if (isset($select_properties['check_homepage']) AND $select_properties['check_homepage'] == 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[128]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"check_subject\" onclick=\"input_activate_10();\"";

						if (isset($select_properties['check_subject']) AND $select_properties['check_subject']== 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[208]."";

						($select_properties['title_subject'] == "") ? $showInfoLang03 = $selectInfoLang : $showInfoLang03 = $selectCheckEntrie;

				echo" ".$showInfoLang03."</p></div>
					<div class=\"config-ri\"><p><input type=\"text\" class=\"insert\" name=\"title_subject\" size=\"20\" style=\"width:90%;\" maxlength=\"25\"";

						if (isset($select_properties['check_subject']) AND $select_properties['check_subject'] == 1) {
							echo " disabled=\"disabled\"";
						}

				 echo" value=\"";

						if (!empty($select_properties['title_subject'])) {
							echo"".$select_properties['title_subject']."";
								$placeholder = "";
						}
						else {
							$placeholder = " placeholder=\"".$fmsg[313]."\"";
						}

				echo"\"$placeholder /></p></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"config-le\"><p>".$amsg[159]."</p></div>
					<div class=\"config-ri\"><label class=\"container\"><p><input type=\"checkbox\" name=\"check_free\"";

						if (isset($select_properties['check_email']) AND $select_properties['check_email'] == 4) {
							echo " disabled=\"disabled\"";
						}
						elseif (isset($select_properties['check_email']) AND $select_properties['check_email'] != 4 AND isset($select_properties['check_free']) AND $select_properties['check_free']== 1) {
							echo " checked=\"checked\"";
						}

				echo" value=\"1\" /><span class=\"checkmark\"></span><a title=\"".$amsg[340]."\" class=\"cursor-help2 oldie\" style=\"position:relative;top:3px;\" href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_info').style.display='inline';return false;\"><img src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[119]."\" /></a></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div id=\"lightbox_info\" class=\"gb-lightbox\" style=\"display:none\">
						<div class=\"gb-lightbox-inner\" style=\"max-width:320px;\">
							<span class=\"aligncenter\"><strong>".$amsg[160]."</strong></span><br />".$amsg[161]."
							<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_info').style.display='none';\" /></div>
						</div>
					</div>";
				echo"
					<p class=\"aligncenter\"><br /><br /><input class=\"button\" style=\"font-weight:bold;\" type=\"submit\" name=\"send3\" value=\"".$fmsg[55]." 3\" /></p>
					</fieldset>
					</form>";

			echo"
				<form method=\"post\" name=\"options4\" action=\"".$url."admin/admin.php?action=guestbook_options&#38;".session_name()."=".session_id()."#anchor-konfig4\">
					<span class=\"sticky-anchor\" id=\"anchor-konfig4\"></span>
					<fieldset style=\"background-color:#f8e0e0;margin-top:12px;\">
					<legend><strong class=\"size-14\">4. ".$amsg[267]."</strong></legend>
					<br /><br />".$deleteIpSuccess."";
				echo"
					<div class=\"config-le\"><p class=\"size-14\">".$amsg[268]."</p></div>
					<div class=\"config-ri\" style=\"margin-top:7px;\"><label class=\"container\"><p><input type=\"checkbox\" name=\"full_privacy\"";

						if ($select_properties['choose_lang'] == 0 && $select_properties['search_func'] == 0 && $select_properties['statistic'] == 0 && $select_properties['quote_func'] == 0 && $select_properties['images_in_entries'] == 0 && $select_properties['antiflood_ban'] == 0 && $select_properties['release_entries'] > 1) {
							echo" checked=\"checked\" disabled=\"disabled\"";
							$tippFullPrivacy = "".$amsg[269]."";
							$showButton = "";
						}
						else {
							$tippFullPrivacy = "".$amsg[270]."";
							$showButton = "<input class=\"button\" style=\"font-weight:bold;\" type=\"submit\" name=\"send4\" value=\"".$fmsg[55]." 4\" />";
						}

				echo" value=\"1\" /><span class=\"checkmark-02\"></span><a title=\"".$amsg[340]."\" class=\"cursor-help2 oldie\" style=\"position:relative;top:3px;\" href=\"".$url."admin/admin.php?action=help&#38;".session_name()."=".session_id()."#anchor-Cookie\"><img src=\"".$url."images/help.png\" width=\"14\" height=\"14\" alt=\"".$amsg[340]."\" /></a></p></label></div>
					<div class=\"break\"></div>";
				echo"
					<div class=\"size-14 text-justify\" style=\"width:90%;margin:0 auto;\">
						<p class=\"zentriert\"><strong>".$amsg[271]."</strong></p>
						<p>".$tippFullPrivacy."</p>
						<ul>
							<li style=\"margin:8px -10px;\">".$amsg[272].",</li>
							<li style=\"margin:8px -10px;\">".$amsg[273].",</li>
							<li style=\"margin:8px -10px;\">".$amsg[292].",</li>
							<li style=\"margin:8px -10px;\">".$amsg[274].",</li>
							<li style=\"margin:8px -10px;\">".$amsg[277].",</li>
							<li style=\"margin:8px -10px;\">".$amsg[276].",</li>
							<li style=\"margin:8px -10px;\">".$amsg[275].".</li>
						</ul>
						<p>".$amsg[280]."</p>
						<p><strong>".$amsg[278]."</strong></p>
					</div>";
				echo"
					<p class=\"aligncenter\"><br /><br />".$showButton."</p>
					</fieldset>
				</form>";
			echo"
				<fieldset style=\"background-color:#fafafa;margin-top:12px;\">
				<legend><strong class=\"size-14\">5. ".$amsg[289]."</strong></legend>";
				echo"
					<br />
					<p class=\"text-justify size-14 marg-side20\" style=\"line-height:1.5em;\">".$amsg[290]."</p>
					<br />
				</fieldset>
			</div>
			<br />";
		echo"
			<script>
				function input_activate(){if(document.options2.entry_length_limit.checked == true){document.options2.entry_length_maximum.disabled=false;document.options2.entry_length_minimum.disabled=false;}else{document.options2.entry_length_maximum.disabled=true;document.options2.entry_length_minimum.disabled=true;}}
				function input_activate_02(){if(document.options2.no_spam_links.checked == true){document.options2.max_links.disabled = false;}else{document.options2.max_links.disabled = true;}}
				function input_activate_03(){if(document.options3.bbcode.checked == true){document.options3.images_in_entries.disabled = false;}else{document.options3.images_in_entries.disabled = true;}}
				function input_activate_04(){if(document.options3.check_email.checked == true){document.options3.check_free.disabled = false;}else{document.options3.check_free.disabled = true;}}
				function input_activate_05(){if(document.options.button_link.checked == true){document.options3.quote_func.disabled = false;document.options.link_entry.disabled = false;}else{document.options3.quote_func.disabled = true;document.options.link_entry.disabled = true;}}
				function input_activate_09(){if(document.options.button_link.checked == true){document.options3.quote_func.disabled = true;document.options.link_entry.disabled = true;}else{document.options3.quote_func.disabled = false;document.options.link_entry.disabled = false;}}
				function input_activate_06(){if(document.options3.rating.checked == true){document.options3.rating_text.disabled = false;}else{document.options3.rating_text.disabled = true;}}
				function input_activate_07(){if(document.options3.rating.checked == true){document.options3.rating_text.disabled = true;}else{document.options3.rating_text.disabled = false;}}
				function input_activate_08(){if(document.options3.check_email.checked == true){document.options3.check_free.disabled = true;}else{document.options3.check_free.disabled = false;}}
				function input_activate_10(){if(document.options3.check_subject.checked == true){document.options3.title_subject.disabled = true;}else{document.options3.title_subject.disabled = false;}}
				function input_activate_11(){if(document.options.privacy_hint.checked == true){document.options.privacy_url.disabled = false;}else{document.options.privacy_url.disabled = true;}}
				function input_activate_12(){if(document.options.statistic.checked == true){document.options.statistic_ban.disabled = false;}else{document.options.statistic_ban.disabled = true;}}
				function input_activate_13(){if(document.options3.smilies.checked == true){document.options3.count_smilies.disabled = false;}else{document.options3.count_smilies.disabled = true;}}
				function input_privacy(){var privacyhint='<img class=\"img-ok marg-le10\" src=\"../images/ausruf.png\" width=\"14\" height=\"14\" alt=\"Check!\" title=\"Check the entry!\" />';if(document.options.privacy_hint.checked==true && document.options.privacy_url.value==''){document.getElementById('warningDSGVO').innerHTML=privacyhint;data.classList.add(\"no-insert\");}else{document.getElementById('warningDSGVO').innerHTML='';data.classList.remove(\"no-insert\");}}
				function input_privacy_02(){if(document.options.privacy_hint.checked==true && document.options.privacy_url.onfocus){document.getElementById('warningDSGVO').innerHTML='';}}
				function input_privacy_03(){var privacyhint='<img class=\"img-ok marg-le10\" src=\"../images/ausruf.png\" width=\"14\" height=\"14\" alt=\"Check!\" title=\"Check the entry!\" />';if(document.options.privacy_hint.checked==true && document.options.privacy_url.value==''){document.getElementById('warningDSGVO').innerHTML=privacyhint;data.classList.add(\"no-insert\");}else{data.classList.remove(\"no-insert\");}}
				function input_privacy_04(){var privacyhint='<img class=\"img-ok marg-le10\" src=\"../images/ausruf.png\" width=\"14\" height=\"14\" alt=\"Check!\" title=\"".$amsg[199]."\" />';if(document.options3.check_town.value==2){document.getElementById('warningTown').innerHTML=privacyhint;}else{document.getElementById('warningTown').innerHTML='';}}
				function input_privacy_05(){var privacyhint='<img class=\"img-ok marg-le10\" src=\"../images/ausruf.png\" width=\"14\" height=\"14\" alt=\"Check!\" title=\"".$amsg[199]."\" />';if(document.options3.check_country.value==2){document.getElementById('warningCountry').innerHTML=privacyhint;}else{document.getElementById('warningCountry').innerHTML='';}}
			</script>";
	}

?>