<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/

	if (!isset($_SESSION['sid']) && !isset($_SESSION['modsid'])) {
		header("Location: admin.php?action=login");
		die();
	}
	else {
		$separated_red = $separated_gray = $count_rating = $average_rating = $show_rating_infos = $schema_info = $no_entries_ips = $no_pics_ips = $info_del_ips = $selected_entry = $myBackupDate = $myBackupTime = "";

		$_GET['change'] = isset($_GET['change']) ? $gbook->real_escape_string($_GET['change']) : "";
		$_GET['refresh'] = isset($_GET['refresh']) ? $gbook->real_escape_string($_GET['refresh']) : "";

		// Delete Ips from old guestbook versions
		$check_entries_ip = $gbook->query("SELECT `ip` FROM `".$table."_entries` WHERE `ip` != ''");
		$entries_ip = $check_entries_ip->num_rows;

		$check_pic_ip = $gbook->query("SELECT `ip` FROM `".$table."_pictures` WHERE `ip` != ''");
		$pic_ip = $check_pic_ip->num_rows;

		($entries_ip > 0 OR $pic_ip > 0) ? $delete_old_ips = true : $delete_old_ips = false;

		$_POST['delete_old_ips'] = isset($_POST['delete_old_ips']) ? $_POST['delete_old_ips'] : 0;

		if (isset($_POST['send_del_ips']) && $_POST['delete_old_ips'] == 1) {
			$no_entries_ips = $gbook->query("UPDATE `".$table."_entries` SET `ip` = NULL");
			$no_pics_ips = $gbook->query("UPDATE `".$table."_pictures` SET `ip` = NULL");

			if ($no_entries_ips && $no_pics_ips) {
				echo "<meta http-equiv=\"Refresh\" content=\"3; url=admin.php?action=guestbook&#38;".session_name()."=".session_id()."\" />";
				$info_del_ips = "<p class=\"zentriert green size-14\"><strong>- ".$amsg[141]."</strong><img src=\"".$url."images/wait.gif\" class=\"img-ok marg-le15\" alt=\"\" width=\"16\" height=\"16\" /></p>";
			}
			else {
				$info_del_ips = "<p class=\"error\">".$emsg[11]."</p>";
			}
		}

		// Delete activation/deactivation codes for guestbook entries older than 30 days.
		if (CLEAN_CODE) {
			$code_del = time()-(86400*30);
			$gbook->query("UPDATE `".$table."_entries` SET `activation_code` = NULL  WHERE (`check_time` <= '$code_del' OR `check_time` = '')");
		}

		$sql_ip_sperre 	= $gbook->query("SELECT `ip` FROM `".$table."_forbidden_ip`");
		$count_ip_sperre = $sql_ip_sperre->num_rows;

		($count_ip_sperre < 1) ? ($ok = "ok") : ($ok = "not_ok");

		$check_schema = (empty($_SERVER['HTTPS'])) ? 'http' : 'https';
		$check_url = explode("://", $url);

		if ($check_schema !== $check_url[0]) {
			$schema_info = "<strong class=\"red size-14\">".$emsg[84]."<img class=\"marg-le10\" src=\"../images/ausruf.png\" width=\"14\" height=\"14\" alt=\"\" /></strong><br />(http &harr; https) - ".$emsg[85]." <a href=\"admin.php?action=help&#38;".session_name()."=".session_id()."#anchor-save\">".$amsg[82]."</a><br /><br />";
		}

		$sql_properties = $gbook->query("SELECT `bbcode`, `deactivate_html`, `check_homepage`, `entries_per_site`, `links_in_sitefunction`, `guestbook_status`, `images_in_entries`, `max_word_length`, `release_entries`, `smilies`, `quote_func`, `check_town`, `check_country`, `rating`, `rating_text`, `privacy_hint` FROM `".$table."_properties`");
		$properties = $sql_properties->fetch_assoc();

		$properties['rating_text'] = $properties['rating_text'] === NULL ? "" : $properties['rating_text'];

		($properties['guestbook_status'] == 1) ? ($guestbook_status = "ok") : ($guestbook_status = "not_ok");
		(empty($properties['rating_text'])) ? ($rating_entry = $fmsg[352]) : ($rating_entry = $properties['rating_text']);

		if ($properties['rating'] == 2) {
			$sql_count_ratings = $gbook->query("SELECT `id` FROM `".$table."_entries` WHERE `stars` != 0 AND `status` != 0");
			$sum_ratings = $sql_count_ratings->num_rows;

			$sql_show_rating = $gbook->query("SELECT `count_rating`, `average_rating` FROM `".$table."_rating`");
			list($count_rating, $average_rating) = $sql_show_rating->fetch_row();

			$show_rating_infos  = "<p class=\"aligncenter\">";
			$show_rating_infos .= "".$rating_entry." <span class=\"nowrap\">".$fmsg[358]." <strong>".$average_rating."</strong> ".$fmsg[359]." <strong>".$count_rating."</strong> ".$fmsg[360]."";

			if ($sum_ratings != $count_rating) {
				$show_rating_infos .= "<a class=\"marg-le15\" title=\"Refresh\" href=\"".$url."admin/admin.php?action=guestbook&#38;refresh=rating&#38;".session_name()."=".session_id()."\"><img class=\"img-ok\" src=\"../images/refresh.png\" width=\"16\" height=\"16\" alt=\"Refresh\" /></a>";
			}

			$show_rating_infos .= "</span></p>";

			if ($_GET['refresh'] == "rating") {
				$sql_count_stars = $gbook->query("SELECT SUM(`stars`) AS `stars` FROM `".$table."_entries` WHERE `status` != 0");
				$count_stars = $sql_count_stars->fetch_array();
				$sum_stars = $count_stars['stars'];

				($sum_ratings > 0 && $sum_stars > 0) ? $average_stars = $sum_stars / $sum_ratings : $average_stars = 0;

				$gbook->query("UPDATE `".$table."_rating` SET `count_rating` = '".$sum_ratings."', `average_rating` = '".$average_stars."'");

				echo "<meta http-equiv=\"Refresh\" content=\"0; url=admin.php?action=guestbook&#38;".session_name()."=".session_id()."\" />";
			}
		}

		$selected_entry = "<br />";		
		isset($_POST['send']) && !isset($_POST['entry']) ? $selected_entry = "<p class=\"error\">&nbsp;>>&nbsp;".$emsg[16]."&nbsp;<<&nbsp;</p>" : "<br />";

		if (isset($_POST['send']) AND isset($_POST['action']) AND isset($_POST['entry'])) {
			$y = count($_POST['entry']);

			if ($_POST['action'] == "delete" && !ModLogin) {
				for ($x=0;$x<$y;$x++) {
					$entry_id = $_POST['entry'][$x];
					$gbook->query("DELETE FROM `".$table."_entries` WHERE `id`='".$entry_id."'");
				}
			}

			if ($_POST['action'] == "activate_entry") {
				for ($x=0;$x<$y;$x++) {
					$entry_id = $_POST['entry'][$x];
					$gbook->query("UPDATE `".$table."_entries` SET `status`='2' WHERE `id`='".$entry_id."'");
				}
			}

			if ($_POST['action'] == "activate_text") {
				for ($x=0;$x<$y;$x++) {
					$entry_id = $_POST['entry'][$x];
					$gbook->query("UPDATE `".$table."_entries` SET `status`='1' WHERE `id`='".$entry_id."'");
				}
			}

			if ($_POST['action'] == "deactivate") {
				for ($x=0;$x<$y;$x++) {
					$entry_id = $_POST['entry'][$x];
					$gbook->query("UPDATE `".$table."_entries` SET `status`='0' WHERE `id`='".$entry_id."'");
				}
			}

			if ($properties['rating'] == 2) {
				$count_new_ratings = $gbook->query("SELECT `id` FROM `".$table."_entries` WHERE `stars` != 0 AND `status` != 0");
				$new_sum_ratings = $count_new_ratings->num_rows;

				$count_new_stars = $gbook->query("SELECT SUM(`stars`) AS `stars` FROM `".$table."_entries` WHERE `status` != 0");
				$new_stars = $count_new_stars->fetch_array();
				$new_sum_stars = $new_stars['stars'];

				($new_sum_ratings > 0 && $new_sum_stars > 0) ? $new_average_stars = $new_sum_stars / $new_sum_ratings : $new_average_stars = 0;

				$gbook->query("UPDATE `".$table."_rating` SET `count_rating` = '".$new_sum_ratings."', `average_rating` = '".$new_average_stars."'");

				echo "<meta http-equiv=\"Refresh\" content=\"0; url=admin.php?action=guestbook&#38;".session_name()."=".session_id()."\" />";
			}
		}

		if($_GET['change'] == "status" || $_GET['change'] == "photostatus") {
			$status_query = $gbook->query("SELECT `status` FROM `".$table."_entries` WHERE `id` = '".$_REQUEST['id']."'");
			list($entry_status) = $status_query->fetch_row();

			$page = isset($_GET['page']) ? intval($_GET['page']) : 1;

			if($_GET['change'] == "photostatus") {
				if ($entry_status < 2) {
					$update_status = $gbook->query("UPDATE `".$table."_entries` SET `status` = '2' WHERE `id` = '".$_REQUEST['id']."'");
				}
				elseif ($entry_status == 2) {
					$update_status = $gbook->query("UPDATE `".$table."_entries` SET `status` = '1' WHERE `id` = '".$_REQUEST['id']."'");
				}
			}

			if($_GET['change'] == "status") {
				if($entry_status == 0) {
					$update_status = $gbook->query("UPDATE `".$table."_entries` SET `status` = '1' WHERE `id` = '".$_REQUEST['id']."'");
				}
				elseif($entry_status > 0) {
					$update_status = $gbook->query("UPDATE `".$table."_entries` SET `status` = '0' WHERE `id` = '".$_REQUEST['id']."'");
				}
			}

			if ($update_status) {
				if ($properties['rating'] == 2) {
					$count_new_ratings = $gbook->query("SELECT `id` FROM `".$table."_entries` WHERE `stars` != 0 AND `status` != 0");
					$new_sum_ratings = $count_new_ratings->num_rows;

					$count_new_stars = $gbook->query("SELECT SUM(`stars`) AS `stars` FROM `".$table."_entries` WHERE `status` != 0");
					$new_stars = $count_new_stars->fetch_array();
					$new_sum_stars = $new_stars['stars'];

					($new_sum_ratings > 0 && $new_sum_stars > 0) ? $new_average_stars = $new_sum_stars / $new_sum_ratings : $new_average_stars = 0;

					$gbook->query("UPDATE `".$table."_rating` SET `count_rating` = '".$new_sum_ratings."', `average_rating` = '".$new_average_stars."'");
				}
				echo "<meta http-equiv=\"Refresh\" content=\"0; url=admin.php?action=guestbook&#38;page=".$page."&#38;".session_name()."=".session_id()."#anchor-entryID-".$_REQUEST['id']."\" />";
			}
		}

		$sql_entries_gesperrt 	= $gbook->query("SELECT `id` FROM `".$table."_entries` WHERE `status` = '0'");
		$entries_gesperrt 		= $sql_entries_gesperrt->num_rows;

		($entries_gesperrt < 1) ? ($gesperrt = "ok") : ($gesperrt = "not_ok");

		$sql_count_entries = $gbook->query("SELECT `id` FROM `".$table."_entries`");
		$count_entries = $sql_count_entries->num_rows;

		if (isset($_GET['page'])) {
			(!is_numeric($_GET['page']) OR empty($_GET['page'])) ? $page = 1 : $page = $_GET['page'];
		}
		else {
			$page = 1;
		}

		$page = $gbook->real_escape_string($page);
		$pages_total        = ceil($count_entries/$properties['entries_per_site']) ;
		$page_start         = floor($page - $properties['links_in_sitefunction']/2) ;
		$page_start         = $page_start <= 0 ? 1 : $page_start ;
		$page_end           = ($page_start + $properties['links_in_sitefunction']-1) ;
		$page_end           = $page_end >= $pages_total ?  $pages_total : $page_end ;
		$page_max           = $page*$properties['entries_per_site'];
		$max_minus_per_page = $page_max-$properties['entries_per_site'];
		$page_entry_start   = $count_entries-$max_minus_per_page+1;

		echo "
		<div class=\"content-02\">
		<p class=\"aligncenter\">".$schema_info."
			<strong>".$fmsg[173]."?</strong><img class=\"img-ok marg-le15\" src=\"../images/".$guestbook_status.".png\" width=\"14\" height=\"14\" alt=\"\" />
		</p>";

		if ($count_entries < 1)	{
			echo"
				<p>&nbsp;</p>
				<hr style=\"width:80%\" />
				<p>&nbsp;</p>
				<p class=\"aligncenter\"><br /><strong>".$amsg[380]."</strong></p>";
		}
		else {
			echo"
			<p class=\"aligncenter\">
				<strong>".$amsg[39]."<img class=\"img-ok marg-le15\" src=\"../images/".$ok.".png\" width=\"14\" height=\"14\" alt=\"\" />";

					if ($count_ip_sperre > 0 && !ModLogin) {
						echo"<a class=\"marg-le10\" title=\"".$amsg[40]."\" href=\"".$url."admin/admin.php?action=spamwords&#38;show=ip_forbidden&#38;".session_name()."=".session_id()."\">[ ".$amsg[43]." ".$count_ip_sperre." ]</a>";
					}

			echo "</strong>
			</p>
			<p class=\"aligncenter\">
				<strong>".$amsg[42]."<img class=\"img-ok marg-le15\" src=\"../images/".$gesperrt.".png\" width=\"14\" height=\"14\" alt=\"\" />";

					if ($entries_gesperrt > 0) {
						echo"<span class=\"marg-le10\">[ ".$amsg[43]." ".$entries_gesperrt." ]</span>";
					}

			echo "</strong>
			</p>";

			if (!$clean_backup) {
				echo"
					<p class=\"aligncenter\">
						<strong>";

							if (empty($last_backup_time)) {
								echo"<span class=\"red\">".$amsg[87]."</span>";
							}
							else {
								$dateFormat !== "us" ? $myBackupDate = date("d.m.Y", $last_backup_time) : $myBackupDate = date("m-d-Y", $last_backup_time);
								$dateFormat !== "us" ? $myBackupTime = date("H:i", $last_backup_time) : $myBackupTime = date("h:i A", $last_backup_time);

								echo"".$amsg[44]." ".$myBackupDate." || ".$myBackupTime." $new_backup";
							}

						echo"</strong>
					</p>";
			}

			if ($delete_old_ips && !ModLogin) {
				echo "
					<form action=\"".$url."admin/admin.php?action=guestbook&#38;".session_name()."=".session_id()."\" method=\"post\">
						<p class=\"aligncenter\"><strong>".$amsg[145]."</strong> <label class=\"container\" style=\"display:inline-block;top:-15px;margin-left:8px;\"><input type=\"checkbox\" class=\"marg-le15\" name=\"delete_old_ips\" value=\"1\" /><span class=\"checkmark-02\"></span></label><input type=\"submit\" class=\"button marg-le15\" name=\"send_del_ips\" value=\"OK\" /></p>
					</form>".$info_del_ips."";
			}

			echo"
			<hr style=\"width:80%\" />
			<div class=\"aligncenter\">
			<form action=\"".$url."admin/admin.php?action=guestbook&#38;page=".$page."&#38;".session_name()."=".session_id()."\" method=\"post\">
			<p class=\"lh-35\">".$fmsg[104].":<label class=\"container\" style=\"display:inline-block;top:-15px;margin-left:6px;\" title=\"".$fmsg[104]."\"><input type=\"checkbox\" class=\"img-ok checkboxloeschen marg-le10\" name=\"all\" value=\"1\" onclick=\"select_all(this.checked,this.form)\" /><span class=\"checkmark-02\"></span></label>
			<span class=\"nowrap\"><select class=\"large-panel-le25 select-style\" name=\"action\">
				<option value=\"deactivate\">".$fmsg[326]."</option>
				<option value=\"activate_entry\">".$fmsg[323]."</option>
				<option value=\"activate_text\">".$fmsg[324]."</option>";

				if (!ModLogin) {
					echo "<option value=\"delete\">".$fmsg[325]."</option>";
				}

			echo"
			</select>
			<input type=\"submit\" class=\"button marg-le15\" name=\"send\" value=\"OK\" /></span></p>".$selected_entry."
			<span class=\"size-13 lh-35\">";

			if ($page > 1) {
				$page_minus = $page-1;
				echo "<a class=\"arrow-left\" href=\"".$url."admin/admin.php?action=guestbook&#38;page=".$page_minus."&#38;".session_name()."=".session_id()."\"><img class=\"img-ok\" src=\"".$url."images/left.png\" height=\"14\" width=\"12\" title=\"".$fmsg[4]."\" alt=\"".$fmsg[4]."\" /></a>";
			}

			if ($page_start > 1) {
				echo "<a class=\"navi-page\" href=\"".$url."admin/admin.php?action=guestbook&#38;page=1&#38;".session_name()."=".session_id()."\">1</a>... ";
			}

			for ($i = $page_start; $i <= $page_end ;$i++) {
				if ($i == $page) {
					echo "<strong class=\"this-page\"> [".$i."] </strong>";
				}
				else {
					echo "<a class=\"navi-page\" href=\"".$url."admin/admin.php?action=guestbook&#38;page=".$i."&#38;".session_name()."=".session_id()."\"> ".$i." </a>";
				}
			}

			if ($page_end < $pages_total) {
				echo " ...<a class=\"navi-page\" href=\"".$url."admin/admin.php?action=guestbook&#38;page=".$pages_total."&#38;".session_name()."=".session_id()."\">".$pages_total."</a>";
			}

			if ($page < $pages_total) {
				$page_plus = $page+1;
				echo "<a class=\"arrow-right\" href=\"".$url."admin/admin.php?action=guestbook&#38;page=".$page_plus."&#38;".session_name()."=".session_id()."\"><img class=\"img-ok\" src=\"".$url."images/right.png\" height=\"14\" width=\"12\" title=\"".$fmsg[14]."\" alt=\"".$fmsg[14]."\" /></a>";
			}

			echo"</span>
				<br />".$show_rating_infos."<br />
				<div id=\"lightbox_hp\" class=\"gb-lightbox\" style=\"display:none\">
					<div class=\"gb-lightbox-inner\" style=\"max-width:530px;\">
						<span class=\"aligncenter\"><strong>".$amsg[206]."</strong></span><br />".$amsg[207]."
						<div class=\"gblb-close\"><img class=\"close-flag\" src=\"".$url."images/not_ok.png\" alt=\"Close\" width=\"14\" height=\"14\" onclick=\"document.getElementById('lightbox_hp').style.display='none';\" /></div>
					</div>
				</div>
				";

			$sql_entries = $gbook->prepare("SELECT `comment`, `date`, `email`, `homepage`, `icq`, `id`, `status`, `name`, `text`, `time`, `origin`, `marker`, `stars`, `check_time` FROM `".$table."_entries` ORDER BY `id` DESC LIMIT ".(($page-1)*$properties['entries_per_site'] ).",".$properties['entries_per_site']."");
			$sql_entries->execute();
			$sql_entries->store_result();
			$sql_entries->bind_result($comment, $date, $email, $homepage, $consent, $id, $status, $name, $text, $time, $origin, $marker, $stars, $usTime);

			while ($sql_entries->fetch()) {
				$gb_rating = $gb_rating01 = $gb_rating02 = "";
				
				$page_entry_start = $page_entry_start-1;
				$number = $page_entry_start;
				
				$name = $name === NULL ? "" : $name;
				$origin = $origin === NULL ? "" : $origin;
				$email = $email === NULL ? "" : $email;
				$homepage = $homepage === NULL ? "" : $homepage;
				$comment = $comment === NULL ? "" : $comment;

				$name = stripslashes(htmlentities(strip_tags($name), ENT_QUOTES, "UTF-8"));

				(($properties['check_town'] == 1) && ($properties['check_country'] == 1)) ? $origin = "" : "";
				$origin = stripslashes(htmlentities(strip_tags($origin), ENT_QUOTES, "UTF-8"));
				$origin	= shortWords($origin, $short_town);

				$email = stripslashes(htmlspecialchars(strip_tags($email), ENT_QUOTES));

				$homepage = stripslashes(htmlentities(strip_tags($homepage), ENT_QUOTES, "UTF-8"));

				$stars = ($properties['rating']) ? $stars : 0;
				$stars = stripslashes(htmlentities(strip_tags($stars), ENT_QUOTES, "UTF-8"));

				$consent_dsgvo = ($properties['privacy_hint'] > 1 && $consent == 1) ? '|<span class="marg-side20 text-shadow size-12">'.$amsg[264].'<img class="img-ok marg-le10" src="../images/ok.png" width="14" height="14" alt="OK" /></span>' : '';

				$text = shortWords($text, $properties['max_word_length']);

				if ($properties['deactivate_html']) {
					$text = htmlentities(strip_tags($text), ENT_QUOTES, "UTF-8");
				}

				$text = nl2br($text);
				$text = stripslashes($text);
				$text = quote($text);

				if ($properties['deactivate_html']) {
					$comment = htmlentities(strip_tags($comment), ENT_QUOTES, "UTF-8");
				}

				$comment = nl2br($comment);
				$comment = stripslashes($comment);

				if ($properties['smilies']) {
					$comment = smilies($comment);
					$text = smilies($text);
				}

				if ($properties['bbcode']) {
					$comment = bbcode($comment);
					$text = bbcode($text);

					if (($properties['images_in_entries'] && $status < 2) OR !$properties['images_in_entries']) {
						$imgLocked = "locked";
						$imgBg = "bg-transp";
					}
					else {
						$imgLocked = $imgBg = "";
					}

					$sql_picture = $gbook->prepare("SELECT `pic_name`, `width`, `height`, `title` FROM `".$table."_pictures`");
					$sql_picture->execute();
					$sql_picture->bind_result($pic_adname, $pic_adwidth, $pic_adheight, $pic_adtitle);

					while ($sql_picture->fetch()) {
						$maxpicwidth = '490';
						$newwidth = $pic_adwidth;
						$newheight = $pic_adheight;
						$pic_adtitle = $pic_adtitle === NULL ? "" : htmlspecialchars($pic_adtitle);

						if ($pic_adwidth > $maxpicwidth){
							$prozent = $maxpicwidth/$pic_adwidth;
							$newwidth = floor($pic_adwidth*$prozent);
							$newheight = floor($pic_adheight*$prozent);
						}

						$text = str_replace('[img]'.$pic_adname.'[/img]', '<div class="title-container '.$imgBg.'" style="max-width:'.$newwidth.'px;"><span class="'.$imgLocked.'"><img class="centered '.$imgLocked.'" src="'.$url.'img_guest/'.$pic_adname.'" alt="'.$pic_adtitle.'" width="'.$newwidth.'" height="'.$newheight.'" /></span><div class="pic-overlay"><span class="pic-title">'.$pic_adtitle.'</span></div></div>', $text);
						$comment = str_replace('[img]'.$pic_adname.'[/img]', '<div class="title-container" style="max-width:'.$newwidth.'px;"><img class="centered" src="'.$url.'img_guest/'.$pic_adname.'" alt="'.$pic_adtitle.'" width="'.$newwidth.'" height="'.$newheight.'" /><div class="pic-overlay"><span class="pic-title">'.$pic_adtitle.'</span></div></div>', $comment);
					}

					$sql_picture->close();
				}
				else {
					$text = preg_replace("/\[img\](.*?)\[\/img\]/si", "", $text);
					$text = preg_replace("/\[b\](.*?)\[\/b\]/si", "<strong>\\1</strong>", $text);
					$text = preg_replace("/\[.*?\]/si", "", $text);
					$comment = preg_replace("/\[.*?\]/si", "", $comment);
				}

				if ($properties['rating'] && $stars > 0) {
					$gbrat = 1;
					$gb_rating01 = array();

					while ($gbrat <= $stars) {
						$gb_rating01[] = "<img src=\"".$url."images/icons/stars/star_red.png\" width=\"16\" height=\"16\" alt=\"\" />";
						$gbrat ++;
					}

					$gbrat02 = 5;
					$gb_rating02 = array();

					while ($gbrat02 > $stars) {
						$gb_rating02[] = "<img src=\"".$url."images/icons/stars/star.png\" width=\"16\" height=\"16\" alt=\"\" />";
						$gbrat02 --;
					}

					$separated_red = implode("", $gb_rating01);

					($gb_rating02 != "" && $stars < 5) ? $separated_gray = implode("", $gb_rating02) : $separated_gray = "";

					$gb_rating = "<div class=\"gb-rating\" title=\"".$rating_entry." ".$stars." ".$fmsg[357]."\">".$separated_red."".$separated_gray."</div>";
				}

				if ($dateFormat === "us") {
					!empty($usTime) ? $time = date("h:i A", $usTime) : (!empty($time) ? "" : $time = "(n.a.)");
					!empty($usTime) ? $date = date("m-d-Y", $usTime) : (!empty($date) ? "" : $date = "(n.a.)");
				}
				elseif ($dateFormat === "sv") {
					!empty($usTime) ? $time = date("H:i", $usTime) : (!empty($time) ? "" : $time = "(n.a.)");
					!empty($usTime) ? $date = date("Y-m-d", $usTime) : (!empty($date) ? "" : $date = "(n.a.)");
				}
				else {
					!empty($usTime) ? $time = date("H:i", $usTime) : (!empty($time) ? "" : $time = "(n.a.)");
					!empty($usTime) ? $date = date("d.m.Y", $usTime) : (!empty($date) ? "" : $date = "(n.a.)");
				}

				if ($marker != 0 && !empty($email)) {
					$mark = $mark_info = "";

					if ($properties['quote_func']) {
						($marker == 1) ? $mark_info = "".$amsg[165]." - ".$amsg[167]."<br />".$amsg[166]." - ".$amsg[167]."" : "";
						($marker == 2) ? $mark_info = "".$amsg[165]." - ".$amsg[168]."<br />".$amsg[166]." - ".$amsg[167]."" : "";
						($marker == 3) ? $mark_info = "".$amsg[165]." - ".$amsg[167]."<br />".$amsg[166]." - ".$amsg[168]."" : "";
						$mark = " <sup class=\"tooltip tooltiplarge cursor-help pos-left\">[e]<span class=\"tooltiptext tooltiptextlarge\" style=\"font-size:12px;background-color:#0000ff;\">".$mark_info."</span></sup>";
					}
					else {
						($marker == 1 || $marker == 3) ? $mark_info = "".$amsg[165]." - ".$amsg[167]."" : "";
						$mark = " <sup class=\"tooltip tooltiplarge cursor-help pos-left\">[e]<span class=\"tooltiptext tooltiptextlarge\" style=\"font-size:12px;background-color:#0000ff;\">".$mark_info."</span></sup>";

						($marker == 2) ? $mark = "" : "";
					}
				}
				else {
					$mark = $mark_info = "";
					$markClass = "tooltipsmall";
					$markTextClass = "tooltiptextsmall";
				}

				$status == 0 ? $entryLock = " entry-locked" : $entryLock = "";

				echo"<span class=\"sticky-anchor\" id=\"anchor-entryID-".$id."\"></span>
				<table class=\"main-table".$entryLock."\">
				<tr class=\"headpost bg-gray\">
				<td class=\"headpad beitragnr text-left entbl\" style=\"width:43%;\"><strong>&nbsp;".$name."</strong>";

				if (!empty($origin)) {
					echo "<br />&nbsp;".$origin."";
				}

				echo "</td>
				<td class=\"headpad zentriert entbl\">";

				if (empty($email)) {
					echo "";
				}
				else {
					echo "<a href=\"mailto:".$email."\"><img class=\"ico\" src=\"".$url."images/icons/email/emailnew.gif\" alt=\"".$email."\" title=\"".$email."\" /></a>";
				}

				if (empty($homepage) OR $homepage == "http://") {
					echo "";
				}
				else {
					echo "&nbsp;<a href=\"javascript:{}\" onclick=\"document.getElementById('lightbox_hp').style.display='inline';return false;\"><img class=\"ico\" src=\"".$url."/images/icons/homepage/homepage.gif\" alt=\"".$homepage."\" title=\"".$homepage."\" /></a>";
				}

				echo "</td>
				<td class=\"headpad beitragnr text-right entbl\" style=\"width:32%;\"><strong>".$amsg[84]." # ".$number."</strong><br />".$date." | ".$time."</td>
				<td class=\"text-center\" style=\"width:23px;\"><label class=\"container\" style=\"padding-left:0;\"><input class=\"checkboxloeschen\" type=\"checkbox\" name=\"entry[]\" value=\"".$id."\" /><span class=\"checkmark-sm\"></span></label></td>
				</tr>";

				echo "
				<tr class=\"bg-white text-left entbl\">
				<td colspan=\"4\" class=\"headpad tb-padBot15\">
					".$gb_rating."";

				echo "
					".$text."";

				if (!empty($comment)) {
					echo "<br />
						<table class=\"comment-table tableCenter tb-pad5\">
						<tr>
						<td class=\"bg-gray2\">
						<p class=\"heading\">".$fmsg[106].":</p>
						".$comment."
						</td>
						</tr>
						</table>";
				}

				echo "</td>
				</tr>";
				echo "
				<tr class=\"text-left\">
				<td colspan=\"4\" class=\"pad-top-bottom main-bottom\">
				";

					if (!ModLogin) {
						echo"<a class=\"marg-side20 tooltip tooltipsmall\" style=\"text-decoration:none;\" href=\"".$url."admin/admin.php?action=edit&#38;id=".$id."&#38;".session_name()."=".session_id()."\"><img class=\"img-ok\" src=\"../images/edit.png\" width=\"14\" height=\"14\" alt=\"".$fmsg[70]."\" /><span class=\"tooltiptext tooltiptextsmall\">".$amsg[33]."</span></a>|";
					}

					echo "<a class=\"marg-side20 tooltip tooltipsmall\" style=\"text-decoration:none;\" href=\"".$url."admin/admin.php?action=comment&#38;id=".$id."&#38;".session_name()."=".session_id()."\"><img class=\"img-ok\" src=\"../images/comment.png\" width=\"14\" height=\"14\" alt=\"".$fmsg[106]."\" /><span class=\"tooltiptext tooltiptextsmall\">".$amsg[327]."</span></a>".$mark."";

					if ($status == 1) {
						$text_status = '<a class="tooltip tooltipsmall nodeco" href="'.$url.'admin/admin.php?action=guestbook&#38;page='.$page.'&#38;change=status&#38;id='.$id.'#anchor-entryID-'.$id.'"><strong class="text-shadow">TEXT</strong><img class="img-ok marg-le10" src="../images/ok.png" width="14" height="14" alt="" /><span class="tooltiptext tooltiptextsmall">'.$fmsg[326].'?</span></a>';
						$photo_status = '<a class="tooltip tooltipsmall nodeco" href="'.$url.'admin/admin.php?action=guestbook&#38;page='.$page.'&#38;change=photostatus&#38;id='.$id.'#anchor-entryID-'.$id.'"><img class="img-ok picShadowSmall" src="../images/photo2.png" width="25" height="16" alt="'.$amsg[90].'" /><span class="tooltiptext tooltiptextsmall">'.$fmsg[320].'</span></a>';
					}
					elseif ($status == 2) {
						$text_status = '<a class="tooltip tooltipsmall nodeco" href="'.$url.'admin/admin.php?action=guestbook&#38;page='.$page.'&#38;change=status&#38;id='.$id.'#anchor-entryID-'.$id.'"><strong class="text-shadow">TEXT</strong><img class="img-ok marg-le10" src="../images/ok.png" width="14" height="14" alt="" /><span class="tooltiptext tooltiptextsmall">'.$fmsg[326].'?</span></a>';
						$photo_status = '<a class="tooltip tooltipsmall nodeco" href="'.$url.'admin/admin.php?action=guestbook&#38;page='.$page.'&#38;change=photostatus&#38;id='.$id.'#anchor-entryID-'.$id.'"><img class="img-ok picShadowSmall" src="../images/photo.png" width="25" height="16" alt="'.$amsg[90].'" /><img class="img-ok marg-le10 hidden" src="../images/ok.png" width="14" height="14" alt="" /><span class="tooltiptext tooltiptextsmall">'.$fmsg[344].'</span></a>';
					}
					else {
						$text_status = '<a class="tooltip tooltipsmall nodeco" href="'.$url.'admin/admin.php?action=guestbook&#38;page='.$page.'&#38;change=status&#38;id='.$id.'#anchor-entryID-'.$id.'"><strong class="text-shadow text-crossed red">TEXT</strong><img class="img-ok marg-le10" src="../images/not_ok.png" width="14" height="14" alt="" /><span class="tooltiptext tooltiptextsmall">'.$fmsg[324].'?</span></a>';
						$photo_status = '<a class="tooltip tooltipsmall nodeco" href="'.$url.'admin/admin.php?action=guestbook&#38;page='.$page.'&#38;change=photostatus&#38;id='.$id.'#anchor-entryID-'.$id.'"><img class="img-ok picShadowSmall" src="../images/photo2.png" width="25" height="16" alt="'.$amsg[90].'" /><span class="tooltiptext tooltiptextsmall">'.$fmsg[323].'?</span></a>';
					}

				echo "|<span class=\"marg-side20\">".$text_status."</span>";

					if ($properties['bbcode'] && $properties['images_in_entries']) {
						echo"|<span class=\"marg-side20\">".$photo_status."</span>";
					}

				echo "".$consent_dsgvo."";

				echo "
				</td>
				</tr>
				</table>
				<p>&nbsp;</p>";
			}

			$sql_entries->free_result();
			$sql_entries->close();

			echo"
				</form>
			</div>
			<p class=\"aligncenter size-13 lh-35\">";

			if ($page > 1) {
				$page_minus = $page-1;
				echo "<a class=\"arrow-left\" href=\"".$url."admin/admin.php?action=guestbook&#38;page=".$page_minus."&#38;".session_name()."=".session_id()."\"><img class=\"img-ok\" src=\"".$url."images/left.png\" height=\"14\" width=\"12\" title=\"".$fmsg[4]."\" alt=\"".$fmsg[4]."\" /></a>";
			}

			if ($page_start > 1) {
				echo "<a class=\"navi-page\" href=\"".$url."admin/admin.php?action=guestbook&#38;page=1&#38;".session_name()."=".session_id()."\">1</a>... ";
			}

			for ($i = $page_start; $i <= $page_end ;$i++) {
				if ($i == $page) {
					echo "<strong class=\"this-page\"> [".$i."] </strong>";
				}
				else {
					echo "<a class=\"navi-page\" href=\"".$url."admin/admin.php?action=guestbook&#38;page=".$i."&#38;".session_name()."=".session_id()."\"> ".$i." </a>";
				}
			}

			if ($page_end < $pages_total) {
				echo " ...<a class=\"navi-page\" href=\"".$url."admin/admin.php?action=guestbook&#38;page=".$pages_total."&#38;".session_name()."=".session_id()."\">".$pages_total."</a>";
			}

			if ($page < $pages_total) {
				$page_plus = $page+1;
				echo "<a class=\"arrow-right\" href=\"".$url."admin/admin.php?action=guestbook&#38;page=".$page_plus."&#38;".session_name()."=".session_id()."\"><img class=\"img-ok\" src=\"".$url."images/right.png\" height=\"14\" width=\"12\" title=\"".$fmsg[14]."\" alt=\"".$fmsg[14]."\" /></a>";
			}

			echo "</p>";
		}

		echo"
			<p>&nbsp;</p>
			</div>";
	}
?>