<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/

	if (!isset($_SESSION['sid']) && !isset($_SESSION['modsid'])) {
		header("Location: ../admin.php?action=login");
		die();
	}
	else {
		$toTop = 'javascript:scrollToTop()';

		echo'
			<style>html{scroll-behavior:smooth}</style>';
		
		echo'
			<p>This documentation is intended to help you understand the features of <span class="italic">myPHP Guestbook</span> and answer open questions. Additional explanations can also be found in the <span class="italic">ReadMe.pdf</span> attached to the download.</p>
			<hr /><hr />
			<div class="text-left">
			<span id="anchor-top"></span>
			<h1><br />Table of Contents:</h1>
			<h2><br /><a href="#anchor-Intro">I. Introduction, Disclaimer</a></h2>
			<h2><a href="#anchor-Aktuell">II. Current changes</a></h2>
			<h2><a href="#anchor-Install">III. Preparation and Installation or Update of <span class="italic">myPHP Guestbook</span></a></h2>
			<ol>
				<li><a href="#anchor-Update">Reinstallation or update from v.3.x to v.4.x</a>
				<li><a href="#anchor-Webdesign">&quot;Responsive web design&quot; and integration via &quot;iframe&quot;</a>
				<li><a href="#anchor-Ordner">Special rights of specific <span class="nowrap">folders <img class="arrow-left marg-le25" title="IMPORTANT" src="'.$url.'images/ausruf.png" height="14" width="14" alt="IMPORTANT" /></span></a>
				<li><a href="#anchor-htaccess">Using <span class="nowrap">.htaccess files <img class="arrow-left marg-le25" title="IMPORTANT" src="'.$url.'images/ausruf.png" height="14" width="14" alt="IMPORTANT" /></span></a>
				<li><a href="#anchor-Cookie">Privacy and <span class="nowrap"><span class="italic">myPHP Guestbook</span> <img class="arrow-left marg-le10Perc" title="IMPORTANT" src="'.$url.'images/ausruf.png" height="14" width="14" alt="IMPORTANT" /></span></a>
					<ol>
						<li class="sub-main"><a href="#anchor-Cookie">Cookies used by <span class="italic">myPHP Guestbook</span></a>
						<li class="sub-main"><a href="#anchor-saveIP">How user IPs are processed</a>
						<li class="sub-main"><a href="#anchor-noIp">Use of the <span class="italic">myPHP Guestbook</span> without setting cookies and/or without processing IPs.</a>
						<li class="sub-main"><a href="#anchor-morePP">Other privacy settings</a>
					</ol>
			</ol>
			<h2><a href="#anchor-Config">IV. Usage hints</a></h2>
			<ol>
				<li><a href="#anchor-Config">Config.inc.php</a>
					<ol>
						<li class="sub-main"><a href="#anchor-timezone">Time zone and Date format used by <span class="italic">myPHP Guestbook</span></a></li>
						<li class="sub-main"><a href="#anchor-save">Subsequent switch to an (un)encrypted Internet connection</a><br />(http &harr; https) <img class="arrow-left marg-le25" title="IMPORTANT" src="'.$url.'images/ausruf.png" height="14" width="14" alt="IMPORTANT" /></a></li>
					</ol>
				<li><a href="#anchor-Gaestebuch">Guestbook</a>
					<ol>
						<li><a href="#anchor-Gaestebuch">Guestbook page</a>
							<ol>
								<li class="sub-main"><a href="#anchor-Changes">Changes of font style, font color and size, backgrounds, guestbook width, icons for e-mail, homepage and stars, frame colors, etc.</a></li>
								<li class="sub-main"><a href="#anchor-ChooseLang">Language selection by user</a></li>
								<li class="sub-main"><a href="#anchor-search">Search function for user</a></li>
								<li class="sub-main"><a href="#anchor-Copy">Copyright notice</a></li>
							</ol>
						<li><a href="#anchor-Eintragsseite">Insert page</a>
							<ol>
								<li class="sub-main"><a href="#anchor-Entry">Input options</a></li>
								<li class="sub-main"><a href="#anchor-Smiley">Smileys/Emojis</a></li>
								<li class="sub-main"><a href="#anchor-BBC">BBCodes</a></li>
								<li class="sub-main"><a href="#anchor-Photo">Images in guestbook comments</a></li>
								<li class="sub-main"><a href="#anchor-Quote">Quoting of guestbook comments</a></li>
								<li class="sub-main"><a href="#anchor-Stars">Star rating function</a></li>
								<li class="sub-main"><a href="#anchor-ComInfo">Inform guest about a reply to his Post</a></li>
								<li class="sub-main"><a href="#anchor-IPBar">IP lock of the entry page</a></li>
							</ol>
					</ol>
				<li><a href="#anchor-Admin">Admin-Control-Panel</a><br />
				<span class="sub-main"><a style="margin-left:50px;" href="#anchor-new-pw">3.0.1. Forgotten Password function</a></span><br />
				<span class="sub-main"><a style="margin-left:50px;" href="#anchor-sec-auth">3.0.2. Two-factor authentication</a></span><br />
				<span class="sub-main"><a style="margin-left:50px;" href="#anchor-hijacking">3.0.3. "Session Hijacking"</a></span><br />
				<span class="sub-main"><a style="margin-left:50px;" href="#anchor-Noentry">3.0.4. Automatic login lock</a></span>
					<ol>
						<li><a href="#anchor-Gaestebucheintraege">Guestbook entries</a>
							<ol>
								<li class="sub-main"><a href="#anchor-Edit">Manage, edit, comment on Posts</a></li>
								<li class="sub-main"><a href="#anchor-Grafik">Upload and edit uploaded graphic files</a></li>
								<li class="sub-main"><a href="#anchor-Blog">Admin Blog</a></li>
								<li class="sub-main"><a href="#anchor-Front">Open frontend</a></li>
							</ol>
						<li><a href="#anchor-Einstellungen">Properties</a>
							<ol>
								<li class="sub-main"><a href="#anchor-AdminEdit">Admin- and Login data</a><br />esp: Moderators => Admin with restricted rights</li>
								<li class="sub-main"><a href="#anchor-Konfig">General configuration</a><br />
									<ol type="a">
										<li><a href="#anchor-LinkButton">Link to the entry page (text, button, remove link)</a></span></li>
										<li><a href="#anchor-ChooseLang">Individual language selection by the user</a></span></li>
										<li><a href="#anchor-privacy">Set link to a privacy policy</a></span></li>
										<li><a href="#anchor-search">Search function for the user</a></span></li>
										<li><a href="#anchor-permaLi">Activate Permalinks</a></span></li>
									</ol>
								<li class="sub-main"><a href="#anchor-Upload">Configuration file uploads</a></li>
								<li class="sub-main"><a href="#anchor-Thankyou">E-mail settings and individual &quot;Thank-you e-mail&quot; to the guest</a></li>
								<li class="sub-main"><a href="#anchor-MoreKonfig">Further configuration options</a> <img class="arrow-left marg-le25" title="IMPORTANT" src="'.$url.'images/ausruf.png" height="14" width="14" alt="IMPORTANT" /></li>
							</ol>
						<li><a href="#anchor-Template">Template</a>
							<ol>
								<li class="sub-main"><a href="#anchor-StandTempl">Standard Template</a></li>
								<li class="sub-main"><a href="#anchor-EditTempl">Edit Template<br />(incl. font, font size, text colors, backgrounds, width etc.)</a></li>
								<li class="sub-main"><a href="#anchor-MakeTempl">Create Template</a></li>
								<li class="sub-main"><a href="#anchor-DelTempl">Delete Template</a></li>
							</ol>
						<li><a href="#anchor-Styles">CSS style</a>
							<ol>
								<li class="sub-main"><a href="#anchor-StandStyle">Standard Style</a></li>
								<li class="sub-main"><a href="#anchor-EditStyle">Edit Style<br />(incl. various application examples for individual settings)</a></li>
								<li class="sub-main"><a href="#anchor-MakeStyle">Create Style</a></li>
								<li class="sub-main"><a href="#anchor-DelStyle">Delete Style</a></li>
							</ol>
						<li><a href="#anchor-banner">Banner and individual greeting text</a>
							<ol>
								<li class="sub-main"><a href="#anchor-ShowBanner">Show, edit and delete banners</a></li>
								<li class="sub-main"><a href="#anchor-PlusBanner">Add banner and/or welcome text</a></li>
							</ol>
						<li><a href="#anchor-Smilies">Smileys/Emojis</a>
							<ol>
								<li class="sub-main"><a href="#anchor-ShowSmil">Show Smileys</a></li>
								<li class="sub-main"><a href="#anchor-PlusSmil">Add Smiley</a></li>
								<li class="sub-main"><a href="#anchor-DelSmil">Delete Smileys</a></li>
								<li class="sub-main"><a href="#anchor-EditSmil">Edit Smileys</a></li>
							</ol>
						<li><a href="#anchor-Badwords">Badwords</a>
							<ol>
								<li class="sub-main"><a href="#anchor-ShowBadw">Show and delete Badwords</a></li>
								<li class="sub-main"><a href="#anchor-PlusBadw">Add Badwords</a></li>
							</ol>
						<li><a href="#anchor-Spamfilter">Spam filter</a>
							<ol>
								<li class="sub-main"><a href="#anchor-SpamBasics">Basic principles of spam <span class="nowrap">protection <img class="arrow-left marg-le25" title="IMPORTANT" src="'.$url.'images/ausruf.png" height="14" width="14" alt="IMPORTANT" /></a></span></li>
								<li class="sub-main"><a href="#anchor-ShowSpamWo">Show and delete Spamwords</a></li>
								<li class="sub-main"><a href="#anchor-PlusSpamWo">Add Spamwords</a></li>
								<li class="sub-main"><a href="#anchor-ShowIpBar">IP lock after Spam entry</a></li>
							</ol>
						<li><a href="#anchor-Backup">Backup</a>
							<ol>
								<li class="sub-main"><a href="#anchor-BackUpEdit">Manage Backups and restore entries</a></li>
								<li class="sub-main"><a href="#anchor-MakeBackUp">Create Backup</a></li>
							</ol>
						<li><a href="#anchor-Statistik">Statistic</a>
							<ol>
								<li class="sub-main"><a href="#anchor-ShowStats">Show Statistic</a></li>
								<li class="sub-main"><a href="#anchor-DelStats">Delete Statistic</a></li>
							</ol>
						<li><a href="#anchor-update">Update check</a>
						<li><a href="#anchor-Hilfe">Help</a>
						<li><a href="#anchor-Logout">Logout</a>
					</ol>
				<li><a href="#anchor-Repair">Diagnostic and repair tool</a>
			</ol>
			<h2><a href="#anchor-lang">V. Additional</a></h2>
			<ol>
				<li><a href="#anchor-lang">Languages</a>
				<li><a href="#anchor-Credits">Credits</a>
				<li><a href="#anchor-Copyright">Copyright, license</a>
				<li><a href="#anchor-History">Version History</a>
				<li><a href="#anchor-Kontakt">Contact</a>
			</ol><br />
			</div>
			<hr /><hr />';
//I. Einleitung		
		echo'
			<span id="anchor-Intro" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<h2><br />I. Introduction, Disclaimer</h2>
			<p><span class="italic">myPHP Guestbook</span> is an open source guestbook and is licensed under the GNU General Public License.</p>
			<p>Before using the guestbook, you should read the <span class="italic">license.txt</span> (can be found in the folder "license").</p>
			<p>By installing and using <span class="italic">myPHP Guestbook</span>, you accept the GNU General Public License.</p>
			<p>Under the terms of the license, anyone can independently change the code of <span class="italic">myPHP Guestbook</span> or use parts of the code for other projects. However, this is only permitted if the license terms are complied with, see here: &lt;www.gnu.org/licenses&gt;</p>
			<p>So that the program <span class="italic">myPHP Guestbook</span> can be further improved, your assistance is also asked. You are welcome to report your wishes for future features or announce found errors. Use the <a href="https://www.php-guestbook.de/start.gbook.php" title="Link opens a new window" rel="external">Demo Guestbook</a> on "www.php-guestbook.de", so that also other users can profit and take part in discussions. I will endeavor to fix any discovered bugs immediately.</p>
			<p>Since <span class="italic">myPHP Guestbook</span> is a relatively small project, no patches are offered to close any security gaps. Therefore, you should always download and install the <a href="https://www.php-guestbook.de/index.php#anchor-newvers" title="Link opens a new window" rel="external">latest version</a> to keep up-to-date. Please check for updates on <a href="https://www.php-guestbook.de" title="Link opens a new window" rel="external">www.php-guestbook.de</a> or register for our <a href="https://www.php-guestbook.de/mail.reg.php" title="Link opens a new window" rel="external">Newsletter</a>.</p>
			<p class="text-shadow zentriert"><br /><strong>DISCLAIMER:</strong></p>
			<p><strong>It\'s not possible to offer an always and everywhere perfectly working software. <span class="italic">myPHP Guestbook</span> is offered WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.</strong></p> 
			<p><strong><span class="italic">myPHP Guestbook</span> is offered "as well as it is" and accepted by you upon installation, excluding any warranty and liability. See the GNU General Public License for more details.</strong></p>
			<p><strong>You are yourself responsible for compliance with legal requirements when using the <span class="italic">myPHP Guestbook</span> in accordance with the respective national legal provisions, especially as the legal conditions may vary depending on the place of use and may also change at any time.</strong></p>';
//II. Aktuelle Änderungen	
		echo'
			<span id="anchor-Aktuell" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<h2><br />II. Current changes</h2>
			<p>A complete description of all program changes from version 4.0.0 onwards can be found at "www.php-guestbook.de" under <a href="https://www.php-guestbook.de/start.changelog.php" title="Link opens a new window" rel="external">Changelog</a></p>';
//III.	Installationshinweise
		echo'
			<span id="anchor-Install" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<h2><br />III. Preparation and Installation or Update of <span class="italic">myPHP Guestbook</span></h2>
			<p>Minimum Requirements for operating <span class="italic">myPHP Guestbook '.$version.'</span>:</p>
			<ul>
				<li>Apache Server
				<li>MySQL 5.x or 8.0 - (MySQL STRICT MODE since <span class="italic">myPHP Guestbook v.4.9.1</span>)
				<li>PHP 7.x, 8.0 or 8.1 (due to possibly higher PHP versions than 8.1 see <a href="https://www.php-guestbook.de/index.php#anchor-require" title="Link opens a new window to www.php-guestbook.de" rel="external">HERE</a>)
				<li>Activated MySQLi support
				<li>Only for the use of the photo upload function:
					<ul>
						<li>Activated GD support
						<li style="list-style-type:none">(The guestbook without image upload can also be used without a GD module.)
					</ul>
				<li>Additional prerequisite requirements for using to allow use of the photo upload and smiley upload function:
					<ul>
						<li>file_uploads = On
					</ul>
				<li>Not mandatory for the guestbook, but desirable for security reasons:
					<ul>
						<li>The use of own .htaccess files permitted by your provider.
					</ul>
				<li>For the automatic zipping (compression) of the BackUps created with the program:
					<ul>
						<li>Activated zlib support
						<li style="list-style-type:none">(The guestbook can be installed and used without this support, including the BackUp production, but the BackUps will not be compressed automatically.)
					</ul>
			</ul>';
//III.1. Installation, Update
		echo'
			<span id="anchor-Update" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />1. Installation or Update:</strong></p>
			<p>Detailed instructions and explanations with a step-by-step guide, which is to be observed during an installation or an update of the program <span class="italic">myPHP Guestbook</span> and which steps are necessary in detail, can be found in the <strong class="italic">ReadMe.pdf</strong> attached to the download. For an update, please also read the attached <strong class="italic">ReadMe-Update.pdf</strong>.</p>
			<p class="zentriert red"><strong>Attention:</strong></p>
			<p class="red"><strong>For security reasons, please delete the folder "install" with all files contained in it after successful installation or update!</strong></p>';
//III.2. iframe
		echo'
			<span id="anchor-Webdesign" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2. When including the guestbook per "iframe" please note:</strong></p>
			<p>If your website, in which the guestbook is embedded, has a fixed width, you don\'t have to pay any special attention to the integration via "iframe", everything remains or will be implemented as usual. However, if your website has a flexible width, you should take note of two points in particular to fully exploit the possibilities of the guestbook\'s automatic resizing, depending on the end device:</p>
			<ol>
				<li type="a">The width of the iframes must <strong>not</strong> be defined absolutely, but only relative to the parent element. This means that for the iframe <strong>no</strong> width specification with px or pt but with % should be used. So <strong>not</strong> e.g. "width: 500px" but "width: 100%"!
				<li type="a">The iframe should be integrated on the page in such a way that it takes its <strong>full width</strong>, without any navigation or other texts or similar on the right or left next to it and possibly with an inner padding to the parent element right and left up to a maximum of 5px. Only then can the minimum width of 320px be achieved on a smartphone!
			</ol>';
//III.3. Ordnerrechte		
		echo'
			<span id="anchor-Ordner" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3. Special rights of specific folders:</strong></p>
			<p>Regardless of whether you came to this paragraph, because the installer has indicated that certain folders are not writable, or you have received error messages during image upload or back-up creation, or because you be just careful: Read this (and the following) section, and do not frighten, if you do not understand everything immediately; everything is solvable. <span class="td-nowrap">:-)</span></p>
			<p>In the hints of older <span class="italic">myPHP Guestbook</span>-documentations it was always stated that the backup- and smilie-folders should get the CHMOD rights 0777. However, this is not necessarily correct and neglects the safety aspect.</p>
			<p>For a better understanding: The directories (folders) &quot;images/smilies&quot;, &quot;banner&quot;, &quot;backup&quot; and &quot;img_guest&quot; must be created in such a way that PHP is able to store files in these folders and these files can be &quot;read&quot; by PHP. This requires certain rights, namely the so-called &quot;CHMOD rights 0755&quot; or in <span class="italic">some</span> server configurations even 0777, because otherwise saving backups, uploading new smileys or an own banner or the photo upload, which is possible since V.4.4.0, will not work.</p>
			<p>For security reasons, however, a folder should have as few rights as possible. So better, because safer, CHMOD 0755 and only if there is no other way CHMOD 0777. On the website of &quot;wiki.selfhtml.org&quot; it is expressed as: &quot;777 is evil.&quot;</p>
			<p>The checking and, if necessary, changing rights of a folder on the webspace can be done with a FTP client, e.g. with FileZilla or similar. This mostly works by opening the directory tree of your own web space on the web server, clicking on the desired folder with the mouse (depending on the program with the left or right mouse button) and clicking on &quot;Change file attributes&quot; or &quot;File Permissions&quot; or &quot;Properties&quot; or similar named references. It usually opens another window where you can see and (if necessary) change which rights the folder has or should have.</p>
			<p>Whether in your case the four designated folders (and also the file "config.inc.php" in the directory "includes") have to get the rights 0777 or the -preferably- lower rights 0755, must be tried out in the doubt, because this also depends on whether the Apache server and the files run under the same user (what they should do nowadays) or not.</p>
			<p>After uploading all the files and folders from the download package, the folder rights should normally be 0755. The installer is also focused on 0755 with the built-in check for writeability of these folders. If the folders were displayed there in green with the message: "available, writable", everything should be fine. - <span class="italic">However, this does not replace an independent examination!</span></p>
			<p>If the installer shows you that the four or one of the four folders "images/smilies", &quot;banner&quot;, "backup" and/or "img_guest" are present, but cannot be written to, you can still use the guestbook, but the following will not work:</p>

			<ol>
				<li type="a">You can\'t back up the guestbook entries with this script,
				<li type="a">no new smileys and no new banner can be uploaded with this script
				<li type="a">and the upload of images will not work.
			</ol>
			<p>To resolve this, you must either change the CHMOD rights of the affected folder(s) as described above or, if not desired or possible, check one of the following options:</p>
			<ul>
				<li>Solution for a): Use another external back-up program for the database entries, e.g. MyphpAdmin, mySQLDumper or similar and activate in the &quot;General configuration&quot; settings here in the admin area of the guestbook the option: &quot;BackUp after sending via e-mail delete from the server again?&quot;.
				<li>Solution for b): First of all, a whole series of smileys and two banner are already available after the initial installation. Only if they are not sufficient AND the folders &quot;smilies&quot; and &quot;banner&quot; are displayed as not writable, you may need to upload new smileys and a new banner via FTP. The data of the smileys uploaded via FTP must then also be entered manually in the database table &quot;* _smilies&quot;.
				<li>Solution for c): Disable in the &quot;General configuration&quot; settings here in the admin area of the guestbook the option: &quot;Show images in guestbook entries, activate image upload&quot;.
			</ul>';
//III.4. .htaccess
		echo'
			<span id="anchor-htaccess" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />4. Using .htaccess files:</strong></p>
			<p>The download package contains three partially different .htaccess files, namely in the folders "backup", "includes" and "img_guest". They also serve to increase safety against harmful interference by third parties.</p>
			<p>Files with the name .htaccess (the first character is a dot) are part of the configuration of the Apache web server. In the central configuration, the server administrator, in other words, your provider, determines which permissions he or she wants to grant to which users or which virtual offerings (virtual hosts). In addition, in the central configuration of Apache (which you as a normal user can\'t access, unless you run your own server), you can also set any other file name, which is why the name of such a file doesn\'t necessarily have to be .htaccess (although it is common and therefore usually so).</p>
			<p><strong>With one sentence:</strong> You can use the .htaccess files from the <span class="italic">myPHP Guestbook</span>, if your provider has given you this possibility in your hosting package.</p>
			<p>This should be the case with the current large providers. Basically more would be possible than contained in the attached files, but not allowed everywhere. The instructions in these files are therefore limited to what providers normally allow.</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>If you receive error messages after uploading images, especially those with <span class="italic">&quot;500 server error&quot;</span>, or if uploaded images should not be displayed despite error-free upload, please follow the tips in the <strong class="italic">&quot;ReadMe.pdf&quot;</strong>!</p>
			<p>If this does not help, as a last resort delete the .htaccess file from the &quot;img_guest&quot; folder, and ask your provider, what is possible within your hosting package and what is not.</p>
			<p><strong><span class="red">TIP:</span></strong> Test whether the uploaded &quot;.htaccess&quot; does what it is supposed to do by calling the following link:</p>
			<p class="zentriert italic"><a href="'.$url.'img_guest/index.php" title="Click to test - link opens a new window" rel="external">'.$url.'img_guest/index.php</a></p>
			<p>... You should see an &quotHTTP-403 error&quot in your browser, similar to the content:</p>
			<p class="zentriert italic"><strong>&quot;Forbidden You don\'t have permission to access ... on this server.&quot;</strong></p>
			<p>If this is the case and uploaded images are displayed, it works properly.</p>
			<p>If, on the other hand, you click on the link and than you see the guestbook index page, it does <span class="italic">not</span> work and the contents of the folder can be accessed from the outside.</p>
			<p>If you can\'t use any .htaccess files or if they don\'t produce the desired effect and if you have to assign CHMOD rights 0777 to the three folders "images/smilies", "backup" and "img_guest" described in the previous section, I strongly recommend to =&gt;</p>
			<ol>
				<li type="a">deactivate the option: &quot;Show images in guestbook entries, activate image upload&quot; under the link &quot;General configuration&quot; and
				<li type="a">activate the option: &quot;BackUp after sending via e-mail delete from the server again?&quot; also in the &quot;General configuration&quot; and
				<li type="a">after completion of the installation, change the CHMOD rights of the file "config.inc.php" from the directory "includes" to 0444 or 0644 (-r--r--r-- or -rw-r--r--) to prevent access and manipulation from outside, and
				<li type="a">change the provider, not only because of this guestbook script, but because he obviously lives with his offer still behind the moon.
			</ol>';
// III.5. Datenschutzhinweise + 5.1. Cookies
		echo'
			<span id="anchor-Cookie" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />5. Privacy and the <span class="italic">myPHP Guestbook:</span></strong></p>
			<p class="text-shadow"><strong>5.1. Cookie Notes:</strong></p>
			<p>Up to four <strong>technically necessary session cookies</strong> are used by the <span class="italic">myPHP Guestbook</span> script, depending on the configuration, and up to two of them should be mentioned in a privacy policy. "<span class="italic">Technically necessary session cookies</span>" combine the following crucial features: They expire automatically when the browser is closed, do not store content suitable for individualizing the user, and are not suitable for tracking or creating a user profile, e.g., for advertising purposes or the like.</p>
			<ul>
				<list-style-type:none>1. If you enable the option "Activate search function" in the "General Configuration" (default: disabled), a cookie with a session ID is automatically set when the guestbook index page (this is the page on which the guestbook entries are displayed) is opened. The same cookie with session ID is set or used (if already present because of the enabled search function) when the " Quote posts" function is enabled (default since v.4.10.7: disabled) and the quote function is used by a user.<br /><br />
				A session ID consists of a random sequence of numbers and letters generated by the server for each visit to the website and is only used to assign the calling browser to the session. This is necessary so that, when using the search function, the search results and, when using the quote function, the quoted entry can be assigned to the requesting browser.<br /><br />
				Thus, this cookie does not contain any data of the user, in particular also no IP, not the term(s) searched for and likewise no contents from a quoted post and is deleted automatically with the end of the session.</li><br /><br />
				<list-style-type:none>2. Another session cookie is set if you release the language selection for the user in the configuration settings (default: disabled) <strong>and</strong> a user actually uses this language selection, i.e. switches to another of the offered languages. Then a cookie is generated which contains an abbreviation of the selected language (e.g. "de" for German or "pl" for Polish etc.). This is necessary because otherwise the language selection would have to be repeated every time a new page of the guestbook is opened.<br /><br />
				This cookie also does not contain any personal data of the user. In addition, the language selection can be set in such a way that the user is expressly informed beforehand that he agrees to the setting of such a cookie by selecting another language.</li>
			</ul>
			<p>Finally, one or two more session cookies are set in the admin control panel, but they are not interesting for the public because they only concern the admin himself and should therefore only be mentioned here for the sake of completeness:</p>
			<ul>
				<list-style-type:none>3. When the admin panel is called, a cookie with a session ID is set to uniquely identify the computer from which the user logs in.</li><br /><br />
				<list-style-type:none>4. And finally, when you activate the so-called "Blog Mode" in the admin area, so that the admin can also use all the functions of the guestbook that are otherwise blocked in blog mode (example: photo upload).</li>
			</ul>
			<p><strong>All</strong> cookies listed here are cancelled and deleted at the latest when the browser window is closed.</p>
			<p>If you do not know how to deal with such cookies from a legal point of view, use one of the common search engines and enter there as search terms e.g.: "data protection technically necessary cookies" or also "data protection session cookies".</p>
			<p>You can configure the guestbook so that no cookies are set on a visitor\'s computer by not activating the three functions listed above (search function, quote function, language selection). See also the following <a href="#anchor-noIp">section 5.3</a> in addition.</p>';
// III.5.2. IPs
		echo'
			<br /><span id="anchor-saveIP" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong>5.2. How user IPs are processed:</strong></p>
			<p>The IP of a visitor is usually only <strong>anonymized and temporarily</strong> (if the default settings are not changed, between a few minutes to about 12 hours) stored in separate database tables.</p>
			<p>Anonymization is done by shortening each IP. For IPv4 addresses the last octet is set to "0", for IPv6 addresses the last three blocks are set to "0". In addition, the IPs shortened in this way are provided with an individual salt and then saved as a hash algorithm. All this happens on up to four occasions:</p>
			<ul>
				<li>To protect against automated mass entries ("Flood protection", activated after installation => default: 5 to 10 minutes, depending on installed version) and</li>
				<li>to protect against misuse of the search function (if the search function is activated => default: 60 min.),</li>
				<li>to control the number of image uploads in a posting (if the function for uploading images is activated => default: 20 min.),</li>
				<li>as well as for statistics (when statistics is activated => default: 12 hours).</li>
			</ul>
			<p>The strings of characters formed from the original IP and stored for a limited period can no longer be personalised and can therefore in my opinion no longer be regarded as "personal data".</p>
			<p>No IP will be saved for the respective guestbook entry, not even anonymized.</p>
			<p>The above mentioned time periods until the respective removal of the hash values from the database correspond to the basic settings after installation and cannot be regarded as absolute for technical reasons, since the automatic deletion also depends on the "index.php" and the "insert.php" being called on the Web. This is because the deletion process is not triggered until the page is called.</p>
			<p>Only <strong>IPs of spam entries are temporarily saved in plain text</strong>. This is done to prevent further spam entries in the guestbook of the sender under the same IP.</p>
			<p>Such "Spam-IPs" are usually deleted automatically after 7 days. Data, the further storage of which is necessary for evidence purposes, can be excluded from deletion by the Admin until the respective incident has been finally clarified.</p>
			<p>The storage of IPs under which a spam entry was made can be deactivated under the link "General configuration" (default: activated).</p>
			<p>See also the notes in the lower sections: <a href="#anchor-IPBar">IP lock of the entry page</a> and <a href="#anchor-ShowIpBar">IP lock after spam entry</a></p>
			<p>You can configure the guestbook so that no IPs are processed. See the following <a href="#anchor-noIp">section 5.3</a>.</p>
			<p><strong><span class="red">TIP:</span></strong> You will also find helpful suggestions for the Privacy Policy of your website under this link as a PDF file: <a href="https://www.php-guestbook.de/pdf-files/myPHPGuestbook-DSGVO.pdf" title="Link opens a new window" rel="external">Formulation aid for information on the <span class="italic">myPHP Guestbook</span> in a Privacy Policy</a>. (But I\'m sorry, it\'s only in German.)</p>';
// III.5.3. Keine Cookies setzen, keine IPs speichern
		echo'
			<span id="anchor-noIp" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />5.3. Use of the <span class="italic">myPHP Guestbook</span> without setting cookies and/or without processing IPs:</strong></p>
			<p class="text-shadow">5.3.1. Operation without cookies:</p>
			<p>If you do not want the script "<span class="italic">myPHP Guestbook</span>" to set cookies on a visitor\'s computer, the following functions must be deactivated:</p>
			<ul>
			<li>the search function,</li>
			<li>the quote function,</li>
			<li>the individual language selection by the guest.</li>
			</ul>
			<p>Then only the cookies required to identify the admin when logging into the admin panel are set, see above.</p>
			<p class="text-shadow">5.3.2. Operation without processing IPs:</p>
			<p>If you do not want the script "<span class="italic">myPHP Guestbook</span>" to process the IPs of visitors, neither anonymously nor (for spam entries) in plain text, the following functions must be or become deactivated:</p>
			<ul>
			<li>the search function,</li>
			<li>the statistic about the hits of the guestbook,</li>
			<li>the function to protect against mass entries (Flood lock - set value to "0"),</li>
			<li>the collection and temporary storage of IPs after spam entries and</li>
			<li>the function to upload image files.</li>
			</ul>
			<p>You can make these settings all at once with a click under this link: "<a href="'.$url.'admin/admin.php?action=guestbook_options&#38;'.session_name().'='.session_id().'#anchor-konfig4">Extended Privacy</a>".</p>
			<p>Please note that if cookies and IP processing are deactivated, the functions listed above cannot be used. A renewed activation is only possible for each function individually under the link "<a href="'.$url.'admin/admin.php?action=guestbook_options&#38;'.session_name().'='.session_id().'">General configuration</a>".</p>';
//III.5.4.mehr Datenschutz
		echo'
			<span id="anchor-morePP" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />5.4. Other privacy settings:</strong></p>
			<p>Under the link "General configuration" you can define, that the guest, who has written a new entry for the guestbook, has to confirm before saving and publishing this entry by marking a checkbox that he agrees with the processing and saving of his entries according to the rules of the data protection basic regulation. This optional function is deactivated after installation.</p>
			<p>You can also use the "General configuration" link to set up a link to the privacy statement on your website at the end of the pages containing the published guestbook entries and the form for a new entry.  (Default setting: deactivated). The link should be entered in the corresponding field as an absolute path (i.e. with: http(s)://).</p>
			<p>Within the European Union, as a precautionary measure, it is recommended to make use of both options.</p>';
//IV. + 1. config.inc	
		echo'
			<span id="anchor-Config" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<h2><br />IV. Usage notes:</h2>
			<p class="text-shadow"><strong>1. config.inc.php (folder &quot;includes&quot;):</strong></p>
			<p>The guestbook requires a SQL database, in which e.g. the entries of the visitors, but also the configuration data and much more are stored. In order for the guestbook to run at all, the database access data (which you receive from your provider) must be correctly entered in the file "config.inc.php".</p>
			<p>Thanks to the installation script, in which all required data is queried in a clear mask, setting up the connection to the database and creating the required database tables is simple. When I switched to MySQLi, I also added an automatic check into the script to see if the required PHP extension MySQLi is available on your webspace.</p>
			<p>The Installer script, as well as the script for updating the database, is located in the &quot;install&quot; folder.</p>
			<p><strong><span class="red">TIP:</span></strong> If the "config.inc.php" has been damaged or overwritten or if other undefined connection problems to the database should occur, this can be checked and in most cases repaired with the diagnostic and repair tool of <span class="italic">myPHP Guestbook</span>. See <a href="#anchor-Repair">section IV. 4, "Diagnostic and Repair Tool"</a> for further information.</p>';
//IV.1.1. Zeitzone
		echo'
			<span id="anchor-timezone" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />1.1. Time zones, date and time format:</strong></p>
			<p>If you have selected one of the countries offered in the drop-down menu during the installation from v. 4.5.6 onwards, the "config.inc.php" also stores the time zone under which your homepage runs with the guestbook. For subsequent changes to the time zone, the &quot;config.inc.php&quot; must be opened with an editor, and a different time zone may be assigned to the &quot;<span class="blue">$timezone</span>&quot; variable.</p>
			<p>All time zones recognized and used by PHP can be found at:</p>
			<p class="zentriert">&lt; php.net/manual/timezones.php &gt;.</p>
			<p>If the variable "<span class="blue">$timezone</span>" is empty, i.e. it is not assigned a certain time zone, the program accesses the server\'s default settings.</p>
			<p>If you have installed the guestbook with one of the earlier guestbook versions (v. 4.5.5 or lower), there will be no variable "<span class="blue">$timezone</span>" in the "config.inc.php" of your installation. If you haven\'t noticed any discrepancies in the time recording (e.g. date and time of guestbook entries) so far, the server on which your guestbook script is running will be configured correctly for your needs and you don\'t have to worry about it. Otherwise, load the "config. inc. php" from the server to your computer, open it with an editor and insert the following after the access data for your database, e.g. for Germany:</p>
			<p class="zentriert blue">$timezone = &quot;Europe/Berlin&quot;;</p>
			<p>For time zones of other countries see link above. The time zone is to be quoted in quotation marks, as in the example. Don\'t forget the semicolon at the end!</p>
			<p>As soon as the US flag is set in the general configuration settings, the <strong>date in US format</strong> is also displayed in the guestbook (mm-dd-yyyy). In addition, the time display on the guestbook entries page and in the post preview is in American 12-hour format. (Change of the time display for all guestbook entries from v.4.9.0 / 10. May 2018.) For all other flags, the 24-hour time format and the internationally accepted date format (dd.mm.yyyy) will be retained.</p>';
//IV.1.2. https		
		echo'
			<span id="anchor-save" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />1.2. Subsequent switch to an (un)encrypted Internet connection<br />(http &harr; https):</strong></p>
			<p>If you change your website <strong>after</strong> installing the guestbook to a secure internet connection (or vice versa) (switching between "http" and "https"), you also have to change the path for the links within the guestbook.</p>
			<p>To do this, download the "config.inc.php" (can be found in the folder "includes") from the server to your own computer, open it with an editor and change/add the "http://" to "http<strong>s</strong>://" (or vice versa) in the "Domainpath" to the variables "<span class="blue">$url</span>" and "<span class="blue">$url02</span>". Save and load the "config.inc.php" back onto the server. - Done.</p>';
//IV.2. + 2.1. Gästebuchseite	
		echo'
			<span id="anchor-Gaestebuch" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2. Guestbook</strong></p>
			<p class="text-shadow"><strong>2.1. Guestbook page:</strong></p>
			<p>On the "index"-page in the top level of the guestbook folder all contributions, which have been entered in the guestbook, are displayed. The number of posts per page can be set individually in the admin area as well as the number of links to browse through the individual pages. - If you want to prevent unpleasant line breaks when displaying the guestbook on a smartphone, don\'t change the default setting of max. 9.</p>
			<p>The guestbook has a template and style management, with which you can easily change the appearance of the guestbook. A total of twelve ready-made templates with the matching CSS styles are installed and can be used according to your personal taste. See section 3.3 below for more information.</p>
			<p>If you include the guestbook via PHP, please note that the GET variable "$page" is already used by the script.</p>
			<p>The guestbook page can be adjusted with appropriate knowledge of PHP and HTML itself, e. g. to insert additional links. For less experienced PHP users, an add-on package is available for download at <a href="https://www.php-guestbook.de" title="Link opens a new window" rel="external">www.php-guestbook.de</a>. With the included files and two demo pages, the inclusion of the guestbook script by PHP "include" should not be a problem any more, although basic knowledge in HTML, PHP and CSS as well as about building a website should generally be present.</p>';
//IV.2.1.1.			
		echo'
			<span id="anchor-Changes" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.1.1. Changes of font, font size, font and link colors, backgrounds, guestbook width, alignment on the page (right-left-centered), symbols for e-mail and homepage of a guest entry, color of the active rating stars:</strong></p>
			<p>All the settings listed above can be easily adjusted under the link "Edit template". Changes to the source code or the CSS are not necessary. See below <a href="#anchor-EditTempl">Section IV. 3.3.2, "Edit Templates"</a>.</p>
			<p>On the page for the guestbook entries, the input and text area fields get a gray frame with corresponding outer shadow when the cursor is placed on the program side. To customize this, see <a href="#anchor-EditStyle">Section IV. 3.4.2, "Edit Style"</a> below.</p>';
//IV.2.1.2.	Copyright
		echo'
			<span id="anchor-Copy" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.1.2. Copyright Notice:</strong></p>
			<p>The visible copyright notice on the index and insert page may be removed according to the General Public License.</p>
			<p>However, you should keep in mind that <span class="italic">myPHP Guestbook</span> comes to new users mainly through the link in the copyright notice.</p>
			<p>The copyright notice in the source code may not be removed in any file.</p>';
//IV.2.2. Eintragsseite	
		echo'
			<span id="anchor-Eintragsseite" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2. Insert page:</strong></p>
			<p>In order for posts to be published in the guestbook, they must be entered on the entry page by the user. This is the "insert.php" on the top level of the guestbook folder.</p>
			<p>The default setting for the width with which the entry form is displayed in the browser is 500px. Under the link "Edit Template" you can set that the entry form is displayed with the same width as the guestbook entries on the "index. php".</p>
			<p>Depending on how the guestbook is configured, there are more or less features to choose from. The most important ones are ...</p>';
//IV.2.2.1.	Eingabemöglichkeiten
		echo'
			<span id="anchor-Entry" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.1. Input options:</strong></p>
			<p>After the installation, from version 4.6.0 all input fields, except those for the name and the guest\'s contribution, can be shown and hidden separately in the Admin-Panel under the link "General configuration".</p>
			<p>To save space, the input fields for place and country on the one hand and for e-mail and homepage on the other (as far as space requirements permit under certain configurations) are arranged next to each other. If only one of the two adjacent input fields is deactivated, the remaining field automatically extends over the entire width of the input form to obtain a visually uniform appearance.</p>';
//IV.2.2.2.	Smileys
		echo'
			<span id="anchor-Smiley" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.2. Smileys/Emojis:</strong></p>
			<p><span class="italic">myPHP Guestbook</span> supports Emojis, i.e. you can type ":angry:" into a new guestbook entry and in the guestbook page the ":angry:" will be replaced by a picture with an angry smiley.</p>
			<p>The insertion of such smileys has been changed to v.4.x: If in one of the versions prior to 4.1 a clicked smiley was always placed at the end of the typed text in the entry form, it will now be inserted where the cursor is located in the text field, with a space before and behind it.</p>
			<p>Using emojis can help to interpret written text correctly. For example, not every sarcasm or irony can be recognized by every reader from the choice of words. - However, it is often undesirable if a user decorate his entry with "chains" of Emojis.</p>
			<p>To control this to a certain extent, you can use the link "General configuration" to select the appropriate checkbox to specify that the program checks how many Emojis the guest has inserted into his message when saving or previewing a new post. If there are more than '.$maxSmilies.' Emojis in a guestbook entry, excess Emojis are automatically removed from the text.</p>
			<p>You can change the maximum number of tolerated Emojis (default: 10 pieces) if you wish. See the "<a href="#anchor-MoreKonfig-02">Further configuration options</a>" section below.</p>
			<p>This function is deactivated after the installation.</p>';
//IV.2.2.3.	BBCode
		echo'
			<span id="anchor-BBC" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.3. BBCodes:</strong></p>
			<p>With BBCodes the guest can format his entry. For example, text between the two tags [b]<strong>Any text</strong>[/b] is displayed in bold.</p>
			<p>In addition to this simple BBCode, many more can be used in <span class="italic">myPHP Guestbook</span> e.g. for colored texts, quotations and more.</p>
			<p>If the guest selects a certain text area in the form field with the mouse and then clicks on the desired BBCode, the required tags are automatically set to the beginning and the end of the selected text.</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>Clickable links and e-mail addresses can now only be inserted into posts when using the tags provided by the newly created input masks. The input masks are called up via the corresponding BBCode buttons. For example, if a URL in the form: "http://www.example.com" is written into a guestbook entry without the tags provided when using the input mask, the program issues a warning message for the guest and refuses to save the entry until it is changed. - My observations show that this alone blocks more than 3/4 of all spam attempts, because spam bots do not call up input masks and therefor a post with a clickable link to any porn site by a nocturnal bot is practically impossible.</p>
			<p>The comfortable insertion of BBCodes with one click only works -just like the comparable function to insert the smileys- if the user has activated Javascript. If not, a corresponding message will be displayed.</p>';
//IV.2.2.4.	Fotos
		echo'
			<span id="anchor-Photo" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.4. Images in guestbook entries:</strong></p>
			<p>In the guestbook versions up to 4.3.x pictures could only be placed in entries if they were linked, i.e. somewhere were already online, be it at one of the many photo portals, be it on the guest\'s own web space or wherever. This had a series of disadvantages both of the legal nature as well as insofar, that according to experience these photos disappeared sooner or later from where they were linked and then left a lot of unsightly "gaps" in the guestbook.</p>
			<p>With the upload function provided from version 4.4.0 onwards, a guest can upload images from his own computer to a folder on the webspace, that also contains the guestbook script, and these images will then be displayed in the guestbook entry. Images can also be uploaded and posted by the admin in his comment on a guestbook entry. Since these files are then stored on your own webspace, they can no longer be deleted uncontrollably by third parties.</p>
			<p>The guest can also enter an individual short description of the image, which will be displayed later when you move the mouse over the image, a so-called "title".</p>
			<p>In order to use this function, both "BBCodes" and the function "Images in guestbook entries, activate image upload", have to be activated in the configuration settings. After a new installing, the image upload and image display feature in entries is initially disabled.</p>
			<p>On the server side, the following settings in particular must be available (in case of doubt, ask your provider or check via "<span class="italic">php.info</span>"):</p>
			<ul>
				<li>file_uploads = On
				<li>activated GD support
			</ul>
			<p>If your webspace does not have GD support provided by the provider, the program is set up in such a way that the "Image Upload" function cannot be activated in the general configuration settings.</p>
			<p>In order to prevent any offensive images from being posted overnight, two security barriers have been added:</p>
			<ul>
				<li>Every time an image is uploaded, the admin will automatically receive an e-mail with the uploaded picture for immediate control. (This mail comes as soon as the upload function has been activated by the admin, for security reasons always, regardless of the other e-mail settings.)
				<li>Uploaded images can be viewed by the guest in the entry preview immediately, but are invisible to the public after saving the post. Instead, a placeholder is displayed in the post with the message, that an image set there must first be activated by the admin. As soon as the admin was able to convince himself about the safety of the uploaded file by sending him an e-mail, he can activate the picture by clicking on the link in the separate e-mail with the reference to a new guestbook entry. It is not necessary to log in to the admin-area first. The only prerequisite is that the upload function and the "Send an e-mail to the admin after a new entry" function have been activated in the general configuration settings.
					<ul>
						<li style="list-style-type:none"><br /><strong>Note:</strong> The need to check and unlock each newly uploaded image can be deactivated in exceptional cases. For further explanations see below <a href="#anchor-MoreKonfig">Section IV. 3.2.5, "Further Configuration Options"</a>.
						<li style="list-style-type:none"><br />Possibly images inserted by the admin in his comment to a guestbook entry are immediately visible to the public even without permission; the admin as commentator has to know what he is doing.
					</ul>
			</ul>
			<p><strong>Additional features:</strong></p>
			<ul>
				<li>Depending on the php.ini settings, up to 6 MB of files can be uploaded. Under the link "Upload properties", this limit can of course also be reduced to 1 MB. The default setting is 2 MB.
				<li>Uploaded images are automatically resized! Under the link "Upload properties" you can set the desired maximum width and height of the image. The maximum image width is determined and displayed automatically by the program according to the template selected by the admin or the width of the guestbook, so that it does not matter how large the uploaded image is, there are no problems with the layout of the guestbook. If the guestbook is viewed on the small screen of a smartphone, for example, the images will be reduced in size automatically.
				<li>The image quality of jpg-files (and thus also the subsequent loading time) can be set between 10 and 100% individually under the link "Upload properties ".
				<li>Since the admin area has a fixed size regardless of the setting for the public area of the guestbook, the images are scaled to fit the backend ad.
				<li>Only files in *.jpg and *.png format can be uploaded, all other files are locked.
				<li>For security reasons, the uploaded files are subject to multiple automatic scans to ensure that only image files can actually be uploaded.
				<li>What will later be stored in the folder with the guestbook pictures is always a copy of the uploaded file, adapted in size and quality and provided with a new file name; the original will be deleted immediately after making the copy, also to avoid that later image files are shown in the guestbook, which infiltrate malicious code via the EXIF header.
				<li>The maximum number of files uploaded by a user to his entry and inserted in the guestbook entry can be set in a range between "1" and "10" under the link "Upload properties ". The default setting after installation is "2".
				<li>For further safety instructions, please read the <strong class="italic">&quot;ReadMe.pdf&quot;</strong>.
			</ul>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>When uploading large files with e. g. 5 or even 6 MB, the user should use a fast internet connection because the maximum executable processing time of a script is limited with practically all providers. Anything that cannot be processed by the script within this time will be canceled in the execution process.'; if(ini_get("max_execution_time")==true){echo' The maximum runtime of a script is set by your provider to <strong>'.ini_get("max_execution_time").' seconds</strong>.';}echo'</p>';
//IV.2.2.5.	Zitate
		echo'
			<span id="anchor-Quote" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.5. Quoting of guestbook entries:</strong></p>
			<p>A new citation function can also be deactivated separately in the configuration settings*. (*This function is activated after a new installation.)</p>
			<p>If this feature is not blocked by the admin, a linked "Quote" icon will be displayed at the end of every guestbook entry, no matter whether "old" or already existing or only newly written.</p>
			<p>In order to use this function, the other BBCodes do not necessarily have to be or remain activated at the same time.</p>
			<p>After clicking the quotation symbol for the entry selected by the guest, this guestbook entry will be used as a quotation with reference to the author as well as date and time of the entry in the form for a new guestbook entry for a comfortable, unambiguous answer or discussion. Multiple quotations (quotation in quotation in quotation etc.) are possible almost without limitation. Photos that may be included in a quoted article are automatically removed from the quote for reasons of space and for a better overview. Any admin comments on the cited entry are also quoted since v.4.8.0.</p>
			<p>In the so called "Blog-Mode" of the guestbook (new entries only by the admin via the admin-control-panel) the quotation function is deactivated automatically and cannot be activated.</p>';
//IV.2.2.6.	Bewertungsfunktion
		echo'
			<span id="anchor-Stars" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.6. Star rating function:</strong></p>
			<p>With v.4.7.0 the script has been extended by an optional* function for rating the homepage or another freely selectable content by assigning one to five stars (*The rating function is activated after a new installation).</p>
			<p>During a new entry in the guestbook, the guest can click on one of five stars and thus express what he or she thinks of the online presence, for example.</p>
			<p>If the stars displayed in the guestbook after an rating are hovered over with the mouse, a tooltip is displayed with a short explanatory text hint. The Admin can determine whether this text hint should also contain information about the average value calculated from all given ratings by setting the appropriate setting under "General configuartion".</p>
			<p>I have deliberately refrained from preassigning a preassignment according to which "5 stars" are automatically assigned without any activities of the guest. If the guest does not actively click on one of the stars before saving his guestbook entry, no rating takes place and no rating will be saved.</p>
			<p>An editing of a guest submitted rating in the Admin-Control-Panel is only possible to the extent that the rating can be deleted completely under the entry editing link, but not changed otherwise.</p>
			<p>Under the link "<a href="#anchor-EditTempl">"Edit Template"</a>" you can select and set the desired color of the active rating stars from a selection of several graphics according to the respective taste.</p>
			<p>The text for what the guest should rate can be defined individually in the "General configuration" settings. If nothing else is entered here, the default setting is "website rating".</p>';
//IV.2.2.7.	Gast über Antwort zu seinem Eintrag informieren
		echo'
			<span id="anchor-ComInfo" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.7. Inform guest about a reply to his entry:</strong></p>
			<p>If under "General configuration" the option: "Hide check box for \'Info e-mail\' for guest at commenting on his entry" is not deactivated, a field appears on the "insert.php" under the text field for a new guestbook entry, which the guest can click if he wants to be informed about a comment on his entry by e-mail.</p>
			<p>The e-mail is automatically sent to the e-mail address provided by the guest to his entry as soon as a comment on the guestbook entry is saved in the admin panel or the guest entry is quoted in the public area of the guestbook. It is ensured that only the first time you save an admin comment and the first quote of the guest post, an info email is automatically sent to the guest. Later recalling and saving corrections or changes to a once written comment or citing an entry again will not cause further info e-mails.</p>
			<p><span class="italic">That</span> the guest has activated the checkbox and would like to be informed by e-mail, the admin can recognize on the central page for the administration of entries and comments, because in this case behind the link for writing a comment a small "e" for e-mail is displayed: <span class="blue">[e]</span>. When this link is crossed with the mouse, will be displayed, in which cases the guest still receives an appropriate info mail.</p>
			<p>The option "Info-E-Mail to guest" is deactivated automatically or cannot be activated, if the admin specifies that the input field for an e-mail address of the guest is hidden and therefore the guest cannot store an e-mail address to which the info mail could be sent.</p>';
//IV.2.2.8.	IP-Sperre der Eintragsseite
		echo'
			<span id="anchor-IPBar" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.8. IP lock of the entry page:</strong></p>
			<p>There are two approaches where the program <span class="italic">myPHP Guestbook</span> uses the user\'s IP address to temporarily prevent further entries in the guestbook under the same IP address:</p>
			<p>One is to protect against automated mass entries within a short time and the other to protect against spam entries.</p>
			<p>The protection against automated mass entries by means of an IP lock functions in such a way that the IP of a user who has written a guestbook entry remains stored for a certain, adjustable period of time in the form of an unidentifiable one-way hash algorithm and further guestbook entries are prevented under the same IP within this period of time. The whole thing is called "Flood ban" and becomes annoying for some users just after the new installation of the guestbook, namely when they try to copy and paste entries from another, previously used guestbook into the <span class="italic">myPHP Guestbook</span> within a very short time.</p>
			<p>One solution is simple: Just make the entries in the admin control panel under the link "Admin Blog", there is no "Flood Protection", see <a href="#anchor-Blog">Section IV. 3.1.3., "Admin Blog"</a>.</p>
			<p>Because of the IP lock caused by a spam entry and maintained by the program for '.$delete_spamIps.' days, see <a href="#anchor-ShowIpBar">Section IV. 3.7.3., "Spam filter - IP locks"</a>.</p>
			<p>If you do not want IPs to be processed by the script, see above <a href="#anchor-noIp">Section III.5.3.</a>.</p>';
//IV.3.	Admin-Control-Panel
		echo'
			<span id="anchor-Admin" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3. Admin-Control-Panel</strong></p>
			<p>The whole guestbook is easily managed via the <span class="italic">myPHP Guestbook</span> admin control panel. Access to the Admin Panel is only possible with a correct Username and Password.</p>
			<p>On some pages of the Admin Panel you will find this info icon: <img class="img-ok" title="'.$amsg[119].'" src="'.$url.'images/help.png" width="14" height="14" alt="'.$amsg[119].'" />. Clicking on it opens a lightbox window with further helpful information about the selected function.</p>';
		echo'
			<span id="anchor-new-pw" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.0.1. Forgotten password function:</strong></p>
			<p>If you have forgotten your Password for logging in to the Admin control panel, you can generate a new Password via the link "Forgot password" and have it sent to your Admin e-mail address.</p>
			<p>If you have made use of this option, you should then log in with the newly generated Password and enter a new Password immediately. The replacement Password requested with the "Forgotten password"-function is automatically deactivated after '.$pw_minutes.' minutes for security reasons.</p>';
		echo'
			<span id="anchor-sec-auth" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.0.2. Two-factor authentication:</strong></p>
			<p>If you are particularly careful and don\'t mind the extra effort, you can activate the need to enter a second Password in addition to the unavoidable input of a correct username and Admin Password to log in to the Admin Panel.</p>
			<p>This second Password is regenerated by the program from a random sequence of letters and digits at each login when the corresponding function is enabled, and is sent to the Admin by e-mail. It will be valid for three minutes. Within these 180 seconds, the additional Password sent by mail must be entered and submitted, otherwise the login process starts again from the beginning.</p>
			<p>After installation, this feature is initially disabled. To enable it, please open the file "settings.inc.php" in the directory "includes" with an editor. There you will find the constant "<span class="blue">GB_SEC_AUTH</span>" in seventh position under the copyright notices. Replace "<span class="blue">false</span>" in this constant with "<span class="blue">true</span>". Save the change and upload the file to your server. That\'s it.</p>			
			<p><strong>Please note:</strong> Enable this feature only if you are sure that automatic emailing via PHP works with the script.</p>';			
		echo'
			<span id="anchor-hijacking" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.0.3. Session Hijacking:</strong></p>
			<p>In order for a server to recognize a particular client when calling multiple pages of a host, a session is created with an individual ID that expires upon logout or even after a specified period of time or when the browser is closed. So, for example, here in the Admin Panel, after logging in, you can click and access one page after another without having to log in again for each click and for each new page.</p>
			<p>In the case of so-called "Session hijacking", a third party obtains the data of such a session in order to take your virtual place.</p>
			<p>The best protection against such attacks is the use of encrypted https connections and the prevention of "cross-site scripting" attacks as probably the main method to get session data via JavaScript.</p>
			<p>As a further, more in-depth protection, PHP can be used to ensure that the session ID generated by the server (at the latest) when the login page is called up is automatically renewed, i.e. exchanged, during the logging process, so that any data previously obtained are invalid.</p>
			<p>To do this, we use the function "session_regenerate_id". However, "session_regenerate_id" has a small catch:</p>
			<p>If networks are unstable, e.g. WiFi or mobile networks, the newly generated session may be "lost". Then the login fails. So if you work a lot e.g. with a tablet <strong>and</strong> often have login problems, you can deactivate the automatic renewal of the session ID (default: activated) to test if possible login problems can be solved.</p>
			<p>After installing or updating from a myPHP Guestbook version < 4.10.6 this feature is enabled. To disable it, please open with an editor the file "settings.inc.php" in the directory "includes". There you will find the constant "<span class="blue">ID_REG</span>" in the sixth position under the copyright notices. Replace "<span class="blue">true</span>" in this constant with "<span class="blue">false</span>". Save the change and upload the file to your server.</p>';
		echo'
			<span id="anchor-Noentry" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.0.4. Automatic login lock:</strong></p>
			<p>Any attempt to log in to the Admin control panel with an incorrect username or Password and any incorrect e-mail address entered in the "Forgotten password"-function will be recorded and incremented. After '.$allowed_attemps.' attempts with incorrect entries, the login area is completely blocked for any input.</p>
			<p>The login option will then remain blocked for '.$barrier_days.' days for security reasons and will only be released again automatically after the expiry of this period.</p>			
			<p>However, so that the Admin also has the possibility to log in before the end of these '.$barrier_days.' days if necessary, an e-mail is sent to the Admin with a link for immediate release of the login at the same time as the login area is blocked.</p>
			<p>So that the code for the release of a blocked login cannot be guessed simply by automated mass attempts, the possibility of a premature unblocking of the login for <strong>1 hour is permanently blocked</strong>, if even <strong>one</strong> attempt with a wrong release code occurred. So always make sure to use the complete, if necessary, correctly copied link in the e-mail for the premature release of a blocked login.</p>
			<p>In the event that you mistyped your login data once or twice, the counting of incorrect login data will be reset to zero after each successful login.</p>
			<p>If the Admin Area is inactive for more than '.$session_lifetime.' minutes, the session created with the login will be destroyed for security reasons and the Admin has to log in again. Each click on a link in the Admin Area resets this time measurement to zero, so that the full '.$session_lifetime.' minutes are available after each click. - <strong>Attention!</strong> This timeout with forced logout has nothing to do with the above-mentioned loss of the session in the context of the "session_regenerate_id" function and is independent of it.</p>';
//IV.3.1. + 3.1.1.	Gästebucheinträge bearbeiten
		echo'
			<span id="anchor-Gaestebucheintraege" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.1. Guestbook entries:</strong></p>
			<span id="anchor-Edit" class="sticky-anchor"></span>
			<p class="text-shadow"><strong>3.1.1. Manage, edit, comment on entries:</strong></p>
			<p>On the page "Entries and Comments" you can manage the guestbook entries or add a comment to a post if necessary. Just click on the appropriate icon <img class="img-ok" src="../images/edit.png" width="14" height="14" title="Edit entry" alt="" /> for "Edit entry" or <img class="img-ok" src="../images/comment.png" width="14" height="14" title="Comment entry" alt="" /> for "Comment entry" under the respective guestbook entry and perform the desired action.</p>
			<p>You can also use BBCodes and emojis within an admin commentary or upload and insert photos.</p>
			<p>At the beginning of the page you can see whether the guestbook is activated, if certain IPs have been blocked to access the entry page, if all entries in the guestbook are enabled and when the last BackUp was created.</p>
			<p>Below each post you will then see whether only the text of a post or any photos posted there are released or blocked.</p>
			<p>In addition, you can also block or release posts and photos in two ways:</p>
			<ul>
				<li>The first possibility is to mark the checkbox, which is located at the top right of each entry, then select the desired action from the top of the drop-down menu and click on "OK". (Only) using this drop-down menu, you can also delete entries from the database permanently (!). If you mark the check box to the left of the drop-down menu for "Select All", all contributions <strong>on the respective page</strong> are automatically marked and can be activated, deactivated or deleted in one operation.
				<li>The second option is to click on the "<strong class="text-shadow">Text</strong>" link in the lower right-hand corner of the entry to be edited (= only the written text without any set photos will be activated or the contribution will be completely deactivated) or to click on the icon for graphic files <img class="img-ok picShadowSmall" src="../images/photo.png" width="25" height="16" alt="Photo" /> (= images inserted in the contribution will be released or blocked) in order to change the current status.
			</ul>';
//IV.3.1.2.	Edit Fotoupload
		echo'
			<span id="anchor-Grafik" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.1.2. Upload and edit uploaded graphic files:</strong></p>
			<p>Here all the graphics files uploaded with the "Image Upload" function are displayed and managed. Whether the picture in the public area of the guestbook is released or still locked does not matter.</p>
			<p>The possible editing includes, for example, deleting uploaded files or editing an entered description ("title") of the photo.</p>
			<p>It may happen that uploaded photos are not aligned correctly and are "upside down" or "lying on the page". This usually applies to images taken with smartphones. Such *jpg files (not *png files) can then be rotated to the correct position here. If the rotation of an image changes its height and width, this is automatically corrected as well.</p>
			<p>Images uploaded by the admin via FTP can also be entered here into the database table of the image folder.</p>
			<p>If a photo has been uploaded once, which the admin doesn\'t unlock because of a content that he has classified as critical/illegal, the file should be deleted, also to avoid external links!</p>			
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>As a website operator, you are liable for the content of all presentations on your website. Naturally, this also applies to images published there. If, for example, you have indications that an uploaded/posted photo is an unauthorized copy from the Internet, that persons have been shown there without their consent or similar, you are obliged to delete the photo immediately. The same applies to critical photo motifs, such as e.g. glorifying violence, racist, pornographic or similar illegal representations/contents.</p>';
//IV.3.1.3.	Admin Blog
		echo'
			<span id="anchor-Blog" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.1.3. Admin Blog:</strong></p>
			<p>There is also the possibility to use the guestbook as a blog, travel diary or similar, in which only the admin himself can publish entries, no outside third party.</p>
			<p>But even if the guestbook is <span class="italic">not</span> in the so-called. "Blog Mode", entries in the guestbook can of course be entered by the admin here.</p>
			<p>For entries made in the admin control panel under the link "Admin Blog", the following applies:</p>
			<ul>
				<li>there is <span class="italic">no</span> spam check, <span class="italic">no</span> e-mail is sent to the admin about the new entry;
				<li>photos entered by the admin in the post are <span class="italic">immediately activated and visible</span> to the public;
				<li>new entries can be entered and saved here in any number without waiting time, the so called "Flood protection" is <span class="italic">not</span> active in this case.
			</ul>
			<p>For the operation of the guestbook in "Blog-Mode" under "Properties" ==&gt; "General Configuration" ==&gt; "Link to page for guestbook entries" the radio button for "Remove link (Blog mode)" has to be selected and this setting has to be saved.</p>
			<p>This results in the following special features, among other things:</p>
			<ul>
				<li>The links to "insert.php", which are available on the "index"-page for guestbook entries above and below the previously published entries, will be deactivated/hidden. 
				<li>The entry page "insert.php" and the file upload page "pic.upload.php" are no longer accessible on the web (automatic redirection to the "index"page), new entries and uploads can only be made in the admin control panel.
				<li>If you want to use the photo upload in blog mode, you may not have blocked cookies in your browser. Setting a cookie while the blog mode and photo upload are activated is necessary to ensure that only you as an admin and no third party can access the photo upload page. The cookie is automatically deleted when logging out from the admin panel.
				<li>The quotation function for existing guestbook entries is automatically deactivated or cannot be activated.
				<li>The input field for the name of the blogger changes from a mandatory field to an optional field, so that entering a name in blog mode is possible but not mandatory.
			</ul>';
//IV.3.1.4.	Frontend
		echo'
			<span id="anchor-Front" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.1.4. Open frontend:</strong></p>
			<p>A click on this link opens the guestbook page as it is published on your webspace, so that any edits, comments etc. can be checked immediately.</p>';
//IV.3.2. + 3.2.1.	Allgemeine Einstellungen		
		echo'
			<span id="anchor-Einstellungen" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2. Properties:</strong></p>
			<p>General guestbook settings can be made here in four sub-categories:</p>
			<a id="anchor-AdminEdit" name="anchor-AdminEdit"></a><div class="top"><a href="#anchor-top" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2.1. Admin- and Login data:</strong></p>
			<p>Here your personal data are administered as admin. The e-mail address is required to send a notification (if enabled) to the admin when new entries are made, backups will also be automatically sent to this account as well as notifications about any attempts of spam entries and photo uploads.</p>
			<span id="anchor-pws" class="sticky-anchor"></span>
			<p>You can also renew a forgotten or outdated password here. A status bar, which appears after focusing the input field for a new password, gives you a (non-binding) indication of the quality of your chosen password.</p>
			<p><strong>A good password should meet the following conditions:</strong></p>
			<ol>
				<li><strong>It should not contain a name, birthday or any real word.</strong></li>
				<li><strong>It should contain at least one upper and one lower case letter.</strong></li>
				<li><strong>It should contain at least one digit.</strong></li>
				<li><strong>It should contain at least one "non-word" character (no letter, no digit).</strong></li>
				<li><strong>It should consist of more than 10 characters.</strong></li>
				<li><strong>The last character should be neither a digit nor a "non-word" character.</strong></li>
			</ol>
			<p>The recommendation to change a password at regular intervals was abandoned by the German Federal Office for Information Security (BSI) at the beginning of 2020 with widespread approval from experts. The corresponding warning notice if your password is older than 90 days has therefore been removed from the program.</p>
			<p>You are solely responsible for compliance with the first of the six rules listed above. - Compliance with the rules under points 2 to 6 will be checked for you by the program. You will only receive a closed dark green bar as a sign of a "good" password if all the conditions under numbers 2 to 6 are met.</p>
			<p>In the second field under the admin data you can enter up to three so-called "<strong>Moderators</strong>".</p>
			<p>Moderators have reduced access rights in the admin panel. They can block or release guestbook entries and posted photos or comment entries <strong>but do not delete or edit entries or photos</strong>.</p>
			<p>They can also create backups and import backups, as well as view statistics and the "Help"file.</p>
			<p>With these restrictions, moderators have access and editing options under the linked pages in the navigation under "Entries", "Backup" and "Miscellaneous".</p>
			<p>All other admin options are locked or inaccessible to moderators.</p>
			<p>Moderators as well as the admin can have a 30-minute replacement password sent to their registered e-mail address via the "Forgotten password" function. However, only the admin can assign a new password for a moderator for an unlimited period of time.</p>
			<p>When you create a new moderator you can determine whether this moderator should also be informed automatically by the program via e-mail of a new guestbook entry and a file upload.</p>
			<p>Test the possibilities of a moderator by entering a test person.</p>';
//IV.3.2.2.	Allgemeine Konfiguration
		echo'			
			<span id="anchor-Konfig" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2.2. General configuration:</strong></p>
			<p>The basic settings of the guestbook are defined here by you</p>
			<p>This includes, for example:</p>
			<ul>
				<li>Whether Smileys/Emojis and/or BBCodes,
				<li>the citation function and/or image upload are active,
				<li>the rating function (allocation of 1 to 5 stars) can be switched on or off here,
				<li>the limit at which the spam filter cancels or only blocks a post,
				<li>how many links a visitor is allowed to place in his or her post without this being considered a spam attempt,
				<li>the complete guestbook and
				<li>the guestbook statistics can be activated or deactivated with one click here, as well as
				<li>the display and the option to enter a visitor\'s e-mail address,
				<li>the possibility of entering a place of origin and/or
				<li>of the visitor\'s country,
				<li>for a link to the homepage and also
				<li>the input field for a "subject" to the guest\'s entry can be activated or deactivated individually.
				<li>Alternatively, the input fields for e-mail addresses, place and country of the guest can be determined as required fields here ...
			</ul>
			<p>... and much more.</p>';
		echo'
			<span id="anchor-LinkButton" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />a) Link to the entry page (text, button, remove link/blog mode):</strong></p>
			<p>Among other things, it is also possible to individually design the links to the page for new guestbook entries, which are displayed above and below the already published entries, either as text links, as html buttons or to hide these links completely.</p>
			<p><strong>Text link:</strong> Enter the text into the corresponding input field, which should appear as anchor text of the link in the guestbook. The input can be up to 35 characters long. For an individual coloring of this link see <a href="#anchor-EditStyle">Section IV. 3.4.2, Edit Style</a>.</p>
			<p><strong>Button (default):</strong> If you want to insert a clickable html button as an anchor for the link instead of a text link, select the corresponding checkbox and click "Save".</p>
			<p>The label of the button corresponds again to the input in the field "Text of the link/button".</p>
			<p>If you do not enter a different text, the default value from the language file is used for the link or the button labeling.</p>
			<p>For changes to the background and font color of the button, see <a href="#anchor-EditStyle">Section IV. 3.4.2, "Edit Style"</a>.</p>
			<p><strong>Remove link:</strong> Users who would like to use the guestbook as a blog, travel diary or similar and who do not want to have entries from third parties there, please select the option "Remove link (blog mode)". For further explanation of this option, see above: <a href="#anchor-Blog">Section IV. 3.1.3, Admin Blog</a>.</p>';
// IV.3.2.2.b) Sprachauswahl User
		echo'
			<span id="anchor-ChooseLang" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />b) Individual language selection by the user:</strong></p>
			<p>You can activate the option "Individual language selection by guest" (default: deactivated), optionally with or without cookie note for the user. Javascript must be enabled to use the language selection.</p>
			<p>If activated, a link in the form of a bar with flags will be displayed on the "index" page above the guestbook entries and the link to the input form. The link allows the guest to decide whether the descriptions on the "index" and "insert. php" should be displayed in one of the other available languages instead of the default language set by the admin.</p>
			<p>A different language selected is stored by a cookie on the user\'s computer. The cookie is invalidated and deleted when the browser is closed.</p>
			<p>The language selection can be activated optionally with or without a note to the guest on the setting of a cookie. If you enable the language selection, it is recommended that you select the activation with cookie hint.</p>
			<p>You can customize the text for this cookie hint to suit your needs. To do this, please open the language file of your choice in the directory "lang" and change the text to the variable <span class="blue">&#36;cmsg[0]</span> visible under the heading "<span class="red">// Cookie Note to User</span>" as required, save the changes, reload the file onto the server, done.</p>
			<p><strong><span class="red">TIP:</span></strong> Please note that individual entries in the fields "Title of the guestbook", "Text of the link or button", "Text for the rating function" and/or "Change title of the "Subject" field" cannot be translated by the program. If a guest chooses a language that is different from the one set by the admin, individual entries in these fields are therefore ignored by the program and the linguistically appropriate language phrases are displayed instead.</p>';
// IV.3.2.2.c) Datenschutz
		echo'
			<span id="anchor-privacy" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />c) Set link to a Privacy policy:</strong></p>
			<p>If you activate the option "Show link to privacy policy" (default: deactivated), you can enter the URL to a data protection declaration that may exist on your website in the input field below. A link to this privacy statement will then be displayed at the bottom of the public pages of the guestbook (index- and insert.php).</p>
			<p>Especially if you link the guestbook directly without integration via iframe or PHP-include and therefore outside the normal navigation of your website, it makes sense to make use of this possibility if required.</p>';
// IV.3.2.2.d) Suchfunktion
		echo'
			<span id="anchor-search" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />d) Search function:</strong></p>
			<p>You have the option of activating a search function for the guest in the configuration settings (default: deactivated).</p>
			<p>If you release the search, a search field is displayed above the guestbook entries, with which the guest can search for certain entries or terms in the guestbook, without having to browse and read all entries.</p>
			<p>The program searches stored entries for date, name, guest entries and admin comments for the search term(s) entered. The saved entries of the time of entries, place and country, e-mail and homepage address are <strong>not</strong> searched.</p>
			<p>The number of results found is displayed numerically and the entries with search matches are displayed separately. The search term is highlighted in color. The search also works for many special characters in the search term, as long as the entry is not blocked for security reasons.</p>
			<p>A minimum of '.$minInputSearch.' and a maximum of '.$maxInputSearch.' characters can be entered as search terms.</p>
			<p>The search term is stored in a session, which is deleted either by clicking the "Reset" button, trying to perform more than '.$maxSearch.' searches within one hour, or at the latest when the browser window is closed.</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>When the search function is activated, a session must be created when the "index"-page with the guestbook entries is called, so that several identified search results can be assigned. As a result, a technically necessary cookie with a session ID (arbitrary sequence of numbers and letters without personal data) is automatically created by the calling browser on the displaying end device. This session cookie is automatically deleted when the browser window is closed. See also Section III.5.1., <a href="#anchor-Cookie">Cookie Notes</a> above.</p>
			<p><strong>Search Function Security:</strong></p>
			<ul>
			<li>Entered search terms are processed by so called "Prepared Statements" for the search in the database. Prepared statements are considered absolutely safe against SQL injections.<br /><br /></li>
			<li>Regardless of the fact that it is considered superfluous due to the use of prepared statements, any metacharacters contained in a search are nevertheless masked separately. In addition, only selected non-word characters, except letters and digits, can be entered into the search field: apostrophe (&nbsp;<strong class="red">\'</strong>&nbsp;), dot (&nbsp;<strong class="red">.</strong>&nbsp;), comma (&nbsp;<strong class="red">,</strong>&nbsp;), colon (&nbsp;<strong class="red">:</strong>&nbsp;), exclamation mark (&nbsp;<strong class="red">!</strong>&nbsp;), question mark (&nbsp;<strong class="red">?</strong>&nbsp;) and single dash (&nbsp;<strong class="red">-</strong>&nbsp;).<br /><br /></li>
			<li>The character set for data traffic to and from the SQL database is set to UTF-8 by the program. The search function can neither be activated nor used, if UTF8 is changed to another character set.<br /><br /></li>
			<li>The number of searches is limited to '.$maxSearch.' per hour in order to limit malicious gimmicks (anonymized IP block; time recording from the first search).<br /><br />You can increase this number of allowed uses of the search function, as well as change the minimum or maximum number of characters that must be entered in the search field. See the section below: <a href="#anchor-MoreKonfig-02">Further configuration options</a>.<br /><br /></li>
			<li>The search terms entered are stored temporarily in a session on the server, not in a cookie on the user\'s computer. This prevents manipulation of the cookie content.</li>
			</ul>';
// IV.3.2.2.e) Permalinks
		echo'
			<span id="anchor-permaLi" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />e) Activate Permalinks:</strong></p>
			<p>When this function is activated, a link symbol is displayed in each guestbook entry that is linked to the URL of the posting in question (default: deactivated).</p>
			<p>With this URL it is possible to call up a specifically selected entry without having to search through all entries.</p>
			<p>Especially in guestbooks, where e.g. questions on different topics are discussed, it is handy if user or admin can refer in their comments so quickly and easily to one of the previous entries by simply setting the link to the posting in question, without having to quote it completely and repeat it constantly.</p>';
//IV.3.2.3.	Konfiguration Upload
		echo'
			<span id="anchor-Upload" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2.3. Configuration file uploads:</strong></p>
			<p>Here you can make basic settings for the file upload, such as:</p>
			<ul>
				<li>the maximum size of the upload in MB (the absolute upper limit is determined by the "php.ini" on the server side, see "upload_max_filesize" and "post_max_size"),
				<li>the maximum width and height of the image in pixels (the maximum width of a photo is limited by the width of the guestbook minus certain internal distances).
				<li>The maximum number of files a user can upload for his entry can also be set here in the range from "1" to "10". The default setting after installation is "2". The (IP) lock for uploading files, that exceed the specified limit, is set to 20 minutes, after which the count starts again from the beginning.
			</ul>
			<p>To ensure that the automatic determination of the maximum possible width of an uploaded graphic file depends on the selected template, the names of the different pre-installed templates must not be changed!</p>';
//IV.3.2.4.	E-Mail settings
		echo'
			<span id="anchor-Thankyou" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2.4. E-mail settings and individual "Thank-you e-mail" to the guest</strong></p>
			<p>On a number of occasions, e-mails generated automatically by the <span class="italic">myPHP Guestbook</span> script are sent to the admin and - if released - to the guest who wrote a post in the guestbook. This concerns for example made backups, which are sent automatically to the admin by mail, but also hints about photo uploads or new entries written in the guestbook and some more.</p>
			<p>The basic prerequisite for this is that the "mail()" function implemented in PHP is active.</p>
			<p>Some providers disable or restrict this feature for their customers. If the mail() function is not available on the server side, the automatically generated e-mails cannot be sent by the program.</p>
			<p>Then there are the cases where providers restrict the mail() function so that it only works if an address is used as sender of such mails, which the customer has deposited as "official" mail address to the virtual host on which the script runs. To do this, you can simply save the corresponding e-mail address as the sender under the link "E-mail configuration".</p>
			<p>You can easily test the mail() function by using the possibility of sending a test e-mail on the "E-Mail Configuration" page.</p>
			<p>In the "General configuration" settings you can also specify whether a guest, if he or she has written an entry in the guestbook and entered his or her e-mail address, will automatically receive an e-mail from the program with a small "thank you".</p>
			<p>Under the above-mentioned link you will be shown which text the guest receives by default with this e-mail. You can customize the text according to your needs and wishes. The prerequisite is that the option "Send a \'Thank-you e-mail\' to the user" is activated.</p>
			<p><strong>Hint:</strong> The e-mail address shown here is displayed by the program as the <strong>sender\'s</strong> address for <strong>all</strong> automatically sent e-mails (e-mail header "From").</p>
			<p><strong class="red">NOTE:</strong> Select an e-mail address other than the one you specified as your admin e-mail address under the "Admin and login data" link. If necessary, simply set up another, otherwise unused e-mail address.</p>';			
//IV.3.2.5.	Weitere Konfigurationsmöglichkeiten
		echo'
			<span id="anchor-MoreKonfig" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2.5. Further configuration options ==><br />File "settings.inc.php", folder "includes":</strong></p>
			<p>If you open the "settings.inc.php" file, you can adjust other basic settings by changing individual values of the constants and variables stored there.</p>
			<p class="zentriert"><span class="red"><strong>Attention!</strong></span></p>
			<p><strong>Do not delete or remove any of the constants or variables there under any circumstances. This would cause a fatal error in the program flow! Make a backup copy of the original "settings.inc.php" file before saving any changes as a precaution!</strong></p>
			<p>Below the copyright notices you will first see a total of 8 constants that control the following:</p>
			<ul><li><span class="blue">SPAM_PROTECT</span> => Default: <span class="blue">true</span> (= enabled)</li></ul>
			<p>Enables or disables Spam protection.</p>
			<p><strong>Attention! Spam protection should ALWAYS be enabled, at least when using the guestbook on public pages that are freely accessible to everyone on the web (= true).</strong></p>
			<ul><li><span class="blue">PIC_CHECK</span> => Default: <span class="blue">true</span> (= enabled)</li></ul>
			<p>Enables or disables case-by-case review followed by separate approval of each newly uploaded image by the Admin.</p>
			<p><strong>Attention! The temporary blocking of a newly uploaded images should ALWAYS be activated, at least when using the guestbook on public pages that are freely accessible to everyone on the web (= true).</strong></p>
			<p>In the "General Configuration" settings will be displayed if the spam protection is disabled and/or uploaded graphic files are immediately displayed in the public area of the guestbook without prior verification and approval by the Admin.</p>
			<ul><li><span class="blue">CLEAN_CODE</span> => Default: <span class="blue">true</span> (= enabled)</li></ul>
			<p>Activating this constant ensures that the code generated with each new guestbook entry and stored in the database for unlocking or blocking this entry via admin email is automatically deleted after 30 days.</p>
			<ul><li><span class="blue">SCROLL_TO_TOP</span> => Default: <span class="blue">true</span> (= enabled)</li></ul>
			<p>Enables or disables the Javascript function "scrollIntoView", which causes the page to scroll to the top of the visible area when clicking on many internal links or buttons on index- and insert.php. "scrollIntoView" now works in all modern browsers, of course not in IE or other antiques.</p>
			<p>Some browsers, such as Firefox, do not properly process internal anchor jump targets on an IFrame embedded page (as of early 2021). However, "scrollIntoView" achieves the desired goal even in these browsers.</p>
			<ul><li><span class="blue">SCROLL_ON_INDEX</span> => Default: <span class="blue">true</span> (= enabled)</li></ul>
			<p>Enables or disables a button on the page with the guestbook entries (index.php), which is displayed at the bottom center of the page when scrolling down. When you click on this button, the page scrolls back up to the first entry. This function is also controlled by Javascript with "scrollIntoView". - Note: This function logically does not work if the guestbook is embedded via IFrame with automatic height adjustment.</p>
			<p>The difference between <span class="blue">SCROLL_TO_TOP</span> and <span class="blue">SCROLL_ON_INDEX</span> is essentially that <span class="blue">SCROLL_TO_TOP</span> is associated with references, which simultaneously make a change to the content by re-parsing the page or calling another page, while with <span class="blue">SCROLL_ON_INDEX</span> the content of the page remains unchanged and is not exited.</p>
			<ul><li><span class="blue">DISABLE_MYSQLI_CHECK</span> => Default: <span class="blue">true</span> (= No error display)</li></ul>
			<p>Makes sure that the display of MySQLi errors on the screen is turned off.</p>
			<p><strong>Attention! The error display should ALWAYS be deactivated in productive system operation for safety reasons (= true).</strong></p>
			<ul><li><span class="blue">ID_REG</span> => Default: <span class="blue">true</span> (= enabled)</li></ul>
			<p>Enables the PHP function "session_regenerate_id", which ensures that a new session ID is generated each time the user logs into the Admin Panel. (Protection against so-called "Session Hijacking")</p>
			<ul><li><span class="blue">GB_SEC_AUTH</span> => Default: <span class="blue">false</span> (= disabled)</li></ul>
			<p>Enables or disables 2-factor authentication to login to the Admin Panel.</p>
			<span id="anchor-MoreKonfig-02" class="sticky-anchor"></span>
			<p>Following the costants explained above, you will find further variables with which you can influence the following:</p>
			<ul>
				<li><span class="blue">$emojis_and_bbcodes</span> ==&#62; Number of Emojis displayed on "insert.php" when BBCodes are enabled.</li>
				<li><span class="blue">$only_emojis</span> ==&#62; Number of Emojis displayed on "insert.php" when BBCodes are disabled.</li>
				<li><span class="blue">$delete_spamIps</span> ==&#62; Number of days that an IP blocked due to spam remains stored in the database before it is automatically deleted.</li>
				<li><span class="blue">$session_lifetime</span> ==&#62; Time in minutes that the session is retained after logging into the admin panel before it is destroyed. (The input here has nothing to do with the renewal of the session during login, see above!)</li>
				<li><span class="blue">$recording_days</span> ==&#62; Number of days recorded in the database for daily statistics and displayed in the admin panel.</li>
				<li><span class="blue">$allowed_attemps</span> ==&#62; Allowed attempts of a login to the Admin Panel with incorrect access data before the login is automatically blocked.</li>
				<li><span class="blue">$barrier_days</span> ==&#62;	Number of days the login remains locked before it is automatically released again.</li>
				<li><span class="blue">$pw_minutes</span> ==&#62; Number of minutes that a password that was requested with the "Forgotten Password" function remains valid. (The input here has nothing to do with the three minutes until the second password expires when 2-factor authentication is activated!)</li>
				<li><span class="blue">$maxInputSearch</span> ==&#62; Maximum number of characters that can be entered in the search field.</li>
				<li><span class="blue">$minInputSearch</span> ==&#62; Minimum number of characters that must be entered in the search field.</li>
				<li><span class="blue">$maxSearch</span> ==&#62; Number of permitted uses of the search function in one hour.</li>
				<li><span class="blue">$maxSmilies</span> ==&#62; Total number of Emojis allowed in a Post (if control is activated under "General Configuration").</li>
				<li><span class="blue">$quoteFirst</span> ==&#62; When using the quote function, should the quoted entry be displayed before the guest\'s reply (==> true) or should the quoted entry be placed at the end of the reply (==> false)?</li>
			</ul>';
//IV.3.3. Templates	
		echo'
			<span id="anchor-Template" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.3. Template</strong></p>
			<p>The representation of the entries in the guestbook is decisively determined by the template used. To work with templates (edit and create), HTML skills are required (with restrictions, see below).</p>';
//IV.3.3.1.	Standard Template
		echo'
			<span id="anchor-StandTempl" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.3.1. Standard Template</strong></p>
			<p>Here all existing templates are displayed at a glance and can be changed by clicking on one of the corresponding radio buttons and then saving. The currently used template is marked.</p>
			<p>To facilitate the selection between the different pre-installed templates, views can be opened by clicking on the "Show example" button.</p>
			<p><strong><span class="red">TIP:</span></strong> For optical reasons, the preinstalled templates &quot;myPHP-GBook4_wide-R&quot;, &quot;myPHP-GBook4_wide2-R&quot; and &quot;myPHP-GBook4_black3-R&quot; should not be selected with a guestbook width of less than 600px, because otherwise the left column with names etc. can become too narrow depending on the entry.</p>
			<p><strong><span class="red">TIP:</span></strong> The pre-installed template "myPHP-GBook4_color-R" allows you to change the frame color around a guestbook entry under the link "Edit template" and the selection "myPHP-GBook4_color-R" to change as desired.</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>Each of the thirteen pre-installed templates requires one of the thirteen matching CSS styles. The corresponding styles have the same names as the templates. If a template is used without the corresponding style, it can lead to display errors, which do not cause any damage (except in the eye of the viewer), but disturb the appearance of the guestbook. For this reason, a warning symbol <img src="'.$url.'images/ausruf.png" height="14" width="14" alt="" /> is displayed when you select a template unless the corresponding CSS style of the same name has also been selected. So if you change a template, you should always set the corresponding style in a second step, then the warning symbol disappears.</p>';
//IV.3.3.2.	Edit Template
		echo'
			<span id="anchor-EditTempl" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.3.2. Edit Template  (incl. font and font size, text colors, width, backgrounds etc.)</strong></p>
			<p>The individual templates can be customized according to your wishes. Use the appropriate link to call up the template you use for editing, the further procedure is self-explanatory.</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>For an adjustment of the basic settings of background colors for the entire guestbook page and the guestbook entries, for the insertion of a background image, for changes of the font size and color, the maximum width of the guestbook and its orientation on the website (right-left-centered), as well as the color of the active rating stars and other icons, the CSS code should and need not be changed. These settings can be made faster and easier under "Edit Template".</p>
			<p><strong class="red">TIP:</strong> You can also set a different font here (default: Arial). In the drop-down menu, the 9 families of fonts considered to be sufficiently "web-safe" are available for free selection. - If this is not enough for you and therefore you want to have access to another font not included in the menu, do the following:</p>
			<ul>
				<li>Open the file "fonts.inc.php" in the directory "includes" with an editor.</li>
				<li>Add the desired font to the two arrays shown there.<br />
					Make sure that the syntax is correct!<br /><strong>In the first array: <span class="blue size-16">[ \' ... , ... , ... \' ,  \' ... \' ],</span><br />and in the second: <span class="blue size-16">\' ... , ... , ... \'</span></strong><br />
					If you add the new font in the second array after the existing last one, don\'t forget to put a comma behind the penultimate line!<br />
					You can also omit the addition in the second array if your system is running on PHP 5.5 or higher.</li>
				<li>Save changes and upload the file again.</li>
			</ul>';
//IV.3.3.3.	Template erstellen
		echo'
			<span id="anchor-MakeTempl" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.3.3. Create Template</strong></p>
			<p>This option can only be used to the full extent if HTML knowledge is available, as the entire appearance of the guestbook entries can be determined by the user here.</p>
			<p>Note that the HTML code you insert is only intended for one entry and repeats itself with each subsequent entry. So you can\'t insert the code of a whole HTML page there.</p>
			<p>If you have created a basic HTML code framework, you need to use the guestbook variables in the right place. For example, <span class="blue">&lt;$name$&gt;</span> is the placeholder for the guest\'s name, who writes a post in the guestbook.</p>
			<p>For beginners it is recommended to edit existing templates and to adapt them according to your wishes. Previews for self-made templates do not work, of course.</p>';
//IV.3.3.4. Template löschen
		echo'
			<span id="anchor-DelTempl" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.3.4. Delete Template</strong></p>
			<p>Unused templates can be deleted here simply and permanently(!).</p>
			<p>However, I recommend that you do not delete any of the pre-installed templates, unless the corresponding CSS style is also removed.</p>
			<p>To avoid accidentally deleting all templates, you cannot remove the last template in the database.</p>
			<p>If one or more templates should have been deleted and later the wish to restore them arises, this can be done with the diagnosis and repair tool of <span class="italic">myPHP Guestbook</span> without any problems. See the <a href="#anchor-Repair">Section IV. 4, "Diagnostic and Repair Tool"</a> for more details.</p>';
//IV.3.4. CSS
		echo'
			<span id="anchor-Styles" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.4. CSS style</strong></p>
			<p>Besides the template used, the appearance of <span class="italic">myPHP Guestbook</span> is also determined by the CSS style used.</p>
			<p>If you don\'t know exactly what CSS is, you should definitely take a look at tutorials (you can find them on the Internet) to get some basic knowledge.</p>';
//IV.3.4.1. Standard Style
		echo'
			<span id="anchor-StandStyle" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.4.1. Standard Style</strong></p>
			<p>All existing styles are displayed here at a glance and can be changed by clicking on one of the corresponding radio buttons and then saving. The currently used style is marked.</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>Each of the thirteen pre-installed CSS styles requires one of the thirteen matching templates. The corresponding templates have the same names as the styles. If a style is used without the corresponding template, it can lead to display errors, which do not cause any damage (you know: except in the eye of the viewer), but disturb the appearance of the guestbook. For this reason, a warning symbol <img src="'.$url.'images/ausruf.png" height="14" width="14" alt="" /> is displayed when you select a CSS style unless the corresponding template of the same name has also been selected. So if you change a style, you should always set the corresponding template in a second step, then the warning symbol disappears.</p>';
//IV.3.4.2. Edit Style
		echo'
			<span id="anchor-EditStyle" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.4.2. Edit Style</strong></p>
			<p>If you want to make small changes to the style, you can edit an existing style here.</p>
			<p>Make sure that you choose the right class for the template you are using!</p>
			<p>In style, you can use some variables that are described on the "Create style" or "Edit style" pages under the text field for input. The contents of these variables are recorded in the respective template and are also changed there (see above under "Edit template").</p>
			<p><strong class="red">TIPP:</strong> Individual changes in the external CSS file can and should be avoided in order to avoid unnecessary problems and work during a later update. Anything that you want to do differently on the CSS can and should be done with the corresponding entries under "Edit Style". Since this CSS is called and processed after the external file, everything that is in it and may conflict with individual codes in the external file is treated as a priority and overwrites the statements from the external file.</p> 
			<p><strong><span class="red">TIP:</span> Here are a few CSS code examples of layout changes that are asked over and over again:</strong></p>
			<p>First click on "CSS-Style" &#62; "Edit Style" and open the style you are currently using by clicking on the "Edit" button. At the end of the existing style, insert and save the alternatively desired code:</p>
			<p><strong>Font color:</strong></p>
			<p>a) Guestbook entries black text, description of the form fields on the "insert.php" bright text:</p>
			<ul>
				<li>Settings for text color of the guestbook entries under "Edit template", for the light font (only) on the "insert.php" insert in the CSS code:<br />
				<span class="blue">.insert-table { color:#f2f2f2; }</span></li>
			</ul>
			<p>b) Changing the colors for the text links to the entry page and the page numbers for scrolling above and below the guestbook entries:</p>
			<ul>
				<li>In the example below the link is blue (= #0000ff) in normal state and red (= #ff0000) in active state:<br /> 
				<span class="blue">.this-page,.navi-page:link,.navi-page:visited { color:#0000ff; }<br />
				.navi-page:hover,.navi-page:active { color:#ff0000; }</span></li>
			</ul>
			<p>c) Remove text shadows at the link to the entry page and the page numbers for browsing through the pages with the guestbook entries:</p>
			<ul>
				<li style="list-style:none;"><span class="blue">.this-page,a:link.navi-page { text-shadow:none; }</span></li>
			</ul>
			<p>d) Change the font and background color of the html button to the entry page:</p>
			<ul>
				<li>In the example below, the background color of the button is dark blue (= #3300ff), the font color is white (= #fff):<br />
				<span class="blue">a:link.insert-button,a:visited.insert-button { color:#fff; background-color:#3300ff; background:#3300ff; }</span></li>
			</ul>
			<p><strong>Layout entry fields:</strong></p>
			<p>a) The input fields and the text area field are given a gray frame with an appropriate outer shadow when the cursor is placed. A color-matched shadow is also shown in the field where the guest can click if he wants to be informed about an answer to his post by e-mail. The colors of frames and shadows can be customized as follows:</p>
			<ul>
				<li>No shadow, unchanged frame color:<br />
				<span class="blue">.insert:focus, textarea:focus, .comment-info { border:solid 1px #9e9e9e; -webkit-box-shadow: 0 0 0 0; -moz-box-shadow: 0 0 0 0; box-shadow: 0 0 0 0; }</span><br /><br /></li>
				<li>For a white frame with shadow (for black/very dark backgrounds):<br />
				<span class="blue">.insert:focus, textarea:focus, .comment-info { border:solid 1px #f2f2f2; -webkit-box-shadow: 0 0 5px 4px rgba(255,255,255, 0.3); -moz-box-shadow: 0 0 5px 4px rgba(255,255,255, 0.3); box-shadow: 0 0 5px 4px rgba(255,255,255, 0.3); }</span><br /><br /></li>
				<li>For a green frame with shadow:<br />
				<span class="blue">.insert:focus, textarea:focus { border:solid 1px #00cc66; -webkit-box-shadow: 0 0 5px 4px rgba(31,248,20, 0.12); -moz-box-shadow: 0 0 5px 4px rgba(31,248,20, 0.12); box-shadow: 0 0 5px 4px rgba(31,248,20, 0.12); }</span><br /><br /></li>
				<li>For a red frame with shadow:<br />
				<span class="blue">.insert:focus, textarea:focus{ border:solid 1px #ff0000; -webkit-box-shadow: 0 0 5px 4px rgba(219,28,28, 0.12); -moz-box-shadow: 0 0 5px 4px rgba(219,28,28, 0.12); box-shadow: 0 0 5px 4px rgba(219,28,28, 0.12); }</span><br /><br /></li>
				<li>For a blue frame with shadow:<br />
				<span class="blue">.insert:focus, textarea:focus { border:solid 1px #0066ff; -webkit-box-shadow: 0 0 5px 4px rgba(0,0,255, 0.12); -moz-box-shadow: 0 0 5px 4px rgba(0,0,255, 0.12); box-shadow: 0 0 5px 4px rgba(0,0,255, 0.12); }</span></li>
			</ul>
			<p>b) Change the background- and font color of the input fields:</p>
			<ul>
				<li>In the example below, the background color is dark-gray (= #424242), the font color is white (= #fff):<br />
				<span class="blue">textarea, textarea:focus, .insert, .insert:focus, .no-insert:focus, .gb-info, .search-insert, .search-icon, .search-button { color:#fff !important; background-color:#424242 !important; }</span></li>
			</ul>';
		echo'
			<p><strong>Others:</strong></p>
			<p>a) Shadows around posted images and rounded corners:</p>
			<ul>
				<li><span class="blue">img.add-on { -webkit-border-radius:3px; -moz-border-radius:3px; -khtml-border-radius:3px; border-radius:3px; -webkit-box-shadow:0px 0px 10px #474747; -moz-box-shadow:0px 0px 10px #474747; box-shadow:0px 0px 10px #474747; }</span></li>
			</ul>
			<p>b) Icon for external links partially or completely remove:</p>
			<ul>
				<li>Websites referenced by a link contained in a guestbook entry will be opened in a new browser window when you click on it. It has become common practice to display a corresponding icon to the user when a link refers to an external website. This also happens with the <span class="italic">myPHP Guestbook</span>, where every link in a guestbook entry is automatically preceded by the symbol: <img class="img-ok" src="../images/link-sym.png" width="14" height="12" alt="" />.<br /><br /></li>
				<li>If you want to work "cleanly" in this area, you should make sure that any links to a target of <strong>your own website</strong> are not marked. This is done by simply inserting the following code into the CSS:<br /><span class="blue">a.external[href^="http(s)://www.your-website.com"] { padding:0; background:none; }</span><br /><br /></li>
				<li>If you want to remove the symbol <strong>completely</strong>, insert the following:<br /><span class="blue">a.external[href^="http:"],a.external[href^="https:"] { padding:0; background:none; }</span></li>
			</ul>
			<span id="anchor-rgba" class="sticky-anchor"></span>
			<p>c) Semi-transparent font, backgrounds or frames:</p>
			<ul>
				<li>Sometimes there is a need for semi-transparent objects, e.g. if you want to put a background color over a background image to make a font easier to read, but where the image should still shine through.<br /><br /> 
				This can also be done quickly and easily with CSS, and for some years now with RGBA. RGBA is supported by all modern browsers (Edge, IE&nbsp;>=&nbsp;9, Chrome&nbsp;>=&nbsp;1.0, FF&nbsp;>=&nbsp;3.0, Safari&nbsp;>=&nbsp;3.1, Opera&nbsp;>=&nbsp;10.0).<br /><br />
				On the pages in the admin panel: "CSS Style" => "Edit style" and => "Create new style" you will find a small tool to easily create the required code. Proceed as follows:<br /><br />
				<ul>
					<li>Select the desired color or shade of gray in the color table under the button "Selection of web-safe colors and shades of gray" and copy the corresponding hexadecimal code.<br /><br />
					<li>Insert the hexadecimal code into the input field with the example default "#ffffff".<br /><br />
					<li>In the drop-down menu next to it, select the desired opacity of the color or shade of gray. The lower the opacity, the higher the transparency.<br /><br />
					<li>Click the button: "Convert Hex. to RGB(A)".<br /><br />
					<li>Below you will see the generated RGB color code identical to the selected hexadecimal color code and as a fourth element the alpha channel with the selected transparency level.<br /><br />
					<li>Copy the RGBA code and paste it into your CSS like the hexadecimal code. Example for semi-transparent white background:<br /><span class="blue">background-color:rgba(255, 255, 255, 0.5);</span>
				</ul>
			</ul>
			<p class="zentriert"><br /><strong>Attention!</strong></p>
			<p><strong>The variables used in the preinstalled CSS code should remain unchanged in order not to destroy the setting options under "Edit template".</strong></p>';
//IV.3.4.3. Style erstellen
		echo'
			<span id="anchor-MakeStyle" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.4.3. Create Style</strong></p>
			<p>For users with the appropriate knowledge of CSS, this feature allows you to create your own style from scratch.</p>';
//IV.3.4.4. Style löschen
		echo'
			<span id="anchor-DelStyle" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.4.4. Delete Style</strong></p>
			<p>Styles that are not needed can be deleted here simply and permanently(!).</p>
			<p>However, I recommend that you do not delete any of the preinstalled styles, unless the corresponding template is also removed.</p>
			<p>To avoid accidentally deleting all styles, you cannot remove the last style in the database.</p>
			<p>Should one or more styles have been deleted and later the desire to restore them arises, this can be done with the diagnosis and repair tool of <span class="italic">myPHP Guestbook</span> without any problems. See <a href="#anchor-Repair">Section IV. 4, "Diagnostic and Repair Tool"</a> for more details.</p>';
// IV.3.5. Banner
		echo'
			<span id="anchor-banner" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.5. Banner and individual greeting text</strong></p>
			<p>With the check box "Activate banner" in the "General Configuration" settings you activate the display of a banner and/or - depending on your wish - an introductory text on the public pages "index-" and "insert.php".</p>
			<p>As a sample, two banners are already included in the download, the data of which was saved during the installation. Of course, every user is free to design and use his or her own banner.</p>
			<p>The banner is linked to the displayed URL. If the visitor clicks on the banner, he/she will be directed to the corresponding page. The title is displayed when the banner is moved over with the mouse. The (optional) greeting text can be up to 1000 characters long and can be formatted with BBCodes.</p>
			<p>If the guestbook is integrated into a separate page by "include", the insertion of such a banner is pointless (as with an integration by "iframe"). Activation of the "banner" function is therefore ineffective if you use the supplementary files from the "include" download.</p>';
// IV.3.5.1. Banner anzeigen, editieren, löschen
		echo'
			<span id="anchor-ShowBanner" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.5.1. Show, edit and delete banners</strong></p>
			<p>On the "Show banner" page, the banners entered in the database are displayed with the associated texts.</p>
			<p>The active banner displayed on the guestbook page is marked with a green check mark, the inactive banner(s) with a red cross. A click on the red cross of the banner you want to activate changes the status.</p>
			<p>By clicking on the edit icon you can change the welcome text, the URL under which the banner is linked and the title of the banner. If you do not want a greeting text, simply delete the pre-formulated text and leave the field blank.</p>
			<p>Finally, clicking on the delete icon deletes the corresponding banner, including the image file on the server, from the database.</p>
			<p>Only banners that are not activated can be deleted.</p>';
// IV.3.5.2. Banner hinzufügen
		echo'
			<span id="anchor-PlusBanner" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.5.2. Add banner and/or welcome text</strong></p>
			<p>To add your own banner, simply load the desired image file (format: *jpg, *png or *gif) into the directory "banner" of the guestbook folder.</p>
			<p>In the drop-down menu the name of the newly uploaded file is displayed and can be selected. As soon as you click on "Save file name", the data of the banner (file name, width and height) are saved in the database and the file is marked as "selected".</p>
			<p>At the same time, the URL of your website, a title to the banner and a greeting text are saved.</p>
			<p>In the lower third of the page "Add banner" you can also specify by selecting the marked checkbox that only a welcome text is captured as a banner without using a graphic at the same time.</p>
			<p>You can then change all texts individually by switching to the "Show banner" page and clicking on the "Edit" editing icon there, see above.</p>';
//IV.3.6. Smileys
		echo'
			<span id="anchor-Smilies" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.6. Smileys/Emojis</strong></p>
			<p>Smileys are standard in guestbooks and forums. This feature is also available in <span class="italic">myPHP Guestbook</span>.</p>
			<p>Smileys work like this:</p>
			<p>Each smiley has its own BBCode (the BBCode for an angry smiley is e.g. ":angry:", which can be changed of course). If now in the guestbook ":angry:" in an entry was written and smileys are activated in the guestbook, instead of ":angry:" the picture of the angry smiley appears.</p>
			<p>The "normal" user will insert a smiley into his or her text by simply clicking on it, if he or she has not switched off Javascript in his or her browser. The smiley appears after clicking on it where the cursor of the mouse was previously in the text.</p>';
//IV.3.6.1. Show Smileys
		echo'
			<span id="anchor-ShowSmil" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.6.1. Show smileys</strong></p>
			<p>All existing smileys are displayed here for the overview and can be deleted or edited if necessary.</p>';
//IV.3.6.2. Smiley hinzufügen
		echo'
			<span id="anchor-PlusSmil" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.6.2. Add smiley</strong></p>
			<p>If the pre-installed smileys are not enough or you don\'t like them, you can upload your own smileys here and define BBCode and other properties.</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>The first 12 (or 19) smileys shown on the guestbook entry page ("insert.php") after or instead of the BBCodes and the drop-down menus have a size of 15 x 15px. If you insert other smileys with different sizes, especially those with a width of more than 15px, this can lead to unattractive line breaks for the layout. One solution might be to open the file "functions.inc.php" from the directory "includes" and assign a smaller number to the variables "<span class="blue">$emojis_and_bbcodes</span>" and "<span class="blue">$only_emojis</span>", e.g. only 10 / 17 pieces or even less.</p>';
//IV.3.6.3. Smileys löschen
		echo'
			<span id="anchor-DelSmil" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.6.3. Delete smileys</strong></p>
			<p>Smileys that you don\'t like can be deleted easily under "Show smileys". Use checkboxes to quickly and easily mark the smileys you want to remove.</p>';
//IV.3.6.4. Edit Smileys
		echo'
			<span id="anchor-EditSmil" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.6.4. Edit smileys</strong></p>
			<p>This feature is very helpful when making small changes to smileys. For example, the BBCode can be changed without deleting and adding the smiley.</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>If you subsequently change the BBCode of a smiley, remember that all smileys inserted in existing guestbook entries will no longer be displayed as a graphic with the "old", modified BBCode.</p>';
//IV.3.7. Badwords
		echo'
			<span id="anchor-Badwords" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.7. Badwords and their replacement</strong></p>
			<p>With this function you can censor insults and other unwanted words in the guestbook.</p>
			<p>Although censorship can also be circumvented by tricks, it does provide initial protection.</p>
			<p>In the versions from 3.2.x onwards, the "badwords" were replaced by a freely selectable substitute word determined by the admin, whereby this text change on the public guestbook page was not recognizable for third parties. In my opinion, it is unacceptable to exchange parts of a text published by third parties without any notice, even if it is only an undue part of the text, such as e.g. verbal abuse or the like. As a result, "Badword" filtering has been changed to replace unwanted words/terms you have entered in the database with stars (***).</p>
			<p><strong><span class="red">TIP:</span></strong> Use the possibilities of this filter carefully! The filter also recognizes terms that are only part of a word and filters them out.</p>
			<p>For example, if you don\'t want the word "shit" to appear suddenly in a post on your page, just enter the badword in the list. The filter replaces "shit" in "***" and "shitstorm" in "***storm".</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p><strong>The pre-installed "Badwords" are intended for use on German-speaking websites. Check them for your needs.</strong></p>';
//IV.3.7.1. Badwords anzeigen und löschen
		echo'
			<span id="anchor-ShowBadw" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.7.1. Show and delete Badwords</strong></p>
			<p>See all unwanted words (badwords) here. If you want to delete badwords, select the badwords you want to delete and click on "Delete all checked".</p>';
//IV.3.7.2. Badwords hinzufügen
		echo'
			<span id="anchor-PlusBadw" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.7.2. Add Badwords</strong></p>
			<p>To replace words, they must be stored in the database first.</p>
			<p><strong><span class="red">TIP:</span></strong> Make sure that the word consists of at least 3 characters, otherwise it can easily happen that strings of letters are replaced within normal words.</p>';
//IV.3.8. Spamfilter
		echo'
			<span id="anchor-Spamfilter" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.8. Spam filter</strong></p>
			<p>Spam protection in v.3.x, which replaced the unspeakable captcha, was based solely on monitoring one control feature and was quite successful.</p>
			<p>But I also had reports from users, where it was not enough and which partly received several spam entries every day.</p>
			<p>The new spam protection handles both the previous successful method and a number of other checks, of which the critical check for certain keywords, which I call "spam words", is only one aspect. This way, the filter can be easily extended at a later date if required.</p>
			<p>If you are interested in the details, you may want to have a look at the source code of the corresponding file, for the "normal" user I think it is important to know the following for better handling:</p>
			<p>The spam filter works with a system of "penalty points". This means that it captures certain typical characteristics of spam and then assigns points for them.</p>
			<p>For example, each entry is searched for spam words from the list when clicking on the "Save" button and each detected spam word is scored with one penalty point. The links contained in a post are also counted and penalized with one (additional) penalty point each time a maximum limit (adjustable in the configuration settings) is exceeded.</p>
			<p>This and a number of other checks are carried out automatically by the spam filter, whereby some spamming features, such as the previous spam protection, are scored with 5 points in one fell swoop, while others are scored with only 1 point, depending on their relevance. (For example, not every post containing the word "Viagra" is always spam.)</p>
			<p>All penalty points are added by the program. If the sum of "penalty points" exceeds certain limits, a distinction is made:</p>
			<ul>
				<li>If the maximum limit is exceeded, the contribution will be discarded immediately, i.e. it will not be saved. The IP address of the sender is saved and blocked for immediate recall of the entry page. An e-mail is sent to the admin, informing him/her about the number of "penalty points" determined by the program and the criteria from which the individual "penalty points" were formed.
				<li>If the program detects "penalty points" by spam-suspicious contents, but these do not reach the critical limit in total, the contribution is stored in the database, but marked as "deactivated". This means that the post is present, but not visible in the public area. Once again, an e-mail is sent to the admin with the content of the post, the determined "penalty points" and their cause(s), as well as a link to the possible activation of the blocked post by e-mail.
				<li>If no spamming features are detected, everything remains as usual: the post is saved normally and -depending on the configuration settings- is either released immediately or blocked according to your specifications. As usual, an e-mail with the content of the post will be sent to the admin (unless you have explicitly deactivated this function), who also has a link to the "remote lock" of the posted post by e-mail as a precaution.
				<li>The above mentioned "upper limit" of admissible "penalty points", which must not be exceeded, can be set in the configuration settings of the admin panel in the range between "1" as minimum value and "20" as maximum value by yourself. - After installation, the default setting is "5".
				<li>The also mentioned "upper limit" of unsuspicious links in a post can also be set in the configuration settings of the admin area between "0" (=each link is suspicious) and a maximum of "20". - After installation, the default setting is "2". The link check does not take into account the visitor\'s homepage entered in the corresponding column and only checks entries in the text field; it recognizes and counts links in the form of: "http://www.example.org" as well as in: "www.example.org" or in: "http://example.org" and finally in "[url=http://www.example.org]LINK[/url]".
				<li>Checking an entry for spam words and checking the number of links set in the text message can be switched off completely in the configuration settings.
			</ul>
			<span id="anchor-disableSpam" class="sticky-anchor"></span>
			<ul>
				<li><strong>Note:</strong> Other parts of the spam protection can be disabled by disabling certain variables. To do this, open the file "spamfilter.php" in the directory "includes", there the first three variables below the copyright notice.<p>The checks for spam words and for the number of set links in posts can be switched off under "General configuration".</p><p>The <strong>complete</strong> spam protection is not intended to be deactivated. However, this is still possible in individual cases. See <a href="#anchor-MoreKonfig">Section IV. 3.2.5, "Further configuration options ..."</a> for more details.</p>
			</ul>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p><strong>The pre-installed "spam words" are intended for use on German-speaking websites. Check them for your needs.</strong></p>';
// IV.3.8.1. Spam Basics
		echo'
			<span id="anchor-SpamBasics" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.8.1 Basic principles of spam protection</strong></p>
			<p>What is the purpose of spam? Usually, links to other website should be distributed as quickly and as widely as possible. For some time now, however, there have also been cases where, instead of links, certain keywords (e.g. company or brand names) have been repeatedly placed dozens of times in otherwise largely meaningless texts, presumably specifically for search engines. To achieve this, so-called bots are usually used, i.e. small programs that automatically search the WWW for forms with the possibility of entering such links or keywords.</p>
			<p>This mode of operation, which is designed for speed and mass, makes it possible to search specifically for specific characteristics and to take appropriate defensive measures, which can then also be automated, as here with the "spam filter".</p>
			<p>Everything that is automated can be bypassed. - The currently spread spam bots through the spam filter, the spam filter through spam bots "programmed" on it. Even though I am not aware of such things so far, the whole thing is likely to be a matter of time. What remains, however, is the goal of such bots: to spread links or certain terms on a massive scale.</p>
			<p>This provides effective spam protection against unwanted links: preventing the entry of such URLs (which at the same time most effectively keeps away the human spammers that can be found from time to time).</p>
			<p>How do you do that? Three simple options:</p>
			<ul>
				<li>In the "General configuration" settings select the check box for: "<span class="italic">Entries must be approved</span>", i.e. change to a moderated guestbook. - This does not prevent the saving of such entries, but prevents their publication without the permission of the admin.<br /><br /></li>
				<li>Another alternative: In the "General configuration" settings <strong>de</strong>activate the BBCodes and activate the checkbox for "Hide entry field for homepage address". - Posting of any links by a guest is impossible, but no more photos can be uploaded or other BBCodes can be used.<br /><br /></li>
				<li><strong>However, the more elegant way in my eyes is a different one:</strong> In the "General configuration" settings activate the checkboxes for "<span class="italic">Detect and prevent spam by the number of links in posts</span>" <strong>and</strong> "<span class="italic">Hide entry field for homepage address</span>" <strong>and</strong> set the "<span class="italic">Number of unsuspected links in posts</span>" to "0". - This allows you to continue using BBCodes, but no links can be published in the guestbook. The end of the story :-)</li>
			</ul>
			<p>Meaningless entries with constantly repeated keywords are effectively combated by adding the keyword(s) used to the spam word list.</p>';
//IV.3.8.2. Spamwords anzeigen und löschen
		echo'
			<span id="anchor-ShowSpamWo" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.8.2 Show and delete SpamWords</strong></p>
			<p>Typical spam words or word groups are displayed here and can be deleted by selecting them.</p>
			<p>If all spam words in the list are deleted, the "Detecting and preventing spam with keywords in posts" function in the configuration settings is automatically deactivated. If one or more spam words are added to the list at a later date again, please do not forget to re-enable the spam word check in the configuration settings. A warning message is displayed on the spam words page.</p>';
//IV.3.8.3. Spamwords hinzufügen
		echo'
			<span id="anchor-PlusSpamWo" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.8.3 Add SpamWords</strong></p>
			<p>Once a spam bot has managed to overcome all the tests of the spam filter and smuggle his senseless word garbage into your guestbook, take a good look at the text.</p>
			<p>You will usually find some terms which are repeated several times and which appear in "normal" texts of "real" guestbook writers either not at all or only occasionally. Save this word or even a phrase here in the database for future control by the filter.</p>
			<p><strong><span class="red">TIP:</span></strong> Upper and lower case letters are not important for checking a post for spam words if the keyword is stored in lower case in the corresponding "Spam Word List"; if it is written in upper case there, it will not be found as a match in the text to be checked. So always save everything in lower case in the spam word list.</p>
			<p>In addition, a "normal" spam word entered in the list will also be recognized in a guest\'s post if it is only part of a word. If, for example,"sex" is stored as a keyword in the spam list, the program recognizes in the text ...</p>
			<p class="zentriert italic">&quot;Peter received the award as sexiest man alive,<br />although he is as sexy as Donald Duck and never had SEX.&quot;</p>
			<p>... three spam words and assigns three penalty points, regardless of whether "sex" in the text is written in capital letters or small letters and once only as part of a word or with an attached "y". Whoever wants to prevent this in an individual case, enters the keyword in the list with a space before and after it, i.e. (of course without the quotation marks): " sex ". Then the program only searches for it.</p>
			<p>But watch out, as with the "Badword filter": think first, then act. If a keyword with a space before and behind it is included in the spam word list, it will not be recognized by the program if it is inserted at the beginning of the sentence (no space before it) or at the end of the sentence (no space after it).</p> 
			<p><strong><span class="red">TIP:</span></strong> A spam word can be entered several times in the corresponding list and thus be weighted correspondingly higher, because it is counted as a spam feature just as often in the case of multiple entries.</p>
			<p>Example: If the word "sex" is saved twice in the spam word list and a guestbook entry contains the word "sex" only once, two "penalty points" will still be registered immediately.</p>';
//IV.3.8.4. IP-Sperre nach Spameintrag
		echo'
			<span id="anchor-ShowIpBar" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.8.4 IP lock after spam entry</strong></p>
			<p>As noted above, the IPs under which a spammer has written to your guestbook are automatically saved in this list, if the spam message was so stupidly, that it was immediately rejected by the spam filter and storage was prevented. Since v. 4.7.1, this is the only remaining place in the program, where an IP address is stored in plain text and not as an unidentifiable hash algorithm. All the IPs entered here are then prevented from accessing the entry page again.</p>
			<p>Spambots, however, usually work with dynamic, i.e. changing IPs. The lock works only for a limited period of time until the robot comes back over another IP, which is why it usually makes no sense to store the locked IPs permanently, especially since a list that is too long would eventually suffer performance problems.</p>
			<p>Therefore, IPs in the revocation list are automatically deleted after '.$delete_spamIps.' days with the next call of insert.php.</p>
			<pIf an IP is to remain stored longer for any reason, this is possible by clicking the green check mark behind the IP concerned; the check mark then changes to a red cross as a sign of the permanent block. Clicking again cancels the process.</p>
			<p>Of course, you can also manually delete a blocked IP from the list by selecting it.</p>
			<p>Finally, the guestbook can be configured so that no IPs are processed, not even IPs under which a spam entry was made. See above <a href="#anchor-noIp">Section III.5.3</a>.</p>';
//IV.3.9. Backup
		echo'
			<span id="anchor-Backup" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.9. Backup</strong></p>
			<p>Who wants to lose all your guestbook entries through a server crash or something like that?</p>
			<p>To protect yourself from this, you can use this function to create back ups and restore damaged or deleted posts from such a back up.</p>
			<p><strong><span class="red">TIP:</span> It is always advisable to create a current BackUp after every new entry in the guestbook.</strong></p>
			<p><strong>If you manage the backups on the server, i.e. the function "Delete backups from the server after sending them by e-mail"? has <span class="italic">not</span> been activated, a warning message in the form of the Icon: <img src="'.$url.'images/ausruf.png" height="14" width="14" alt="" /> will be displayed at the beginning of the central page for managing the "Entries and Comments", if the last BackUp is older than the last guestbook entry. Just click on this icon to create a current BackUp.</strong></p>
			<p>Since v.4.5.4 the BackUp-function of the <span class="italic">myPHP Guestbook</span> not only saves the contents of the table "entries" with the guestbook entries, but also the contents of the table "pictures" with file names, image sizes, title designations etc. of photo uploads and restores them if necessary.</p>
			<p><strong>NOTE:</strong> The files uploaded to the folder "img_guest" can and will <strong>NOT</strong> be backed up in this way! The photos stored in this folder should be downloaded at regular intervals via FTP and stored on your own PC for security reasons</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>Generally, errors can occur if you want to recover from a backup that was not created with the same guestbook version. However, full compatibility is usually given between BackUps from version 3.0.0 to version 4.5.3, then again from version 4.5.4 to version 4.5.6, from version 4.6.0 to version 4.6.3 and finally from version 4.7.0 upwards.</p>
			<p>Errors will occur if you have created a backup under a version smaller than 3. x and want to restore from this version on 3. x or higher without further editing. Usually these problems are caused by the use of another prefix: Up to v.2.0.5 the prefix "myphpgb" was used by default, from version 3.0.0 the prefix is "guestbook". To solve this, you have to change/replace the old prefix in your backup file with a good text editor.</p>
			<p>As of version 3. x, backups were automatically deleted from the server when logging out of the admin area, so that the previously created backup had to be downloaded to your own computer and, if necessary, uploaded from there again. One of the consequences was that management with mobile devices was virtually impossible.</p>
			<p>Since version 4.1, this has been solved as follows: Backup files now remain in the corresponding backup folder on the server, protected against unauthorized download or unauthorized access with a corresponding ".htaccess" file (included in the package).</p>
			<p>BackUps remain in place up to a maximum of 3 backups, the older backups that exceed this limit are automatically deleted.</p>
			<p>In order to restore damaged or lost entries in the guestbook, the desired BackUp file can then be determined by a click and used directly by the server, which ultimately means that this can also be done on the go and not only at home on your home computer. As additional security, a copy of the backup will be sent to the admin via e-mail.</p>
			<p>The backups are zipped automatically (important because of the e-mail distribution), restores can be done directly from the zipped file. If the gzip module is not available in your webspace, the program will also create and process unzipped versions.</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>If your provider should not allow the use of htaccess files, so that the backup files on the server cannot be protected from third party access, it is possible and in this case it is strongly recommended to prevent the backups from being saved on the server by a corresponding setting on the "General configuration" page; in case of an emergency, the backups sent by e-mail must be used (and you should change your provider). - The default setting after installing this version is: "Save backups on the server".</p>';
//IV.3.9.1. BackUps verwalten
		echo'
			<span id="anchor-BackUpEdit" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.9.1. Manage backups and restore entries</strong></p>
			<p>Restoring contributions from a backup you have created is child\'s play:</p>
			<p>Select the backup you want from the backup list (sorted by date and time) and click the "Restore" button. <span class="italic">myPHP Guestbook</span> then inserts the old guestbook entries and the old entries from the table "_pictures" back into the database.</p>
			<p>If you want to use an older version of a backup: Upload the desired backup file via FTP into the backup folder on the server. Go to the BackUp List page in the Admin Control Panel or reload the page. You can now see the file name of the newly loaded file in the BackUp directory in the appropriate drop-down menu. Select it and save the file name in the backup list to access and use the file.</p>
			<p class="zentriert"><strong>Attention!</strong></p>
			<p>All entries in the tables "_entries" and "_pictures", which existed at the time of a restore from a backup, are deleted and filled with the data from the backup file. However, if the BackUp used for the recovery should come from one of the previous guestbook versions < 4.5.4, the contents of the table "_pictures" remain unchanged, i.e. it will not be deleted, because there is nothing in the older BackUp files, with which the table "_pictures" could be filled again. After updating from a guestbook version < 4.5.4 to version 4.5.4 (or higher), you should create a new backup immediately, so that there is also a backup file of the table "_pictures" and can be used if necessary.</p>';
//IV.3.9.2. BackUp erstellen
		echo'
			<span id="anchor-MakeBackUp" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.9.2. Create Backup</strong></p>
			<p>To create a current backup of the database tables with your guestbook entries and the contents of the table "_pictures", you only need to select this option.</p>
			<p>The backup is stored on the server and a zipped copy will be sent to you via e-mail as described above.</p>';
//IV.3.10. Statistik
		echo'
			<span id="anchor-Statistik" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.10. Statistic</strong></p>
			<p>To give you an overview of how often your guestbook has been called up, a small statistic is built into <span class="italic">myPHP Guestbook</span>.</p>
			<p>This works like many other features only if you have activated the statistics under "General configuration". The default setting after installation is deactivated.</p>';
//IV.3.10.1. Statistik anzeigen
		echo'
			<span id="anchor-ShowStats" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.10.1. Show Statistic</strong></p>
			<p>Here you can see the total number of visitors as well as the total number of hits to the guestbook and whether one or more visitors have currently accessed the guestbook. Below is a small statistic of the last '.$recording_days.' days.</p>
			<p>The anonymisation of the IPs (see above, Section III.5.2.), which is necessary for reasons of data protection, is at the same time the reason, why the number of unique visits to the guestbook from different addresses listed in the "Visitors" section has a certain source of error, which cannot be verified exactly and is estimated by me in the upper single-digit percentage range. This has no influence on the shown number of all "hits", i.e. the total number of clicked pages of the guestbook.</p>
			<p>The line "Currently online" shows the number of visitors who have visited the guestbook in the last three minutes. Your own call of the guestbook will not be counted or displayed.</p>';
//IV.3.10.2. Statistik löschen
		echo'
			<span id="anchor-DelStats" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.10.2. Delete Statistic</strong></p>
			<p>Older entries than those of the last 15 days are automatically deleted in the database. This does not affect the display of the sums of calls and visitors.</p>
			<p>However, if you click on the link: "Delete statistics", not only the statistics of the last '.$recording_days.' days will be deleted irrevocably, but also the totals will be reset to zero.</p>';
// IV.3.11. Update
		echo'
			<span id="anchor-update" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.11. Update check</strong></p>
			<p>If you click on this link, it will be checked if a newer version of the <span class="italic">myPHP Guestbook</span> is available for download than the one you are currently using. If so, you will receive an update note and a link to download the latest version of the program. If not, you will be informed that you are using the current version.</p>
			<p>There is <strong>no</strong> automatic download and especially <strong>no</strong> automatic installation of an update.</p>';
//IV.3.12. Hilfe
		echo'
			<span id="anchor-Hilfe" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.12. Help</strong></p>
			<p>This page.</p>';
//IV.3.13. Logout
		echo'
			<span id="anchor-Logout" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.13. Logout</strong></p>
			<p>After completing the work in the admin area, do not forget to log out. Links to the logout can be found in the header of the admin panel on the top right and at the end of the navigation on the left.</p>
			<p>After no later than 30 minutes of inactivity in the admin control panel, the session for the stay in the admin area is destroyed for security reasons, which is equivalent to a "forced logout". The time until the end of the session is displayed as a countdown in the top right-hand header.</p>';
//IV.4. Repair-Tool
		echo'
			<span id="anchor-Repair" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />4. Diagnostic and repair tool:<br />(Restore database tables or configuration file)</strong></p>
			<p>Sometimes it happens that individual database tables have been changed, e.g. because pre-installed templates or CSS styles have been erased by mistake or changed by the user, or because similar things occur and later there is a desire to restore them to their original state.</p>
			<p>In order to make a complete new installation unnecessary, a "repair tool" can be downloaded for these cases at <a href="https://www.php-guestbook.de/repair.php" title="Link opens a new window" rel="external">www.php-guestbook.de/repair.php</a>. This makes it easy to restore selected database tables of the <span class="italic">myPHP Guestbook</span> to their original state and with the same contents as after installation.</p>
			<p>Furthermore, this tool can also be used to rewrite the configuration file ("config.inc.php") or to investigate connection problems to the database.</p>
			<p>If the file "config.inc.php" is to be rewritten, remember to give the file the corresponding CHMOD write permissions again if necessary (see section III.4. above at the end under lit. c.).</p>';
// V. Sonstiges			
		echo'
			<span id="anchor-lang" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<h2><br />V. Additional</h2>';
// V.1. Sprachen			
		echo'
			<p class="text-shadow"><strong><br />1. Languages:</strong></p>
			<p>To ensure that <span class="italic">myPHP Guestbook</span> is not only used on German-speaking websites, language files have been implemented from version 2.0.0 onwards.</p>
			<p>I am always looking for translators to translate <span class="italic">myPHP Guestbook</span> into other languages. If you are interested, have time and foreign language skills, please contact me: <a href="mailto:post@php-guestbook.de">post@php-guestbook.de</a>.</p>';
//V.2. Credits
		echo'
			<span id="anchor-Credits" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2. Credits</strong></p>
			<p>In the following - as far as known - some people who have played a bigger role in the development of <span class="italic">myPHP Guestbook</span>.</p>';
//V.2.1. Hauptentwickler
		echo'
			<p class="text-shadow"><strong><br />2.1 Main developer</strong></p>
			<p>Claudio Pose (Switzerland) - The original source code of <span class="italic">myPHP Guestbook</span> was written by Claudio Pose.</p>
			<p>Some parts of the code were built in by other projects, which play a minor role compared to the whole script.</p>
			<p>Since Claudio Pose stopped support and the website in 2006, but <span class="italic">myPHP Guestbook</span> is very popular and should be developed further, Christian Thomas, www.hostonline.de, based on the last version 2.0.5, created the version 3.0.0.</p>
			<p>In 2012 version 3.2.0 was made available for download there, at the end of October 2014 version 3.2.1, after that Mr. Christian Thomas gave up the further development of the script in favour of the existing versions 4.x.</p>
			<p>With the discontinuation of the deployment of bugfixes for PHP 5.3 in August 2014 and the simultaneous deployment of PHP 5.6, it became necessary to comprehensively revise the PHP code for handling the database connection, which had become outdated again.</p>
			<p>For this purpose, version 3.2.0, which was created by Christian Thomas in December 2012, was rewritten by Wolfgang Leverberg, www.php-guestbook.de, using parts of the original code again, but with the conversion of the database connection to MySqli, and was made available for download from October 3, 2014.</p>';
//V.2.2. Übersetzer
		echo'
			<p class="text-shadow"><strong><br />2.2. Translators</strong></p>
			<ul>
				<li>Dutch:
				<ul>
					<li>Marco Hopster (Netherlands)
					<li style="list-style-type:none">marco@mhopster.nl
					<li>Pierre Linssen (Netherlands)
					<li style="list-style-type:none">linski@mirpir.eu
				</ul>
				<li>Portuguese:
				<ul>
					<li>Harry Tartsch (Germany)
					<li style="list-style-type:none">tartsch@arcor.de
				</ul>
				<li>Slovak and Czech:
				<ul>
					<li>Peter Schoeller (Germany)
					<li style="list-style-type:none">schoeller.peter@gmail.com
				</ul>
				<li>Polish:
				<ul>
					<li>Peter Renka (Germany)
					<li style="list-style-type:none">petren@freenet.de
				</ul>
				<li>French and Italian:
				<ul>
					<li>Valentina Panciroli (Italy)
					<li style="list-style-type:none">&lt;netperla.com&gt;
				</ul>
				<li>Swedish:
				<ul>
					<li>Anders Rundkvist (Sweden)
				</ul>
			</ul>';
//V.2.3. Sonstige Helfer/Beteiligte
		echo'
			<p class="text-shadow"><strong><br />2.3. Other developers or assistants</strong></p>
			<p>Whether programmers, bug reporters or graphic designers, many other people have helped to create <span class="italic">myPHP Guestbook</span>, such as:</p>
			<ul>
				<li>David Vignoni (Italy)
				<li style="list-style-type:none">dave@icon-king.com
			</ul>
			<ul>
				<li>Turthra Leinir (Denmark)
				<li style="list-style-type:none">leinir2002@hotmail.com
			</ul>
			<ul>
				<li>Felix Maduakor (Germany)
				<li style="list-style-type:none">felix.maduakor@rub.de
			</ul>
			<hr style="width:75%;" />
			<p>Parts of the file upload functions come with kind permission from:</p>
			<ul>
				<li>ISP Image Upload and Resize PHP Programm
				<li style="list-style-type:none">© Joachim Patten (ISP), 2013
				<li style="list-style-type:none">isp_image_resize Ver.1.5 : Version vom 08.02.2013
				<li style="list-style-type:none">Copyright Joachim Patten (ISP)
				<li style="list-style-type:none">URL: &lt;www.neusser-marktplatz.de&gt;
			</ul>
			<hr style="width:75%;" />
			<p>Parts of the spam filter are from:</p>
			<ul>
				<li>&lt;www.naturfotografie-digital.de/impressum/impressum.php&gt;
			</ul>
			<hr style="width:75%;" />
			<p>The function "shortWords" (original designation "MakeBreakable") is from:</p>
			<ul>
				<li>Mr Werner Rumpeltesz, &lt;www.gaijin.at&gt;
				<li style="list-style-type:none;margin-top:8px;">modified for use under the requirements of <span class="italic">myPHP Guestbook</span>
			</ul>
			<hr style="width:75%;" />
			<p>The javascripts "Sticky-Header", "Countdown" and "Password Validation" are based on examples from:</p>
			<ul>
				<li>&lt;www.w3schools.com&gt;
			</ul>
			<hr style="width:75%;" />
			<p>The Regex for the e-mail validation is from:</p>
			<ul>
				<li>&lt;https://emailregex.com&gt;
				<li style="list-style-type:none;margin-top:8px;">modified for use under the requirements of <span class="italic">myPHP Guestbook</span>
			</ul>
			<p>... and the Regex for the validation of URLs from:
			<ul>
				<li>&lt;http://urlregex.com&gt;
			</ul>
			<hr style="width:75%;" />';
//V.3. Copyright, Lizenz
		echo'
			<span id="anchor-Copyright" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3. Copyright, license</strong></p>
			<ul>
				<li><span class="italic">myPHP Guestbook</span> v. 2.0.5 Copyright © 2003 - 2006 Claudio Pose,
				<li style="list-style-type:none"><span class="italic">myPHP Guestbook</span> v. 2.0.5 was an open source project of Networkarea.ch
				<li><span class="italic">myPHP Guestbook</span> v. 3.2.1 Copyright © 2011 - 2014
				<li style="list-style-type:none">Christian Thomas, &lt;www.hostonline.de&gt;
				<li><span class="italic">myPHP Guestbook</span> '.$version.' Copyright © 2014 - 2022
				<li style="list-style-type:none">Wolfgang Leverberg, <a href="https://www.php-guestbook.de" title="Link opens a new window" rel="external">www.php-guestbook.de</a>
			</ul>
			<p><span class="italic">myPHP Guestbook</span> is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.</p>
			<p><span class="italic">myPHP Guestbook</span> is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.</p>
			<p>You should have received a copy of the GNU General Public License along with this program. - If not, see &lt;www.gnu.org/licenses&gt;</p>';
//V.4. Version History
		echo'
			<span id="anchor-History" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />4. Version History</strong></p>
			<ul>
				<li>1.0.6 Final 13.03.2004 <span class="nowrap marg-leVers">Claudio Pose</span>
				<li>1.1.0 Final 17.03.2004
				<li>1.2.0 Final 25.03.2004
				<li>1.3.3 Final 07.04.2004
				<li>1.4.2 Final 14.04.2004
				<li>1.5.1 Final 06.05.2004
				<li>1.6.2 Final 10.06.2004
				<li>1.7.1 Final 02.08.2004
				<li>1.8.3 Final 20.08.2004
				<li>1.9.1 Final 18.09.2004
				<li>1.9.2 Final 16.10.2004
				<li>2.0.0 Final 06.04.2005
				<li>2.0.1 Final 10.04.2006
				<li>2.0.2 Final 29.04.2006
				<li>2.0.3 Final 06.05.2006
				<li>2.0.4 Final 06.05.2006
				<li>2.0.5 Final 30.06.2006
				<li>3.0.0 Final 24.09.2011 <span class="nowrap marg-leVers">Christian Thomas</span>
				<li>3.0.1 Final 12.02.2012
				<li>3.1.0 Final 15.04.2012
				<li>3.2.0 Final 21.12.2012
				<li>3.2.1 Final 25.10.2014
				<li>4.0.0 Final 10.03.2014 <span class="nowrap marg-leVers">Wolfgang Leverberg</span>
				<li>4.1.0 Final 01.04.2014
				<li>4.2.0 Final 03.10.2014
				<li>4.2.1 Final 28.10.2014
				<li>4.2.2 Final 02.11.2014
				<li>4.2.3 Final 16.11.2014
				<li>4.3.0 Final 28.11.2014
				<li>4.3.1 Final 13.12.2014
				<li>4.3.2 Final 02.01.2015
				<li>4.4.0 Final 21.02.2015
				<li>4.4.1 Final 07.03.2015
				<li>4.4.2 Final 20.03.2015
				<li>4.5.0 Final 01.05.2015
				<li>4.5.1 Final 20.06.2015
				<li>4.5.2 Final 26.06.2015
				<li>4.5.3 Final 18.07.2015
				<li>4.5.4 Final 04.09.2015
				<li>4.5.5 Final 03.10.2015
				<li>4.5.6 Final 02.01.2016
				<li>4.6.0 Final 06.02.2016
				<li>4.6.1 Final 01.05.2016
				<li>4.6.2 Final 03.07.2016
				<li>4.6.3 Final 08.10.2016
				<li>4.7.0 Final 06.01.2017
				<li>4.7.1 Final 04.03.2017
				<li>4.7.2 Final 18.03.2017
				<li>4.7.3 Final 13.05.2017
				<li>4.7.4 Final 15.07.2017
				<li>4.7.5 Final 02.09.2017
				<li>4.8.0 Final 01.01.2018
				<li>4.8.1 Final 12.02.2018
				<li>4.9.0 Final 10.05.2018
				<li>4.9.1 Final 08.07.2018
				<li>4.9.2 Final 03.11.2018
				<li>4.9.3 Final 02.01.2019
				<li>4.10.0 Final 04.03.2019
				<li>4.10.1 Final 17.03.2019
				<li>4.10.2 Final 13.04.2019
				<li>4.10.3 Final 01.09.2019
				<li>4.10.4 Final 04.01.2020
				<li>4.10.5 Final 01.01.2021
				<li>4.10.6 Final 03.03.2021
				<li>4.10.7 Final 01.05.2021
				<li>4.10.8 Final 08.09.2021
				<li>4.10.9 Final 02.01.2022
			</ul>';
//V.5. Kontakt
		echo'
			<span id="anchor-Kontakt" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Back to top">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />5. Contact</strong></p>
			<p><span class="italic">myPHP Guestbook</span> was a project by Claudio Pose - Networkarea.ch.</p>
			<p>Versions 3.x have been developed by Christian Thomas, Kuhstr. 8, 45701 Herten-Westerholt (Germany) - www.hostonline.de - admin@westerhost.de.</p>
			<p>Versions 4.x have been written by Wolfgang Leverberg, Auf\'m Heidchen 6, D-42855 Remscheid (Germany) - <a href="https://www.php-guestbook.de" title="Link opens a new window" rel="external">www.php-guestbook.de</a> - <a href="mailto:post@php-guestbook.de">post@php-guestbook.de</a></p>
			<p>&nbsp;</p>
			<p class="italic text-right">Remscheid (Germany), January 2022</p>';
	}
    
?>