<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/

	if (!isset($_SESSION['sid']) && !isset($_SESSION['modsid'])) {
		header("Location: ../admin.php?action=login");
		die();
	}
	else {
		$toTop = 'javascript:scrollToTop()';

		echo'
			<style>html{scroll-behavior:smooth}</style>';
		
		echo'
			<p>Diese Dokumentation soll Ihnen dabei helfen, die Features von <span class="italic">myPHP Guestbook</span> zu verstehen und offene Fragen zu beantworten. Ergänzende Erläuterungen finden Sie auch in der dem Download beigefügten <span class="italic">ReadMe.pdf</span>.</p>
			<hr /><hr />
			<div class="text-left">
			<span id="anchor-top"></span>
			<h1><br />Inhaltsverzeichnis:</h1>
			<h2><br /><a href="#anchor-Intro">I. Einführung, Haftungsausschluss</a></h2>
			<h2><a href="#anchor-Aktuell">II. Aktuelle Änderungen</a></h2>
			<h2><a href="#anchor-Install">III. Vorbeitung und Installation oder Updates von <span class="italic">myPHP Guestbook</span></a></h2>
			<ol>
				<li><a href="#anchor-Update">Neuinstallation oder Update von V.3.x auf V.4.x</a>
				<li><a href="#anchor-Webdesign">&quot;Responsive Webdesign&quot; und die Einbindung per &quot;iframe&quot;</a>
				<li><a href="#anchor-Ordner">Besondere Rechte bestimmter <span class="nowrap">Ordner <img class="arrow-left marg-le10Perc" title="WICHTIG" src="'.$url.'images/ausruf.png" height="14" width="14" alt="WICHTIG" /></span></a>
				<li><a href="#anchor-htaccess">Nutzung von <span class="nowrap">.htaccess-Dateien <img class="arrow-left marg-le10Perc" title="WICHTIG" src="'.$url.'images/ausruf.png" height="14" width="14" alt="WICHTIG" /></span></a>
				<li><a href="#anchor-Cookie">Datenschutz und das <span class="nowrap"><span class="italic">myPHP Guestbook</span> <img class="arrow-left marg-le10Perc" title="WICHTIG" src="'.$url.'images/ausruf.png" height="14" width="14" alt="WICHTIG" /></span></a>
					<ol>
						<li class="sub-main"><a href="#anchor-Cookie">Von <span class="italic">myPHP Guestbook</span> verwendete Cookies</a>
						<li class="sub-main"><a href="#anchor-saveIP">Wie IPs der User verarbeitet werden</a>
						<li class="sub-main"><a href="#anchor-noIp">Verwendung des <span class="italic">myPHP Guestbook</span> ohne Setzen von Cookies und/oder ohne Verarbeitung von IPs.</a>
						<li class="sub-main"><a href="#anchor-morePP">Weitere Datenschutzeinstellungen</a>
					</ol>
			</ol>
			<h2><a href="#anchor-Config">IV. Nutzungshinweise</a></h2>
			<ol>
				<li><a href="#anchor-Config">Config.inc.php</a>
					<ol>
						<li class="sub-main"><a href="#anchor-timezone">Von <span class="italic">myPHP Guestbook</span> verwendete Zeitzone und Datumsformat</a></li>
						<li class="sub-main"><a href="#anchor-save">Spätere Umstellung auf eine (un)gesicherte Internet-Verbindung</a><br />(http &harr; https) <img class="arrow-left marg-le10Perc" title="WICHTIG" src="'.$url.'images/ausruf.png" height="14" width="14" alt="WICHTIG" /></li>
					</ol>
				<li><a href="#anchor-Gaestebuch">Gästebuch</a>
					<ol>
						<li><a href="#anchor-Gaestebuch">Gästebuchseite</a>
							<ol>
								<li class="sub-main"><a href="#anchor-Changes">Änderungen der Schriftart, von Schriftfarbe und -größe, Hintergründen, Breite des Gästebuchs, Icons für E-Mail, Homepage und Sterne, Rahmenfarben etc..</a></li>
								<li class="sub-main"><a href="#anchor-ChooseLang">Sprachauswahl durch den User</a></li>
								<li class="sub-main"><a href="#anchor-search">Suchfunktion für den User</a></li>
								<li class="sub-main"><a href="#anchor-Copy">Copyrighthinweis</a></li>
							</ol>
						<li><a href="#anchor-Eintragsseite">Eintragsseite</a>
							<ol>
								<li class="sub-main"><a href="#anchor-Entry">Eingabemöglichkeiten</a></li>
								<li class="sub-main"><a href="#anchor-Smiley">Smileys/Emojis</a></li>
								<li class="sub-main"><a href="#anchor-BBC">BBCodes</a></li>
								<li class="sub-main"><a href="#anchor-Photo">Bilder in Gästebucheinträgen</a></li>
								<li class="sub-main"><a href="#anchor-Quote">Zitieren von Gästebucheinträgen</a></li>
								<li class="sub-main"><a href="#anchor-Stars">Bewertungsfunktion</a></li>
								<li class="sub-main"><a href="#anchor-ComInfo">Gast über Antwort zu seinem Eintrag informieren</a></li>
								<li class="sub-main"><a href="#anchor-IPBar">IP-Sperre der Eintragsseite</a></li>
							</ol>
					</ol>
				<li><a href="#anchor-Admin">Admin-Control-Panel</a><br />
				<span class="sub-main"><a style="margin-left:50px;" href="#anchor-new-pw">3.0.1. Passwort-vergessen-Funktion</a></span><br />
				<span class="sub-main"><a style="margin-left:50px;" href="#anchor-sec-auth">3.0.2. Zwei-Faktor-Authentisierung</a></span><br />
				<span class="sub-main"><a style="margin-left:50px;" href="#anchor-hijacking">3.0.3. "Session Hijacking"</a></span><br />
				<span class="sub-main"><a style="margin-left:50px;" href="#anchor-Noentry">3.0.4. Automatische Login-Sperre</a></span>
					<ol>
						<li><a href="#anchor-Gaestebucheintraege">Gästebucheinträge</a>
							<ol>
								<li class="sub-main"><a href="#anchor-Edit">Einträge verwalten, editieren, kommentieren</a></li>
								<li class="sub-main"><a href="#anchor-Grafik">Hochgeladene Grafikdateien verwalten und editieren</a></li>
								<li class="sub-main"><a href="#anchor-Blog">Admin Blog</a></li>
								<li class="sub-main"><a href="#anchor-Front">Frontend anzeigen</a></li>
							</ol>
						<li><a href="#anchor-Einstellungen">Einstellungen</a>
							<ol>
								<li class="sub-main"><a href="#anchor-AdminEdit">Admin- und Login Einstellungen</a><br />esp.: Moderatoren => Admin mit eingeschränkten Rechten</li>
								<li class="sub-main"><a href="#anchor-Konfig">Allgemeine Konfiguration</a><br />
									<ol type="a">
										<li><a href="#anchor-LinkButton">Link zur Eintragsseite (Text, Button, Link entfernen)</a></li>
										<li><a href="#anchor-ChooseLang">Individuelle Sprachauswahl durch den User</a></li>
										<li><a href="#anchor-privacy">Link zu einer Datenschutzerklärung setzen</a></li>
										<li><a href="#anchor-search">Suchfunktion für den User aktivieren</a></li>
										<li><a href="#anchor-permaLi">Permalinks aktivieren</a></span></li>
									</ol>
								<li class="sub-main"><a href="#anchor-Upload">Konfiguration Datei-Uploads</a></li>
								<li class="sub-main"><a href="#anchor-Thankyou">E-Mail Einstellungen und individuelle &quot;Danke-E-Mail&quot; an den Gast</a></li>
								<li class="sub-main"><a href="#anchor-MoreKonfig">Weitere Konfigurationsmöglichkeiten</a> <img class="arrow-left marg-le10Perc" title="WICHTIG" src="'.$url.'images/ausruf.png" height="14" width="14" alt="WICHTIG" /></li>
							</ol>
						<li><a href="#anchor-Template">Template</a>
							<ol>
								<li class="sub-main"><a href="#anchor-StandTempl">Standard Template</a></li>
								<li class="sub-main"><a href="#anchor-EditTempl">Template editieren<br />(inkl. Schriftart, Schriftgröße, Textfarben, Hintergründen, Breite u.ä.)</a></li>
								<li class="sub-main"><a href="#anchor-MakeTempl">Template erstellen</a></li>
								<li class="sub-main"><a href="#anchor-DelTempl">Template löschen</a></li>
							</ol>
						<li><a href="#anchor-Styles">CSS-Style</a>
							<ol>
								<li class="sub-main"><a href="#anchor-StandStyle">Standard Style</a></li>
								<li class="sub-main"><a href="#anchor-EditStyle">Style editieren<br />(inkl. div. Anwendungs-Beispielen)</a></li>
								<li class="sub-main"><a href="#anchor-MakeStyle">Style erstellen</a></li>
								<li class="sub-main"><a href="#anchor-DelStyle">Style löschen</a></li>
							</ol>
						<li><a href="#anchor-banner">Banner und individueller Begrüßungstext</a>
							<ol>
								<li class="sub-main"><a href="#anchor-ShowBanner">Banner anzeigen, editieren und löschen</a></li>
								<li class="sub-main"><a href="#anchor-PlusBanner">Banner und/oder Begrüßungstext hinzufügen</a></li>
							</ol>
						<li><a href="#anchor-Smilies">Smileys/Emojis</a>
							<ol>
								<li class="sub-main"><a href="#anchor-ShowSmil">Smileys anzeigen</a></li>
								<li class="sub-main"><a href="#anchor-PlusSmil">Smiley hinzufügen</a></li>
								<li class="sub-main"><a href="#anchor-DelSmil">Smileys löschen</a></li>
								<li class="sub-main"><a href="#anchor-EditSmil">Smileys editieren</a></li>
							</ol>
						<li><a href="#anchor-Badwords">Badwords</a>
							<ol>
								<li class="sub-main"><a href="#anchor-ShowBadw">Badwords anzeigen und löschen</a></li>
								<li class="sub-main"><a href="#anchor-PlusBadw">Badwords hinzufügen</a></li>
							</ol>
						<li><a href="#anchor-Spamfilter">Spamfilter</a>
							<ol>
								<li class="sub-main"><a href="#anchor-SpamBasics">Grundsätzliches zum Schutz <span class="nowrap">vor Spam <img class="arrow-left marg-le10Perc" title="WICHTIG" src="'.$url.'images/ausruf.png" height="14" width="14" alt="WICHTIG" /></span></a></li>
								<li class="sub-main"><a href="#anchor-ShowSpamWo">Spamwords anzeigen und löschen</a></li>
								<li class="sub-main"><a href="#anchor-PlusSpamWo">Spamwords hinzufügen</a></li>
								<li class="sub-main"><a href="#anchor-ShowIpBar">IP-Sperren nach Spameinträgen</a></li>
							</ol>
						<li><a href="#anchor-Backup">Backup</a>
							<ol>
								<li class="sub-main"><a href="#anchor-BackUpEdit">Backups verwalten und Einträge wiederherstellen</a></li>
								<li class="sub-main"><a href="#anchor-MakeBackUp">Backup erstellen</a></li>
							</ol>
						<li><a href="#anchor-Statistik">Statistik</a>
							<ol>
								<li class="sub-main"><a href="#anchor-ShowStats">Statistik anzeigen</a></li>
								<li class="sub-main"><a href="#anchor-DelStats">Statistik löschen</a></li>
							</ol>
						<li><a href="#anchor-update">Update prüfen</a>
						<li><a href="#anchor-Hilfe">Hilfe</a>
						<li><a href="#anchor-Logout">Logout</a>
					</ol>
				<li><a href="#anchor-Repair">Diagnose- und Reparatur-Tool</a>
			</ol>
			<h2><a href="#anchor-lang">V. Sonstiges</a></h2>
			<ol>
				<li><a href="#anchor-lang">Sprachen</a>
				<li><a href="#anchor-Credits">Credits</a>
				<li><a href="#anchor-Copyright">Copyright, Lizenz</a>
				<li><a href="#anchor-History">Version History</a>
				<li><a href="#anchor-Kontakt">Kontakt</a>
			</ol><br />
			</div>
			<hr /><hr />';
// I.	Einführung, Haftungsausschluss
		echo'
			<span id="anchor-Intro" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<h2><br />I. Einführung, Haftungsausschluss</h2>
			<p><span class="italic">myPHP Guestbook</span> ist ein Open Source Gästebuch und unterliegt der GNU General Public License.</p>
			<p>Bevor Sie das Gästebuch benutzen, sollten Sie die <span class="italic">license.txt</span> durchlesen (zu finden im Ordner "license").</p>
			<p>Mit der Installation und Benutzung von <span class="italic">myPHP Guestbook</span> akzeptieren Sie die GNU General Public License.</p>
			<p>Nach den Lizenzbedingungen kann jeder selbstständig den Code von <span class="italic">myPHP Guestbook</span> ändern oder Teile des Codes für andere Projekte benutzen. Dies ist allerdings nur dann gestattet, wenn die Lizenzbestimmungen eingehalten werden, siehe hier: &lt;www.gnu.org/licenses&gt;</p>
			<p>Damit das Programm <span class="italic">myPHP Guestbook</span> weiter verbessert werden kann, ist auch Ihre Mithilfe gefragt. Sie können gerne Wünsche für zukünftige Features mitteilen oder gefundene Fehler melden. Nutzen Sie hierfür am besten das <a href="https://www.php-guestbook.de/start.gbook.php" title="Link öffnet ein neues Fenster" rel="external">Demo-Gästebuch</a> auf "www.php-guestbook.de", damit auch andere User profitieren und sich an Diskussionen beteiligen können. Ich werde bestrebt sein, ggf. entdeckte Bugs umgehend zu beheben.</p>
			<p>Da es sich bei <span class="italic">myPHP Guestbook</span> um ein relativ kleines Projekt handelt, werden keine Patches angeboten, um ggf. aufgetretene Sicherheitslücken zu schließen. Daher sollten Sie stets die jeweils <a href="https://www.php-guestbook.de/index.php#anchor-newvers" title="Link öffnet ein neues Fenster" rel="external">aktuellste Version</a> herunterladen und installieren, um immer auf dem neuesten Stand zu sein. Achten Sie bitte auf Hinweise zu Updates unter <a href="https://www.php-guestbook.de" title="Link öffnet ein neues Fenster" rel="external">www.php-guestbook.de</a> oder melden Sie sich einfach zum <a href="https://www.php-guestbook.de/mail.reg.php" title="Link öffnet ein neues Fenster" rel="external">Newsletterversand</a> an.</p>
			<p class="text-shadow zentriert"><br /><strong>HAFTUNGSAUSSCHLUSS:</strong></p>
			<p><strong>Es ist nicht möglich, eine immer und überall fehlerfrei arbeitende Software anzubieten oder gar eine Haftung für fehlerhafte Software oder eventuelle Sicherheitslücken und daraus ggf. resultierende Schäden und/oder Folgeschäden zu übernehmen, die daher grundsätzlich ausgeschlossen wird.</strong></p>
			<p><strong><span class="italic">myPHP Guestbook</span> wird &quot;so wie es ist&quot; angeboten und mit der Installation von Ihnen akzeptiert, unter Ausschluss jeglicher Gewährleistung und unter Ausschluss jeglicher Haftung. Für weiteres siehe auch die GNU-Lizenz.</strong></p>
			<p><strong>Für die Einhaltung gesetzlicher Vorgaben bei der Nutzung des <span class="italic">myPHP Guestbook</span> entsprechend den jeweiligen landesrechtlichen Bestimmungen sind Sie selbst verantwortlich, zumal sich die rechtlichen Bedingungen je nach Verwendungsort unterscheiden und auch jederzeit ändern können.</strong></p>';
// II.	Aktuelle Änderungen
		echo'
			<span id="anchor-Aktuell" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<h2><br />II. Aktuelle Änderungen</h2>
			<p>Eine komplette Darstellung aller Programmänderungen ab der Version 4.0.0 finden Sie auf "www.php-guestbook.de" unter <a href="https://www.php-guestbook.de/start.changelog.php" title="Link öffnet ein neues Fenster" rel="external">Changelog</a></p>';
// III.	Vorbereitung und Installation oder Update
		echo'
			<span id="anchor-Install" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<h2><br />III. Vorbereitung und Installation oder Update des <span class="italic">myPHP Guestbook</span></h2>
			<p>Voraussetzungen zum Betrieb von <span class="italic">myPHP Guestbook '.$version.'</span>:</p>
			<ul>
				<li>Apache Server
				<li>MySQL 5.x oder 8.0 - (MySQL STRICT MODE ab <span class="italic">myPHP Guestbook v.4.9.1</span>)
				<li>PHP 7.x, 8.0 oder 8.1 (wegen ggf. höherer PHP-Versionen als 8.1 siehe <a href="https://www.php-guestbook.de/index.php#anchor-require" title="Link öffnet ein neues Fenster zu www.php-guestbook.de" rel="external">HIER</a>)
				<li>serverseitig aktivierte MySQLi Unterstützung
				<li>nur für die Nutzung der Bilder-Upload-Funktion:
					<ul>
						<li>serverseitig aktivierter GD Support
						<li style="list-style-type:none">(Das Gästebuch ohne Bild-Upload kann ohne GD-Modul genutzt werden.)
					</ul>
				<li>nur für die Nutzung der Bilder-Upload- und Smiley-Upload-Funktion:
					<ul>
						<li>serverseitig: - file_uploads = On
					</ul>
				<li>Für die Funktion des Gästebuchs ebenfalls nicht zwingend erforderlich, aus Sicherheitsgründen aber wünschenswert:
					<ul>
						<li>vom Provider zugelassene Nutzung eigener .htaccess-Dateien
					</ul>
				<li>Für das automatische Zippen (komprimieren) der mit dem Programm erstellten BackUps:
					<ul>
						<li>serverseitig: - zlib Support
						<li style="list-style-type:none">(Das Gästebuch kann einschließlich der BackUp-Fertigung auch ohne diesen Support installiert und genutzt werden, die BackUps werden dann nur nicht automatisch komprimiert.)
					</ul>
			</ul>';
// III.1. Neuinstallation oder Update	
		echo'
			<span id="anchor-Update" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />1. Neuinstallation oder Update:</strong></p>
			<p>Ausführliche Hinweise und Erläuterungen mit einer Schritt für Schritt Anleitung, was bei einer Installation oder einem Update des Programms <span class="italic">myPHP Guestbook</span> zu beachten ist und welche Schritte im Einzelnen notwendig sind, finden Sie in der dem Download beigefügten <strong class="italic">ReadMe.pdf</strong>. Für ein Update lesen Sie bitte ergänzend auch die beigefügte <strong class="italic">ReadMe-Update.pdf</strong>.</p>
			<p class="zentriert red"><strong>ACHTUNG:</strong></p>
			<p class="red"><strong>Achten Sie bitte darauf, nach erfolgreicher Installation oder Update den &quot;install-Ordner&quot; aus Sicherheitsgründen mit allen darin befindlichen Dateien wieder von Ihrem Server zu löschen!</strong></p>';
// III.2. Einbinden des Gästebuchs per iframe
		echo'
			<span id="anchor-Webdesign" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2. Beim Einbinden des Gästebuchs per &quot;iframe&quot; zu beachten:</strong></p>
			<p>Wenn Ihre Website, in die das Gästebuch eingebunden wird, eine feste Breite hat, müssen Sie bei der Einbindung per &quot;iframe&quot; nichts besonderes beachten, alles bleibt bzw. wird umgesetzt wie üblich. Hat Ihre Website jedoch eine flexible Breite, sollten Sie, um die Möglichkeiten der automatischen Größenanpassung des Gästebuchs je nach Endgerät vollständig auszunutzen, insbesondere zwei Punkte beachten:</p>
			<ol>
				<li type="a">Die Breite des iframes darf <strong>nicht absolut</strong> festgelegt werden, sondern nur relativ zum Elternelement. Das bedeutet, dass für das iframe <strong>keine</strong> Breitenangabe mit px oder pt sondern mit % erfolgen sollte; also <strong>nicht</strong> z.B.: &quot;width:500px&quot; sondern &quot;width:100%&quot; !
				<li type="a">Das iframe sollte auf der Seite so eingebunden werden, dass es deren <strong>volle Breite</strong> einnimmt, also ohne irgendeine Navigation oder sonstige Texte o.ä. rechts oder links daneben und allenfalls mit einem Innenabstand (padding) zum Elternelement rechts und links bis zu maximal 5px. Nur dann kann die minimale Breite von 320px auf einem Smartphone erzielt werden !
			</ol>';
// III.3. Besondere Rechte bestimmter Ordner
		echo'
			<span id="anchor-Ordner" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3. Besondere Rechte bestimmter Ordner:</strong></p>
			<p>Gleichgültig ob Sie zu diesem Absatz gelangt sind, weil der Installer Ihnen angezeigt hat, dass bestimmte Ordner nicht beschreibbar sind, Sie Fehlermeldungen beim Foto-Upload oder der BackUp-Erstellung bekommen haben oder einfach nur sorgfältig vorgehen: Lesen Sie sich diesen (und auch den folgenden) Abschnitt aufmerksam durch und erschrecken Sie nicht sofort, wenn Ihnen das eine oder andere zunächst unverständlich erscheint; alles ist lösbar. <span class="td-nowrap">:-)</span></p>
			<p>In den Hinweisen älterer <span class="italic">myPHP Guestbook</span>-Dokumentationen hieß es bislang stets, die backup- und smilie-Ordner müssten die CHMOD Rechte 0777 erhalten. Das ist jedoch so nicht unbedingt richtig und vernachlässigt den Sicherheitsaspekt.</p>
			<p>Zum besseren Verständnis: Die Verzeichnisse (Ordner) &quot;images/smilies&quot;, &quot;banner&quot;, &quot;backup&quot; und &quot;img_guest&quot; müssen so angelegt sein, dass von PHP in diesen Ordnern Dateien abgelegt werden und diese Dateien dann auch &quot;gelesen&quot; werden können. Dafür werden bestimmte Rechte benötigt, nämlich die sogen. CHMOD Rechte 0755 oder bei <span class="italic">manchen</span> Server-Konfigurationen sogar 0777, weil sonst die Speicherung von BackUps, das Hochladen von neuen Smileys oder eines eigenen Banners oder der seit V.4.4.0 mögliche Foto-Upload nicht funktionieren.</p>
			<p>Grundsätzlich sollte ein Ordner aus Sicherheitsgründen jedoch so wenig Rechte wie möglich bekommen. Also besser, weil sicherer, CHMOD 0755 und nur wenn es nicht anders geht CHMOD 0777. Auf der Website von "wiki.selfhtml.org" wird es so ausgedrückt: &quot;777 ist böse.&quot;</p>
			<p>Das Prüfen und ggf. Ändern von Rechten eines Ordners auf dem Webspace kann mit einem FTP-Clienten, wie z.B. dem bekannten FileZilla o.ä. erfolgen. Oft funktioniert das so, dass man den Verzeichnisbaum des eigenen Webspace auf dem Webserver öffnet, mit der Mouse den gewünschten Ordner anklickt (je nach Programm mit der linken oder auch rechten Mousetaste) und in dem sich dann öffnenden Fenster den Punkt &quot;Dateiattribute ändern&quot; oder &quot;Dateiberechtigungen&quot; oder &quot;Eigenschaften&quot; oder ähnlich benannte Verweise anklickt. Es öffnet sich dann meist ein weiteres Fenster, in dem man sehen und bei Bedarf ändern kann, welche Rechte der betreffende Ordner hat oder bekommen soll.</p>
			<p>Ob in Ihrem Fall die vier bezeichneten Ordner (und außerdem die Datei "config.inc.php" im Verzeichnis "includes") die Rechte 0777 bekommen müssen oder die –vorzuziehenden- geringeren Rechte 0755 genügen, muss im Zweifel ausprobiert werden, weil dies auch davon abhängt, ob der Apache-Server und die Dateien unter demselben Benutzer laufen (was sie heutzutage tun sollten) oder nicht.</p>
			<p>Nach dem Hochladen aller Dateien und Ordner aus dem Download-Paket sollten die Ordnerrechte im Normalfall 0755 betragen. Auf 0755 ist auch der Installer mit der eingebauten Prüfung einer Beschreibbarkeit dieser Ordner ausgerichtet. Wenn dort die Ordner in grüner Schrift mit dem Hinweis: &quot;vorhanden, beschreibbar&quot; angezeigt wurden, sollte alles Ordnung sein. - <span class="italic">Eine eigenverantwortliche Prüfung ersetzt dies jedoch nicht!</span></p>
			<p>Wurde Ihnen vom Installer angezeigt, dass die vier oder einer der vier Ordner &quot;images/smilies&quot;, &quot;banner&quot;, &quot;backup&quot; und/oder &quot;img_guest&quot; zwar vorhanden, aber nicht beschreibbar sind, können Sie das Gästebuch trotzdem nutzen, es wird aber folgendes nicht funktionieren:</p>
			<ol>
				<li type="a">Es kann kein BackUp der Gästebucheinträge mit diesem Script erstellt werden,
				<li type="a">es können keine neuen Smileys und kein eigenes Banner mit diesem Script hochgeladen werden
				<li type="a">und der Bildupload wird nicht funktionieren.
			</ol>
			<p>Um dies zu beheben, müssen Sie entweder die CHMOD Rechte des/der betroffenen Ordner ändern, wie oben beschrieben, oder, falls nicht gewünscht oder möglich, eine der folgenden Optionen prüfen:</p>
			<ul>
				<li>für a) Lösung: ein anderes, externes BackUp-Programm für die Datenbankeinträge, wie z.B. myphpAdmin, mySQLDumper o.ä. benutzen und in den &quot;Allgemeinen Konfigurationseinstellungen&quot; hier im Admin-Bereich des Gästebuchs die Option: &quot;BackUp nach dem Versand per E-Mail wieder vom Server löschen?&quot; aktivieren;
				<li>für b) Lösung: zunächst einmal sind eine ganze Reihe von Smileys sowie zwei Banner nach der Erstinstallation schon vorhanden. Nur wem die nicht genügen UND die Ordner &quot;smilies&quot; und &quot;banner&quot; als nicht beschreibbar angezeigt werden, muss ggf. gewünschte neue Smileys bzw. ein eigenes Banner per FTP hochladen. Die Daten der per FTP hochgeladenen Smileys müssen dann ebenfalls manuell noch in die Datenbanktabelle &quot;*_smilies&quot; eintragen werden;
				<li>für c) Lösung: in den &quot;Allgemeinen Konfigurationseinstellungen&quot; hier im Admin-Bereich des Gästebuchs die Option: &quot;Bilder in Gästebucheinträgen anzeigen, Bild-Upload aktivieren:?&quot; deaktivieren. 
			</ul>';
// III.4. htaccess-Dateien	
		echo'
			<span id="anchor-htaccess" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />4. Nutzung von .htaccess-Dateien:</strong></p>
			<p>Dem Download-Paket sind drei teils unterschiedliche .htaccess-Dateien beigefügt, nämlich in den Ordnern &quot;backup&quot;, &quot;includes&quot; und &quot;img_guest&quot;. Sie dienen ebenfalls dazu, die Sicherheit vor schädlichen Eingriffen Dritter zu erhöhen.</p>
			<p>Dateien mit dem Namen .htaccess (das erste Zeichen ist ein Punkt) sind Bestandteile der Konfiguration des Apache Webservers. Der Server-Administrator, also im Zweifel ihr Website-Hoster/Provider, legt in der zentralen Konfiguration fest, welche Berechtigungen er welchen Benutzern oder auch welchen Webangeboten (virtuellen Hosts) zugestehen möchte. Außerdem lässt sich in der zentralen Konfiguration des Apache (an die Sie als normaler User nicht herankommen, es sei denn, Sie betreiben Ihren eigenen Server) auch ein beliebiger anderer Dateiname einstellen, weshalb der Name einer solchen Datei nicht unbedingt .htaccess lauten muss (wenn es auch üblich und daher meistens so ist).</p>
			<p><strong>Mit einem Satz:</strong> Sie können die .htaccess-Dateien aus dem <span class="italic">myPHP Guestbook</span> nutzen, wenn Ihr Provider Ihnen diese Möglichkeit bei Ihrem Hostingpaket eingeräumt hat.</p>
			<p>Bei den aktuellen großen Providern sollte das der Fall sein. Grundsätzlich wäre mehr möglich, als in den beigefügten Dateien hinterlegt, aber eben nicht überall erlaubt. Die Anweisungen in diesen Dateien beschränken sich daher auf das, was Provider im Normalfall zulassen.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Sollten Sie nach dem Hochladen von Bildern Fehlermeldungen erhalten, insbesondere solche mit <span class="italic">&quot;500 server error&quot;</span>, oder sollten trotz fehlerfreiem Upload die hochgeladenen Bilder nicht angezeigt werden, beachten Sie bitte die Tipps in der <strong class="italic">&quot;ReadMe.pdf&quot;</strong>!</p>
			<p>Wenn Sie damit nicht weiterkommen, löschen Sie als letzten Ausweg notfalls die .htaccess aus dem Verzeichnis &quot;img_guest&quot; wieder vom Server und machen Sie sich über entsprechende FAQ, E-Mails, Anrufe o.ä. bei Ihrem Provider schlau, was bei Ihrem Hostingpaket möglich ist und was nicht.</p>
			<p><strong><span class="red">TIPP:</span></strong> Testen Sie, ob die hochgeladene &quot;.htaccess&quot; macht, was sie soll, in dem Sie den folgenden Link aufrufen:</p>
			<p class="zentriert italic"><a href="'.$url.'img_guest/index.php" title="Anklicken zum Testen - Link öffnet ein neues Fenster" rel="external">'.$url.'img_guest/index.php</a></p>
			<p>... es sollte dann in Ihrem Browser ein &quot;HTTP-403-Fehler&quot; angezeigt werden, in etwa mit dem Inhalt:</p>
			<p class="zentriert italic"><strong>&quot;Forbidden You don\'t have permission to access ... on this server.&quot;</strong></p>
			<p>Wenn das der Fall ist und hochgeladene Bilder angezeigt werden, funktioniert es ordnungsgemäß.</p>
			<p>Sollten Sie hingegen nach Anklicken des Links auf der Gästebuch-Index-Seite landen, funktioniert es offenkundig <span class="italic">nicht</span> und auf den Inhalt des Ordners kann von außen zugegriffen werden.
			<p>Sollten Sie keine .htaccess-Dateien nutzen können bzw. diese nicht den gewünschten Effekt erzeugen und womöglich auch noch gezwungen sein, den im vorherigen Abschnitt beschriebenen drei Ordnern &quot;images/smilies&quot;, &quot;backup&quot; und &quot;img_guest&quot; die CHMOD Rechte 0777 zuweisen zu müssen, rate ich dringend dazu =&gt;</p>
			<ol>
				<li type="a">unter dem Link &quot;Allgemeinen Konfigurationseinstellungen&quot; die Option: &quot;Bilder in Gästebucheinträgen anzeigen, Bild-Upload aktivieren:?&quot; zu <strong>de</strong>aktivieren und
				<li type="a">ebenfalls in den &quot;Allgemeinen Konfigurationseinstellungen&quot; die Option: &quot;BackUp nach dem Versand per E-Mail wieder vom Server löschen?&quot; zu <strong>ak</strong>tivieren und
				<li type="a">nach Abschluss der Installation die CHMOD Rechte der Datei "config.inc.php" aus dem Verzeichnis "includes" auf 0444 oder 0644 zu ändern (-r--r--r-- oder -rw-r--r--), um Zugriffe und Manipulationen von Außen zu verhindern und
				<li type="a">den Anbieter zu wechseln, und zwar nicht nur wegen diesem Gästebuchscript, sondern weil er offensichtlich mit seinem Angebot noch hinter dem Mond lebt.
			</ol>';
// III.5. Datenschutzhinweise + 5.1. Cookies
		echo'
			<span id="anchor-Cookie" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />5. Datenschutz und das <span class="italic">myPHP Guestbook:</span></strong></p>
			<p class="text-shadow"><strong>5.1. Cookie-Hinweise:</strong></p>
			<p>Vom Skript <span class="italic">myPHP Guestbook</span> werden je nach Konfiguration bis zu vier <strong>technisch notwendige Session-Cookies</strong> eingesetzt, von denen bis zu zwei in einer Datenschutzerklärung Erwähnung finden sollten. "<span class="italic">Technisch notwendige Session-Cookies"</span>" vereinen folgende entscheidende Merkmale: Sie verfallen mit dem Schließen des Browsers automatisch, speichern keine Inhalte, die sich zur Individualisierung des Users eignen und eignen sich nicht zur Nachverfolgung oder zur Anlage eines Nutzerprofils z.B. für Werbungszwecke o.ä..</p>
			<ul>
				<list-style-type:none>1. Wenn Sie in den "Allgemeinen Konfigurationseinstellungen" die Option "Suchfunktion aktivieren" freigeben (default: deaktiviert), wird automatisch beim Aufruf der Gästebuch-Index-Seite (das ist die Seite, auf der die Gästebucheinträge angezeigt werden) ein Cookie mit einer Session-ID gesetzt. Derselbe Cookie mit Session-ID wird gesetzt oder (wenn schon wegen der aktivierten Suchfunktion vorhanden) genutzt, wenn die Funktion zum "Zitieren von Beiträgen" aktiviert (default seit v.4.10.7: deaktiviert) und die Zitatfunktion von einem User benutzt wird.<br /><br />
				Eine Session-ID besteht aus einer vom Server für den jeweiligen Besuch der Webseite stets neu generierten willkürlichen Ziffern- und Buchstabenfolge und dient lediglich dazu, den aufrufenden Browser der Sitzung (=Session) zuzuordnen. Das ist notwendig, damit bei einer Nutzung der Suchfunktion die Suchergebnisse und bei Nutzung der Zitat-Funktion der zitierte Eintrag dem anfragenden Browser zugeordnet werden können.<br /><br />
				Dieser Cookie enthält also keinerlei Daten des Users, insbesondere auch keine IP, nicht den oder die Begriffe, nach denen gesucht wird und ebenfalls keine Inhalte aus einem zitierten Post und wird automatisch mit dem Ende der Sitzung gelöscht.</li><br /><br />
				<list-style-type:none>2. Ein weiterer Session-Cookie wird gesetzt. wenn Sie in den Konfigurationseinstellungen die Sprachauswahl für den User freigeben (default: deaktiviert) <strong>und</strong> ein User diese Sprachauswahl auch tatsächlich nutzt, also auf eine andere der angebotenen Sprachen umstellt. Dann wird ein Cookie generiert, der ein Kürzel der gewählten Sprache enthält (z.B. "en" für Englisch oder "pl" für Polnisch usw.). Das ist notwendig, weil sonst bei jeder neu aufgerufenen Seite des Gästebuchs die Sprachauswahl wiederholt werden müsste.<br /><br />
				Auch dieser Cookie enthält also keinerlei personenbezogene Daten des Users. Außerdem kann die Sprachauswahl so eingestellt werden, dass der User vorher ausdrücklich darauf hingewiesen wird, dass er mit der Auswahl einer anderen Sprache dem Setzen eines solchen Cookies zustimmt.</li>
			</ul>
			<p>Schließlich werden im Admin-Control-Panel noch ein oder zwei weitere Session-Cookies gesetzt, die allerdings für die Öffentlichkeit uninteressant sind, weil sie nur den Admin selbst betreffen und die daher hier lediglich der Vollständigkeit halber Erwähnung finden sollen:</p>
			<ul>
				<list-style-type:none>3. Beim Aufruf des Admin-Panels wird ein Cookie mit einer Session-ID gesetzt zur eindeutigen Identifizierung des Rechners, von dem aus sich eingeloggt wird.</li><br /><br />
				<list-style-type:none>4. Und schließlich wird bei Aktivierung des sogen. "Blog-Modus" im Admin-Bereich ein Cookie gesetzt, damit der Admin auch alle die Funktionen des Gästebuchs nutzen kann, die ansonsten im Blog-Modus gesperrt sind (Beispiel: Foto-Upload).</li>
			</ul>
			<p><strong>Alle</strong> hier aufgeführten Cookies werden spätestens mit dem Schließen des Browserfensters ungültig und wieder gelöscht.</p>
			<p>Wenn Sie nicht wissen, wie Sie mit solchen Cookies in rechtlicher Hinsicht umgehen müssen, nutzen Sie eine der gängigen Suchmaschinen und geben Sie dort als Suchbegriffe z.B. ein: "Datenschutz technisch notwendige Cookies" oder auch "Datenschutz Session Cookies". - Anmerkung speziell für deutsche User: Beim Aufruf der Webseite des Bundesgerichtshofs (BGH) [https://www.bundesgerichtshof.de/] werden (Stand 23.04.2021) drei Session-Cookies gesetzt, ohne dass Sie als Besucher hiernach gefragt oder vorab informiert werden. Was schließen wir daraus? :-)</p>
			<p>Sie können das Gästebuch so konfigurieren, dass keine Cookies auf dem Rechner eines Besuchers gesetzt werden, in dem Sie die drei oben aufgeführten Funktionen (Suchfunktion, Zitatfunktion, Sprachauswahl) nicht aktivieren. Siehe ergänzend hierzu auch den folgenden <a href="#anchor-noIp">Abschnitt 5.3.</a>.</p>';
// III.5.2. IPs
		echo'
			<br /><span id="anchor-saveIP" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong>5.2. Wie IPs der User verarbeitet werden:</strong></p>
			<p>Die IP eines Besuchers wird in der Regel lediglich <strong>anonymisiert und zeitlich befristet</strong> (wenn die Voreinstellungen nicht geändert werden zwischen wenigen Minuten bis zu ca. 12 Std.) in gesonderten Datenbanktabellen gespeichert.</p>
			<p>Die Anonymisierung erfolgt durch Kürzung jeder IP. Bei den IPv4-Adressen wird das letzte Oktett, bei den IPv6-Adressen werden die letzten drei Blöcke jeweils auf "0" gesetzt. Zusätzlich werden die so gekürzten IPs mit einem individuellen Salt versehen und dann als Hash-Algorithmus gespeichert. Dies alles geschieht bei bis zu vier Gelegenheiten:</p>
			<ul>
				<li>Zum Schutz vor automatisierten Massen-Einträgen ("Flood-Sperre", nach der Intallation aktiviert => default: 5 bis 10 Min., je nach installierter Version) und</li>
				<li>zum Schutz vor Missbrauch der Suchfunktion (wenn die Suchfunktion aktiviert wird => default: 60 Min.),</li>
				<li>zur Kontrolle der Anzahl von Bilder-Uploads in einem Posting (wenn die Funktion zum Bilder-Upload aktiviert wird => default: 20 Min.),</li>
				<li>sowie für die Statistik (wenn die Statistik aktiviert wird => default: 12 Stunden).</li>
			</ul>
			<p>Die so aus der ursprünglichen IP gebildeten und befristet gespeicherten Zeichenfolgen sind nicht mehr personalisierbar und können daher m.E. auch nicht mehr als "personenbezogene Daten" angesehen werden.</p>
			<p>Zum jeweiligen Gästebucheintrag wird keine IP gespeichert, auch nicht anonymisiert.</p>
			<p>Die o.g. Zeitspannen bis zur jeweiligen Entfernung der Hash-Werte aus der Datenbank entsprechen den Grundeinstellungen nach der Installation und können technisch bedingt nicht als absolut angesehen werden, da die automatische Löschung auch davon abhängt, wie oft bzw. dass die "index.php" und die "insert.php" im Web aufgerufen werden. Denn erst mit dem Aufruf der Seite wird der Löschvorgang angestoßen.</p>
			<p>Nur <strong>IPs von Spameinträgen werden im Klartext</strong> zeitlich befristet gesichert. Dies geschieht u.a., um weitere Spameinträge im Gästebuch vom Absender unter derselben IP zu verhindern.</p>
			<p>Solche "Spam-IPs" werden i.d.R. nach 7 Tagen automatisch gelöscht. Daten, deren weitere Aufbewahrung zu Beweiszwecken erforderlich ist, können vom Admin bis zur endgültigen Klärung des jeweiligen Vorfalls von der Löschung ausgenommen werden.</p>
			<p>Die Speicherung von IPs, unter denen ein Spam-Eintrag erfolgte, kann unter dem Link "Allgemeine Konfiguration" deaktiviert werden (default: aktiviert).</p>
			<p>Siehe ergänzend auch die Hinweise in den unteren Abschnitten: <a href="#anchor-IPBar">IP-Sperre der Eintragsseite</a> und <a href="#anchor-ShowIpBar">IP-Sperren nach Spameinträgen</a></p>
			<p>Sie können das Gästebuch so konfigurieren, dass keinerlei IPs verarbeitet werden. Siehe hierzu den folgenden <a href="#anchor-noIp">Abschnitt 5.3.</a>.</p>
			<p><strong><span class="red">TIPP:</span></strong> Hilfreiche Anregungen für die Datenschutzerklärung Ihrer Website finden Sie ferner unter diesem Link als PDF: <a href="https://www.php-guestbook.de/pdf-files/myPHPGuestbook-DSGVO.pdf" title="Link öffnet ein neues Fenster" rel="external">Formulierungshilfe für Angaben zum <span class="italic">myPHP Guestbook</span> in einer Datenschutzerklärung</a>.</p>';
// III.5.3. Keine Cookies setzen, keine IPs speichern
		echo'
			<span id="anchor-noIp" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />5.3. Verwendung des <span class="italic">myPHP Guestbook</span> ohne Setzen von Cookies und/oder ohne Verarbeitung von IPs:</strong></p>
			<p class="text-shadow">5.3.1. Betrieb ohne Cookies:</p>
			<p>Wenn Sie nicht möchten, dass durch das Skript "<span class="italic">myPHP Guestbook</span>" Cookies auf dem Rechner eines Besuchers gesetzt werden, müssen folgende Funktionen deaktiviert sein:</p>
			<ul>
			<li>die Suchfunktion,</li>
			<li>die Zitier-Funktion,</li>
			<li>die individuelle Sprachauswahl durch den Gast.</li>
			</ul>
			<p>Dann werden nur noch die zur Identifizierung des Admins beim Login ins Admin-Panel erforderlichen Cookies gesetzt, s.o.</p>
			<p class="text-shadow">5.3.2. Betrieb ohne Verarbeitung von IPs:</p>
			<p>Wenn Sie nicht möchten, dass durch das Script "<span class="italic">myPHP Guestbook</span>" die IPs von Besuchern verarbeitet werden, weder anonymisiert noch (bei Spam-Einträgen) im Klartext, müssen folgende Funktionen deaktiviert sein oder werden:</p>
			<ul>
			<li>die Suchfunktion,</li>
			<li>die Statistik über die Aufrufe des Gästebuchs,</li>
			<li>die Funktion zum Schutz vor Masseneinträgen (Flood-Sperre - Wert auf "0" setzen),</li>
			<li>die Erfassung und befristete Speicherung von IPs nach Spam-Einträgen und</li>
			<li>die Funktion zum Upload von Bilddateien.</li>
			</ul>
			<p>Sie können diese Einstellungen alle auf einmal mit einem Klick unter diesem Link: "<a href="'.$url.'admin/admin.php?action=guestbook_options&#38;'.session_name().'='.session_id().'#anchor-konfig4">Erweiterter Datenschutz</a>" vornehmen.</p>
			<p>Beachten Sie, dass bei Deaktivierung von Cookies und IP-Verarbeitung die oben aufgezählten Funktionen nicht genutzt werden können. Eine erneute Aktivierung ist nur für jede Funktion einzeln unter dem Link "<a href="'.$url.'admin/admin.php?action=guestbook_options&#38;'.session_name().'='.session_id().'">Allgemeine Konfiguration</a>" möglich.</p>';
//III.5.4.mehr Datenschutz
		echo'
			<span id="anchor-morePP" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />5.4. Weitere Datenschutzeinstellungen:</strong></p>
			<p>Unter dem Link "Allgemeine Konfiguration" können Sie festlegen, dass der Gast, der einen neuen Eintrag für das Gästebuch verfasst hat, vor dem Speichern und der Veröffentlichung dieses Eintrags durch das Markieren einer CheckBox bestätigen muss, mit der Verarbeitung und Speicherung seiner Eingaben nach den Regeln der Datenschutzgrundverordnung einverstanden zu sein. Diese optionale Funktion nach der Installation ist zunächst deaktiviert.</p>
			<p>Weiterhin können Sie unter dem Link "Allgemeine Konfiguration" einstellen, dass am Ende der Seiten mit den veröffentlichten Gästebucheinträgen und dem Formular für einen neuen Eintrag ein Link zur Datenschutzerklärung auf Ihrer Website angezeigt wird. (Voreinstellung: deaktiviert). Der Link sollte in das entsprechende Feld als absoluter Pfad eingegeben werden (also mit: http(s)://).</p>
			<p>Innerhalb der Europäischen Union wird vorsorglich empfohlen, von beiden Möglichkeiten Gebrauch zu machen.</p>';
// IV. Nutzungshinweise 
		echo'
			<h2><br />IV. Nutzungshinweise:</h2>';
// IV.1. config.inc.php		
		echo'
			<span id="anchor-Config" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong>1. config.inc.php (Verzeichnis &quot;includes&quot;):</strong></p>
			<p>Das Gästebuch benötigt eine SQL-Datenbank, in der z.B. die Einträge der Besucher, aber auch die Konfigurationsdaten und vieles mehr gespeichert werden. Damit das Gästebuch überhaupt läuft, müssen daher die Datenbankzugangsdaten (die erhalten Sie von Ihrem Websitehoster) korrekt in der Datei &quot;config.inc.php&quot; eingetragen sein.</p>
			<p>Dank dem Installations-Script, in dem alle benötigten Daten in einer übersichtlichen Maske abgefragt werden, ist die Einrichtung der Verbindung zur Datenbank und die Anlage der benötigten Datenbanktabellen einfach. Mit der Umstellung auf MySQLi habe ich in das Script ferner eine automatische Prüfung eingebaut, ob die benötigte PHP-Erweiterung MySQLi auf Ihrem Webspace verfügbar ist.</p>
			<p>Das Installer-Script befindet sich ebenso wie das Script zum Update der Datenbank im Ordner "install".</p>
			<p><strong><span class="red">TIPP:</span></strong> Sollte die "config.inc.php" beschädigt oder überschrieben werden oder sollten sonstige nicht definierbare Verbindungsprobleme zur Datenbank entstehen, kann dies mit dem Diagnose- und Reparatur-Tool zu <span class="italic">myPHP Guestbook</span> geprüft und in den meisten Fällen behoben werden. Näheres hier siehe unten <a href="#anchor-Repair">Abschnitt IV. 4., "Diagnose- und Reparatur-Tool"</a>.</p>';
// IV.1.1. Zeitzonen
		echo'
			<span id="anchor-timezone" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />1.1. Zeitzonen, Datums- und Zeitformat:</strong></p>
			<p>Wenn Sie bei der Installation ab v.4.5.6 eines der Länder ausgewählt haben, die im DropDown-Menü angeboten werden, wird in der &quot;config.inc.php&quot; auch die Zeitzone gespeichert, unter der Ihre Homepage mit dem Gästebuch läuft. Für nachträgliche Änderungen der Zeitzone muss also die &quot;config.inc.php&quot; mit einem Editor geöffnet und der Variablen &quot;<span class="blue">$timezone</span>&quot; eine ggf. gewünschte andere Zeitzone zugewiesen werden.</p>
			<p>Alle von PHP erkannten und verwendbaren Zeitzonen finden Sie unter:</p>
			<p class="zentriert">&lt; php.net/manual/timezones.php &gt;.</p>
			<p>Wenn die Variable &quot;<span class="blue">$timezone</span>&quot; leer ist, ihr also keine bestimmte Zeitzone zugewiesen wird, wird vom Programm auf die Grundeinstellungen des Servers zurückgegriffen.</p>
			<p>Falls Sie die Installation des Gästebuchs mit einer der früheren Gästebuch-Versionen (v.4.5.5 oder kleiner) vorgenommen haben, wird in der &quot;config.inc.php&quot; Ihrer Installation keine Variable &quot;<span class="blue">$timezone</span>&quot; existieren. Sollten Sie bisher keine Unstimmigkeiten in der Zeiterfassung (z.B. Datum und Zeit von Gästebucheinträgen) festgestellt haben, wird der Server, auf dem Ihr Gästebuchscript läuft, für Ihre Bedürfnisse korrekt konfiguriert sein und Sie müssen sich darum nicht weiter kümmern. Andernfalls laden Sie die &quot;config.inc.php&quot; vom Server auf Ihren Rechner, öffnen sie mit einem Editor und fügen nach den Zugangsdaten für Ihre Datenbank z.B. für Deutschland folgendes ein:</p>
			<p class="zentriert blue">$timezone = &quot;Europe/Berlin&quot;;</p>
			<p>Für Zeitzonen anderer Länder siehe Link oben. Die Zeitzone ist in Anführungszeichen zu setzen, wie im Beispiel. Das Semikolon am Ende nicht vergessen!</p>
			<p>Sobald in den allgemeinen Konfigurationseinstellungen die US-Flagge eingestellt wird, wird im Gästebuch auch das Datum im US-Format angezeigt (mm-dd-yyyy). Außerdem erfolgt die Zeitanzeige auf der Seite mit den Gästebucheinträgen und in der Beitragsvorschau im amerikanischen 12-Stunden-Format. (Umstellung der Zeitanzeige für alle Gästebucheinträge ab v.4.9.0 / 10. Mai 2018.) Bei allen anderen Flaggen bleibt es beim 24-Stunden-Zeitformat und dem international üblichen Datumsformat (TT.MM.JJJJ).</p>';
// IV.1.2. https
		echo'
			<span id="anchor-save" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />1.2. Nachträgliche Umstellung auf eine (un)gesicherte Internetverbindung (http &harr; https):</strong></p>
			<p>Wer seine Website <strong>nach</strong> der Installation des Gästebuchs auf eine gesicherte Internetverbindung (oder umgekehrt) umstellt (Wechsel zwischen &quot;http&quot; und &quot;https&quot;), muss auch den Pfad für die Verweise innerhalb des Gästebuchs umstellen.</p>
			<p>Hierzu die &quot;config.inc.php&quot; (zu finden im Ordner &quot;includes&quot;) vom Server auf den eigenen Rechner runterladen, mit einem Editor öffnen und beim &quot;Domainpath&quot; zu den Variablen &quot;<span class="blue">$url</span>&quot; und &quot;<span class="blue">$url02</span>&quot; das &quot;http://&quot; in &quot;http<strong>s</strong>://&quot; (oder umgekehrt) ändern/ergänzen. Abspeichern und die &quot;config.inc.php&quot; wieder auf den Server laden. - Fertig.</p>';
// IV.2. + 2.1. Gästebuchseite
		echo'
			<span id="anchor-Gaestebuch" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2. Gästebuch</strong></p>
			<p class="text-shadow"><strong>2.1. Gästebuchseite:</strong></p>
			<p>Auf der "index"-Seite in der obersten Ebene des Gästebuchordners werden alle Beiträge, die in das Gästebuch eingetragen wurden, angezeigt. Die Anzahl der Beiträge pro Seite kann hier im Admin-Bereich ebenso individuell selber festgelegt werden, wie die Anzahl der Links zum Durchblättern der einzelnen Seiten. - Wer unschöne Umbrüche bei der Anzeige des Gästebuchs auf einem Smartphone verhindern möchte, sollte bei der Anzahl der angezeigten Links zum Durchblättern nicht über die Voreinstellung von max. 9 hinausgehen.</p>
			<p>Das Gästebuch verfügt über ein Template- und Style-Management, mit dem Sie das Aussehen des Gästebuchs ganz einfach verändern können. Insgesamt zwölf vorgefertigte, mit den passenden CSS-Styles versehene Templates werden mit installiert und können nach Ihrem persönlichen Geschmack genutzt werden. Mehr hierzu unten im Abschnitt 3.3.</p>
			<p>Falls Sie das Gästebuch über PHP includen, sollten Sie beachten, dass die GET-Variable &quot;$page&quot; bereits vom Script verwendet wird.</p>
			<p>Die Gästebuchseite kann mit entsprechenden Kenntnissen in PHP und HTML selbst angepasst werden, um z.B. zusätzliche Links einzufügen. Für weniger erfahrene PHP-Nutzer steht auf <a href="https://www.php-guestbook.de" title="Link öffnet ein neues Fenster" rel="external">www.php-guestbook.de</a> ein Ergänzungspaket zum Download bereit. Mit den dort enthaltenen angepassten Dateien und zwei Demo-Seiten sollte das includen des Gästebuch-Scripts kein Problem mehr sein, wobei allerdings Grundkenntnisse in HTML, PHP und CSS sowie über den Aufbau einer Website im Allgemeinen vorhanden sein sollten.</p>';
// IV.2.1.1. Änderungen von Schriftfarbe pp
		echo'
			<span id="anchor-Changes" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.1.1. Änderungen der Schriftart, von Schriftgröße, Schrift- und Linkfarben, Hintergründen, Breite des Gästebuchs, Ausrichtung auf der Seite (rechts-links-mittig), Symbole für E-Mail und Homepage eines Gasteintrages, Farbe der aktiven Bewertungs-Sterne:</strong></p>
			<p>Alle die oben aufgelisteten Einstellungen können ganz einfach unter dem Link &quot;Template editieren&quot; angepasst werden. Änderungen am Quellcode oder den CSS sind hierfür nicht notwendig.  Siehe unten <a href="#anchor-EditTempl">Abschnitt IV. 3.3.2, "Template editieren"</a>.</p>
			<p>Auf der Seite für die Gästebucheinträge bekommen die Input- und das Textarea-Feld beim Setzen des Cursors programmseitig einen grauen Rahmen mit entsprechendem äußerem Schatten gesetzt. Um dies auf Wunsch individuell anzupassen, siehe unten <a href="#anchor-EditStyle">Abschnitt IV. 3.4.2, "Style editieren"</a>.</p>';
// IV.2.1.2. Copyrighthinweis
		echo'
			<span id="anchor-Copy" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.1.2. Copyrighthinweis:</strong></p>
			<p>Der sichtbare Copyrighthinweis auf der Index- und Insert-Seite darf laut der General Public License entfernt werden.</p>
			<p>Sie sollten jedoch bedenken, dass <span class="italic">myPHP Guestbook</span> vor allem durch den Link im Copyrighthinweis an neue User kommt.</p>
			<p>Der Copyrighthinweis im Quellcode darf in keiner Datei entfernt werden.</p>';
// IV.2.2. Eintragsseite
		echo'
			<span id="anchor-Eintragsseite" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2. Eintragsseite:</strong></p>
			<p>Damit Beiträge im Gästebuch erfasst werden, müssen sie auf der Eintragsseite durch den Besucher eingetragen werden. Es handelt sich hierbei um die &quot;insert.php&quot; auf der obersten Ebene des Gästebuchordners.</p>
			<p>Die Grundeinstellung für die Breite, mit der das Eintragsformular im Browser dargestellt wird, beträgt 500px. Sie können unter dem Link "Template editieren" einstellen, dass das Eintragsformular abweichend hiervon mit derselben Breite dargestellt wird, wie die Gästebucheinträge auf der "index.php".</p>
			<p>Je nachdem, wie das Gästebuch konfiguriert ist, stehen auf der Seite für neue Einträge mehr oder weniger Features zur Auswahl. Die Wichtigsten davon sind …</p>';
// IV.2.2.1. Eingabemöglichkeiten
		echo'
			<span id="anchor-Entry" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.1. Eingabemöglichkeiten:</strong></p>
			<p>Nach der Installation sind ab Version 4.6.0 sämtliche Eingabefelder, außer denen für den Namen und den Beitrag des Gastes, im Admin-Panel unter dem Link "Allgemeine Konfiguration" getrennt voneinander ein- und ausblendbar.</p>
			<p>Zur Platzersparnis sind die Input-Felder für Ort und Land einerseits, sowie (soweit der Platzbedarf dies unter bestimmten Konfigurationen zulässt) für E-Mail und Homepage andererseits, nebeneinander angeordnet. Wird nur eins der beiden jeweils nebeneinander liegenden Input-Felder deaktiviert, erstreckt sich anschließend das verbliebene Feld automatisch über die gesamte Breite des Eingabeformulars, um ein optisch einheitliches Aussehen zu erhalten.</p>';
// IV.2.2.2. Smileys
		echo'
			<span id="anchor-Smiley" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.2. Smileys/Emojis:</strong></p>
			<p><span class="italic">myPHP Guestbook</span> unterstützt Emojis, d.h. Sie können z.B. ":angry:" bei einem neuen Gästebucheintrag eintippen und in der Gästebuchseite wird das ":angry:" durch ein Bild mit einem wütenden Smiley ersetzt.</p>
			<p>Das Einfügen solcher Smileys wurde in v. 4.x geändert: Wurde bei einer der Versionen vor 4.1 ein angeklickter Smiley stets ans Ende des getippten Textes im Eintragsformular gesetzt, wird er jetzt dort eingefügt, wo sich der Cursor im Textfeld befindet, jeweils mit einem Leerzeichen davor und dahinter.</p>
			<p>Die Verwendung von Emojis kann dabei hilfreich sein, geschriebenen Text richtig zu interpretieren. So ist z.B. nicht jeder Sarkasmus oder jede Ironie allen aus der Wortwahl heraus für jeden Leser erkennbar. – Unerwünscht ist jedoch oftmals, einen Eintrag mit aneinandergereihten "Ketten" von Smileys zu "verzieren".</p>
			<p>Um dies in gewissem Umfang zu steuern, können Sie unter dem Link "Allgemeine Konfiguration" durch markieren der entsprechenden Checkbox festlegen, dass das Programm beim Speichern oder der Vorschau eines neuen Eintrags prüft, wieviele Emojis vom Gast in seinen Eintrag eingefügt wurden. Wenn mehr als '.$maxSmilies.' Stück in einem Gästebucheintrag enthalten sind, werden automatisch überzählige Emojis aus dem Text entfernt.</p>
			<p>Die maximale Anzahl der geduldeten Emojis (default: 10 Stück) können Sie auf Wunsch ändern. Siehe hierzu unten den Abschnitt "<a href="#anchor-MoreKonfig-02">weitere Konfigurationsmöglichkeiten</a>".</p>
			<p>Die Funktion zur Kontrolle der Anzahl verwendeter Emojis ist nach der Installation zunächst deaktiviert.</p>';
// IV.2.2.3. BBCodes
		echo'
			<span id="anchor-BBC" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.3. BBCodes:</strong></p>
			<p>Anhand von BBCodes kann der Gast seinen Eintrag formatieren. Dadurch wird z.B. Text zwischen den beiden Tags [b]<strong>Irgendein Text</strong>[/b] fett dargestellt.</p>
			<p>Neben diesem einfachen BBCode können in <span class="italic">myPHP Guestbook</span> noch viele weitere verwendet werden für farbige Texte, Zitate und mehr.</p>
			<p>Wenn der Gast mit der Mouse einen bestimmten Textbereich im Formularfeld markiert und dann auf den gewünschten BBCode klickt, werden die benötigten Tags automatisch an den Anfang und das Ende des markierten Textes gesetzt.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Anklickbare Links und E-Mail-Adressen können jetzt nur noch bei Verwendung der Tags, wie sie von den neu angelegten Eingabemasken mitgeliefert werden, in Beiträge eingefügt werden. Die Eingabemasken werden über die entsprechenden BBCode-Buttons aufgerufen. Wenn eine URL z.B. in der Form: &quot;http://www.example.com&quot; ohne die bei Nutzung der Eingabemaske mitgelieferten Tags in einen Gästebucheintrag geschrieben wird, wirft das Programm einen Warnhinweis für den Gast aus und verweigert die Speicherung des Eintrags bis zur Änderung. - Alleine damit werden nach meinen Beobachtungen schon mehr als 3/4 aller Spamversuche geblockt, denn Spam-Bots rufen keine Eingabemasken auf und ein anklickbarer Verweis auf irgendeine Pornoseite durch einen nachtaktiven Bot ist damit praktisch ausgeschlossen.</p>
			<p>Das komfortable Einfügen von BBCodes mit einem Klick funktioniert nur -ebenso wie die vergleichbare Funktion zum Einfügen der Smileys-, wenn der Nutzer Javascript aktiviert hat. Wenn nicht, wird ein entsprechender Hinweis eingeblendet.</p>';
// IV.2.2.4. Foto Uploads
		echo'
			<span id="anchor-Photo" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.4. Bilder (Fotos) in Gästebucheinträgen:</strong></p>
			<p>In den Gästebuchversionen bis 4.3.x konnten Bilder in Einträgen nur eingestellt werden, wenn sie verlinkt waren, also irgendwo, sei es bei einem der vielen Fotoportale, sei es auf dem eigenen Webspace des Gastes oder wo auch immer, bereits online gestellt waren. Das hatte eine Reihe von Nachteilen sowohl haftungsrechtlicher Natur wie auch insofern, dass erfahrungsgemäß diese Bilder dort, von wo sie verlinkt waren, über kurz oder lang wieder verschwanden und dann im Gästebuch recht unschöne &quot;Lücken&quot; hinterließen.</p>
			<p>Mit der ab Version 4.4.0 bereitgestellten Upload-Funktion kann ein Gast Fotos oder sonstige Bilddateien vom eigenen Rechner in einen Ordner auf dem Webspace, auf dem sich auch das Gästebuchscript befindet, hochladen, die dann im Gästebuchbeitrag angezeigt werden. Auch vom Admin können Bilder in einen Kommentar zu einem Gästebucheintrag hochgeladen und eingestellt werden. Da diese Dateien anschließend auf dem eigenen Webspace liegen, können sie nicht mehr einfach von dritter Seite unkontrolliert gelöscht werden.</p>
			<p>Ferner kann eine individuelle Kurzbeschreibung des Bilds, die später beim Überfahren mit der Mouse eingeblendet wird, ein sogen. &quot;Title&quot;, eingegeben werden.</p>
			<p>Für die Nutzung dieser Funktionen müssen in den Konfigurationseinstellungen sowohl &quot;BBCodes&quot; wie auch die Funktion: &quot;Bilder in Gästebucheinträgen anzeigen, Bild-Uploads zulassen?&quot; aktiviert werden. Nach der Neuinstallation ist die Funktion Bilder-Uploads und Bildanzeige in Einträgen zunächst deaktiviert.</p>
			<p>Serverseitig müssen insbesondere folgende Einstellungen vorliegen (im Zweifel bei Ihrem Hoster nachfragen oder über <span class="italic">php.info</span> prüfen):</p>
			<ul>
				<li>file_uploads = On
				<li>aktivierter GD-Support
			</ul>
			<p>Sollte bei Ihrem Webspace kein GD-Support durch den Provider zur Verfügung gestellt werden, ist das Programm so eingerichtet, dass sich die Funktion &quot;Bild-Upload&quot; in den allgemeinen Konfigurationseinstellungen nicht aktivieren lässt.</p>
			<p>Damit nicht über Nacht irgendwelche anstößigen Bilder eingestellt werden, wurden zwei Sicherheitsschranken eingepflegt: </p>
			<ul>
				<li>Der Admin bekommt automatisch jedes Mal, wenn ein Bild hochgeladen wird, eine E-Mail mit der hochgeladenen Datei zur sofortigen Kontrolle übermittelt. (Diese Mail kommt, sobald die Upload-Funktion vom Admin freigeschaltet wurde, aus Sicherheitsgründen immer, unabhängig von den sonstigen E-Mail-Einstellungen. Bedingung ist nur die serverseitige Verfügbarkeit der PHP internen mail()-Funktion.)
				<li>Hochgeladene Bilder können vom Gast zwar in der Eintragsvorschau sofort betrachtet werden, sind aber nach dem Speichern des Beitrags zunächst noch für die Öffentlichkeit unsichtbar. Es wird stattdessen ein Platzhalter im Beitrag angezeigt mit dem Hinweis, dass ein dort eingestelltes Bild vom Admin erst freigeschaltet werden muss. Sobald der Admin sich über die ihm übermittelte E-Mail mit der hochgeladenen Datei von deren Unbedenklichkeit überzeugen konnte, kann er ebenfalls mit einem Klick auf den Link in der gesonderten Mail über den Hinweis auf einen neuen Gästebucheintrag das Bild freischalten. Ein vorheriges Einloggen hier in den Admin-Bereich ist nicht notwendig. Voraussetzung ist lediglich, dass die Upload-Funktion und die Funktion &quot;Admin per E-Mail von neuem Gästebucheintrag informieren&quot; in den allgemeinen Konfigurationseinstellungen aktiviert wurden.
					<ul>
						<li style="list-style-type:none"><br /><strong>Hinweis:</strong> Die Notwendigkeit einer Prüfung und Freischaltung jedes neu hochgeladenen Bilds kann in besonderen Ausnahmefällen deaktiviert werden. Für weitere Erläuterungen hierzu siehe unten <a href="#anchor-MoreKonfig">Abschnitt IV. 3.2.5, "Weitere Konfigurationsmöglichkeiten"</a>.
						<li style="list-style-type:none"><br />Ggf. vom Admin in einen Kommentar zu einem Gästebucheintrag eingefügte Bilder sind auch ohne Freigabe sofort öffentlich sichtbar; der Admin als Kommentator muss wissen, was er macht.
					</ul>
			</ul>
			<p><strong>Weitere Features:</strong></p>
			<ul>
				<li>Je nach Einstellung in der php.ini können Dateien bis zu 6 MB hochgeladen werden. Unter dem Link "Upload Konfiguration" kann diese Grenze selbstverständlich auch niedriger bis auf 1 MB reduziert werden. Die Voreinstellung ist auf 2 MB.
				<li>Hochgeladene Bilder werden automatisch in der Größe angepasst! Unter dem Link "Upload Konfiguration" können hierzu die gewünschte maximale Breite und Höhe festgelegt werden. Die hierbei grösste einstellbare Bildbreite wird vom Programm automatisch nach dem vom Admin gewählten Template bzw. der eingestellten Breite des Gästebuchs ermittelt und angezeigt, so dass es gleichgültig davon, wie groß z.B. das hochgeladene Foto ist, keine Probleme mit dem Layout des Gästebuchs gibt. Wenn das Gästebuch auf dem kleinen Bildschirm z.B. eines Smartphones betrachtet wird, werden die eingestellten Bilder in der Darstellung automatisch verkleinert.
				<li>Die Bildqualität von jpg-Dateien (und damit letztlich auch die anschließende Ladezeit) kann genauso individuell unter dem Link "Upload Konfiguration" zwischen 10 und 100% eingestellt werden.
				<li>Da der Admin-Bereich unabhängig von der Einstellung zum öffentlichen Bereich des Gästebuchs eine feste Größe hat, werden die Fotos für die Anzeige im Backend noch einmal gesondert passend skaliert.
				<li>Es können ausschließlich Dateien im Format .jpg und .png hochgeladen werden, alle anderen Dateien sind gesperrt.
				<li>Die hochgeladenen Dateien werden zur Sicherheit mehreren automatischen Prüfungen unterworfen, um sicherzustellen, dass tatsächlich nur Bilddateien hochgeladen werden können.
				<li>Das, was später im Ordner mit den Gästebuchbildern abgelegt wird, ist stets eine -in Größe und Qualität angepasste und mit einem neuem Dateinamen versehene- Kopie der hochgeladenen Datei; das Original wird nach Fertigung der Kopie umgehend wieder gelöscht, auch um zu vermeiden, dass später Bilddateien im Gästebuch gezeigt werden, die Schadcode über den EXIF-Header einschleusen.
				<li>Die maximale Anzahl der von einem User zu seinem Eintrag hochgeladenen und im Gästebuchbeitrag eingefügten Dateien kann in einem Bereich zwischen "1" und "10" unter dem Link "Upload Konfiguration" eingestellt werden. - Die Voreinstellung nach der Installation ist "2".
				<li>Wegen weiterer Sicherheitshinweise lesen Sie die <strong class="italic">&quot;ReadMe.pdf&quot;</strong>.
			</ul>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Beim Upload von großen Dateien mit z.B. 5 oder sogar 6 MB sollte der User eine entsprechend schnelle Internetverbindung nutzen, weil die maximal ausführbare Verarbeitungszeit eines Scripts bei praktisch allen Providern begrenzt ist. Alles, was nicht innerhalb dieser Zeit vom Script verarbeitet werden kann, wird im Bearbeitungsprozess abgebrochen.'; if(ini_get("max_execution_time")==true){echo' Die maximale Laufzeit eines Scripts ist durch Ihren Provider auf <strong>'.ini_get("max_execution_time").' Sekunden</strong> festgelegt.';}echo'</p>';
// IV.2.2.5. Zitate
		echo'
			<span id="anchor-Quote" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.5. Zitieren von Gästebucheinträgen:</strong></p>
			<p>Ebenfalls in den Konfigurationseinstellungen gesondert deaktivierbar* ist eine neue Zitierfunktion. (*Diese Funktion ist nach einer Neuinstallation aktiviert.)</p>
			<p>Wird dieses Feature vom Admin nicht gesperrt, wird am Ende eines jeden Gästebucheintrags, gleichgültig ob &quot;alt&quot; bzw. schon vorhanden oder erst neu verfasst, ein verlinktes &quot;Zitat&quot;-Symbol eingeblendet.</p>
			<p>Für die Nutzung dieser Funktion müssen nicht zwingend gleichzeitig auch die sonstigen BBCodes freigeschaltet sein bzw. bleiben.</p>
			<p>Nach dem Anklicken des Zitatsymbols zu dem vom Gast gewählten Eintrag, wird dieser Gästebuchbeitrag als Zitat mit Hinweis auf Verfasser sowie Datum und Zeit des Eintrags in das Formular für einen neuen Gästebucheintrag übernommen zur komfortablen, eindeutigen Beantwortung oder Diskussion. Mehrfachzitate (Zitat in Zitat in Zitat usw.) sind nahezu unbeschränkt möglich. In einem zitierten Beitrag ggf. enthaltenen Fotos werden aus Platzgründen und zur besseren Übersicht aus dem Zitat automatisch entfernt. Etwaige Admin-Kommentare zu dem zitierten Eintrag werden seit v.4.8.0 mit zitiert.</p>
			<p>Im sogen. "Blog-Modus" des Gästebuchs (neue Einträge nur durch den Admin über das Admin-Control-Panel) wird die Zitatfunktion automatisch deaktiviert bzw. lässt sich nicht aktivieren.</p>';
// IV.2.2.6. Bewertungsfunktion
		echo'
			<span id="anchor-Stars" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.6. Bewertungsfunktion:</strong></p>
			<p>Mit v.4.7.0 ist das Script um eine optionale* Funktion zur Bewertung der Homepage oder auch eines anderen, frei wählbaren Inhalts durch Vergabe von einem bis fünf Sterne erweitert worden (*Die Bewertungs-Funktion ist nach einer Neuinstallation aktiviert.)</p>
			<p>Während eines neuen Eintrags im Gästebuch kann der Gast einen von fünf Sternen anklicken und so zum Ausdruck bringen, was er z.B. von der Online-Präsenz hält.</p>
			<p>Werden die nach einer Bewertung im Gästebuch angezeigten Sterne mit der Mouse überfahren, wird ein tooltip eingeblendet mit einem kurzen erläuternden Texthinweis. Der Admin kann durch entsprechende Einstellung unter "Allgemeiner Konfiguartion" festlegen, ob dieser Texthinweis auch Angaben zu dem aus allen abgegebenen Bewertungen ermittelten Durchschnittswert enthalten soll.</p>
			<p>Es wurde bewusst davon Abstand genommen, eine Vorbelegung durchzuführen, nach der ohne irgendwelche diesbezüglichen Aktivitäten des Gastes automatisch "5 Sterne" vergeben werden. Klickt der Gast vor dem Speichern seines Gästebucheintrags nicht aktiv einen der Sterne an, findet keine Bewertung statt und es wird auch keine gespeichert.</p>
			<p>Eine Editierung einer vom Gast abgegebenen Bewertung im Admin-Control-Panel ist nur insoweit möglich, wie die Bewertung unter dem Link zur Eintragsbearbeitung zwar ganz gelöscht, ansonsten aber nicht geändert werden kann.</p>
			<p>Unter dem Link <a href="#anchor-EditTempl">"Template editieren"</a> lässt sich aus einer Auswahl mehrerer Grafiken die nach dem jeweiligen Geschmack gewünschte Farbe der aktiven Bewertungs-Sterne auswählen und einstellen.</p>
			<p>Der Text zu dem, was der Gast bewerten soll, lässt sich in den "Allgemeinen Konfigurationseinstellungen" individuell bestimmen. Wird hier nichts abweichendes eingetragen, lautet die Vorbelegung "Websitebewertung".</p>';
// IV.2.2.7. Gast über Antwort zu seinem Eintrag informieren
		echo'
			<span id="anchor-ComInfo" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.7. Gast über Antwort zu seinem Eintrag automatisch informieren:</strong></p>
			<p>Wenn unter "Allgemeiner Konfiguration" die Option: "Check-Box für "Info-E-Mail" an Gast bei Kommentierung seines Eintrags" nicht deaktiviert wird, erscheint auf der "insert.php" unter dem Textfeld für einen neuen Gästebucheintrag ein Feld, das der Gast anklicken kann, wenn er über einen Kommentar zu seinem Eintrag per E-Mail informiert werden möchte.</p>
			<p>Die E-Mail wird automatisch an die vom Gast zu seinem Eintrag angegebene E-Mail-Adresse verschickt, sobald entweder im Admin-Panel ein Kommentar zu dem betreffenden Gästebucheintrag abgespeichert oder der Gastbeitrag im öffentlichen Bereich des Gästebuchs zitiert wird. Es ist sichergestellt, dass nur beim <strong>ersten</strong> Speichern eines Admin-Kommentars und beim <strong>ersten</strong> Zitat des Gastbeitrags eine Info-E-Mail an den Gast geht; späteres erneutes Aufrufen und Speichern von Korrekturen oder Änderungen zu einem einmal verfassten Kommentar oder erneutes Zitieren eines Eintrags veranlassen keine weiteren Info-E-Mails mehr.</p>
			<p><span class="italic">Dass</span> der Gast die Check-Box aktiviert hat und per E-Mail informiert werden möchte, erkennt der Admin auf der zentralen Seite zur Verwaltung von Einträgen und Kommentaren daran, dass hinter dem Link zum Abfassen eines Kommentars ein kleines "e" für E-Mail eingeblendet wird: <span class="blue">[e]</span>. Beim Überfahren dieses Links mit der Mouse wird als Tooltip eingeblendet, bei welchen Aktionen der Gast eine entsprechende Info-Mail erhält.</p>
			<p>Die Option "Info-E-Mail an Gast" wird automatisch deaktiviert bzw. lässt sich nicht aktivieren, wenn der Admin festlegt, dass das Eingabefeld für eine E-Mail-Adresse des Gastes ausgeblendet wird und daher der Gast eine E-Mail-Anschrift, an die die Info-Mail geschickt werden könnte, nicht hinterlegen kann.</p>';
// IV.2.2.8. IP-Sperre der Eintragsseite
		echo'
			<span id="anchor-IPBar" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2.2.8. IP-Sperre der Eintragsseite:</strong></p>
			<p>Es gibt zwei Ansätze, bei denen das Programm <span class="italic">myPHP Guestbook</span> die IP des Users nutzt, um weitere Einträge im Gästebuch unter derselben IP temporär zu verhindern:</p>
			<p>Einmal zum Schutz vor automatisierten Masseneinträgen binnen kurzer Zeit und zum Anderen zum Schutz vor Spameinträgen.</p>
			<p>Der Schutz vor automatisierten Masseneinträgen mittels IP-Sperre funktioniert so, dass die <strong>(anonymisierte)</strong> IP eines Users, der einen Gästebucheintrag verfasst hat, für eine gewisse, einstellbare Zeitspanne gespeichert bleibt und unter derselben IP innerhalb dieser Zeitspanne weitere Gästebucheinträge verhindert werden. Das Ganze nennt sich "Flood Sperre" und wird manchen Usern gerade nach der Neuinstallation des Gästebuchs lästig, nämlich wenn sie versuchen, per "copy and paste" binnen kürzester Zeit Einträge aus einem anderen, zuvor genutzten Gästebuch in das <span class="italic">myPHP Guestbook</span> zu übertragen.</p>
			<p>Eine Lösung ist einfach: Die Einträge einfach im Admin-Control-Panel unter dem Link "Admin Blog" vornehmen, dort gibt es keine "Flood Protection", siehe unten <a href="#anchor-Blog">Abschnitt IV. 3.1.3., "Admin Blog"</a>.</p>
			<p>Wegen der IP-Sperre, die durch einen Spameintrag verursacht wird und programmseitig für '.$delete_spamIps.' Tage aufrecht erhalten bleibt, siehe unten <a href="#anchor-ShowIpBar">Abschnitt IV. 3.7.3., "Spamfilter - IP-Sperren"</a>.</p>
			<p>Falls Sie nicht möchten, dass IPs vom Script verarbeitet werden, siehe hierzu oben <a href="#anchor-noIp">Abschnitt III.5.3.</a>.</p>';
// IV.3. Admin-Control-Panel
		echo'
			<span id="anchor-Admin" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3. Admin-Control-Panel</strong></p>
			<p>Das ganze Gästebuch wird kinderleicht über das <span class="italic">myPHP Guestbook</span> Admin-Control-Panel verwaltet. Zugriff auf das Admin-Panel gibt es nur mit einem korrekten Benutzernamen und Passwort.</p>
			<p>Auf einigen Seiten des Admin-Panels finden Sie dieses Info-Symbol: <img class="img-ok" title="'.$amsg[119].'" src="'.$url.'images/help.png" width="14" height="14" alt="'.$amsg[119].'" />. Wenn Sie darauf klicken, öffnet sich ein Lightbox-Fenster mit weiteren hilfreichen Informationen zu der markierten Funktion.</p>';
		echo'
			<span id="anchor-new-pw" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.0.1. Passwort vergessen:</strong></p>
			<p>Falls Sie Ihr Passwort zum Einloggen in das Admin-Control-Panel einmal vergessen haben sollten, können Sie über den Link "Passwort vergessen" ein neues Passwort generieren und sich an Ihre Admin-E-Mail-Adresse schicken lassen.</p>
			<p>Wenn Sie von dieser Möglichkeit Gebrauch gemacht haben, sollten Sie sich anschließend mit dem neu generierten Passwort einloggen und sogleich ein neues Passwort vergeben. Das mit der "Passwort-vergessen"-Funktion angeforderte Ersatzpasswort wird aus Sicherheitsgründen nach '.$pw_minutes.' Minuten automatisch wieder deaktiviert.</p>';
		echo'
			<span id="anchor-sec-auth" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.0.2. Zwei-Faktor-Authentisierung:</strong></p>
			<p>Wer ganz besonders vorsichtig ist und den zusätzlichen Aufwand nicht scheut, kann über die stets notwendige Eingabe eines korrekten Benutzernamens und des Admin-Passwortes hinaus zum Einloggen in das Admin-Panel die Notwendigkeit zur Eingabe eines zweiten Passworts aktivieren.</p>
			<p>Dieses zweite Passwort wird bei Freischaltung der entsprechenden Funktion vom Programm aus einer zufälligen Zeichenfolge bei jedem Login neu generiert und dem Admin per E-Mail zugeschickt. Es ist dann drei Minuten gültig. Innerhalb dieser 180 Sekunden muss das per Mail zugeschickte weitere Passwort eingegeben und abgeschickt werden, sonst beginnt der Login-Vorgang wieder von vorne.</p>
			<p>Nach der Installation ist dieses Feature zunächst deaktiviert. Um es zu aktivieren, öffnen Sie bitte mit einem Editor die Datei "settings.inc.php" im Verzeichnis "includes". Dort finden Sie an siebter Stelle unter den Copyright-Hinweisen die Konstante "<span class="blue">GB_SEC_AUTH</span>". Ersetzen Sie das "<span class="blue">false</span>" in dieser Konstante mit "<span class="blue">true</span>". Speichern Sie die Änderung und laden Sie die Datei auf Ihren Server. Das war\'s.</p>			
			<p><strong>Bitte beachten:</strong> Aktivieren Sie dieses Feature nur, wenn Sie sicher sind, dass der automatische E-Mail-Versand per PHP mit dem Skript funktioniert.</p>';			
		echo'
			<span id="anchor-hijacking" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.0.3. Session Hijacking:</strong></p>
			<p>Damit ein Server einen bestimmten Clienten beim Aufruf mehrerer Seiten eines Hosts erkennen kann, wird eine Session angelegt mit einer individuellen ID, die mit dem Logout oder auch nach einer festgelegten Zeitspanne oder dem Schließen des Browsers wieder verfällt. So können Sie z.B. hier im Admin-Panel nach dem Einloggen eine Seite nach der anderen anklicken und aufrufen, ohne sich bei jedem Klick und für jede neue Seite neu anmelden zu müssen.</p>
			<p>Beim sogen. "Session Hijacking" verschafft sich ein Dritter die Daten einer solchen Session, um damit Ihren virtuellen Platz einzunehmen.</p>
			<p>Der beste Schutz gegen solche Angriffe sind die Verwendung verschlüsselter https-Verbindungen und die Unterbindung von "Cross-Site Scripting"-Angriffen als vermutlich der Hauptmethode, um per JavaScript an die Session-Daten zu gelangen.</p>
			<p>Als weiteren, vertiefenden Schutz kann PHP dazu genutzt werden, dass die (spätestens) mit dem Aufruf der Login-Seite vom Server generierte Session-ID während des Loggin-Vorgangs automatisch erneuert, also ausgetauscht wird, so dass zuvor ggf. erlangte Daten wertlos sind.</p>
			<p>Dazu nutzt man die Funktion "session_regenerate_id". Allerdings hat "session_regenerate_id" einen kleinen Haken:</p>
			<p>Bei instabilen Netzwerken, wie z.B. WiFi oder mobilen Netzwerken, kann es vorkommen, dass die neu generierte Session "verloren geht". Dann misslingt der Login. Sollten Sie also viel z.B. mit einem Tablet arbeiten <strong>und</strong> öfter Login-Probleme haben, können Sie die automatische Erneuerung der Session-ID deaktivieren, um zu testen, ob sich eventuelle Schwierigkeiten beim Login damit beheben lassen.</p>
			<p>Nach der Installation oder einem Update von einer myPHP Guestbook Version < 4.10.6 ist dieses Feature aktiviert. Um es zu deaktivieren, öffnen Sie bitte mit einem Editor die Datei "settings.inc.php" im Verzeichnis "includes". Dort finden Sie an sechster Stelle unter den Copyright-Hinweisen die Konstante "<span class="blue">ID_REG</span>". Ersetzen Sie das "<span class="blue">true</span>" in dieser Konstante mit "<span class="blue">false</span>". Speichern Sie die Änderung und laden Sie die Datei auf Ihren Server.</p>';
		echo'
			<span id="anchor-Noentry" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.0.4. Automatische Login-Sperre:</strong></p>
			<p>Jeder Versuch, sich in das Admin-Control-Panel mit einem falschen Nutzernamen oder einem falschen Passwort einzuloggen und auch jede Eingabe einer falschen E-Mail-Adresse bei der "Passwort vergessen"-Funktion wird erfasst und hochgezählt. Nach '.$allowed_attemps.' Versuchen mit unrichtigen Eingaben wird der Login-Bereich für jegliche Eingaben komplett gesperrt.</p>
			<p>Die Möglichkeit zum Login bleibt danach aus Sicherheitsgründen für '.$barrier_days.' Tage gesperrt und wird erst nach deren Ablauf automatisch wieder freigegeben.</p>
			<p>Damit der Admin jedoch auch die Möglichkeit hat, sich vor Ablauf dieser '.$barrier_days.' Tage bei Bedarf wieder einzuloggen, geht gleichzeitig mit der Sperre des Login-Bereichs eine E-Mail an den Admin mit einem Link zur sofortigen Freigabe des Login.</p>
			<p>Damit nicht einfach durch automatisierte massenhafte Versuche der Code für die Freigabe eines gesperrten Login erraten werden kann, wird die Möglichkeit einer vorzeitigen Entsperrung des Login für <strong>1 Stunde dauerhaft</strong> blockiert, falls auch nur <strong>ein Versuch mit einem falschen Freigabe-Code</strong> erfolgte. Achten Sie also immer darauf, den ungekürzten, bei Bedarf fehlerfrei kopierten Link in der E-Mail zur vorzeitigen Freigabe eines gesperren Login zu verwenden.</p>
			<p>Für den Fall, dass Sie sich selbst ein- oder zweimal bei der Eingabe der Daten zum Login vertippt haben, wird die Zählung von Eingaben falscher Login-Daten nach jedem erfolgreichen Login wieder auf Null gesetzt.</p>
			<p>Bei Inaktivität im Admin-Bereich von mehr als '.$session_lifetime.' Minuten wird schließlich aus Sicherheitsgründen die mit dem Einloggen angelegte Session zerstört und der Admin muss sich neu einloggen. Jeder Klick auf einen Link im Admin-Bereich setzt diese Zeitmessung wieder auf Null, sodass die vollen '.$session_lifetime.' Minuten nach jedem Klick wieder zur Verfügung stehen. - <strong>Achtung!</strong> Diese Zeitsperre mit Zwangslogout hat mit dem oben angesprochenen Verlust der Session im Rahmen der Funktion "session_regenerate_id" nichts zu tun und ist hiervon unabhängig.</p>';
// IV.3.1. Gästebucheinträge + IV.3.1.1. Einträge verwalten, editieren, kommentieren
		echo'
			<span id="anchor-Gaestebucheintraege" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.1. Gästebucheinträge:</strong></p>
			<span id="anchor-Edit" class="sticky-anchor"></span>
			<p class="text-shadow"><strong>3.1.1. Einträge verwalten, editieren, kommentieren:</strong></p>
			<p>Auf der Seite &quot;Einträge und Kommentare&quot; verwalten Sie die Gästebucheinträge oder fügen bei Bedarf einen Kommentar zu einem Beitrag hinzu. Hierzu einfach auf das entsprechende Symbol <img class="img-ok" src="../images/edit.png" width="14" height="14" title="Eintrag bearbeiten" alt="" /> für "Eintrag bearbeiten" oder <img class="img-ok" src="../images/comment.png" width="14" height="14" title="Eintrag kommentieren" alt="" /> für "Eintrag kommentieren" unter dem jeweiligen Gästebucheintrag klicken und die gewünschte Aktion ausführen.</p>
			<p>Auch innerhalb eines Admin-Kommentars können Sie selbstverständlich BBCodes und Emojis nutzen oder Fotos hochladen und einfügen.</p>
			<p>Sie sehen zu Beginn der Seite, ob das Gästebuch freigeschaltet ist, ob bestimmte IPs zum Aufruf der Eintragsseite gesperrt wurden, ob alle Einträge im Gästebuch freigegeben sind und wann das letzte BackUp erstellt wurde.</p>
			<p>Unter jedem Beitrag sehen Sie dann noch einmal separat, ob nur der Text eines Beitrags oder auch dort ggf. eingestellte Fotos freigegeben oder noch gesperrt sind.</p>
			<p>Ferner können Sie hier auf zwei möglichen Wegen Beiträge sperren oder gesperrte Beiträge bzw. noch gesperrte Fotos freigeben:</p>
			<ul>
				<li>Die eine Möglichkeit ist, die Check-Box, die sich oben rechts bei jedem Eintrag befindet, zu markieren, dann auf der Seite oben im Drop-Down-Menü die gewünschte Aktion auswählen und anschließend auf "OK" klicken. (Nur) über dieses Drop-Down-Menü können Sie auch Einträge endgültig (!) aus der Datenbank löschen. Wenn Sie die Check-Box links neben dem Drop-Down-Menü für "Alle auswählen" markieren, werden automatisch alle Beiträge <strong>auf der jeweiligen Seite</strong> markiert und können so schnell und einfach in einem Arbeitsgang z.B. aktiviert, deaktiviert oder gelöscht werden.
				<li>Die zweite Möglichkeit besteht darin, gezielt bei dem zu bearbeitenden Eintrag auf die Links rechts unten "<strong class="text-shadow">Text</strong>" (= nur der geschriebene Text ohne ggf. eingestellte Fotos wird freigeschaltet oder der Beitrag wird komplett deaktiviert) bzw. das Icon für Grafikdateien <img class="img-ok picShadowSmall" src="../images/photo.png" width="25" height="16" alt="Foto" /> (= im Beitrag eingefügte Fotos werden freigeben oder gesperrt) zu klicken, um den aktuellen Status zu ändern.
			</ul>';
// IV.3.1.2. Hochgeladene Grafikdateien verwalten
		echo'
			<span id="anchor-Grafik" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.1.2. Hochgeladene Grafikdateien verwalten und editieren:</strong></p>
			<p>Hier werden alle mit der Funktion &quot;Bild-Upload&quot; hochgeladenen Grafikdateien angezeigt und verwaltet. Ob das Bild im öffentlichen Bereich des Gästebuchs freigeben oder noch gesperrt ist, ist hierbei gleichgültig.</p>
			<p>Die mögliche Bearbeitung beinhaltet z.B. das Löschen von hochgeladenen Dateien oder auch das Editieren einer eingegebenen Beschreibung (&quot;title&quot;) des Bildes.</p>
			<p>Es kann vorkommen, dass hochgeladenen Fotos nicht richtig ausgerichtet sind und "auf dem Kopf stehen" oder "auf der Seite liegen". Das betrifft meist Bilder, die mit Smartphones aufgenommen wurden. Solche *jpg-Dateien (keine *png-Dateien) können dann hier in die richtige Position gedreht werden. Soweit sich druch das Drehen eines Bildes Höhe und Breite ändern, wird dies automatisch ebenfalls korrigiert.</p>
			<p>Ferner können ggf. vom Admin per FTP gesondert hochgeladene Bilder hier in die Datenbanktabelle des Bilderordners eingegeben werden.</p>
			<p>Sollte einmal ein Bild hochgeladen worden sein, das der Admin wegen eines von ihm als kritisch/rechtswidrig eingestuften Inhalts nicht freischaltet, sollte die Datei gelöscht werden, auch um Fremdverlinkungen zu vermeiden!</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Sie haften als Websitebetreiber für den Inhalt aller Darstellungen auf Ihrer Website. Das gilt selbstverständlich auch für dort veröffentlichte Bilder. Falls Sie z.B. Anhaltspunkte dafür haben, dass es sich bei einem hochgeladenen/eingestellten Foto um eine unerlaubte Kopie aus dem Internet handelt, dort Personen ohne deren Einverständnis abgebildet wurden o.ä., sind Sie verpflichtet, das Foto umgehend zu löschen. Vergleichbares gilt für kritische Bildmotive, wie z.B. gewaltverherrlichende, rassistische, pornografische o.ä. rechtswidrige Darstellungen / Inhalte.</p>';
// IV.3.1.3. Admin Blog
		echo'
			<span id="anchor-Blog" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.1.3. Admin Blog:</strong></p>
			<p>Es besteht ebenfalls die Möglichkeit, das Gästebuch als Blog, Reisetagebuch o.ä. zu betreiben, in dem dann ausschließlich der Admin selbst Einträge veröffentlichen kann, kein außenstehender Dritter.</p>
			<p>Aber auch wenn das Gästebuch <span class="italic">nicht</span> im sogen. "Blog-Modus" betrieben wird, können selbstverständlich Einträge im Gästebuch vom Admin hier eingegeben werden.</p>
			<p>Bei Einträgen, die im Admin-Control-Panel unter dem Link "Admin Blog" vorgenommen werden,</p>
			<ul>
				<li>findet <span class="italic">keine</span> Prüfung auf Spam statt, es geht <span class="italic">keine</span> E-Mail an den Admin über den dort neu verfassten Eintrag;
				<li>ggf. im Beitrag vom Admin eingestellte Bilder sind <span class="italic">sofort freigeschaltet</span> und für die Öffentlichkeit sichtbar;
				<li>neue Einträge können in beliebiger Anzahl ohne Wartezeit hier eingegeben und gespeichert werden, die sogen. "Flood-Protection" ist hierbei <span class="italic">nicht</span> aktiv.
			</ul>
			<p>Für den Betrieb des Gästebuchs im "Blog-Modus" muss unter "Einstellungen" ==&gt; "Allgemeine Konfiguration" ==&gt; "Link zur Seite für Gästebucheinträge" der Radio-Button für "Link entfernen (Blog-Modus)" ausgewählt und diese Einstellung gespeichert werden.</p>
			<p>Daraus ergeben sich dann u.a. folgende weitere Besonderheiten:</p>
			<ul>
				<li>Die Links zur Eintragsseite "insert.php", die auf der "index"-Seite für die Gästebucheinträge ober- und unterhalb der schon veröffentlichten Einträge vorhanden sind, werden deaktiviert/ausgeblendet.
				<li>Die Eintragsseite "insert.php" und die Seite zum Dateiupload "pic.upload.php" sind im Web nicht mehr aufrufbar (automatische Umleitung zur "index"-Seite), neue Einträge und Uploads können nur noch im Admin-Control-Panel vorgenommen werden.
				<li>Wenn Sie die den Bild-Upload im Blog-Modus nutzen möchten, dürfen Sie in Ihrem Browser keine Cookies blockiert haben. Das Setzen eines Cookies bei gleichzeitig aktiviertem Blog-Modus und Bildupload ist notwendig, um sicher zu stellen, dass nur Sie als Admin und kein Dritter die Seite zum Dateiupload aufrufen können. Der Cookie wird beim Logout aus dem Admin-Panel automatisch wieder gelöscht.
				<li>Die Zitatfunktion zu vorhandenen Gästebucheinträgen wird automatisch deaktiviert bzw. lässt sich nicht aktivieren.
				<li>Das Eingabefeld für den Namen des Bloggers wird vom Pflichtfeld zum optionalen Feld, sodass die Eingabe eines Namens im Blog-Modus zwar möglich aber nicht mehr zwingend ist.
			</ul>';
// IV.3.1.4. Frontend anzeigen
		echo'
			<span id="anchor-Front" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.1.4. Frontend anzeigen:</strong></p>
			<p>Mit einem Klick auf diesen Link wird die Gästebuchseite geöffnet, wie sie auf Ihrem Webspace veröffentlicht ist, sodass etwaige Editierungen, Kommentierungen etc. sofort überprüft werden können.</p>';
// IV.3.2. Einstellungen
		echo'
			<span id="anchor-Einstellungen" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2. Einstellungen:</strong></p>
			<p>Allgemeine Gästebuch-Einstellungen können hier in vier Unterkategorien vorgenommen werden:</p>';
// IV.3.2.1.  Admin Einstellungen
		echo'
			<span id="anchor-AdminEdit" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2.1. Admin- und Login Einstellungen:</strong></p>
			<p>Hier werden Ihre persönlichen Daten als Admin verwaltet. Die E-Mail-Adresse wird dazu benötigt, bei neuen Einträgen eine Benachrichtigung an den Admin zu senden (falls aktiviert), auch erstellte Backups werden nach dort automatisch geschickt und Mitteilungen über etwaige Versuche von Spameinträgen und Foto-Uploads.</p>
			<span id="anchor-pws" class="sticky-anchor"></span>
			<p>Ebenso kann hier ein vergessenes oder veraltetes Passwort erneuert werden. Über einen Statusbalken, der nach dem Fokussieren des Eingabefeldes für ein neues Passwort erscheint, wird Ihnen ein (unverbindlicher) Hinweis auf die Qualität Ihres gewählten Passworts gegeben.</p>
			<p><strong>Ein gutes Passwort sollte folgende Kriterien erfüllen:</strong></p>
			<ol>
				<li><strong>Es sollte keinen Namen, kein Geburtsdatum oder ein real existierendes Wort enthalten.</strong></li>
				<li><strong>Es sollte mindestens einen Groß- und einen Kleinbuchstaben enthalten.</strong></li>
				<li><strong>Es sollte mindestens eine Ziffer enthalten.</strong></li>
				<li><strong>Es sollte mindestens ein "Nicht-Wort-Zeichen" (kein Buchstabe, keine Ziffer) enthalten.</strong></li>
				<li><strong>Es sollte aus mehr als 10 Zeichen bestehen.</strong></li>
				<li><strong>Das letzte Zeichen sollte weder eine Ziffer noch ein "Nicht-Wort-Zeichen" sein.</strong></li>
			</ol>
			<p>Die Empfehlung, ein Passwort in regelmäßigen Abständen zu ändern, wurde vom deutschen Bundesamt für Sicherheit in der Informationstechnik (BSI) Anfang 2020 unter verbreiteter Zustimmung aus Fachkreisen aufgegeben. Der entsprechende Warnhinweis, wenn Ihr Passwort älter als 90 Tage ist, wurde daher aus dem Programm entfernt.</p>
			<p>Für die Einhaltung der ersten der sechs oben aufgelisteten Regeln sind Sie selbst verantwortlich. - Die Einhaltung der Regeln unter den Ziffern 2 bis 6 wird vom Programm für Sie geprüft. Einen geschlossenen dunkelgrünen Balken als Zeichen eines "guten" Passworts erhalten Sie nur, wenn alle Bedingungen unter den Ziffern 2 bis 6 eingehalten werden.</p>
			<p>Im zweiten Feld unter den Admin-Daten können Sie bis zu drei sogenannte "<strong>Moderatoren</strong>" erfassen.</p>
			<p>Moderatoren haben im Admin-Panel reduzierte Zugriffsrechte. Sie können Gästebuch-Einträge und eingestellte Fotos sperren oder freigeben und Einträge kommentieren aber <strong>keine Einträge oder Fotos löschen oder editieren</strong>.</p>
			<p>Sie können ferner BackUps erstellen und BackUps einspielen, sowie die Statistik und die "Hilfe"-Datei einsehen.</p>
			<p>Mit diesen Einschränkungen haben Moderatoren also Zugriff und Bearbeitungsmöglichkeiten unter den verlinkten Seiten in der Navigation unter "Einträge", "Backup" und "Sonstiges".</p>
			<p>Alle weiteren Admin-Optionen sind für Moderatoren gesperrt bzw. nicht zugänglich.</p>
			<p>Moderatoren können sich ebenso wie der Admin bei Bedarf über die "Passwort-vergessen"-Funktion ein für 30 Minuten gültiges Ersatzpasswort an ihre hinterlegte E-Mail-Adresse schicken lassen. Ein zeitlich unlimitiertes neues Passwort kann allerdings nur der Admin für einen Moderator vergeben.</p>
			<p>Sie können bei der Anlage eines neuen Moderators wie auch später im Rahmen einer Editierung festlegen, ob auch dieser Moderator vom Programm automatisch per E-Mail von einem neuen Gästebucheintrag und einem Datei-Upload informiert werden soll.</p>
			<p>Testen Sie die Möglichkeiten eines Moderators durch Eingabe einer Test-Person.</p>';
// IV.3.2.2. Allgemeine Konfiguration
		echo'
			<span id="anchor-Konfig" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2.2. Allgemeine Konfiguration:</strong></p>
			<p>Die grundlegenden Einstellungen vom Gästebuch werden hier von Ihnen festgelegt.</p>
			<p>Das beinhaltet z.B.:</p>
			<ul>
				<li>ob Emojis und/oder BBCodes,
				<li>die Zitierfunktion und/oder der Bildupload aktiviert sind,
				<li>die Bewertungsfunktion (Vergabe von 1 bis 5 Sternen) kann hier an- oder abgeschaltet werden,
				<li>ab welcher Grenze der Spamfilter einen Beitrag verwirft oder nur sperrt,
				<li>wie viel Links ein Besucher in seinen Beitrag einstellen darf, ohne dass dies als Spamversuch gewertet wird,
				<li>das komplette Gästebuch und
				<li>die Gästebuch-Statistik können hier genauso jeweils mit einem Klick aktiviert oder deaktiviert werden,
				<li>wie die Anzeige und Eintragsmöglichkeit für eine E-Mail-Adresse des Besuchers,
				<li>für den Herkunftsort oder
				<li>das Herkunftsland des Besuchers,
				<li>für einen Link zur Homepage und auch
				<li>das Eingabefeld für einen &quot;Betreff&quot; zum Eintrag des Gastes einzeln an- oder abgeschaltet werden können.
				<li>Alternativ lassen sich hier die Eingabefelder für E-Mail-Adressen, Ort und Land des Gastes als Pflichtfelder bestimmen ...
			</ul>
			<p>... und vieles mehr.</p>';
		echo'
			<span id="anchor-LinkButton" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />a) Auswahl Text-Link oder Button zur Eintragsseite bzw. Link ausblenden (Blog-Modus):</strong></p>
			<p>U.a. besteht hier auch die Möglichkeit, die Links zur Seite für neue Gästebucheinträge, die oberhalb und unterhalb der schon veröffentlichten Einträge angezeigt werden, individuell auszugestalten, entweder als Text-Link, als Html-Button oder aber diese Links ganz auszublenden.</p>
			<p><strong>Text-Link:</strong> Geben Sie in das entsprechende Eingabefeld den Text ein, der als Ankertext des Links im Gästebuch erscheinen soll. Der Eintrag kann bis zu 35 Zeichen lang sein. Wegen einer individuellen Einfärbung dieses Links siehe unten <a href="#anchor-EditStyle">Abschnitt IV. 3.4.2, Style editieren</a>.</p>
			<p><strong>Button (Voreinstellung):</strong> Falls Sie anstatt eines Text-Links einen anklickbaren Html-Button als Anker für den Link einbinden möchten, markieren Sie die entsprechende Radio-Box und klicken auf speichern.</p>
			<p>Die Beschriftung des Buttons entspricht wieder der Eingabe im Feld "Text des Links/Buttons".</p>
			<p>Wenn Sie keinen abweichenden Text eingeben, wird die Vorgabe aus der Sprachdatei für den Link bzw. die Beschriftung des Buttons verwendet.</p>
			<p>Für Änderungen an der Hintergrund- und Schriftfarbe des Buttons siehe erneut das Beispiel unten <a href="#anchor-EditStyle">Abschnitt IV. 3.4.2, "Style editieren"</a></p>
			<p><strong>Link entfernen:</strong> User, die das Gästebuch als eine Art Blog, Reisetagebuch oder ähnliches verwenden möchten und die keine Einträge von Dritten dort wünschen, wählen bitte die Option "Link entfernen (Blog-Modus)". Für weitere Erläuterungen zu dieser Option siehe oben: <a href="#anchor-Blog">Abschnitt IV. 3.1.3, Admin Blog</a></p>';
// IV.3.2.2.b) Sprachauswahl User
		echo'
			<span id="anchor-ChooseLang" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />b) Individuelle Sprachauswahl durch den User:</strong></p>
			<p>Sie können die Option "Individuelle Sprachauswahl durch den Gast" aktivieren (Voreinstellung: Deaktiviert), alternativ mit oder ohne Cookie-Hinweis an den User. Um die Sprachauswahl nutzen zu können, muss Javascript zugelassen sein.</p>
			<p>Bei Aktivierung wird auf der Index-Seite oberhalb der Gästebucheinträge und dem Verweis zum Eintragsformular ein Link in Form einer Leiste mit Flaggen eingeblendet, über den der Gast die Möglichkeit hat, selbst festzulegen, ob die Beschreibungen auf der "index"- und "insert.php" statt in der vom Admin voreingestellten Sprache in einer der anderen verfügbaren Sprachen erfolgen sollen. Gerade bei Websites mit einem internationalen Publikum, die ggf. ohnehin schon eine Sprachauswahl vorsehen, bietet sich an, dem User diese Möglichkeit zu eröffnen.</p>
			<p>Eine gewählte andere Sprache wird durch einen Cookie auf dem Rechner des Users hinterlegt. Der Cookie wird mit dem Schließen des Browsers ungültig und wieder gelöscht.</p>
			<p>Die Sprachauswahl kann wahlweise mit oder ohne einen Hinweis an den Gast auf das Setzen eines Cookies aktiviert werden. Wenn die Sprachauswahl von Ihnen freigegeben wird, wird empfohlen, die Aktivierung mit Cookie-Hinweis zu wählen.</p>
			<p>Sie haben die Möglichkeit, den Text für diesen Cookie-Hinweis nach Ihren Bedürfnissen anzupassen. Dafür öffnen Sie bitte im Verzeichnis "lang" die Sprachdatei Ihrer Wahl und ändern den Text zu der unter der Überschrift "<span class="red">// Cookie Belehrung</span>" ersichtlichen Variablen <span class="blue">&#36;cmsg[0]</span> nach Bedarf, Änderung speichern, die Datei neu auf den Server laden, fertig.</p>
			<p><strong><span class="red">TIPP:</span></strong> Bedenken Sie bitte, dass individuelle Eingaben in den Feldern "Titel des Gästebuchs", "Text des Links/Buttons", "Text zur Bewertungsfunktion" und/oder "Bezeichnung für \'Betreff\'-Feld ändern" vom Programm nicht übersetzt werden können. Wenn ein Gast eine andere Sprache wählt, als vom Admin eingestellt, werden daher individuelle Eingaben in diesen Feldern vom Programm ignoriert und statt dessen die sprachlich passenden Sprachphrasen angezeigt.</p>';
// IV.3.2.2.c) Datenschutz
		echo'
			<span id="anchor-privacy" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />c) Link zu einer Datenschutzerklärung setzen:</strong></p>
			<p>Wenn Sie die Option "Link zur Datenschutzerklärung anzeigen" aktivieren (Voreinstellung: Deaktiviert), können Sie in das Eingabefeld darunter die URL zu einer auf Ihrer Website ggf. vorhandenen Datenschutzerklärung eingeben. Ein Link zu dieser Datenschutzerklärung wird dann jeweils am unteren Ende der öffentlichen Seiten des Gästebuchs (index- und insert.php) angezeigt.</p>
			<p>Insbesondere wenn Sie das Gästebuch direkt verlinken ohne Einbindung per Iframe oder per PHP-include und damit außerhalb der normalen Navigation Ihrer Website, bietet es sich an, von dieser Möglichkeit bei Bedarf Gebrauch zu machen.</p>';
// IV.3.2.2.d) Suchfunktion
		echo'
			<span id="anchor-search" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />d) Suchfunktion aktivieren:</strong></p>
			<p>Sie haben die Möglichkeit, in den Konfigurationseinstellungen eine Suchfunktion für den Gast zu aktivieren (Voreinstellung: Deaktiviert).</p>
			<p>Wenn Sie die Suche freigeben, wird über den Gästebucheinträgen ein Suchfeld eingeblendet, mit dem der Gast nach bestimmten Einträgen oder Begriffen im Gästebuch suchen kann, ohne alle Einträge durchblättern und lesen zu müssen.</p>
			<p>Das Programm durchsucht gespeicherte Eingaben für Datum, Namen, Gasteinträge und Admin-Kommentare nach dem/den eingegebenen Suchbegriff(en). <strong>Nicht</strong> durchsucht werden die gespeicherten Eingaben zur Uhrzeit von Einträgen, Ort und Land, E-Mail- und Homepage-Adresse.</p>
			<p>Die Anzahl der gefundenen Ergebnisse wird numerisch dargestellt und die Einträge mit Übereinstimmungen zur Suche werden separat angezeigt. Der Suchbegriff wird dabei jeweils farblich markiert. Die Suche funktioniert auch bei vielen Sonderzeichen im Suchbegriff, soweit in der Eingabe nicht aus Sicherheitsgründen gesperrt.</p>
			<p>Es müssen mindestens '.$minInputSearch.' und können maximal '.$maxInputSearch.' Zeichen als Suchbegriff eingegeben werden.</p>
			<p>Der Suchbegriff wird in einer Session zwischengespeichert, die entweder durch einen Klick auf den "Reset"-Button, den Versuch, mehr als die maximal zulässigen Suchvorgänge innerhalb einer Stunde durchzuführen oder spätestens mit dem Schließen des Browser-Fensters wieder gelöscht wird.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Mit Aktivierung der Suchfunktion muss beim Aufruf der "index"-Seite mit den Gästebucheinträgen eine Session angelegt werden, damit bei mehreren identifizierten Suchergebnisses eine Zuordnung erfolgen kann. Das hat zur Folge, dass durch den aufrufenden Browser auf dem anzeigenden Endgerät automatisch ein technisch notwendiger Cookie mit einer Session-ID (willkürliche Ziffern- und Buchstabenfolge ohne personenbezogene Daten) angelegt wird. Dieser Session-Cookie wird mit dem Schließen des Browserfensters ebenso automatisch wieder gelöscht. Siehe hierzu auch oben Abschnitt III.5.1., <a href="#anchor-Cookie">Cookie-Hinweise</a>.</p>
			<p><strong>Sicherheit der Suchfunktion:</strong></p>
			<ul>
			<li>Eingegebene Suchbegriffe werden über sogen. "Prepared Statements" für die Recherche in der Datenbank verarbeitet. Prepared Statements gelten als absolut sicher gegen SQL-Injektions.<br /><br /></li>
			<li>Ungeachtet des Umstands, dass es wegen der Verwendung von Prepared Statements als überflüssig gilt, werden gleichwohl die in einer Suche ggf. enthaltenen Metazeichen gesondert maskiert. Außerdem können in das Suchfeld außer Buchstaben und Ziffern nur ausgewählte Nicht-Wort-Zeichen eingegeben werden, und zwar: Hochkomma (&nbsp;<strong class="red">\'</strong>&nbsp;), Punkt (&nbsp;<strong class="red">.</strong>&nbsp;), Komma (&nbsp;<strong class="red">,</strong>&nbsp;), Doppelpunkt (&nbsp;<strong class="red">:</strong>&nbsp;), Ausrufungszeichen (&nbsp;<strong class="red">!</strong>&nbsp;), Fragezeichen (&nbsp;<strong class="red">?</strong>&nbsp;) und einfacher Bindestrich (&nbsp;<strong class="red">-</strong>&nbsp;).<br /><br /></li>
			<li>Der Zeichensatz für den Datenverkehr von und zur SQL-Datenbank ist programmseitig auf UTF-8 eingestellt. Die Suchfunktion lässt sich weder aktivieren noch nutzen, falls von UTF8 auf einen anderen Zeichensatz umgestellt wird.<br /><br /></li>
			<li>Die Anzahl der Suchvorgänge ist auf '.$maxSearch.' Stück innerhalb einer Stunde begrenzt, um mutwillige Spielereien einzuschränken (anonymisierte IP-Sperre; Zeiterfassung ab dem ersten Suchvorgang).<br /><br />Sie können diese Zahl einer erlaubten Nutzung der Suchfunktion erhöhen, ebenso wie Sie auch die Zahl der mindestens notwenigen oder höchstens zulässigen Eingabe von Zeichen in das Suchfeld ändern können. Siehe hierzu den Abschnitt unter: <a href="#anchor-MoreKonfig-02">Weitere Konfigurationsmöglichkeiten</a>.<br /><br /></li>
			<li>Die eingegebenen Suchbegriffe werden in einer Session auf dem Server, nicht in einem Cookie auf dem Rechner des Users zwischengespeichert. Das schließt Manipulationen des Cookie-Inhalts aus.</li>
			</ul>';
// IV.3.2.2.e) Permalinks
		echo'
			<span id="anchor-permaLi" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />e) Permalinks aktivieren:</strong></p>
			<p>Bei der Aktivierung dieser Funktion wird in jedem Gästebucheintrag ein Link-Symbol eingeblendet, das mit der URL zu dem betreffenden Posting verknüpft ist (Voreinstellung: Deaktiviert).</p>
			<p>Mit dieser URL ist es möglich, einen gezielt ausgewählten Eintrag aufzurufen, ohne alle Einträge danach durchsuchen zu müssen.</p>
			<p>Insbesondere bei Gästebüchern, in denen z.B. Fragen zu verschiedenen Themen diskutiert werden, ist es praktisch, wenn User oder Admin in ihren Kommentaren so schnell und einfach auf einen der früheren Einträge verweisen können, indem sie einfach den Link zu dem betreffenden Posting setzen, ohne diesen jeweils komplett zitieren und damit ständig wiederholen zu müssen.</p>';
// IV.3.2.3. Konfiguration Datei-Uploads
		echo'
			<span id="anchor-Upload" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2.3. Konfiguration Datei-Uploads:</strong></p>
			<p>Hier können grundlegende Einstellungen zum Dateiupload vorgenommen werden, wie z.B.:</p>
			<ul>
				<li>die maximale Größe des Uploads in MB (die absolute Obergrenze wird serverseitig von der "php.ini" festgelegt, siehe hierzu &quot;upload_max_filesize&quot; und &quot;post_max_size&quot;),
				<li>die maximale Breite und Höhe des Bildes in Pixel u.ä. (die maximale Breite eines Fotos wird von der eingestellten Breite des Gästebuchs abzüglich gewisser Innenabstände begrenzt).
				<li>Auch die maximale Anzahl der von einem User zu seinem Eintrag hochgeladenen und im Gästebuchbeitrag eingefügten Dateien kann hier seit v.4.5.3 in einem Bereich zwischen &quot;1&quot; und &quot;10&quot; eingestellt werden. - Die Voreinstellung nach der Installation ist &quot;2&quot;. Die (IP-)Sperre zum Upload von über dem eingestellten Limit hinausgehenden weiteren Dateien ist auf 20 Minuten festgelegt, danach beginnt die Zählung wieder von vorne.
			</ul>
			<p>Damit die automatische Ermittlung der höchstmöglichen Breite einer hochgeladenen Grafikdatei je nach gewähltem Template funktioniert, dürfen die Namen der verschiedenen vorinstallierten Templates nicht geändert werden!</p>';
// IV.3.2.4. E-Mail Einstellungen
		echo'
			<span id="anchor-Thankyou" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2.4. E-Mail Einstellungen und individuelle &quot;Danke-E-Mail&quot; an den Gast</strong></p>
			<p>Zu einer Reihe von Anlässen werden vom Script <span class="italic">myPHP Guestbook</span> automatisch generierte E-Mails an den Admin und –soweit freigegeben- auch an den Gast, der einen Beitrag im Gästebuch geschrieben hat, geschickt. Dies betrifft beispielweise gefertigte BackUps, die automatisch an den Admin per Mail geschickt werden, aber auch Hinweise über Fotouploads oder neu ins Gästebuch geschriebene Einträge und einiges mehr.</p>
			<p>Grundsätzliche Voraussetzung hierfür ist, dass die in PHP implementierte Funktion "mail()" aktiv ist.</p>
			<p>Einige Provider deaktivieren diese Funktion für Ihre Kunden oder schränken sie ein. Falls die mail()-Funktion serverseitig nicht verfügbar ist, können die automatisch generierten E-Mails vom Programm nicht verschickt werden.</p>
			<p>Dann gibt es noch die Fälle, in denen Provider die mail()-Funktion so einschränken, dass sie nur funktioniert, wenn als Absender solcher E-Mails eine Adresse benutzt wird, die der Kunde zu dem virtuellen Host, auf dem das Script läuft, als "offizielle" Mail-Adresse hinterlegt hat. Dafür können Sie ganz einfach ebenfalls unter dem Link "E-Mail Konfiguration" die entsprechende E-Mail-Adresse als Absender speichern.</p>
			<p>Sie können die mail()-Funktion testen, in dem Sie von der Möglichkeit des Versands einer Test-E-Mail auf der Seite "E-Mail Konfiguration" Gebrauch machen.</p>
			<p>In den &quot;Allgemeinen Konfigurationseinstellungen&quot; können Sie auch festlegen, ob ein Gast, wenn er einen Eintrag ins Gästebuch verfasst und dabei seine E-Mail-Adresse mit angegeben hat, vom Programm automatisch eine E-Mail mit einem kleinen &quot;Danke-Schön&quot; erhält.</p>
			<p>Unter dem o.g. Link wird Ihnen angezeigt, welchen Text der Gast mit dieser E-Mail standardmäßig erhält. Sie können den Text individuell auf Ihre Bedürfnisse und nach Ihren Wünsche anpassen. Voraussetzung ist, dass die Option "Per E-Mail für Eintrag bedanken" aktiviert ist.</p>
			<p><strong>Hinweis:</strong> Die an dieser Stelle ersichtliche E-Mail Adresse wird vom Programm bei <strong>allen</strong> automatisch verschickten E-Mails als <strong>Absender</strong>-Adresse angezeigt (E-Mail header "From").</p>
			<p><strong class="red">TIPP:</strong> Wählen Sie hierfür eine andere E-Mail-Adresse als die, die Sie unter dem Link "Admin- und Login-Daten" als Ihre Admin-E-Mail Adresse angegeben haben. Notfalls richten Sie einfach eine weitere, ansonsten ungenutzte E-Mail Adresse ein.</p>';
// IV.3.2.5. Weitere Konfigurationsmöglichkeiten
		echo'
			<span id="anchor-MoreKonfig" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.2.5. Weitere Konfigurationsmöglichkeiten ==><br />Datei "settings.inc.php", Verzeichnis "includes":</strong></p>
			<p>Wenn Sie die Datei "settings.inc.php" öffnen, können Sie durch Änderung einzelner Werte der dort erfassten Konstanten und Variablen weitere Grundeinstellungen anpassen.</p>
			<p class="zentriert"><span class="red"><strong>Achtung!</strong></span></p>
			<p><strong>Löschen oder entfernen Sie keinesfalls irgendeine der dortigen Konstanten oder Variablen. Dies würde einen schweren Fehler im Programmablauf verursachen! Fertigen Sie vor dem Speichern irgendwelcher Änderungen vorsorglich eine Sicherungskopie der Original-Datei "settings.inc.php" an!</strong></p>
			<p>Unter den Copyright-Hinweisen sehen Sie zunächst insgesamt 8 Konstanten, die folgendes steuern:</p>
			<ul><li><span class="blue">SPAM_PROTECT</span> => Grundeinstellung: <span class="blue">true</span> (= aktiviert)</li></ul>
			<p>Aktiviert oder deaktiviert den Spamschutz.</p>
			<p><strong>Achtung! Der Spamschutz sollte zumindest beim Einsatz des Gästebuchs auf öffentlichen und für jeden frei im Web zugänglichen Seiten IMMER aktiviert sein (= true).</strong></p>
			<ul><li><span class="blue">PIC_CHECK</span> => Grundeinstellung: <span class="blue">true</span> (= aktiviert)</li></ul>
			<p>Aktiviert oder deaktiviert die Einzelfallprüfung mit anschließender separater Freigabe jedes neu hochgeladenen Bildes durch den Admin.</p>
			<p><strong>Achtung! Der vorläufige Sperre eines neu hochgeladenen Bildes sollte zumindest beim Einsatz des Gästebuchs auf öffentlichen und für jeden frei im Web zugänglichen Seiten IMMER aktiviert sein (= true).</strong></p>
			<p>In den &quot;Allgemeinen Konfigurationseinstellungen&quot; wird angezeigt, falls der Spam-Schutz deaktiviert ist und/oder hochgeladene Grafik-Dateien ohne vorherige Prüfung und Freigabe durch den Admin sofort im öffentlichen Bereich des Gästebuchs angezeigt werden.</p>
			<ul><li><span class="blue">CLEAN_CODE</span> => Grundeinstellung: <span class="blue">true</span> (= aktiviert)</li></ul>
			<p>Die Aktivierung dieser Konstante sorgt dafür, dass der mit jedem neuen Gästebucheintrag generierte und in der Datenbank gespeicherte Code zur Freigabe oder zum Sperren dieses Eintrags per Admin-E-Mail nach 30 Tagen automatisch gelöscht wird.</p>
			<ul><li><span class="blue">SCROLL_TO_TOP</span> => Grundeinstellung: <span class="blue">true</span> (= aktiviert)</li></ul>
			<p>Aktiviert oder deaktiviert die Javascript-Funktion "scrollIntoView", die beim Klick auf viele interne Links oder Buttons sowohl auf der index- wie auch auf der insert.php dafür sorgt, dass die Seite zum oberen Anfang des sichtbaren Bereichs scrollt. "scrollIntoView" funktioniert mittlerweise in allen modernen Browsern, natürlich nicht im IE oder sonstigen Antiquitäten, dort "springt" die Seite nur.</p>
			<p>Einige Browser, wie z.B. der Firefox, verarbeiten interne Anker-Sprungziele auf einer per IFrame eingebetteten Seite nicht ordnungsgemäß (Stand: Anfang 2021). Durch "scrollIntoView" wird jedoch auch in diesen Browsern das gewünschte Ziel erreicht.</p>
			<ul><li><span class="blue">SCROLL_ON_INDEX</span> => Grundeinstellung: <span class="blue">true</span> (= aktiviert)</li></ul>
			<p>Aktiviert oder deaktiviert auf der Seite mit den Gästebucheinträgen (index.php) einen Button, der beim Scrollen am unteren Ende der Seite mittig eingeblendet wird. Beim Klick auf diesen Button scrollt die Seite wieder nach oben zum ersten Eintrag. Auch diese Funktion wird gesteuert per Javascript mit "scrollIntoView". - Hinweis: Funktioniert logischerweise nicht, wenn das Gästebuch per IFrame mit automatischer Höhenanpassung eingebettet ist.</p>
			<p>Der Unterschied zwischen <span class="blue">SCROLL_TO_TOP</span> und <span class="blue">SCROLL_ON_INDEX</span> liegt im Wesentlichen darin, dass <span class="blue">SCROLL_TO_TOP</span> mit Verweisen verbunden ist, die gleichzeitig eine inhaltliche Änderung vornehmen, indem die Seite neu geparst oder eine andere Seite aufgerufen wird, während bei <span class="blue">SCROLL_ON_INDEX</span> die Seite inhaltlich unverändert bleibt und nicht verlassen wird.</p>
			<ul><li><span class="blue">DISABLE_MYSQLI_CHECK</span> => Grundeinstellung: <span class="blue">true</span> (= keine Fehleranzeige)</li></ul>
			<p>Sorgt dafür, dass die Anzeige von MySQLi-Fehlern auf dem Bildschirm ausgeschaltet wird.</p>
			<p><strong>Achtung! Die Fehleranzeige sollte im produktiven Betrieb aus Sicherheitsgründen IMMER deaktiviert sein (= true).</strong></p>
			<ul><li><span class="blue">ID_REG</span> => Grundeinstellung: <span class="blue">true</span> (= aktiviert)</li></ul>
			<p>Aktiviert die PHP-Funktion "session_regenerate_id", die bewirkt, dass während des Logins in das Admin-Panel jeweils eine neue Session-ID generiert wird. (Schutz vor sogen. "Session Hijacking")</p>
			<ul><li><span class="blue">GB_SEC_AUTH</span> => Grundeinstellung: <span class="blue">false</span> (= deaktiviert)</li></ul>
			<p>Aktiviert oder deaktiviert die 2-Faktor-Athentisierung zum Login in das Admin-Panel.</p>
			<span id="anchor-MoreKonfig-02" class="sticky-anchor"></span>
			<p>Im Anschluss an die oben erläuterten Konstanten finden Sie weitere Variablen, mit denen Sie folgendes beeinflussen können:</p>
			<ul>
				<li><span class="blue">$emojis_and_bbcodes</span> ==&#62; Anzahl der Emojis, die auf der "insert.php" angezeigt werden, wenn BBCodes aktiviert sind.</li>
				<li><span class="blue">$only_emojis</span> ==&#62; Anzahl der Emojis, die auf der "insert.php" angezeigt werden, wenn BBCodes <strong>de</strong>aktiviert sind.</li>
				<li><span class="blue">$delete_spamIps</span> ==&#62; Anzahl der Tage, die eine wegen Spam gesperrte IP in der Datenbank gespeichert bleibt, bevor sie automatisch gelöscht wird.</li>
				<li><span class="blue">$session_lifetime</span> ==&#62; Zeit in Minuten, die die Session nach dem Login ins Admin-Panel vor ihrer Zerstörung erhalten bleibt. (Die Eingabe hier hat nichts mit der Erneuerung der Session während des Logins zu tun, siehe oben!)</li>
				<li><span class="blue">$recording_days</span> ==&#62; Anzahl der Tage, die in der Datenbank für die Tagesstatistik erfasst und im Admin-Panel angezeigt werden.</li>
				<li><span class="blue">$allowed_attemps</span> ==&#62; Zugelassene Versuche eines Login ins Admin-Panel mit falschen Zugangsdaten, bevor das Login automatisch gesperrt wird.</li>
				<li><span class="blue">$barrier_days</span> ==&#62;	Anzahl der Tage, die das Login gesperrt bleibt, bevor es automatisch wieder freigegeben wird.</li>
				<li><span class="blue">$pw_minutes</span> ==&#62; Anzahl der Minuten, die ein Passwort, das mit der "Passwort-vergessen-Funktion" angefordert wurde, gültig bleibt. (Die Eingabe hier hat nichts mit den drei Minuten bis zum Verfall des zweiten Passworts bei Aktivierung der 2-Faktor-Authentisierung zu tun!)</li>
				<li><span class="blue">$maxInputSearch</span> ==&#62; Maximale Anzahl von Zeichen, die in das Eingabefeld der Suchfunktion vom Gast eingegeben werden können.</li>
				<li><span class="blue">$minInputSearch</span> ==&#62; Mindestens notwendige Anzahl von Zeichen, die in das Eingabefeld der Suchfunktion vom Gast eingegeben werden müssen.</li>
				<li><span class="blue">$maxSearch</span> ==&#62; Anzahl der zugelassenen Nutzungen der Suchfunktion innerhalb von 60 Minuten.</li>
				<li><span class="blue">$maxSmilies</span> ==&#62; Anzahl der maximal erlaubten Emojis innerhalb eines neuen Gästebucheintrags (wenn die Überwachung unter "Allgemeine Konfiguration" aktiviert wurde).</li>
				<li><span class="blue">$quoteFirst</span> ==&#62; Soll bei einer Nutzung der Zitatfunktion der zitierte Eintrag vor der Erwiderung des Gastes angezeigt werden (==> true) oder soll der zitierte Eintrag an das Ende der Erwiderung gestellt werden (==> false)?</li>
			</ul>';
// IV.3.3. Template + IV.3.3.1. Standard Template
		echo'
			<span id="anchor-Template" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.3. Template</strong></p>
			<p>Die Darstellung der Einträge im Gästebuch wird entscheidend durch das verwendete Template bestimmt. Um mit Templates zu arbeiten (editieren und erstellen), sind (mit Einschränkungen, s.u.) HTML-Kenntnisse erforderlich.</p>
			<a id="anchor-StandTempl" name="anchor-StandTempl"></a><div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.3.1. Standard Template</strong></p>
			<p>Hier werden alle vorhandenen Templates auf einen Blick dargestellt und können durch einen Klick auf einen der zugehörigen Radio-Buttons und anschließendes Speichern gewechselt werden. Das gerade verwendete Template ist gekennzeichnet.</p>
			<p>Um die Auswahl zwischen den verschiedenen vorinstallierten Templates zu erleichtern, können Ansichten mit einem Klick auf den Button &quot;Show example&quot; aufgerufen werden.</p>
			<p><strong><span class="red">TIPP:</span></strong> Die vorinstallierten Templates &quot;myPHP-GBook4_wide-R&quot;, &quot;myPHP-GBook4_wide2-R&quot; und &quot;myPHP-GBook4_black3-R&quot; sollten aus optischen Gründen nicht mit einer Breite des Gästebuchs von weniger als 600px gewählt werden, da sonst die linke Spalte mit Namen etc. je nach Eintrag zu schmal werden kann.</p>
			<p><strong><span class="red">TIPP:</span></strong> Bei dem vorinstallierten Template &quot;myPHP-GBook4_color-R&quot; kann die Rahmenfarbe um einen Gästebucheintrag ganz einfach unter dem Link &quot;Template editieren&quot; und der Auswahl &quot;myPHP-GBook4_color-R&quot; geändert/nach Wunsch angepasst werden.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Zu den dreizehn vorinstallierten Templates gehören dreizehn abgestimmte CSS-Styles. Die zugehörigen Styles haben jeweils die identische Bezeichnung wie die Templates. Wird ein Template ohne das zugehörige Style verwendet, kann es zu Darstellungsfehlern kommen, die zwar keine Schäden verursachen (außer im Auge des Betrachters), das Erscheinungsbild des Gästebuchs aber empfindlich stören. Deshalb wird bei der Auswahl eines Template ein Warnsymbol <img src="'.$url.'images/ausruf.png" height="14" width="14" alt="" /> angezeigt, solange nicht der zugehörige, gleichnamige CSS-Style ebenfalls ausgewählt wurde. Wenn Sie also ein Template wechseln, sollten Sie in einem zweiten Schritt stets auch den zugehörigen Style einstellen, das Warnsymbol verschwindet dann.</p>';
// IV.3.3.2. Template editieren 
		echo'
			<span id="anchor-EditTempl" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.3.2. Template editieren (inkl. Schriftart und -größe, Textfarben, Breite, Hintergründe u.ä.)</strong></p>
			<p>Die einzelnen Templates können hier nach Ihren Wünschen angepasst werden. Rufen Sie unter dem entsprechenden Link das von Ihnen genutzte Template zur Bearbeitung auf, das weitere Vorgehen ist selbsterklärend.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Für eine Anpassung der grundlegenden Einstellungen von Hintergrundfarben der gesamten Gästebuchseite und der Gästebucheinträge, für das Einfügen eines Hintergrundbilds, für Änderungen der Schriftgröße und -farbe, die maximale Breite des Gästebuchs und dessen Ausrichtung auf der Website (Rechts-Links-Mittig), sowie die Farbe der aktiven Bewertungs-Sterne und anderer Icons sollte und braucht der CSS-Code nicht geändert zu werden. Diese Einstellungen können schneller und einfacher ebenfalls unter "Template editieren" vorgenommen werden.</p>
			<p><strong class="red">TIPP:</strong> Sie können hier u.a. auch eine andere Schriftart einstellen (Voreinstellung: Arial). Im Drop-Down-Menü sind hierzu die als hinreichend "websicher" geltenden 9 Schriftfamilien zur freien Auswahl verfügbar. - Wem das nicht reicht und wer daher unbedingt auf eine andere, nicht im Menü enthaltenen Schriftart zugreifen möchte, macht folgendes:</p>
			<ul>
				<li>Die Datei "fonts.inc.php" im Verzeichnis "includes" mit einem Editor öffnen.</li>
				<li>Die beiden dort ersichtlichen Arrays um die gewünschte Schriftart ergänzen.<br />
					Achten Sie dabei auf die jeweils korrekte Syntax!<br /><strong>Im ersten Array: <span class="blue size-16">[ \' ... , ... , ... \' ,  \' ... \' ],</span><br />und im zweiten: <span class="blue size-16">\' ... , ... , ... \'</span></strong><br />
					Wenn Sie im zweiten Array die neue Schrift nach der vorhandenen letzten hinzufügen, vergessen Sie nicht, ein Komma hinter die dann vorletzte Zeile zu setzen!<br />
					Sie können die Ergänzung im zweiten Array auch ganz weglassen, wenn Ihr System auf PHP 5.5 oder höher läuft.</li>
				<li>Änderungen speichern und Datei neu hochladen.</li>
			</ul>';
// IV.3.3.3. Template erstellen
		echo'
			<span id="anchor-MakeTempl" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.3.3. Template erstellen</strong></p>
			<p>Diese Option kann nur voll ausgenutzt werden, wenn auch HTML Kenntnisse vorhanden sind, da hier das ganze Aussehen von den Gästebucheinträgen selbst bestimmt werden kann.</p>
			<p>Sie sollten beachten, dass der von Ihnen eingefügte HTML Code nur für einen Eintrag bestimmt ist und sich mit jedem weiteren Eintrag wiederholt. Also können Sie nicht den Code einer ganzen HTML Seite dort einfügen.</p>
			<p>Wenn Sie ein Grundgerüst des HTML Codes erstellt haben, müssen Sie die Gästebuch-Variablen am richtigen Ort einsetzen. So ist z.B. &lt;$name$&gt; der Platzhalter für den Namen des Gastes, der sich ins Gästebuch einträgt.</p>
			<p>Für Anfänger wird empfohlen, vorhandene Templates zu editieren und so den Wünschen nach anzupassen. Voransichten für selbstgefertigte Templates funktionieren selbstverständlich nicht.</p>';
// IV.3.3.4. Template löschen
		echo'
			<span id="anchor-DelTempl" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.3.4. Template löschen</strong></p>
			<p>Ungebrauchte Templates können hier einfach und endgültig(!) gelöscht werden.</p>
			<p>Ich empfehle allerdings, keines der vorinstallierten Templates zu löschen, es sei denn, der zugehörige CSS-Style wird ebenfalls entfernt.</p>
			<p>Damit nicht versehentlich alle Templates gelöscht werden, kann das letzte in der Datenbank vorhandene Template nicht entfernt werden.</p>
			<p>Sollte(n) einmal ein oder mehrere Templates gelöscht worden sein und später der Wunsch entstehen, sie wieder herzustellen, kann dies mit dem Diagnose- und Reparatur-Tool zu <span class="italic">myPHP Guestbook</span> problemlos erfolgen. Näheres hier siehe unten <a href="#anchor-Repair">Abschnitt IV. 4., "Diagnose- und Reparatur-Tool"</a>.</p>';
// IV.3.4. CSS-Styles
		echo'
			<span id="anchor-Styles" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.4. CSS-Styles</strong></p>
			<p>Neben dem verwendeten Template wird das Aussehen von <span class="italic">myPHP Guestbook</span> auch vom genutzten CSS-Style bestimmt.</p>
			<p>Falls Sie noch nicht genau wissen, was CSS ist, sollten Sie sich unbedingt Tutorials (finden Sie im Internet) anschauen, damit Sie über ein gewisses Grundwissen verfügen.</p>';
// IV.3.4.1. Standard Style
		echo'
			<span id="anchor-StandStyle" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.4.1. Standard Style</strong></p>
			<p>Hier werden alle vorhandenen Styles auf einen Blick dargestellt und können durch einen Klick auf einen der zugehörigen Radio-Buttons und anschließendes Speichern gewechselt werden. Der gerade verwendete Style ist gekennzeichnet.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Zu den dreizehn vorinstallierten CSS-Styles gehören dreizehn abgestimmte Templates. Die zugehörigen Templates haben jeweils die identische Bezeichnung wie die Styles. Wird ein Style ohne das zugehörige Template verwendet, kann es zu Darstellungsfehlern kommen, die zwar keine Schäden verursachen (Sie wissen schon: außer im Auge des Betrachters), das Erscheinungsbild des Gästebuchs aber mehr oder weniger empfindlich stören. Deshalb wird bei der Auswahl eines CSS-Styles ein Warnsymbol <img src="'.$url.'images/ausruf.png" height="14" width="14" alt="" /> angezeigt, solange nicht das zugehörige, gleichnamige Template ebenfalls ausgewählt wurde. Wenn Sie also einen Style wechseln, sollten Sie stets auch das entsprechende Template wechseln, das Warnsymbol verschwindet dann.</p>';
// IV.3.4.2. Style editieren
		echo'
			<span id="anchor-EditStyle" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.4.2. Style editieren</strong></p>
			<p>Falls kleine Änderungen am Style vorgenommen werden sollen, kann hier ein vorhandener Style editiert werden.</p>
			<p>Achten Sie unbedingt auf die richtige Klassenwahl zum jeweils verwendeten Template!</p>
			<p>Im Style können einige Variablen genutzt werden, die auf den Seiten &quot;Style erstellen&quot; bzw. &quot;Style editieren&quot; unter dem Textfeld zur Eingabe beschrieben sind. Die Inhalte dieser Variablen sind bei dem jeweiligen Template erfasst und werden auch dort geändert (siehe oben unter &quot;Template editieren&quot;).</p>
			<p><strong class="red">TIPP:</strong> Individuelle Änderungen in der externen CSS-Datei können und sollten vermieden werden, schon um unnötige Probleme und Arbeit bei einem späteren Update zu vermeiden. Alles, was Sie an der CSS anders gestalten möchten, kann und sollte durch entsprechende Einträge unter "Style editieren" erfolgen. Da diese CSS nach der externen Datei aufgerufen und abgearbeitet wird, wird alles, was darin steht und eventuell im Widerspruch zu einzelnen Codes in der externen Datei ist, vorrangig behandelt bzw. überschreibt die Anweisungen aus der externen Datei.</p> 
			<p><strong><span class="red">TIPP:</span> Hier einige CSS-Code-Beispiele für Layout-Änderungen, nach denen immer wieder gefragt wird:</strong></p>
			<p>Zunächst unter "CSS-Style" &#62; "Style editieren" anklicken und den von Ihnen aktuell verwendeten Style öffnen, indem Sie auf den Button "Bearbeiten" klicken. Am Ende des vorhandenen Styles den alternativ gewünschten Code einsetzen und speichern:</p>
			<p><strong>Schriftfarbe:</strong></p>
			<p>a) Gästebucheinträge schwarze Schrift, Bezeichnung der Formularfelder auf der "insert.php" helle Schrift:</p>
			<ul>
				<li>Einstellung für die Textfarbe der Gästebucheinträge unter "Template editieren", für hiervon abweichende Schriftfarbe (nur) auf der "insert.php" im CSS-Code einfügen:<br />
				<span class="blue">.insert-table { color:#f2f2f2; }</span></li>
			</ul>
			<p>b) Änderung der Farben für die Text-Links zur Eintragsseite und der Seitenzahlen zum Blättern oberhalb und unterhalb der Gästebucheinträge:</p>
			<ul>
				<li>Im Beispiel unten ist der Link in Normalzustand blau (= #0000ff) und im aktiven Zustand rot (= #ff0000):<br /> 
				<span class="blue">.this-page,.navi-page:link,.navi-page:visited { color:#0000ff; }<br />
				.navi-page:hover,.navi-page:active { color:#ff0000; }</span></li>
			</ul>
			<p>c) Text-Schatten beim Link zur Eintragsseite und den Seitenzahlen zum Blättern durch die Seiten mit den Gästebucheinträgen entfernen:</p>
			<ul>
				<li style="list-style:none;"><span class="blue">.this-page,a:link.navi-page { text-shadow:none; }</span></li>
			</ul>
			<p>d) Änderung der Schrift- und Hintergrundfarbe des Html-Buttons zur Eintragsseite:</p>
			<ul>
				<li>Im Beispiel unten ist die Hintergrundfarbe des Buttons dunkelblau (= #3300ff), die Schriftfarbe weiß (= #fff):<br />
				<span class="blue">a:link.insert-button,a:visited.insert-button { color:#fff; background-color:#3300ff; background:#3300ff; }</span></li>
			</ul>
			<p><strong>Layout Eintragsfelder:</strong></p>
			<p>a) Die Inputfelder und das Textarea-Feld bekommen beim Setzen des Cursors programmseitig einen grauen Rahmen mit entsprechendem äußerem Schatten gesetzt. Einen farblich angepassten Schatten hat auch das Feld, bei dem der Gast anklicken kann, wenn er über eine Antwort zu seinem Eintrag per E-Mail informiert werden möchte. Die Farben von Rahmen und Schatten kann man u.a. wie folgt individuell anpassen:</p>
			<ul>
				<li>Kein Schatten, unveränderte Rahmenfarbe:<br />
				<span class="blue">.insert:focus, textarea:focus, .comment-info { border:solid 1px #9e9e9e; -webkit-box-shadow: 0 0 0 0; -moz-box-shadow: 0 0 0 0; box-shadow: 0 0 0 0; }</span><br /><br /></li>
				<li>Für weißen Rahmen mit Schatten (bei schwarzen/sehr dunklen Hintergründen):<br />
				<span class="blue">.insert:focus, textarea:focus, .comment-info { border:solid 1px #f2f2f2; -webkit-box-shadow: 0 0 5px 4px rgba(255,255,255, 0.3); -moz-box-shadow: 0 0 5px 4px rgba(255,255,255, 0.3); box-shadow: 0 0 5px 4px rgba(255,255,255, 0.3); }</span><br /><br /></li>
				<li>Für grünen Rahmen mit Schatten:<br />
				<span class="blue">.insert:focus, textarea:focus { border:solid 1px #00cc66; -webkit-box-shadow: 0 0 5px 4px rgba(31,248,20, 0.12); -moz-box-shadow: 0 0 5px 4px rgba(31,248,20, 0.12); box-shadow: 0 0 5px 4px rgba(31,248,20, 0.12); }</span><br /><br /></li>
				<li>Für roten Rahmen mit Schatten:<br />
				<span class="blue">.insert:focus, textarea:focus { border:solid 1px #ff0000; -webkit-box-shadow: 0 0 5px 4px rgba(219,28,28, 0.12); -moz-box-shadow: 0 0 5px 4px rgba(219,28,28, 0.12); box-shadow: 0 0 5px 4px rgba(219,28,28, 0.12); }</span><br /><br /></li>
				<li>Für blauen Rahmen mit Schatten:<br />
				<span class="blue">.insert:focus, textarea:focus { border:solid 1px #0066ff; -webkit-box-shadow: 0 0 5px 4px rgba(0,0,255, 0.12); -moz-box-shadow: 0 0 5px 4px rgba(0,0,255, 0.12); box-shadow: 0 0 5px 4px rgba(0,0,255, 0.12); }</span></li>
			</ul>
			<p>b) Hintergrund- und Schriftfarbe der Eingabefelder ändern:</p>
			<ul>
				<li>Im Beispiel unten ist die Hintergrundfarbe dunkelgrau (= #424242), die Schriftfarbe weiß (= #fff):<br />
				<span class="blue">textarea, textarea:focus, .insert, .insert:focus, .no-insert:focus, .gb-info, .search-insert, .search-icon, .search-button { color:#fff !important; background-color:#424242 !important; }</span></li>
			</ul>';
		echo'
			<p><strong>Sonstiges:</strong></p>
			<p>a) Schatten um eingestellte Fotos anzeigen und Ecken abrunden:</p>
			<ul>
				<li><span class="blue">img.add-on { -webkit-border-radius:3px; -moz-border-radius:3px; -khtml-border-radius:3px; border-radius:3px; -webkit-box-shadow:0px 0px 10px #474747; -moz-box-shadow:0px 0px 10px #474747; box-shadow:0px 0px 10px #474747; }</span></li>
			</ul>
			<p>b) Symbol für externe Links teilweise oder vollständig entfernen:</p>
			<ul>
				<li>Webseiten, auf die von einem in einem Gästebucheintrag enthaltenem Link verwiesen wird, werden beim Anklicken in einem neuen Browserfenster geöffnet. Es ist üblich geworden, dem User durch ein entsprechendes Symbol anzuzeigen, wenn ein Link auf eine externe Website verweist. Dies geschieht auch beim <span class="italic">myPHP Guestbook</span>, indem jedem Link in einem Gästebucheintrag automatisch das Symbol: <img class="img-ok" src="../images/link-sym.png" width="14" height="12" alt="" /> vorangestellt wird.<br /><br />
				Wer in diesem Bereich "sauber" arbeiten will, sollte also dafür sorgen, dass eventuelle Links auf ein Ziel der <strong>eigenen Website</strong> nicht gekennzeichnet werden. Dies geschieht ganz einfach durch einfügen folgenden Codes in die CSS:<br /><span class="blue">a.external[href^="http(s)://www.Deine-Website.de"] { padding:0; background:none; }</span><br /><br />
				Wer das Symbol <strong>vollständig</strong> entfernen möchte, fügt folgendes ein:<br /><span class="blue">a.external[href^="http:"],a.external[href^="https:"] { padding:0; background:none; }</span></li>
			</ul>
			<span id="anchor-rgba" class="sticky-anchor"></span>
			<p>c) Semi-transparente Schrift, Hintergünde oder Rahmen:</p>
			<ul>
				<li>Manchmal besteht der Bedarf nach halb-durchsichtigen Objekten, z.B. wenn man zur besseren Lesbarkeit einer Schrift über ein Hintergrundbild eine Hintergrundfarbe legen möchte, bei der aber das Bild noch durchscheinen soll.<br /><br /> 
				Das lässt sich ebenfalls mit CSS schnell und einfach umsetzen, und zwar seit einigen Jahren mit RGBA. RGBA wird von allen modernen Browsern unterstützt (Edge, IE&nbsp;>=&nbsp;9, Chrome&nbsp;>=&nbsp;1.0, FF&nbsp;>=&nbsp;3.0, Safari&nbsp;>=&nbsp;3.1, Opera&nbsp;>=&nbsp;10.0).<br /><br />
				Auf den Seiten im Admin-Panel: "CSS-Style" => "Style editieren" und  => "Style neu erstellen" finden Sie hierfür ein kleines Tool zur einfachen Erstellung des benötigten Codes. Gehen Sie wie folgt vor:<br /><br />
				<ul>
					<li>Suchen Sie sich in der Farbtabelle unter dem Button "Auswahl websichere Farben und Grautöne" die gewünschte Farbe oder den Grauton aus und kopieren Sie den dazugehörigen Hexadezimal-Code.<br /><br />
					<li>Fügen Sie den Hexadezimal-Code in das Inputfeld mit der beispielhaften Vorbelegung "#ffffff".<br /><br />
					<li>Wählen Sie in dem Drop-Down-Menü daneben ("Opacity") die gewünschte Deckkraft der Farbe oder des Grautons. Hierbei gilt: Je geringer die Deckkraft desto höher die Transparenz.<br /><br />
					<li>Klicken Sie auf den Button: "Convert Hex. to RGB(A)".<br /><br />
					<li>Sie sehen dann darunter den generierten RGB-Farbcode identisch zu dem gewählten Hexadezimal-Farbcode und als viertes Element den Alphakanal mit der gewählten Transparenzstufe.<br /><br />
					<li>Kopieren Sie den RGBA-Code und setzen Sie ihn wie sonst den Hexadezimal-Code in Ihre CSS ein. Beispiel für halb-transparenten weißen Hintergrund:<br /><span class="blue">background-color:rgba(255, 255, 255, 0.5);</span>
				</ul>
			</ul>
			<p class="zentriert"><br /><strong>Achtung!</strong></p>
			<p><strong>Die im vorinstallierten CSS-Code eingesetzten Variablen sollten unverändert bleiben, um die Einstellmöglichkeiten unter "Template editieren" nicht zu zerstören.</strong></p>';
// IV.3.4.3. Style erstellen
		echo'
			<span id="anchor-MakeStyle" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.4.3. Style erstellen</strong></p>
			<p>Für Anwender mit entsprechenden Kenntnissen in CSS bietet dieses Feature die Möglichkeit, einen eigenen Style von Grund auf selber zu erstellen.</p>';
// IV.3.4.4. Style löschen
		echo'
			<span id="anchor-DelStyle" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.4.4. Style löschen</strong></p>
			<p>Nicht benötigte Styles können hier ebenso einfach wie endgültig (!) gelöscht werden.</p>
			<p>Ich empfehle allerdings, keinen der vorinstallierten Styles zu löschen, es sei denn, das zugehörige Template wird ebenfalls entfernt.</p>
			<p>Damit nicht versehentlich alle Styles gelöscht werden, kann der letzte in der Datenbank vorhandene Style nicht entfernt werden.</p>
			<p>Sollte(n) einmal ein oder mehrere Styles gelöscht worden sein und später der Wunsch entstehen, sie wieder herzustellen, kann dies mit dem Diagnose- und Reparatur-Tool zu <span class="italic">myPHP Guestbook</span> problemlos erfolgen. Näheres hier siehe unten <a href="#anchor-Repair">Abschnitt IV. 4., "Diagnose- und Reparatur-Tool"</a>.</p>';
// IV.3.5. Banner
		echo'
			<span id="anchor-banner" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.5. Banner und individueller Brüßungstext</strong></p>
			<p>Mit der Check-Box "Banner aktivieren" in den &quot;Allgemeinen Konfigurationseinstellungen&quot; schalten Sie die Anzeige eines Banners und/oder -je nach Wunsch- eines einleitenden Textes auf den öffentlichen Seiten "index-" und "insert.php" frei.</p>
			<p>Als Beispiel oder Muster sind zwei Banner bereits im Download enthalten, deren Daten bei der Installation erfasst wurden. Es steht selbstverständlich jedem User frei, einen eigenen Banner zu gestalten und zu verwenden.</p>
			<p>Der Banner ist verlinkt mit der angezeigten URL. Klickt der Besucher also auf den Banner, wird er zu der entsprechenden Seite geleitet. Der Titel wird beim Überfahren des Banners mit der Mouse angezeigt. Der (optionale) Begrüßungstext kann bis zu 1000 Zeichen lang sein und mit BBCodes formatiert werden.</p>
			<p>Wenn das Gästebuch per "include" in eine eigene Seite eingebunden wird, ist das Einfügen eines solchen Banners sinnlos (ebenso wie bei einer Einbindung per "iframe"). Daher ist eine Aktivierung der Funktion "Banner anzeigen" bei einer Nutzung der ergänzenden Dateien aus dem "include"-Download ohne Wirkung.</p>';
// IV.3.5.1. Banner anzeigen, editieren, löschen
		echo'
			<span id="anchor-ShowBanner" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.5.1. Banner anzeigen, editieren und löschen</strong></p>
			<p>Auf der Seite "Banner anzeigen" werden die in der Datenbank erfassten Banner mit den jeweils zugeordneten Texten dargestellt.</p>
			<p>Der aktive Banner, der auf der Gästebuchseite angezeigt wird, ist mit einem grünen Haken gekennzeichnet, die inaktiven Banner mit einem roten Kreuz. Ein Klick auf das rote Kreuz des Banners, der aktiviert werden soll, ändert den Status.</p>
			<p>Bei einem Klick auf das Bearbeitungssymbol können der Begrüßungstext, die URL, unter der der Banner verlinkt ist und der Titel des Banners geändert werden. Wenn Sie keinen Begrüßungstext wünschen, löschen Sie einfach den vorformulierten Text und lassen das Feld leer.</p>
			<p>Wird schließlich das Lösch-Icon angeklickt, wird der entsprechende Banner inklusive der auf dem Server befindlichen Bilddatei aus der Datenbank gelöscht.</p>
			<p>Es können nur nicht aktivierte Banner gelöscht werden.</p>';
// IV.3.5.2. Banner hinzufügen
		echo'
			<span id="anchor-PlusBanner" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.5.2. Banner und/oder Begrüßungstext hinzufügen</strong></p>
			<p>Um einen eigenen Banner hinzuzufügen, einfach die gewünschte Bilddatei (Format: *jpg, *png oder *gif) in das Verzeichnis "banner" des Gästebuchordners laden.</p>
			<p>Im Drop-Down-Menü wird der Name der neu in das Verzeichnis "banner" hochgeladenen Datei angezeigt und kann ausgewählt werden. Sobald Sie auf "Dateiname speichern" klicken, werden die Daten des Banners (Dateiname, Breite und Höhe) in der Datenbank gespeichert und die Datei als "ausgewählt" markiert.</p>
			<p>Gleichzeitig werden die URL Ihrer Website, ein Titel zum Banner und ein Begrüßungstext gespeichert.</p>
			<p>Im unteren Drittel der Seite "Banner hinzufügen" können sie durch Markierung der gekennzeichneten CheckBox auch festlegen, dass nur ein Begrüßungstext ohne gleichzeitige Verwendung einer Grafik als Banner erfasst wird.</p>
			<p>Alle Texte können Sie anschließend individuell ändern, indem Sie zur Seite "Banner anzeigen" wechseln und dort auf das Bearbeitungssymbol "Editieren" klicken, siehe oben.</p>';
// IV.3.6.  Smileys
		echo'
			<span id="anchor-Smilies" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.6. Smileys/Emojis</strong></p>
			<p>Smileys sind in Gästebüchern und Foren Standard. Auch in <span class="italic">myPHP Guestbook</span> steht Ihnen dieses Feature zur Verfügung.</p>
			<p>Smileys funktionieren wie folgt:</p>
			<p>Jeder Smiley besitzt einen eigenen BBCode (der BBCode für ein wütendes Smiley ist z.B. &quot;:angry:&quot;, was natürlich geändert werden kann). Wenn nun im Gästebuch &quot;:angry:&quot; in einen Eintrag geschrieben wurde und Smileys im Gästebuch aktiviert sind, erscheint anstelle von &quot;:angry:&quot; der wütende Smiley.</p>
			<p>Der &quot;normale&quot; User wird, wenn er nicht gerade Javascript in seinem Browser abgeschaltet hat, ein Smiley durch einfaches Anklicken in seinen Textbeitrag einfügen. Der Smiley erscheint nach dem Anklicken stets dort, wo sich zuvor der Cursor der Mouse im Text befunden hat.</p>';
// IV.3.6.1. Smileys anzeigen
		echo'
			<span id="anchor-ShowSmil" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.6.1. Smileys anzeigen</strong></p>
			<p>Alle vorhandenen Smileys werden hier zur Übersicht angezeigt und können bei Bedarf gelöscht oder editiert werden.</p>';
// IV.3.6.2. Smiley hinzufügen
		echo'
			<span id="anchor-PlusSmil" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.6.2. Smiley hinzufügen</strong></p>
			<p>Wenn Ihnen die vorinstallierten Smileys nicht ausreichen oder nicht gefallen, können Sie hier Ihre eigenen Smileys hochladen und BBCode sowie weitere Eigenschaften bestimmen.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Die ersten 12 (oder 19) Smileys, die auf der Seite für die Gästebucheinträge "insert.php" im Anschluss an oder anstelle der BBCode-Drop-Down-Menüs angezeigt werden, haben eine Breite von 15px. Wenn Sie dort andere Smileys mit abweichenden Größen einfügen, insbesondere solche mit einer Breite von mehr als 15px, kann dies zu für das Layout unschönen Zeilenumbrüchen führen. Eine Lösungsmöglichkeit besteht dann ggf. darin, die Datei "functions.inc.php" aus dem Verzeichnis "includes" zu öffnen und dort den Variablen "<span class="blue">$emojis_and_bbcodes</span>" und "<span class="blue">$only_emojis</span>" eine kleinere Zahl zuzuordnen, beispielsweise nur noch 10 / 17 Stück oder auch weniger.</p>';
// IV.3.6.3. Smileys löschen
		echo'
			<span id="anchor-DelSmil" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.6.3. Smileys löschen</strong></p>
			<p>Smileys, die Ihnen nicht gefallen, können ganz einfach unter &quot;Smileys anzeigen&quot; gelöscht werden. Über Checkboxen können Sie schnell und unkompliziert die zur Entfernung gewünschten Smileys markieren.</p>';
// IV.3.6.4. Smileys editieren
		echo'
			<span id="anchor-EditSmil" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.6.4. Smileys editieren</strong></p>
			<p>Bei kleinen Änderungen an Smileys ist dieses Feature sehr hilfreich. So kann z.B. der BBCode geändert werden, ohne dass der Smiley gelöscht und neu hinzugefügt werden muss.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Wenn Sie den BBCode eines Smileys nachträglich ändern, denken Sie daran, dass alle in schon vorhandenen Gästebucheinträgen eingefügten Smileys mit dem "alten", geänderten BBCode nicht mehr als Grafik dargestellt werden.</p>';
// IV.3.7. Badwords
		echo'
			<span id="anchor-Badwords" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.7. Badwords und deren Ersetzung</strong></p>
			<p>Schimpfwörter, sowie andere nicht erwünschte Wörter können mit diesem Feature im Gästebuch zensiert werden.</p>
			<p>Zwar lässt sich die Zensur durch Tricks auch umgehen, aber ein erster Schutz wird dadurch bereits geboten.</p>
			<p>In den Versionen ab v. 3.2.x wurden die Badwords durch ein vom Admin bestimmtes, frei wählbares Ersatzwort ausgetauscht, wobei diese Textänderung auf der öffentlichen Gästebuchseite für Dritte nicht erkennbar war. In einem von einem Dritten veröffentlichten Text ohne jeden Hinweis Textteile auszutauschen, und seien es auch nur ungehörige Textteile wie Kraftausdrücke o.ä., ist aus meiner Sicht nicht akzeptabel. Daher wurde die Badword-Filterung wieder dahingehend geändert, dass von Ihnen in der Datenbank eingetragene unerwünschte Wörter/Begriffe deutlich erkennbar erneut durch Sterne (***) ersetzt werden.</p>
			<p><strong><span class="red">TIPP:</span></strong> Setzen Sie die Möglichkeiten dieses Filters gut überlegt ein! Der Filter erkennt eingegebene Begriffe auch dann, wenn diese nur Teil eines Wortes sind und filtert sie aus.</p>
			<p>Wenn Sie also z.B. aus verständlichen Gründen nicht möchten, dass in einem Beitrag auf Ihrer Seite plötzlich das Wort &quot;Scheisse&quot; auftaucht, reicht es aus, wenn Sie als Badword in die Liste &quot;scheiss&quot; eintragen; der Filter macht dann aus &quot;Scheisse&quot; ein &quot;***e&quot;. - Tragen Sie aber z.B. &quot;arsch&quot; in die Badword-Liste ein, wird der Filter damit u.a. auch z.B. aus den Wörtern &quot;Wasser marsch&quot; ein &quot;Wasser m***&quot; machen.</p>';
// IV.3.7.1. Badwords anzeigen
		echo'
			<span id="anchor-ShowBadw" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.7.1. Badwords anzeigen und löschen</strong></p>
			<p>Alle unerwünschte Worte (Badwords) sehen Sie hier. Falls Sie Badwords löschen möchten, dann markieren Sie die zu löschenden Begriffe und klicken auf „Markierte löschen“.</p>';
// IV.3.7.2. Badwords hinzufügen
		echo'
			<span id="anchor-PlusBadw" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.7.2. Badwords hinzufügen</strong></p>
			<p>Um Wörter zu ersetzen, müssen Sie natürlich zuerst in der Datenbank gespeichert werden.</p>
			<p><strong><span class="red">TIPP:</span></strong> Achten Sie darauf, dass das Wort mindestens aus 3 Zeichen besteht, sonst kann es zu leicht passieren, dass Buchstabenfolgen innerhalb von normalen Wörtern ersetzt werden.</p>';
// IV.3.8. Spamfilter
		echo'
			<span id="anchor-Spamfilter" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.8. Spamfilter</strong></p>
			<p>Der Spamschutz in den v.3.x, der das unsägliche Captcha ersetzte, stützte sich ausschließlich auf die Überwachung eines Kontroll-Merkmals und war damit recht erfolgreich.</p>
			<p>Aber ich hatte auch Meldungen von Nutzern, wo er eben nicht gereicht hat und teilweise täglich mehrere Spameinträge eingingen.</p>
			<p>Der neue Spamschutz verarbeitet sowohl die bisherige, erfolgreiche Methode wie auch eine Reihe weiterer Prüfungen, von denen die Prüfung auf kritische Schlüsselwörter, von mir als &quot;Spamwörter&quot; bezeichnet, wiederum nur ein Aspekt ist. So kann der Filter bei Bedarf zukünftig leicht ausgebaut werden.</p>
			<p>Wer an den Einzelheiten interessiert ist, mag sich den Quellcode der entsprechenden Datei anschauen, für den "normalen" User ist hierbei m.E. folgendes zum besseren Handling wichtig zu wissen:</p>
			<p>Der Spamfilter arbeitet mit einem System von &quot;Strafpunkten&quot;. D.h. er erfasst bestimmte typische Merkmale für Spam und vergibt dann dafür Punkte.</p>
			<p>So wird z.B. jeder Eintrag beim Klick auf den Speichern-Button nach Spamwörtern aus der Liste durchsucht und bei jeder Übereinstimmung wird jedes erkannte Spamwort mit je einem Strafpunkt gewertet. Auch die in einem Beitrag enthaltenen Links werden gezählt und beim Überschreiten einer (in den Konfigurationseinstellungen einstellbaren) Höchstgrenze mit je einem (weiteren) Strafpunkt belegt.</p>
			<p>Diese und eine Reihe weiterer Prüfungen vollzieht der Spamfilter automatisch, wobei manche Spammerkmale, wie z.B. der bisherige Spamschutz, dabei auf einen Schlag mit 5 Punkten belegt werden, andere eben nur mit 1 Punkt, je nach Erheblichkeit. (So ist z.B. nicht jeder Beitrag, in dem das Wort &quot;Viagra&quot; vorkommt, immer Spam.)</p>
			<p>Alle Strafpunkte werden vom Programm addiert. Wenn nun die Summe der Strafpunkte bestimmte Grenzen übersteigt, wird unterschieden:</p>
			<ul>
				<li>Beim Überschreiten der Höchstgrenze wird der Beitrag sofort verworfen, also gar nicht erst gespeichert. Die IP des Absenders wird gespeichert und für einen sofortigen erneuten Aufruf der Eintragsseite gesperrt. Es geht eine E-Mail an den Admin, in der neben dem verworfenen Eintrag die Anzahl der vom Programm ermittelten &quot;Strafpunkte&quot; und die Kriterien, aus denen die einzelnen &quot;Strafpunkte&quot; gebildet wurden, mitgeteilt werden.
				<li>Wenn das Programm zwar &quot;Strafpunkte&quot; durch Spam-verdächtige Inhalte ermittelt, diese aber in der Summe nicht die kritische Höchstgrenze erreichen, wird der Beitrag in der Datenbank gespeichert, aber als &quot;Deaktiviert&quot; markiert. D.h., der Beitrag ist zwar vorhanden, aber zunächst im öffentlichen Bereich nicht sichtbar. Es geht erneut eine E-Mail an den Admin mit dem Inhalt des Beitrags, den ermittelten &quot;Strafpunkten&quot; und deren Ursache(n), sowie einem Link zur eventuellen Freischaltung des gesperrten Beitrags per E-Mail.
				<li>Werden keinerlei Spammerkmale festgestellt, bleibt alles wie gehabt: Der Beitrag wird normal gespeichert und ist –je nach Einstellung in der Konfigurationsdatei- entweder sofort freigegen oder auch zunächst gesperrt, ganz nach Ihren Vorgaben. Wie üblich geht auch in diesem Fall eine E-Mail mit dem Inhalt des Beitrags an den Admin (es sei denn, Sie haben diese Funktion ausdrücklich abgeschaltet), die jedoch vorsorglich auch einen Link zur &quot;Fernsperre&quot; des veröffentlichten Beitrags per E-Mail hat.
				<li>Die oben angesprochene &quot;Höchstgrenze&quot; an zulässigen &quot;Strafpunkten&quot;, die nicht überschritten werden darf, kann in den Konfigurationseinstellungen des Admin-Panels im Bereich zwischen &quot;1&quot; als Mindestwert und &quot;20&quot; als Höchstwert von Ihnen selbst festgelegt werden. – Nach der Installation ist die Voreinstellung zunächst &quot;5&quot;.
				<li>Die ebenfalls erwähnte &quot;Höchstgrenze&quot; an unverdächtigen Links in einem Beitrag kann genauso in den Konfigurationseinstellungen des Admin-Bereichs im Bereich zwischen &quot;0&quot; (=jeder Link ist verdächtig) und maximal &quot;20&quot; von Ihnen bestimmt werden. – Nach der Installation ist die Voreinstellung zunächst &quot;2&quot;. Die Linkprüfung lässt die in der entsprechenden Spalte eingegebene Homepage des Besuchers unberücksichtigt und prüft nur Eingaben im Textfeld; hierbei erkennt und zählt sie Links sowohl in der Form: &quot;http://www.example.org&quot; wie auch in: &quot;www.example.org&quot; oder in: &quot;http://example.org&quot; und schließlich in &quot;[url=http:// www.example.org]LINK[/url]&quot;. 
				<li>Die Prüfung eines Eintrags auf Spamwörter und die Prüfung der Anzahl im Textbeitrag eingestellter Links können in den Konfigurationseinstellungen vollständig abgeschaltet werden.
			</ul>
			<span id="anchor-disableSpam" class="sticky-anchor"></span>
			<ul>
				<li><strong>Hinweis:</strong> Weitere Teile des Spamschutzes können durch eine Deaktivierung bestimmter Variablen abgeschaltet werden. Öffnen Sie hierzu die Datei "spamfilter.php" im Verzeichnis "includes", dort die ersten drei Variablen unterhalb des Copyright-Hinweises.<p>Die Prüfungen auf Spamwörter und auf die Anzahl gesetzter Links in Einträgen können unter "Allgemeine Konfiguration" abgeschaltet werden.</p><p>Der <strong>komplette</strong> Spamschutz ist grundsätzlich nicht dafür vorgesehen, deaktiviert zu werden. Ausnahmsweise ist dies im Einzelfall dennoch möglich. Für Einzelheiten hierzu siehe oben <a href="#anchor-MoreKonfig">Abschnitt IV. 3.2.5, "Weitere Konfigurationsmöglichkeiten"</a>.</p>
			</ul>';
// IV.3.8.1. Spam Basics
		echo'
			<span id="anchor-SpamBasics" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.8.1 Grundsätzliches zum Spam-Schutz</strong></p>
			<p>Was wird mit Spam bezweckt? Meist sollen Links zu irgendwelchen Websites möglichst schnell und möglichst weit verbeitet werden. Seit einiger Zeit sind darüber hinaus jedoch auch Fälle zu beobachten, bei denen anstatt Links bestimmte Schlüsselworte (z.B. Firmen- oder Markennamen) dutzendfach wiederholt in ansonsten weitgehend sinnfreien Texten untergebracht werden, vermutlich gezielt für Suchmaschinen. Um das zu erreichen, werden i.d.R. sogen. Bots eingesetzt, also kleine Programme, die automatisch das WWW nach Formularen mit der Möglichkeit zur Eingabe eben solcher Links oder Schlüsselworte durchsuchen.</p>
			<p>Diese auf Schnelligkeit und Masse ausgelegte Arbeitsweise ermöglichst es, gezielt nach spezifischen Merkmalen zu suchen und entsprechende Abwehrmaßnahmen zu ergreifen, die dann ebenfalls automatisiert werden können, wie hier mit dem "Spamfilter".</p>
			<p>Alles, was automatisiert ist, kann umgangen werden. - Die derzeit verbreiteten Spam-Bots durch den Spamfilter, der Spamfilter durch entsprechend gezielt darauf "programmierte" Spam-Bots. Auch wenn mir solche bislang nicht bekannt sind, dürfte das Ganze eine Frage der Zeit sein. Was jedoch bleibt, ist das Ziel solcher Bots: Links oder bestimmte Begriffe massenhaft verbreiten.</p>
			<p>Damit liegt der effektivtse Spam-Schutz gegen unerwünschte Links auf der Hand: Das Eintragen von eben solchen URLs zu verhindern (womit gleichzeitig auch die ab und zu anzutreffenden menschlichen Spammer am effektivsten ferngehalten werden können).</p>
			<p>Wie macht man das? Drei einfache Möglichkeiten:</p>
			<ul>
			<li>In den "Allgemeinen Konfigurationseinstellungen" die CheckBox für: "<span class="italic">Einträge müssen freigegeben werden</span>" aktivieren, also auf ein moderiertes Gästebuch umstellen. Das verhindert zwar keine Spam-Einträge, verhindert aber deren Veröffentlichung ohne Zustimmung des Admin.<br /><br /></li>
			<li>Andere Möglichkeit: In den "Allgemeinen Konfigurationseinstellungen" die BBCodes <strong>de</strong>aktivieren <strong>und</strong> die CheckBox für "<span class="italic">Eintragsfeld für Homepage Adresse verbergen</span>" aktivieren. - Das Einstellen jeglicher Links durch einen Gast ist unmöglich, allerdings können auch keine Fotos mehr hochgeladen oder sonstige BBCodes verwendet werden.<br /><br /></li>
			<li><strong>Der in meinen Augen elegantere Weg ist jedoch ein anderer:</strong> In den "Allgemeinen Konfigurationseinstellungen" die CheckBoxen für "<span class="italic">Spam durch Anzahl der Links in Beiträgen erkennen und verhindern</span>" <strong>und</strong> "<span class="italic">Eintragsfeld für Homepage Adresse verbergen</span>" aktivieren <strong>und</strong> die "<span class="italic">Anzahl der unverdächtigen Links in Beiträgen</span>" auf "0" setzen. - Damit können BBCodes weiter verwendet aber keinerlei Links mehr im Gästebuch veröffentlicht werden. Ende Gelände. :-)</li>
			</ul>
			<p>Sinnfreie Einträge mit ständig wiederholten Schlüsselbegriffen werden effektiv durch den Eintrag des oder der verwendeten Schlüsselwörter in die Spamwortliste bekämpft.</p>';
// IV.3.8.2. Spamwords anzeigen
		echo'
			<span id="anchor-ShowSpamWo" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.8.2 Spamwords anzeigen und löschen</strong></p>
			<p>Spam-typische Wörter oder auch Wortgruppen werden hier angezeigt und können genauso durch markieren wieder gelöscht werden.</p>
			<p>Wenn alle Spamwörter in der Liste gelöscht werden, wird die Funktion &quot;Eintrag auf Spamwörter prüfen&quot; in den Konfigurationseinstellungen automatisch deaktiviert. Werden dann zu einem späteren Zeitpunkt wieder ein oder mehrere Spamwörter in die Liste eingetragen, bitte nicht vergessen, die Spamwort-Prüfung in den Konfigurationseinstellungen wieder zu aktivieren. Eine entsprechende Warnung wird auf der Seite mit den Spamwörtern angezeigt.</p>';
// IV.3.8.3. Spamwords hinzufügen
		echo'
			<span id="anchor-PlusSpamWo" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.8.3 Spamwords hinzufügen</strong></p>
			<p>Hat es doch mal ein Spambot geschafft, alle Prüfungen des Spamfilters zu überwinden und seinen sinnlosen Wortmüll in Ihr Gästebuch zu schmuggeln, schauen Sie sich sorgfältig den Text an.</p>
			<p>Sie werden in der Regel einige Begriffe finden, die sich mehrfach wiederholen und die in &quot;normalen&quot; Texten von &quot;echten&quot; Gästebuchschreibern entweder gar nicht oder allenfalls vereinzelt vorkommen. Speichern Sie dieses Wort oder auch eine Wortgruppe hier in der Datenbank zu zukünftigen Kontrolle durch den Filter.</p>
			<p><strong><span class="red">TIPP:</span></strong> Groß- und Kleinschreibung sind für die Prüfung eines Beitrags auf Spamwörter dann gleichgültig, wenn das Schlüsselwort in der entsprechenden &quot;Spamwort-Liste&quot; kleingeschrieben gespeichert wird; wird es dort großgeschrieben eingetragen, wird es im zu überprüfenden Text nicht als Übereinstimmung gefunden werden. <strong>Also stets alles kleingeschrieben in der Spamwort-Liste abspeichern.</strong></p>
			<p>Außerdem wird ein &quot;normal&quot; in die Liste eingetragenes Spamwort im Beitrag eines Gastes ebenso erkannt, wenn es nur ein Teil eines Wortes ist. Wenn also z.B. &quot;sex&quot; als Schlüsselwort in der Spamwortliste vorhanden ist, erkennt das Programm im Text:</p>
			<p class="zentriert italic">&quot;Der Peter wurde ausgezeichnet als sexiest man alive,<br />dabei ist er genauso sexy wie Rumpelstilzchen und Sex hatte er noch nie.&quot;</p>
			<p>... drei Spammerkmale und vergibt drei Punkte, egal ob &quot;sex&quot; im Text groß- oder kleingeschrieben und einmal nur als Teil eines Wortes bzw. mit angehängtem &quot;y&quot;. Wer das im Einzelfall verhindern möchte, trägt das Schlüsselwort in die Liste jeweils mit einem Leerzeichen davor und dahinter ein, also (natürlich ohne die Anführungszeichen): &quot; sex &quot;. Dann wird auch nur exakt danach gesucht.</p>
			<p>Aber Obacht, wie beim "Badword-Filter" gilt auch hier: Erst denken, dann handeln. Wird ein Schlüsselwort mit einem Leerzeichen davor und dahinter in die Spamwortliste aufgenommen, wird es vom Programm nicht erkannt werden, wenn es am Satzanfang (kein Leerzeichen davor) oder am Satzende (kein Leerzeichen danach) eingesetzt ist.</p> 
			<p><strong><span class="red">TIPP:</span></strong> Ein Spamwort kann in die entsprechende Liste mehrfach eingetragen und dadurch entsprechend höher gewichtet werden, weil es bei mehrfachem Eintrag ebenso oft als Spammerkmal gezählt wird.</p>
			<p>Beispiel: Wird das Wort &quot;sex&quot; zweimal in der Spamwortliste abgespeichert und ein Gästebuch-Eintrag enthält einmal das Wort &quot;Sex&quot;, werden dennoch sofort zwei &quot;Strafpunkte&quot; erfasst.</p>';
// IV.3.8.4. IP-Sperren nach Spameinträgen
		echo'
			<span id="anchor-ShowIpBar" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.8.4 IP-Sperren nach Spameinträgen</strong></p>
			<p>Wie oben schon vermerkt, werden die IPs, unter denen eine Spammer Ihr Gästebuch aufgesucht hat, in dieser Liste automatisch gespeichert, wenn der Spambeitrag derart dumm-dreist war, dass er vom Spamfilter sofort verworfen und eine Speicherung verhindert wurde. Dies ist im übrigen seit v.4.7.1 die einzige verbliebene Stelle im Programm, bei der eine IP im Klartext und nicht anonymisiert gespeichert wird. Alle hier erfassten IPs sind sodann gehindert, die Eintragsseite erneut aufzurufen.</p>
			<p>Die Spambots arbeiten jedoch meist mit dynamischen, d.h. wechselnden IPs. Die Sperre wirkt also nur eine begrenzte Zeit, bis der Robot über eine andere IP wiederkommt, weshalb es i.d.R keinen Sinn macht, die gesperrten IPs dauerhaft zu speichern, zumal mit einer zu langen Liste irgendwann die Performance leiden würde.</p>
			<p>Daher werden die IPs in der Sperrliste nach '.$delete_spamIps.' Tagen automatisch mit dem nächsten Aufruf der &quot;insert.php&quot; gelöscht.</p>
			<p>Falls eine IP zu Beweiszwecken länger gespeichert bleiben soll, ist dies möglich durch Anklicken des grünen Hakens hinter der betroffenen IP; der Haken wandelt sich dann als Zeichen der dauerhaften Sperre in ein rotes Kreuz. Erneutes Anklicken macht den Vorgang rückgängig.</p>
			<p>Selbstverständlich können Sie eine gesperrte IP aus der Liste auch durch markieren manuell wieder löschen.</p>
			<p>Schließlich kann das Gästebuch auch so konfiguriert werden, dass keinerlei IPs verarbeitet werden, auch keine IP, unter der ein Spameintrag erfolgte. Siehe hierzu oben <a href="#anchor-noIp">Abschnitt III.5.3.</a>.</p>';
// IV.3.9. Backup
		echo'
			<span id="anchor-Backup" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.9. Backup</strong></p>
			<p>Wer will schon gerne seine ganzen Gästebucheinträge durch einen Server Crash o.ä. verlieren?</p>
			<p>Um sich hiervor zu schützen, können Sie über diese Funktion BackUps erstellen sowie beschädigte oder gelöschte Beiträge aus einem solchen BackUp wieder herstellen.</p>
			<p><strong><span class="red">TIPP:</span> Es empfiehlt sich grundsätzlich, nach jedem neuen Eintrag im Gästebuch ein aktuelles BackUp anzufertigen.</strong></p>
			<p><strong>Wenn Sie die BackUps auf dem Server verwalten, also die Funktion: "BackUp nach dem Versand per E-Mail wieder vom Server löschen?" <span class="italic">nicht</span> aktiviert haben, wird Ihnen auf der zentralen Seite zur Verwaltung der "Einträge und Kommentare" eingangs ein Warnhinweis in Form des Icos: <img src="'.$url.'images/ausruf.png" height="14" width="14" alt="" /> angezeigt, falls das letzte BackUp älter ist als der letzte Gästebucheintrag. Klicken Sie einfach auf dieses Ico, um ein aktuelles BackUp zu erstellen.</strong></p>
			<p>Seit der v.4.5.4 wird mit der BackUp-Funktion des <span class="italic">myPHP Guestbook</span> neben dem Inhalt der Tabelle &quot;entries&quot; mit den Gästebucheinträgen auch der Inhalt der Tabelle &quot;pictures&quot; mit Dateinamen, Bildgrößen, Title-Bezeichnungen etc. von Fotouploads gesichert und im Bedarfsfall wieder hergestellt.</p>
			<p><strong>HINWEIS:</strong> Die in den Ordner &quot;img_guest&quot; hochgeladenen Dateien selbst können und werden auf diesem Weg selbstverständlich <strong>NICHT</strong> gesichert! Die in diesem Ordner abgelegten Fotos sollten in regelmäßigen Abständen per FTP heruntergeladen und zur Sicherheit noch einmal auf dem eigenen PC gespeichert werden.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Es kann generell zu Fehlern kommen, wenn eine Wiederherstellung aus einem BackUp erfolgen soll, das nicht mit der gleichen Gästebuch-Version erstellt wurde. Eine volle Kompabilität ist jedoch in der Regel gegeben zwischen den BackUps ab Version 3.0.0 bis Version 4.5.3, dann wieder ab Version 4.5.4 bis Version 4.5.6, ab Version 4.6.0 bis Version 4.6.3 und schließlich ab Version 4.7.0 aufwärts.</p>
			<p>Es wird zu Fehlern kommen, wenn Sie ein Backup unter einer Version &lt; 3.x erstellt haben und in einer Version &#8805; 3.x hieraus Beiträge ohne weitere Bearbeitung wieder herstellen möchten. In der Regel werden diese Probleme durch die Verwendung eines anderen Prefix verursacht: Bis v.2.0.5 wurde standardmäßig der Prefix "myphpgb" verwendet, ab Version 3.0.0 lautet der Prefix &quot;guestbook&quot;. Um dies zu lösen, müssen Sie in Ihrer Backup-Datei das Prefix mit einem guten Texteditor entsprechend ändern/ersetzen.</p>
			<p>Ab der Version 3.x wurden erstellte Backups mit dem Ausloggen aus dem Admin-Bereich automatisch wieder vom Server gelöscht, so dass das zuvor gefertigte Backup jeweils auf den eigenen Computer heruntergeladen und bei Bedarf von dort wieder hochgeladen werden musste. Eine der Folgen war, dass eine Verwaltung mit mobilen Endgeräten praktisch nicht möglich war.</p>
			<p>Seit Version 4.1 ist das wie folgt gelöst: Backup-Dateien bleiben jetzt im entsprechenden Backup-Ordner auf dem Server liegen, gegen unberechtigten Download oder unerwünschte Einsichtnahme geschützt mit einer entsprechenden htaccess-Datei (ist im Paket enthalten).</p>
			<p>BackUps bleiben bis zu einer Anzahl von 3 Stück bestehen, die älteren, über dieses Limit hinausgehenden BackUps werden automatisch gelöscht.</p>
			<p>Zur Wiederherstellung beschädigter oder verlorener Einträge im Gästebuch kann dann die gewünschte BackUp-Datei durch einen Klick bestimmt und direkt vom Server genutzt werden, was letztlich beinhaltet, dass dies auch von unterwegs geht und nicht nur Zuhause am heimischen Rechner. Als weitere Sicherheit wird zusätzlich eine Kopie des BackUps an den Admin per E-Mail verschickt.</p>
			<p>Die BackUps werden automatisch gezippt (wichtig besonders wegen dem E-Mail-Versand), Wiederherstellungen können unmittelbar aus der gezippten Datei erfolgen. Falls bei Ihrem Webspace das gzip-Modul nicht verfügbar sein sollte, (was gleichfalls automatisch geprüft wird), erstellt und verarbeitet das Programm jedoch auch ungezippte Versionen.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Wenn Ihr Website-Hoster die Nutzung von .htaccess-Dateien nicht zulassen sollte, so dass die auf dem Server liegenden BackUp-Dateien nicht vor dem Zugriff Dritter geschützt werden können, ist es möglich und wird für diesen Fall auch dringend empfohlen, die Speicherung der BackUps auf dem Server durch eine entsprechende Einstellung auf der Seite &quot;Allgemeine Konfiguration&quot; zu unterbinden; dann muss auf die per E-Mail verschickten BackUps im Notfall zurückgegriffen werden (und Sie sollten den Website-Hoster wechseln). - Die Voreinstellung nach der Installation dieser Version ist zunächst auf: &quot;BackUps auf dem Server speichern&quot;.</p>';
// IV.3.9.1. BackUps verwalten
		echo'
			<span id="anchor-BackUpEdit" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.9.1. BackUps verwalten und Einträge wiederherstellen</strong></p>
			<p>Das Wiederherstellen von Beiträgen aus einem von Ihnen hergestellten Backups geht kinderleicht:</p>
			<p>Wählen Sie aus der Backup-Liste das gewünschte Backup aus (sortiert nach Datum und Zeit) und klicken Sie auf den Button &quot;Wiederherstellen&quot;. <span class="italic">myPHP Guestbook</span> fügt dann die alten Gästebucheinträge und die alten Einträge aus der Tabelle &quot;_pictures&quot; wieder in die Datenbank ein.</p>
			<p>Falls Sie einmal eine ältere Ausfertigung eines BackUps nutzen wollen: Laden Sie die gewünschte BackUp-Datei per FTP in den Backup-Ordner auf den Server hoch. Rufen Sie die Seite "BackUp-Liste" im Admin-Control-Panel auf oder laden Sie die Seite neu. Den Dateinamen der neu in das BackUp-Verzeichnis geladenen Datei sehen Sie jetzt im entsprechenden DropDown-Menü: Auswählen und Dateinamen in die Backup-Liste abspeichern, um die Datei dann aufzurufen und zu verwenden.</p>
			<p class="zentriert"><strong>Achtung!</strong></p>
			<p>Alle im Zeitpunkt einer Wiederherstellung aus einem BackUp vorhandenen Einträge in den Tabellen &quot;_entries&quot; und &quot;_pictures&quot; werden gelöscht und mit den Daten aus der BackUp-Datei neu befüllt. Sollte das zur Wiederherstellung verwendete BackUp jedoch aus einer der vorherigen Gästebuch-Versionen &lt; 4.5.4 stammen, bleibt der Inhalt der Tabelle &quot;_pictures&quot; unverändert, wird also auch nicht gelöscht, da in den älteren BackUp-Dateien nichts ist, womit die Tabelle &quot;_pictures&quot; wieder befüllt werden könnte. Sie sollten also nach einem Update von einer Gästebuchversion &lt; 4.5.4 auf die Version 4.5.4 (oder höher) sofort ein neues BackUp erstellen, damit auch eine Sicherungsdatei der Tabelle &quot;_pictures&quot; vorhanden ist und notfalls verwendet werden kann.</p>';
// IV.3.9.2. Backup erstellen
		echo'
			<span id="anchor-MakeBackUp" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.9.2. Backup erstellen</strong></p>
			<p>Um eine aktuelle Sicherung der Datenbank-Tabellen mit Ihren Gästebucheinträgen und den Inhalten der Tabelle &quot;_pictures&quot; zu erstellen, müssen Sie nur diese Option aufrufen.</p>
			<p>Das Backup wird auf dem Sever gespeichert und eine gezippte Kopie wird Ihnen zusätzlich per E-Mail übermittelt, wie eingangs beschrieben.</p>';
// IV.3.10. Statistik
		echo'
			<span id="anchor-Statistik" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.10. Statistik</strong></p>
			<p>Damit Sie einen Überblick haben, wie häufig Ihr Gästebuch aufgerufen wurde, ist eine kleine Statistik in <span class="italic">myPHP Guestbook</span> eingebaut.</p>
			<p>Diese funktioniert, wie viele andere Features nur, wenn Sie die Statistik unter "Allgemeine Konfiguration" aktiviert haben. Die Grundeinstellung nach der Installation ist deaktiviert.</p>';
// IV.3.10.1. Statistik anzeigen
		echo'
			<span id="anchor-ShowStats" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.10.1. Statistik anzeigen</strong></p>
			<p>Hier sehen Sie die Anzahl der gesamten Besucher sowie der gesamten Aufrufe des Gästebuches und ob ein oder mehrere Besucher das Gästebuch zur Zeit aufgerufen haben. Weiter unten gibt es eine kleine genauere Statistik der letzten '.$recording_days.' Tage.</p>
			<p>Die aus Gründen des Datenschutzes notwendige Anonymisierung der IPs (s.o., Abschnitt III.5.2.) bringt es mit sich, dass die unter "Besucher" gelistete Anzahl eindeutiger Aufrufe des Gästebuchs von unterschiedlichen Adressen eine gewisse Fehlerquote aufweist, die sich nicht genau verifizieren lässt und von mir im oberen einstelligen Prozentbereich geschätzt wird. Auf die gezeigte Anzahl aller "Aufrufe", also der Gesamtzahl der angeklickten Seiten des Gästebuchs, hat dies keinen Einfluss.</p>
			<p>In der Zeile "Zur Zeit online" wird die Zahl der Besucher, die das Gästebuch in den jeweils letzten drei Minuten aufgerufen haben, angezeigt. Ihr eigener Aufruf des Gästebuchs wird hierbei nicht gezählt oder angezeigt.</p>';
// IV.3.10.2. Statistik löschen
		echo'
			<span id="anchor-DelStats" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.10.2. Statistik löschen</strong></p>
			<p>Ältere Einträge als die der letzten 15 Tage werden automatisch in der Datenbank gelöscht. Die Anzeige der Summen von Aufrufen und Besuchern bleibt davon unberührt.</p>
			<p>Wenn Sie jedoch auf den Link: &quot;Statistik löschen&quot; klicken, werden nicht nur die Statistik der letzten '.$recording_days.' Tage unwiderruflich gelöscht, sondern auch die Summen werden wieder auf Null gesetzt.</p>';
// IV.3.11. Update
		echo'
			<span id="anchor-update" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.11. Update prüfen</strong></p>
			<p>Wenn Sie diesen Link anklicken, wird geprüft, ob eine neuere Version des <span class="italic">myPHP Guestbook</span> zum Download bereitsteht als die, die Sie aktuell verwenden. Wenn ja, erhalten Sie einen entsprechenden Hinweis zum Update und einen Link als Angebot zum Download der aktuellen Programm-Version. Wenn nein, erfolgt der Hinweis, dass Sie die aktuelle Version nutzen.</p>
			<p>Es erfolgt <strong>kein</strong> automatischer Download und erst recht <strong>keine</strong> automatische Installation eines Updates.</p>';
// IV.3.12. Hilfe
		echo'
			<span id="anchor-Hilfe" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.12. Hilfe</strong></p>
			<p>Diese Seite.</p>';
// IV.3.13. Logout
		echo'
			<span id="anchor-Logout" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3.13. Logout</strong></p>
			<p>Nach Abschluss der Arbeiten im Admin-Bereich das Ausloggen nicht vergessen. Links zum Logout befinden in der Kopfzeile des Admin-Panels oben rechts und am Ende der Navigation links unten.</p>
			<p>Nach spätestens 30 Minuten Inaktivität im Admin-Control-Panel wird aus Sicherheitsgründen die Session für den Aufenthalt im Admin-Bereich zerstört, was einem "Zwangs-Logout" gleichkommt. Die Zeit bis zum Ende der Session wird als Countdown in der Kopfzeile oben rechts angezeigt.</p>';
// IV.4. Diagnose- und Reparatur-Tool
		echo'
			<span id="anchor-Repair" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />4. Diagnose- und Reparatur-Tool:<br />(Datenbanktabellen oder Konfigurationsdatei wiederherstellen)</strong></p>
			<p>Es kommt immer mal wieder vor, dass einzelne Datenbanktabellen verändert wurden, z.B. indem vorinstallierte Templates oder CSS-Styles irrtümlich gelöscht oder vom User verändert wurden o.ä. und später der Wunsch entsteht, diese wieder in den Original-Zustand zurückzuversetzen.</p>
			<p>Um eine komplette Neuinstallation entbehrlich zu machen, kann für diese Fälle unter <a href="https://www.php-guestbook.de/repair.php" title="Link öffnet ein neues Fenster" rel="external">www.php-guestbook.de/repair.php</a> ein "Reparatur-Tool" heruntergeladen werden. Damit ist es problemlos möglich, gezielt ausgewählte, beliebige Datenbank-Tabellen des <span class="italic">myPHP Guestbook</span> wieder in den Zustand und mit den Inhalten wie nach der Installation herzustellen.</p>
			<p>Weiterhin kann mit diesem Tool auch die Konfigurations-Datei ("config.inc.php") neu geschrieben werden oder es können Verbindungsprobleme zur Datenbank untersucht werden.</p>
			<p>Falls die Datei "config.inc.php" neu geschrieben werden soll, denken Sie daran, der Datei bei Bedarf wieder die entsprechenden CHMOD-Schreibrechte zu geben (siehe oben Abschnitt III.4. am Ende unter lit. c.).</p>';
// V. Sonstiges			
		echo'
			<span id="anchor-lang" class="sticky-anchor"></span>
			<h2><br />V. Sonstiges</h2>';
// V.1. Sprachen			
		echo'
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />1. Sprachen:</strong></p>
			<p>Damit <span class="italic">myPHP Guestbook</span> nicht nur auf deutschsprachigen Webseiten zum Einsatz kommt, wurden ab Version 2.0.0 Sprachdateien eingebaut.</p>
			<p>Ich bin stets auf der Suche nach Übersetzern, um <span class="italic">myPHP Guestbook</span> in weitere Sprachen zu übersetzen. Wer Lust, Zeit und entsprechende Fremdsprachenkenntnisse hat, bitte bei mir melden: <a href="mailto:post@php-guestbook.de">post@php-guestbook.de</a>.</p>';
// V.2. Credits + V.2.1. Hauptentwickler			
		echo'
			<span id="anchor-Credits" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />2. Credits</strong></p>
			<p>Nachfolgend -soweit bekannt- einige Personen, die bei der Entwicklung von <span class="italic">myPHP Guestbook</span> eine größere Rolle gespielt haben.</p>
			<p class="text-shadow"><strong><br />2.1 Hauptentwickler</strong></p>
			<p>Claudio Pose (Schweiz) - Der ursprüngliche Quellcode von <span class="italic">myPHP Guestbook</span> wurde von Claudio Pose geschrieben.</p>
			<p>Einzelne Teile des Codes wurden von anderen Projekten eingebaut, welche aber im Vergleich zum ganzen Script eine untergeordnete Rolle spielen.</p>
			<p>Da Claudio Pose ca. in 2006 den Support und die Webseite eingestellt hat, das <span class="italic">myPHP Guestbook</span> jedoch sehr beliebt ist und daher weiterentwickelt werden sollte, wurde von Christian Thomas, www.hostonline.de, auf Basis der letzten Version 2.0.5 die Version 3.0.0 geschaffen.</p>
			<p>2012 wurde dort die Version 3.2.0, Ende Oktober 2014 die Version 3.2.1 zum Download bereitgestellt, danach gab Herr Christian Thomas die Weiterentwicklung des Scripts zugunsten der vorliegenden Versionen 4.x auf.</p>
			<p>Spätestens mit der Einstellung der Bereitstellung von Bugfixes für PHP 5.3 im August 2014 und der gleichzeitigen Bereitstellung von PHP 5.6 wurde es notwendig, den erneut in die Jahre gekommenen PHP-Code für das Handling der Datenbankanbindung umfassend zu überarbeiten.</p>
			<p>Hierzu wurde die im Dezember 2012 von Christian Thomas erstellte Version 3.2.0 bei erneut teilweiser Verwendung des Originalcodes, jedoch mit Umstellung der Datenbankanbindung auf MySqli von Wolfgang Leverberg <a href="https://www.php-guestbook.de" title="Link öffnet ein neues Fenster" rel="external">www.php-guestbook.de</a> umgeschrieben und ab 03.10.2014 zum Download eingestellt.</p>';
// V.2.2. Übersetzer			
		echo'
			<p class="text-shadow"><strong><br />2.2. Übersetzer</strong></p>
			<ul>
				<li>Niederländisch:
				<ul>
					<li>Marco Hopster (Niederlande)
					<li style="list-style-type:none">marco@mhopster.nl
					<li>Pierre Linssen (Niederlande)
					<li style="list-style-type:none">linski@mirpir.eu
				</ul>
				<li>Portugiesisch:
				<ul>
					<li>Harry Tartsch (Deutschland)
					<li style="list-style-type:none">tartsch@arcor.de
				</ul>
				<li>Slowakisch und Tschechisch:
				<ul>
					<li>Peter Schoeller (Deutschland)
					<li style="list-style-type:none">schoeller.peter@gmail.com
				</ul>
				<li>Polnisch:
				<ul>
					<li>Peter Renka (Deutschland)
					<li style="list-style-type:none">petren@freenet.de
				</ul>
				<li>Französisch und Italienisch:
				<ul>
					<li>Valentina Panciroli (Italien)
					<li style="list-style-type:none">&lt;netperla.com&gt;
				</ul>
				<li>Schwedisch:
				<ul>
					<li>Anders Rundkvist (Schweden)
				</ul>
			</ul>';
// V.2.3. Sonstige Entwickler oder Mithelfer			
		echo'
			<p class="text-shadow"><strong><br />2.3. Sonstige Entwickler oder Mithelfer</strong></p>
			<p>Egal ob Programmierer, Bug-Reporter oder Grafiker, bei der Erstellung von <span class="italic">myPHP Guestbook</span> haben viele weitere Personen mitgeholfen, wie z.B.:</p>
			<ul>
				<li>David Vignoni (Italien)
				<li style="list-style-type:none">dave@icon-king.com
			</ul>
			<ul>
				<li>Turthra Leinir (Dänemark)
				<li style="list-style-type:none">leinir2002@hotmail.com
			</ul>
			<ul>
				<li>Felix Maduakor (Deutschland)
				<li style="list-style-type:none">felix.maduakor@rub.de
			</ul>
			<hr style="width:75%;" />
			<p>Teile der Datei-Upload Funktionen stammen mit freundlicher Genehmigung von:</p>
			<ul>
				<li>ISP Image Upload und Resize PHP Programm
				<li style="list-style-type:none">© Joachim Patten (ISP), 2013
				<li style="list-style-type:none">isp_image_resize Ver.1.5 : Version vom 08.02.2013
				<li style="list-style-type:none">Copyright Joachim Patten (ISP)
				<li style="list-style-type:none">URL: &lt;www.neusser-marktplatz.de&gt;
			</ul>
			<hr style="width:75%;" />
			<p>Teile des Spamfilters stammen von:</p>
			<ul>
				<li>&lt;www.naturfotografie-digital.de/impressum/impressum.php&gt;
			</ul>
			<hr style="width:75%;" />
			<p>Die Funktion &quot;shortWords&quot; (Originalbezeichnung &quot;MakeBreakable&quot;) stammt von:</p>
			<ul>
				<li>Herrn Werner Rumpeltesz, &lt;www.gaijin.at&gt;
				<li style="list-style-type:none;margin-top:8px;">modifiziert für die Nutzung unter den Anforderungen des <span class="italic">myPHP Guestbook</span>
			</ul>
			<hr style="width:75%;" />
			<p>Die Javaskripte zum "Sticky-Header", zum "Countdown" und zur "Passwort Validierung" basieren auf Beispielen von:</p>
			<ul>
				<li>&lt;www.w3schools.com&gt;
			</ul>
			<hr style="width:75%;" />
			<p>Das Regex für die E-Mail Validierung stammt von:</p>
			<ul>
				<li>&lt;https://emailregex.com&gt;
				<li style="list-style-type:none;margin-top:8px;">modifiziert für die Nutzung unter den Anforderungen des <span class="italic">myPHP Guestbook</span>
			</ul>
			<p>... und das Regex für die Validierung von URLs von:
			<ul>
				<li>&lt;http://urlregex.com&gt;
			</ul>
			<hr style="width:75%;" />';
// V.3. Copyright, Lizenz		
		echo'
			<span id="anchor-Copyright" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />3. Copyright, Lizenz</strong></p>
			<ul>
				<li><span class="italic">myPHP Guestbook</span> v. 2.0.5 Copyright © 2003 - 2006 Claudio Pose,
				<li style="list-style-type:none"><span class="italic">myPHP Guestbook</span> v. 2.0.5 was an open source project of Networkarea.ch
				<li><span class="italic">myPHP Guestbook</span> v. 3.2.1 Copyright © 2011 - 2014
				<li style="list-style-type:none">Christian Thomas, &lt;www.hostonline.de&gt;
				<li><span class="italic">myPHP Guestbook</span> '.$version.' Copyright © 2014 - 2022
				<li style="list-style-type:none">Wolfgang Leverberg, <a href="https://www.php-guestbook.de" title="Link öffnet ein neues Fenster" rel="external">www.php-guestbook.de</a>
			</ul>
			<p><span class="italic">myPHP Guestbook</span> is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.</p>
			<p><span class="italic">myPHP Guestbook</span> is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.</p>
			<p>You should have received a copy of the GNU General Public License along with this program. - If not, see &lt;www.gnu.org/licenses&gt;</p>
			<hr style="width:75%;" />
			<p><span class="italic">myPHP Guestbook</span> ist freie Software; Sie können es unter den Bedingungen der GNU General Public License, wie von der Free Software Foundation veröffentlicht, Version 3 der Lizenz oder (nach Ihrer Wahl) jeder neueren veröffentlichten Version, weiterverbreiten und/oder modifizieren.</p>
			<p><span class="italic">myPHP Guestbook</span> wird in der Hoffnung, dass es nützlich sein wird, aber OHNE JEDE GEWÄHRLEISTUNG, bereitgestellt; auch ohne die implizite Gewährleistung der MARKTFÄHIGKEIT oder EIGNUNG FÜR EINEN BESTIMMTEN ZWECK. Siehe die GNU General Public License für weitere Details.</p>
			<p>Sie sollten eine Kopie der GNU General Public License zusammen mit myPHP Guestbook erhalten. - Wenn nicht, siehe &lt;www.gnu.org/licenses&gt;.</p>';
// V.4. Version History	
		echo'
			<span id="anchor-History" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Inhaltsverzeichnis">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />4. Version History</strong></p>
			<ul class="text-left">
				<li>1.0.6 Final 13.03.2004 <span class="nowrap marg-leVers">Claudio Pose</span>
				<li>1.1.0 Final 17.03.2004
				<li>1.2.0 Final 25.03.2004
				<li>1.3.3 Final 07.04.2004
				<li>1.4.2 Final 14.04.2004
				<li>1.5.1 Final 06.05.2004
				<li>1.6.2 Final 10.06.2004
				<li>1.7.1 Final 02.08.2004
				<li>1.8.3 Final 20.08.2004
				<li>1.9.1 Final 18.09.2004
				<li>1.9.2 Final 16.10.2004
				<li>2.0.0 Final 06.04.2005
				<li>2.0.1 Final 10.04.2006
				<li>2.0.2 Final 29.04.2006
				<li>2.0.3 Final 06.05.2006
				<li>2.0.4 Final 06.05.2006
				<li>2.0.5 Final 30.06.2006
				<li>3.0.0 Final 24.09.2011 <span class="nowrap marg-leVers">Christian Thomas</span>
				<li>3.0.1 Final 12.02.2012
				<li>3.1.0 Final 15.04.2012
				<li>3.2.0 Final 21.12.2012
				<li>3.2.1 Final 25.10.2014
				<li>4.0.0 Final 10.03.2014 <span class="nowrap marg-leVers">Wolfgang Leverberg</span>
				<li>4.1.0 Final 01.04.2014
				<li>4.2.0 Final 03.10.2014
				<li>4.2.1 Final 28.10.2014
				<li>4.2.2 Final 02.11.2014
				<li>4.2.3 Final 16.11.2014
				<li>4.3.0 Final 28.11.2014
				<li>4.3.1 Final 13.12.2014
				<li>4.3.2 Final 02.01.2015
				<li>4.4.0 Final 21.02.2015
				<li>4.4.1 Final 07.03.2015
				<li>4.4.2 Final 20.03.2015
				<li>4.5.0 Final 01.05.2015
				<li>4.5.1 Final 20.06.2015
				<li>4.5.2 Final 26.06.2015
				<li>4.5.3 Final 18.07.2015
				<li>4.5.4 Final 04.09.2015
				<li>4.5.5 Final 03.10.2015
				<li>4.5.6 Final 02.01.2016
				<li>4.6.0 Final 06.02.2016
				<li>4.6.1 Final 01.05.2016
				<li>4.6.2 Final 03.07.2016
				<li>4.6.3 Final 08.10.2016
				<li>4.7.0 Final 06.01.2017
				<li>4.7.1 Final 04.03.2017
				<li>4.7.2 Final 18.03.2017
				<li>4.7.3 Final 13.05.2017
				<li>4.7.4 Final 15.07.2017
				<li>4.7.5 Final 02.09.2017
				<li>4.8.0 Final 01.01.2018
				<li>4.8.1 Final 12.02.2018
				<li>4.9.0 Final 10.05.2018
				<li>4.9.1 Final 08.07.2018
				<li>4.9.2 Final 03.11.2018
				<li>4.9.3 Final 02.01.2019
				<li>4.10.0 Final 04.03.2019
				<li>4.10.1 Final 17.03.2019
				<li>4.10.2 Final 13.04.2019
				<li>4.10.3 Final 01.09.2019
				<li>4.10.4 Final 04.01.2020
				<li>4.10.5 Final 01.01.2021
				<li>4.10.6 Final 03.03.2021
				<li>4.10.7 Final 01.05.2021
				<li>4.10.8 Final 08.09.2021
				<li>4.10.9 Final 02.01.2022
			</ul>';
// V.5. Kontakt			
		echo'
			<span id="anchor-Kontakt" class="sticky-anchor"></span>
			<div class="top"><a href="'.$toTop.'" title="Zum Seitenanfang">&Lambda;</a></div>
			<p class="text-shadow"><strong><br />5. Kontakt</strong></p>
			<p><span class="italic">myPHP Guestbook</span> war ein Projekt von Claudio Pose - Networkarea.ch.</p>
			<p>Die Versionen 3.x wurden entwickelt von Christian Thomas, Kuhstr.8, 45701 Herten-Westerholt - www.hostonline.de - admin@westerhost.de.</p>
			<p>Die Versionen 4.x wurden geschrieben von Wolfgang Leverberg, Auf\'m Heidchen 6, D-42855 Remscheid<br /><a href="https://www.php-guestbook.de" title="Link öffnet ein neues Fenster" rel="external">www.php-guestbook.de</a> - <a href="mailto:post@php-guestbook.de">post@php-guestbook.de</a></p>
			<p>&nbsp;</p>
			<p class="italic text-right">Remscheid (Deutschland), im Januar 2022</p>';
	}
    
?>