<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	29.03.2022
*/

	if (!isset($_SESSION['sid']) && !isset($_SESSION['modsid'])) {
		header("Location: admin.php?action=login");
		die();
	}
	else {
		echo "
			<div class=\"content-02\">";

		if ($_GET['show'] == "make_backup")	{
			$timestamp	= time();
			$date		= GB_DATE;

			$backup_version = 'gbv7-backup';  // If necessary, change line 295 accordingly !!
			mt_srand(makeRandomName());
			$random = mt_rand();
			$random = substr($random, 0, 10);

			$select_backup_query = $gbook->query("SELECT `clean_backup`, `admin_email` FROM `".$table."_properties`");
			$backup_options 	 = $select_backup_query->fetch_assoc();
			$empfaenger 		 = $backup_options['admin_email'];
			$clean_backup 		 = $backup_options['clean_backup'];
			$title				 = 'myPHP Guestbook '.$version.'';;

			(!extension_loaded("zlib")) ? $compr = 0  :  $compr = 1 ;
			($compr == 1) ? $filetype = "sql.gz" : $filetype = "sql";

			@set_time_limit(0);

			$file_exist = "../backup/".$backup_version."_".$random.".".$filetype."";

			if (file_exists($file_exist)) {
				unlink("../backup/".$backup_version."_".$random.".".$filetype."");
			}

			$i 					= 0;
			$entriefields[$i]	= array();
			$picturefields[$i]	= array();
			$time				= date("H:i:s", $timestamp);
			$uhr				= date("H:i", $timestamp);
			$mysqlversion_sql 	= $gbook->query("SELECT VERSION()");
			$mysqlversion		= $mysqlversion_sql->fetch_row();
			$phpversion			= phpversion();
			$insert[$i]			= "\n# -------------------------------------------\n# ".$title." SQL Dump\n# ".$date." ".$time."\n# PHP Version: ".$phpversion."\n# MySQL Version: ".$mysqlversion[0]."\n# Table: ".$table."_entries\n# Table: ".$table."_pictures\n# -------------------------------------------\n#\n\n";
			$entries_query		= $gbook->query("SHOW COLUMNS FROM `".$table."_entries`");
			$picture_query		= $gbook->query("SHOW COLUMNS FROM `".$table."_pictures`");
			$one[$i]			= "";
			$two[$i]			= "";
			$three[$i]			= "";
			$four[$i]			= "";
			$x					= 0;
			$xx					= 0;

			while ($entries_data = $entries_query->fetch_row()) {
				if ($x < $entries_query->num_rows - 1) {
					$one[$i] .= $entries_data[0].", ";
				}
				else {
					$one[$i] .= $entries_data[0];
				}

				array_push($entriefields[$i], $entries_data[0]);
				$x++;
			}

			$insert_entries_query = $gbook->query("SELECT `comment`, `date`, `email`, `homepage`, `icq`, `id`, `ip`, `status`, `name`, `activation_code`, `text`, `time`, `origin`, `marker`, `stars`, `check_time` FROM `".$table."_entries`");

			while ($insert_entries_data = $insert_entries_query->fetch_assoc()) {
				for ($t=0;$t<count($entriefields[$i]);$t++) {
					if ($t < count($entriefields[$i])-1) {
						if ($entriefields[$i][$t] == "activation_code") {
							$two[$i] .= "'', ";
						}
						elseif ($entriefields[$i][$t] == "ip") {
							$two[$i] .= "'', ";
						}
						else {
							$two[$i] .= "'".prepare_backup($insert_entries_data[$entriefields[$i][$t]])."', ";
						}
					}
					else {
						if ($entriefields[$i][$t] == "activation_code") {
							$two[$i] .= "'', ";
						}
						elseif ($entriefields[$i][$t] == "ip") {
							$two[$i] .= "'', ";
						}
						else {
							$two[$i] .= "'".prepare_backup($insert_entries_data[$entriefields[$i][$t]])."'";
						}
					}
				}

				$insert[$i] .= "INSERT INTO `".$table."_entries` (".$one[$i].") VALUES (".$two[$i].");\n";
				$two[$i] = "";
			}

			while ($picture_data = $picture_query->fetch_row()) {
				if ($xx < $picture_query->num_rows - 1) {
					$three[$i] .= $picture_data[0].", ";
				}
				else {
					$three[$i] .= $picture_data[0];
				}

				array_push($picturefields[$i], $picture_data[0]);
				$xx++;
			}

			$insert_picture_query = $gbook->query("SELECT `id`, `ip`, `pic_name`, `width`, `height`, `title`, `date`, `time` FROM `".$table."_pictures`");

			while ($insert_picture_data = $insert_picture_query->fetch_assoc()) {
				for ($tt=0;$tt<count($picturefields[$i]);$tt++)	{
					if ($tt < count($picturefields[$i])-1) {
						if ($picturefields[$i][$tt] == "ip") {
							$four[$i] .= "'', ";
						}
						else {
							$four[$i] .= "'".prepare_backup($insert_picture_data[$picturefields[$i][$tt]])."', ";
						}
					}
					else {
						if ($picturefields[$i][$tt] == "ip") {
							$four[$i] .= "'', ";
						}
						else {
							$four[$i] .= "'".prepare_backup($insert_picture_data[$picturefields[$i][$tt]])."'";
						}
					}
				}
				$insert[$i] .= "INSERT INTO `".$table."_pictures` (".$three[$i].") VALUES (".$four[$i].");\n";
				$four[$i] = "";
			}

			$dump_buffer = $insert[$i];

			if ($compr == 1) {
				$open_backup  = gzopen("../backup/".$backup_version."_".$random.".".$filetype."","w9");
				$write_backup = gzwrite($open_backup,$dump_buffer);
				gzclose ($open_backup);
			}
			else {
				$open_backup  = fopen("../backup/".$backup_version."_".$random.".".$filetype."","w");
				$write_backup = fputs($open_backup,$dump_buffer);
				fclose ($open_backup);
			}

			if ($write_backup) {
				$last_entry = $gbook->query("SELECT `id`, `check_time` FROM `".$table."_entries` WHERE `id` = (SELECT max(id) FROM `".$table."_entries`)");

				if ($last_entry != "") {
					list($checkId,$checkTime) = $last_entry->fetch_row();

					if (empty($checkTime)) {
						$newCheckTime = time()-1;

						$gbook->query("UPDATE `" . $table . "_entries` SET `check_time` = '".$newCheckTime."' WHERE `id` = '".$checkId."'");
					}
				}

				$gbook->query("INSERT INTO `".$table."_backup` (`dateiname`,`datum`,`uhrzeit`,`backup_time`) VALUES ('".$backup_version."_".$random.".".$filetype."','".$date."','".$uhr."','".time()."')");

				$pfad = "../backup/".$backup_version."_".$random.".".$filetype.""; 

				if (file_exists($pfad))	{
					$sql_noreply = $gbook->query("SELECT `noreply` FROM `".$table."_thankyou` WHERE `lang` = '".$lang_short."'");
					list($emailFrom) = $sql_noreply->fetch_row();						

					(!empty($emailFrom)) ? ($emailAbs = $emailFrom) : ($emailAbs = $mail_abs);

					$anhang = array(); 
					$anhang["name"] = basename($pfad); 
					$anhang["size"] = filesize($pfad); 
					$anhang["data"] = implode("",file($pfad)); 
					$message		= $amsg[65];
					$betreff 		= "BackUp myPHP-Guestbook - ".$_SERVER['SERVER_NAME']."\n";

					(function_exists("mime_content_type")) ? $anhang["type"] = mime_content_type($pfad) : $anhang["type"] = "application/octet-stream";

					function mail_anhang($empfaenger,$betreff,$message,$anhang) { 
						global $emailAbs;

						$data = chunk_split(base64_encode($anhang['data'])); 
						$boundary = md5(uniqid(time()));

						$header = "From: ".$emailAbs."\n";
						$header.= "MIME-Version: 1.0\n";
						$header.= "Content-Type: multipart/mixed;\n";
						$header.= " boundary=\"".$boundary."\"\r\n"; 

						$content = "This is a multi-part message in MIME format -- Dies ist eine mehrteilige Nachricht im MIME-Format.\r\n\r\n"; 
						$content.= "--".$boundary."\r\n"; 
						$content.= "Content-Type: text/html; charset=utf-8\r\n";
						$content.= "Content-Transfer-Encoding: 8bit\r\n\r\n"; 
						$content.= $message."\r\n"; 
						$content.= "--".$boundary."\r\n"; 
						$content.= "Content-Disposition: attachment;\r\n"; 
						$content.= "\tfilename=\"".$anhang['name']."\";\r\n"; 
						$content.= "Content-Length: ".$anhang['size'].";\r\n"; 
						$content.= "Content-Type: ".$anhang['type']."; name=\"".$anhang['name']."\"\r\n"; 
						$content.= "Content-Transfer-Encoding: base64\r\n\r\n"; 
						$content.= $data."\r\n"; 

						if(@mail($empfaenger, $betreff, $content, $header)) return true; 
						
						else return false; 
					} 

					mail_anhang($empfaenger, $betreff, $message, $anhang); 
				}

                echo "
					<fieldset>
						<legend><strong>".$amsg[66]."</strong></legend>
						<br /><br />   
						<p class=\"zentriert\">".$amsg[67]."</p>";

						if ($clean_backup == 1)	{
							$ordner = "../backup";
							$all_backups = scandir($ordner);

							foreach ($all_backups as $single_backup) {
								if ($single_backup != "." && $single_backup != ".." && $single_backup != ".htaccess" && $single_backup != "index.php") {
									unlink("../backup/".$single_backup."");
									$gbook->query("TRUNCATE TABLE `".$table."_backup`");
								}
							}

							echo"<p class=\"zentriert\">".$amsg[80]."</p>";
						}
						else {
							echo"<p class=\"zentriert\">".$amsg[68]."</p>";
						}

						if (showPic) {
							echo"<p class=\"zentriert\"><strong>".$amsg[282]."</strong></p>";
						}

					echo"
						<form method=\"post\" action=\"".$url."admin/admin.php?action=backup&#38;show=restore_backup&#38;".session_name()."=".session_id()."\">
							<table class=\"main-table-02 tb-pad0\" style=\"max-width:450px;\">
								<tr>
									<td>
										<p>&nbsp;</p>
										<p class=\"aligncenter\"><input type=\"button\" class=\"button\" name=\"zurueck\" value=\"".$fmsg[4]."\" onclick=\"window.history.go(-1); return false;\" /></p>
									</td>
								</tr>
							</table>
						</form>
					</fieldset>";
			}
			else {
				echo "
					<div class=\"aligncenter\">
						<p class=\"error\">".$emsg[4]."</p>
						<form method=\"post\" action=\"".$url."admin/admin.php?action=backup&#38;show=restore_backup&#38;".session_name()."=".session_id()."\">
							<table class=\"main-table-02 tb-pad0\" style=\"max-width:450px;\">
								<tr>
									<td>
										<p>&nbsp;</p>
										<p class=\"aligncenter\"><input type=\"button\" class=\"button\" name=\"zurueck\" value=\"".$fmsg[4]."\" onclick=\"window.history.go(-1); return false;\" /></p>
									</td>
								</tr>
							</table>
						</form>
					</div>";
			}
		}
		elseif ($_GET['show'] == "restore_backup") {
			$old_backup_vers01	 = 'gbv3-backup';
			$old_backup_vers02	 = 'gbv4-backup';
			$old_backup_vers03	 = 'gbv5-backup';
			$old_backup_vers04	 = 'gbv6-backup';
			$backup_version 	 = 'gbv7-backup';  // If necessary, also change line 35 accordingly; note line 330 !!
			$select_backup_query = $gbook->query("SELECT `clean_backup` FROM `".$table."_properties`");
			$backup_options 	 = $select_backup_query->fetch_assoc();
			$clean_backup 		 = $backup_options['clean_backup'];
			$info 				 = "";
			$info_02 			 = "";
			$edit_date = $backuptime = "";

			(!extension_loaded("zlib")) ? $compr = 0  :  $compr = 1 ;

			if (isset($_POST['send']) && isset($_POST['entry_id']))	{
				$y = count($_POST['entry_id']);

				if ($y > 1)	{
					$info_02 = "<p class=\"error\">".$emsg[46]."</p>";
				}
				else {
					for ($x=0;$x<$y;$x++) {
						$entry_id = $_POST['entry_id'][$x];

						$select_dateiname_query = $gbook->query("SELECT  `dateiname`  FROM  `".$table."_backup`  WHERE  id = '$entry_id'");
						$select_dateiname 		= $select_dateiname_query->fetch_assoc();

						if (isset($_POST['send'])) {
							@set_time_limit(0);

							$file_exist = "../backup/".$select_dateiname['dateiname']."";

							if (file_exists($file_exist)) {
								$gbbuv  = explode('_', $select_dateiname['dateiname']);
								$backup_vers = $gbbuv[0];

								$gbook->query("TRUNCATE TABLE ".$table."_entries");

								//Delete the existing contents of the "_pictures" table, if BackUp was created with a guestbook version 4.5.4 or higher
								if (($backup_vers === $backup_version) || ($backup_vers === $old_backup_vers01) || ($backup_vers === $old_backup_vers02) || ($backup_vers === $old_backup_vers03) || ($backup_vers === $old_backup_vers04)) {
									$gbook->query("TRUNCATE TABLE ".$table."_pictures");
								}

								$file_ext = explode(".", $select_dateiname['dateiname']);
								$file_ext[2] = isset($file_ext[2]) ? $file_ext[2] : '';
								$file_ext[4] = isset($file_ext[4]) ? $file_ext[4] : '';

								if ($compr == 1 AND ($file_ext[2] == "gz" || $file_ext[4] == "gz"))	{
									$fd = gzopen ("../backup/".$select_dateiname['dateiname']."", "r");
									$query = "";
									$error = 0;

									while (!feof($fd)) {
										$line = fgets($fd, 4096);
										$line = chop($line);

										if (!preg_match("/^#/", $line))	{
											$query .= $line;

											if ((preg_match("/;\n?$/",$line) OR feof($fd)) AND $query != "") {
												if (!$gbook->query($query))	{
													$error++;
												}
											
												$query = "";
											}
										}
									}

									gzclose ($fd);
								}
								else {
									$fd = fopen ("../backup/".$select_dateiname['dateiname']."", "r");
									$query = "";
									$error = 0;

									while (!feof($fd)) {
										$line = fgets($fd, 4096);
										$line = chop($line);

										if (!preg_match("/^#/", $line))	{
											$query .= $line;

											if ((preg_match("/;\n?$/",$line) OR feof($fd)) AND $query != "") {
												if (!$gbook->query($query))	{
													$error++;
												}

												$query = "";
											}
										}
									}

									fclose ($fd);
								}

								if ($error > 0)	{
									$info_02 = "<p class=\"error\">".$fmsg[148].".</p><br />";
								}
								else {
									$info_02 = "<p class=\"zentriert green\"><strong>- ".$fmsg[149]."</strong></p><br />";
								}

								if ($clean_backup == 1)	{
									$ordner = "../backup";
									$all_backups = scandir($ordner);

									foreach ($all_backups as $single_backup) {
										if ($single_backup != "." && $single_backup != ".." && $single_backup != ".htaccess" && $single_backup != "index.php") {
											unlink("../backup/".$single_backup."");

											$gbook->query("TRUNCATE TABLE `".$table."_backup`");
										}
									}

									echo"<p class=\"zentriert\">".$amsg[83]."</p><br />";
								}
							}
							else {
								$info_02 = "<p class=\"error\">".$emsg[6]."</p><br />";
							}
						}
					}
				}
			}
			elseif (isset($_POST['send']) && !isset($_POST['entry_id'])) {
				$info = "<p class=\"error\">".$emsg[45]."</p><br />";
			}

			$backup_delete = 3;

			$sql_count_backup = $gbook->query("SELECT `id` FROM `".$table."_backup`");
			$count_backup = $sql_count_backup->num_rows;

			while($count_backup > $backup_delete) {
				$del_backup_query	= $gbook->query("SELECT  `dateiname`  FROM  `".$table."_backup` WHERE `id` = (SELECT min(id) FROM `".$table."_backup`)");
				$del_backup			= $del_backup_query->fetch_assoc();
				$datei_del			= $del_backup['dateiname'];

				unlink("../backup/".$datei_del."");
				$gbook->query("DELETE FROM `".$table."_backup` WHERE `dateiname` = '$datei_del'");

				$count_backup--;
			}

            echo "
				<fieldset>
					<legend><strong>".$amsg[69]."</strong></legend><br/>
					<script>function backup_upload() {return confirm('".$emsg[47]."');}</script>
					<form method=\"post\" action=\"".$url."admin/admin.php?action=backup&#38;show=restore_backup&#38;".session_name()."=".session_id()."\">";

					if (!$count_backup)	{
						echo"
							<p class=\"error\">".$amsg[87]."</p>
							";
					}
					else {
						echo"$info $info_02
							<p class=\"text-center\"><strong>".$amsg[70]."</strong></p>
							<div class=\"showBackups\">";

								$sql_backuplist = $gbook->query("SELECT * FROM `".$table."_backup` ORDER BY `id` DESC");

								while ($backuplist = $sql_backuplist->fetch_assoc()) {
									if ($dateFormat !== "us" && $dateFormat !== "sv") {
										if (preg_match("/^(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])-[0-9]{4}$/",$backuplist['datum'])) {
											$edit_date = date("d.m.Y", $backuplist['backup_time']);
										}
										else {
											$edit_date = $backuplist['datum'];
										}

										$backuptime = $backuplist['uhrzeit'];
									}
									elseif ($dateFormat === "sv") {
										if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/",$backuplist['datum'])) {
											$edit_date = date("Y-m-d", $backuplist['backup_time']);
										}
										else {
											$edit_date = $backuplist['datum'];
										}

										$backuptime = $backuplist['uhrzeit'];
									}
									else {
										if (preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1]).(0[1-9]|1[0-2]).[0-9]{4}$/",$backuplist['datum'])) {
											$edit_date = date("m-d-Y", $backuplist['backup_time']);
										}
										else {
											$edit_date = $backuplist['datum'];
										}
										if (preg_match("/^(0[0-9]|1[0-9]|2[0-3]):(0[0-9]|[1-5][0-9])$/",$backuplist['uhrzeit'])) {
											$backuptime = date("h:i A", $backuplist['backup_time']);
										}
										else {
											$backuptime = $backuplist['uhrzeit'];
										}
									}

									echo"
										<div class=\"showBackups-le\">".$amsg[71]."</div>
										<div>".$backuplist['dateiname']."</div>
										<div class=\"break\"></div>
										<div class=\"showBackups-le\">".$amsg[55]."</div>
										<div>".$edit_date."</div>
										<div class=\"break\"></div>
										<div class=\"showBackups-le\">".$amsg[56]."</div>
										<div>".$backuptime."</div>
										<div class=\"break\"></div>
										<div class=\"showBackups-le\">".$amsg[229]."</div>
										<div><label class=\"container\" style=\"display:inline-block;top:-14px;\"><input class=\"checkboxloeschen\" type=\"checkbox\" name=\"entry_id[]\" value=\"".$backuplist['id']."\" /><span class=\"checkmark-02\"></span></label></div>
										<div class=\"break\"></div>
										<hr />";
								}

						echo"
							</div>
							<p>&nbsp;</p>
							".$amsg[74]."
							<p>&nbsp;</p>
							<p class=\"aligncenter\"><input type=\"submit\" class=\"button\" name=\"send\" value=\"".$amsg[73]."\" /></p>
							<p>&nbsp;</p>
							<hr style=\"max-width:500px;\" />";
					}

					echo"			
						<p>&nbsp;</p>
						<table class=\"main-table-02 tb-pad0\" style=\"max-width:450px;\">
							<tr>
								<td><p class=\"aligncenter\"><strong>".$amsg[76]."</strong></p></td>
							</tr>";

							if (isset($_POST['backup_plus']) AND isset($_POST['send_backup'])) {
								$fehler = "";
								$_POST['backup_plus'] = $gbook->real_escape_string($_POST['backup_plus']);

								if ($_POST['backup_plus'] == "") {
									$fehler .= "".$emsg[42]."";
								}
								else {
									while (substr_count ($_POST['backup_plus'], " ") > 0) {
										$_POST['backup_plus'] = str_replace (" ", "", $_POST['backup_plus']);
									}

									$update = $gbook->query("INSERT INTO `".$table."_backup` (`dateiname`,`datum`,`uhrzeit`,`backup_time`) VALUES ('".$_POST['backup_plus']."','".GB_DATE."','".date("H:i")."','".time()."')");

									if ($update) {					                        
										echo "<meta http-equiv=\"Refresh\" content=\"0; url=".$url."admin/admin.php?action=backup&#38;show=restore_backup&#38;".session_name()."=".session_id()."\" />";
									}
								}

								if (!$fehler == "")	{ 
									echo "<tr><td><br /><br /><p class=\"error\">".$fehler."</p></td></tr>";
								}
							}

						echo"
							<tr>
								<td><p class=\"aligncenter\"><select name=\"backup_plus\" class=\"select-style\">";

									$old_backups_query	= $gbook->query("SELECT `dateiname` FROM `".$table."_backup`");

									$backup_dir = "../backup";

									$backupFiles = scandir($backup_dir);

									$ib = $resultBackFiles = "";
									$old_backup = array();

									foreach ($backupFiles as $backupFile) {
										if ($backupFile != "." && $backupFile != "..") {
											($backupFile == ".htaccess" OR !preg_match("/^.*\.(?i)(sql|gz)$/i", $backupFile)) ? $backupFile = "" : "";

											$backup_file[$ib] = $backupFile;
										}
										if (isset($backup_file[$ib]) && $backup_file[$ib] != "") {
											while($old_backups = $old_backups_query->fetch_assoc())	{
												$old_backup[] = $old_backups['dateiname'];
											}

											echo "<option value=\"";

											if (!in_array($backup_file[$ib], $old_backup)) {
												echo "".$backup_file[$ib]."\" selected=\"selected\">";

												$resultBackFiles = count($backup_file);
											}
											else {
												echo "\" disabled=\"disabled\">";
											}

											echo "".$backup_file[$ib]."</option>";
										}
									}

						echo "</select></p></td>
						</tr>
					</table>";

					if ($resultBackFiles != "")	{
						$infoNewBackup = "<p class=\"aligncenter red\"><strong>".$amsg[81]."<br /><br /></strong></p>";
						$saveNewBackup = "<p class=\"aligncenter\"><input type=\"submit\" class=\"button\" name=\"send_backup\" value=\"".$amsg[78]."\" onclick=\"return backup_upload()\" /></p>";
					}
					else {
						$infoNewBackup = "<p class=\"aligncenter green\">".$amsg[77]."<img class=\"img-ok marg-le15\" src=\"../images/ok.png\" width=\"14\" height=\"14\" alt=\"\" /></p>";
						$saveNewBackup = "";
					}

					echo"
						".$infoNewBackup."
						".$saveNewBackup."
						<p>&nbsp;</p>
						</form>
						</fieldset>";
			}
			echo"
				</div>";
	}
?>