<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	############################################################################################

	The javascripts "Countdown" and "Sticky-Header" are based on examples from https://www.w3schools.com/

	############################################################################################

	01.09.2021
*/
	header("X-Robots-Tag: noindex");
	header("content-type: text/html; charset=UTF-8");
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate");
	header("Pragma: no-cache");

	session_start();

	$thisGBPage = array('gbookAdmin' => 1);
	$stickyHeight = "style=\"height:35px;\"";

	require_once("../includes/functions.inc.php");

	if (isset($_SESSION['last_activity']) && ((time() - ($session_lifetime*60)) > $_SESSION['last_activity'])){
		unset($_SESSION['sid'], $_SESSION['modsid']);
		session_destroy();
		setcookie("blogmode","",time()-3600,"/");

		header("Location: ".$url."admin/admin.php?action=login");
		die();
	}

	$_SESSION['last_activity'] = time();

	if (isset($_GET['action'])) {
		$_GET['action'] = $gbook->real_escape_string($_GET['action']);

		if (isset($_SESSION['sid']) OR isset($_SESSION['modsid'])) {
			if (!preg_match("/^[_\a-z]*$/is", $_GET['action'])) {
				$_GET['action'] = "guestbook";
			}
		}
		elseif ($_GET['action'] == "login" || $_GET['action'] == "password_forget" || $_GET['action'] == "activatelogin" || ($_GET['action'] == "sfa" && isset($_SESSION['gbsecure']))) {
			$_GET['action'] = $_GET['action'];
		}
		else {
			$_GET['action'] = "login";
		}
	}
	elseif (!isset($_GET['action']) && (isset($_SESSION['sid']) OR isset($_SESSION['modsid']))) {
		$_GET['action'] = "guestbook";
	}
	else {
		$_GET['action'] = "login";
	}

	if (ID_REG && !isset($_SESSION['sid']) && !isset($_SESSION['modsid'])) {
		session_regenerate_id();

		if (isset($_SESSION['gbsecure'])) {
			$_SESSION['gbsecure'] = session_id();
		}
	}

	isset($_GET['show']) ? ($_GET['show'] = $gbook->real_escape_string($_GET['show'])) : $_GET['show'] = "";

	$_REQUEST['id'] = (isset($_REQUEST['id']) && (preg_match("/^\d{1,6}$/",$_REQUEST['id']))) ? $_REQUEST['id'] : "0";
	$_GET['id'] = (isset($_GET['id']) && (preg_match("/^\d{1,6}$/",$_GET['id']))) ? $_GET['id'] : "0";
	$_POST['id'] = (isset($_POST['id']) && (preg_match("/^\d{1,6}$/",$_POST['id']))) ? $_POST['id'] : "0";

	(isset($_GET['action']) && $_GET['action'] == "logout") ? require_once("logout.php") : "";

	isset($_SESSION['sid']) ? define('AdminLogin', true) : define('AdminLogin', false);
	isset($_SESSION['modsid']) ? define('ModLogin', true) : define('ModLogin', false);
	(defined('PHP_VERSION_ID') && (PHP_VERSION_ID >= 50500) && (defined('PASSWORD_ARGON2ID') OR defined('PASSWORD_ARGON2I') OR defined('PASSWORD_BCRYPT') OR defined('PASSWORD_DEFAULT'))) ? define('BEST_PW', true) : define('BEST_PW', false);

	$del_old_stats = mktime(0, 0, 0, date("m"), date("d")-$recording_days, date("Y"));
	$gbook->query("DELETE FROM `".$table."_statistic` WHERE `id` != 1 AND `zeit` <= ".$del_old_stats."");

	$error_02 = $entries_gesperrt = $count_entries = $js_limit = $select_template = $errorCookie = $adminWarning = $pwWarning = $pwModWarning = $mailWarning = $dimWarning = $gb_pw_date = $checkGuestMail = $checkBanner = $widthWarning = "";
	$short_town = "30";

	$sql_properties = $gbook->query("SELECT `admin_email`, `bbcode`, `clean_backup`, `default_template`, `images_in_entries`, `language`, `smilies`, `thanks_email`, `button_link`, `choose_lang`, `check_banner`, `flag`, `search_func` FROM `".$table."_properties`");
	list($adminEmail, $showBbcode, $clean_backup, $default_template, $showImages, $langFile, $showSmileys, $thanksEmail, $blogMod, $chooseLang, $showBanner, $langFlag, $searchFunc) = $sql_properties->fetch_row();

	($showBbcode && $showImages) ? define('showPic', true) : define('showPic', false);
	($blogMod == 2) ? define('BlogMod', true) : define('BlogMod', false);

	require_once("../lang/".$langFile.".php");

	if (BlogMod && ($showBbcode OR $showImages OR $showSmileys)) {
		setcookie("blogmode",session_id(),"0","/","","",true);

		(!isset($_COOKIE['blogmode'])) ? $errorCookie = '<tr><td><p class="error">'.$emsg[15].'</p></td></tr>' : '';
	}

	(BlogMod && isset($_POST['button_link']) && $_POST['button_link'] != 2) ? setcookie("blogmode","",time()-3600,"/") : "";

	echo "<!DOCTYPE html>
	<!--[if IE 9]><html id=\"ie9\" dir=\"ltr\" lang=\"".$lang_short."\"><![endif]-->
	<!--[if !(IE 9) ]><!-->
	<html lang=\"".$lang_short."\">
	<!--<![endif]-->
	<head>
		<meta charset=\"".$encoding."\" />
		<meta name=\"language\" content=\"".$lang_short."\" />
		<meta name=\"viewport\" content=\"width=device-width\" />
		<title>myPHP Guestbook - Admin-Control-Panel ".$version."</title>
		<link rel=\"stylesheet\" href=\"admin-style-4108.css\" />";

		if (AdminLogin || ModLogin) {
			echo "
				<script>
					var countDownTime=new Date().getTime()+($session_lifetime*60000);
					var x=setInterval(function(){var now=new Date().getTime();var distance=countDownTime-now;var minutes=Math.floor((distance%3600000)/60000);var seconds=Math.floor((distance%60000)/1000);if(seconds<10){var seconds=\"0\"+seconds;}
												document.getElementById(\"showLifetime\").innerText=\"".$amsg[210].": \"+minutes+\":\"+seconds;if(distance<0){clearInterval(x);document.getElementById(\"showLifetime\").innerText=\"".$amsg[211]."\";}},1000);
				</script>";

				$stickyHeight = "style=\"height:55px;\"";
		}

echo"
	</head>
	<body>
	<div id=\"container\">
	<div class=\"sticky-box\" ".$stickyHeight.">";

	if (AdminLogin || ModLogin) {
		echo "
			<div id=\"scrollHeader\">
				<strong id=\"showLifetime\">&nbsp;</strong>
				<div class=\"panel-head\"><span class=\"large-panel\"><img src=\"".$url."includes/flags/".$langFlag.".png\" alt=\"\" title=\"".$language."\" width=\"16\" height=\"11\" /></span><strong class=\"large-panel-le15\">".$amsg[0]."<span class=\"large-panel\"> - myPHP Guestbook ".$version."</span></strong></div>
				<div class=\"logout-02\"><a href=\"".$url."admin/admin.php?action=logout&#38;".session_name()."=".session_id()."\" title=\"".$amsg[29]."\">".$amsg[29]."</a></div>
				<div class=\"host\">Host: ".$_SERVER['SERVER_NAME']."</div>
				<a class=\"goTop\" title=\"Go to Top\" href=\"javascript:scrollToTop()\"></a>
			</div>";
	}
	else {
		echo"
			<div class=\"aligncenter size-14\">
				<p style=\"margin-top:6px;\"><img src=\"".$url."includes/flags/".$langFlag.".png\" alt=\"\" width=\"16\" height=\"11\" /><strong class=\"area-text\">myPHP Guestbook<sup>&copy;</sup> - Admin Area</strong></p>
			</div>";
	}

	echo"
		</div>
		<div class=\"break\"></div>
		<div class=\"wrapper\">";

	if (AdminLogin || ModLogin) {

		(!$clean_backup) ? include("check_backup.php") : $backup_warning = "";

		echo"
		<ul id=\"accMenu\" class=\"mobil-menu\">
			<li><a href=\"javascript:void(0)\"><img title=\"".$amsg[238]."\" src=\"../images/menue.png\" width=\"30\" height=\"30\" alt=\"".$amsg[239]."\" /></a>
				<ul>
					<li><a title=\"".$amsg[2]."\" href=\"javascript:void(0)\">".$amsg[2]."</a>
						<ul>
							<li><a href=\"".$url."admin/admin.php?action=guestbook&#38;".session_name()."=".session_id()."\">".$amsg[3]."</a></li>
							<li><a href=\"".$url."admin/admin.php?action=guest_pictures&#38;".session_name()."=".session_id()."\">".$amsg[91]."</a></li>
							<li><a href=\"".$url."admin/admin.php?action=adminblog&#38;".session_name()."=".session_id()."\">".$amsg[177]."</a></li>
							<li><a rel=\"external\" href=\"".$url."\">".$fmsg[50]."</a></li>
						</ul>
					</li>";
	}

	if (AdminLogin && !ModLogin) {
		echo"	
				<li><a title=\"".$amsg[4]."\" href=\"javascript:void(0)\">".$amsg[4]."</a>
					<ul>
						<li><a href=\"".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."\">".$amsg[5]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=guestbook_options&#38;".session_name()."=".session_id()."\">".$amsg[6]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=upload_options&#38;".session_name()."=".session_id()."\">".$amsg[103]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=thanks_email&#38;show=guest_mail&#38;".session_name()."=".session_id()."\">".$amsg[130]."</a></li>
					</ul>
				</li>
				<li><a title=\"".$amsg[12]."\" href=\"javascript:void(0)\">".$amsg[12]."</a>
					<ul>
						<li><a href=\"".$url."admin/admin.php?action=template&#38;show=default_template&#38;".session_name()."=".session_id()."\">".$amsg[13]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=template&#38;show=edit_template&#38;".session_name()."=".session_id()."\">".$amsg[16]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=template&#38;show=make_template&#38;".session_name()."=".session_id()."\">".$amsg[14]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=template&#38;show=delete_template&#38;".session_name()."=".session_id()."\">".$amsg[15]."</a></li>
					</ul>
				</li>
				<li><a title=\"".$amsg[7]."\" href=\"javascript:void(0)\">".$amsg[7]."</a>
					<ul>
						<li><a href=\"".$url."admin/admin.php?action=style&#38;show=default_style&#38;".session_name()."=".session_id()."\">".$amsg[8]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=style&#38;show=edit_style&#38;".session_name()."=".session_id()."\">".$amsg[11]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=style&#38;show=make_style&#38;".session_name()."=".session_id()."\">".$amsg[9]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=style&#38;show=delete_style&#38;".session_name()."=".session_id()."\">".$amsg[10]."</a></li>
					</ul>
				</li>
				<li><a title=\"".$amsg[371]."\" href=\"javascript:void(0)\">".$amsg[371]."</a>
					<ul>
						<li><a href=\"".$url."admin/admin.php?action=banner&#38;show=view_banner&#38;".session_name()."=".session_id()."\">".$amsg[372]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=banner&#38;show=insert_banner&#38;".session_name()."=".session_id()."\">".$amsg[373]."</a></li>
					</ul>
				</li>
				<li><a title=\"".$amsg[17]."\" href=\"javascript:void(0)\">".$amsg[17]."</a>
					<ul>
						<li><a href=\"".$url."admin/admin.php?action=smilies&#38;show=view_smilies&#38;".session_name()."=".session_id()."\">".$amsg[18]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=smilies&#38;show=insert_smilies&#38;".session_name()."=".session_id()."\">".$amsg[19]."</a></li>
					</ul>
				</li>
				<li><a title=\"".$amsg[20]."\" href=\"javascript:void(0)\">".$amsg[20]."</a>
					<ul>
						<li><a href=\"".$url."admin/admin.php?action=badwords&#38;show=view_badwords&#38;".session_name()."=".session_id()."\">".$amsg[21]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=badwords&#38;show=insert_badwords&#38;".session_name()."=".session_id()."\">".$amsg[22]."</a></li>
					</ul>
				</li>
				<li><a title=\"".$amsg[38]."\" href=\"javascript:void(0)\">".$amsg[38]."</a>
					<ul>
						<li><a href=\"".$url."admin/admin.php?action=spamwords&#38;show=view_spam&#38;".session_name()."=".session_id()."\">".$amsg[35]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=spamwords&#38;show=insert_spam&#38;".session_name()."=".session_id()."\">".$amsg[36]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=spamwords&#38;show=ip_forbidden&#38;".session_name()."=".session_id()."\">".$amsg[37]."</a></li>
					</ul>
				</li>";
	}

	if (AdminLogin || ModLogin) {
		echo"
				<li><a title=\"".$amsg[23]."\" href=\"javascript:void(0)\">".$amsg[23]."</a>
					<ul>
						<li><a href=\"".$url."admin/admin.php?action=backup&#38;show=restore_backup&#38;".session_name()."=".session_id()."\">".$amsg[25]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=backup&#38;show=make_backup&#38;".session_name()."=".session_id()."\">".$amsg[24]."</a></li>
					</ul>
				</li>
				<li><a title=\"".$amsg[26]."\" href=\"javascript:void(0)\">".$amsg[26]."</a>
					<ul>
						<li><a href=\"".$url."admin/admin.php?action=statistic&#38;".session_name()."=".session_id()."\">".$amsg[27]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=check_update&#38;".session_name()."=".session_id()."\">".$amsg[326]."</a></li>
						<li><a href=\"".$url."admin/admin.php?action=help&#38;".session_name()."=".session_id()."\">".$amsg[82]."</a></li>
						<li><span class=\"logout\"><a href=\"".$url."admin/admin.php?action=logout&#38;".session_name()."=".session_id()."\">".$amsg[29]."</a></span></li>
					</ul>
				</li>
			</ul>
		</li>
	</ul>
	<div class=\"break\"></div>";

	echo"
		<div class=\"desctop-menu\">
			<fieldset style=\"text-align:left;\">
				<legend><strong>".$amsg[2]."</strong></legend>
				<a"; ($_GET['action']=="guestbook" OR $_GET['action']=="edit" OR $_GET['action']=="comment") ? $liStyle01 = ' class="naviActive"' : $liStyle01 = ''; echo"".$liStyle01." href=\"".$url."admin/admin.php?action=guestbook&#38;".session_name()."=".session_id()."\">".$amsg[3]."</a><br />
				<a"; ($_GET['action']=="guest_pictures" OR $_GET['action']=="edit_guest_pictures") ? $liStyle02 = ' class="naviActive"' : $liStyle02 = ''; echo"".$liStyle02." href=\"".$url."admin/admin.php?action=guest_pictures&#38;".session_name()."=".session_id()."\">".$amsg[91]."</a><br />
				<a"; ($_GET['action']=="adminblog") ? $liStyle03= ' class="naviActive"' : $liStyle03 = ''; echo"".$liStyle03." href=\"".$url."admin/admin.php?action=adminblog&#38;".session_name()."=".session_id()."\">".$amsg[177]."</a><br />
				<a rel=\"external\" href=\"".$url."\">".$fmsg[50]."</a><br />
			</fieldset>";
	}

	if (AdminLogin && !ModLogin) {

		include("check_div.php");

		echo"
			<fieldset>
				<legend><strong>".$amsg[4]."</strong></legend>
				<a"; ($_GET['action']=="admin_options") ? $liStyle04 = ' class="naviActive"' : $liStyle04 = ''; echo"".$liStyle04." href=\"".$url."admin/admin.php?action=admin_options&#38;show=show_mod&#38;".session_name()."=".session_id()."\">".$amsg[5]."</a>".$adminWarning."<br />
				<a"; ($_GET['action']=="guestbook_options") ? $liStyle05 = ' class="naviActive"' : $liStyle05 = ''; echo"".$liStyle05." href=\"".$url."admin/admin.php?action=guestbook_options&#38;".session_name()."=".session_id()."\">".$amsg[6]."</a><br />
				<a"; ($_GET['action']=="upload_options") ? $liStyle06 = ' class="naviActive"' : $liStyle06 = ''; echo"".$liStyle06." href=\"".$url."admin/admin.php?action=upload_options&#38;".session_name()."=".session_id()."\">".$amsg[103]."</a>".$dimWarning."<br />
				<a"; ($_GET['action']=="thanks_email") ? $liStyle07 = ' class="naviActive"' : $liStyle07 = ''; echo"".$liStyle07." href=\"".$url."admin/admin.php?action=thanks_email&#38;show=guest_mail&#38;".session_name()."=".session_id()."\">".$amsg[130]."</a>".$checkGuestMail."<br />
			</fieldset>
			<fieldset>
				<legend><strong>".$amsg[12]."</strong></legend>
				<a"; ($_GET['show']=="default_template") ? $liStyle08 = ' class="naviActive"' : $liStyle08 = ''; echo"".$liStyle08." href=\"".$url."admin/admin.php?action=template&#38;show=default_template&#38;".session_name()."=".session_id()."\">".$amsg[13]."</a><br />
				<a"; ($_GET['show']=="edit_template" OR $_GET['show']=="edit_template_action") ? $liStyle09 = ' class="naviActive"' : $liStyle09 = ''; echo"".$liStyle09." href=\"".$url."admin/admin.php?action=template&#38;show=edit_template&#38;".session_name()."=".session_id()."\">".$amsg[16]."</a>".$widthWarning."<br />
				<a"; ($_GET['show']=="make_template" OR $_GET['show']=="make_template_action") ? $liStyle10 = ' class="naviActive"' : $liStyle10 = ''; echo"".$liStyle10." href=\"".$url."admin/admin.php?action=template&#38;show=make_template&#38;".session_name()."=".session_id()."\">".$amsg[14]."</a><br />
				<a"; ($_GET['show']=="delete_template") ? $liStyle11 = ' class="naviActive"' : $liStyle11 = ''; echo"".$liStyle11." href=\"".$url."admin/admin.php?action=template&#38;show=delete_template&#38;".session_name()."=".session_id()."\">".$amsg[15]."</a><br />
			</fieldset>
			<fieldset>
				<legend><strong>".$amsg[7]."</strong></legend>
				<a"; ($_GET['show']=="default_style") ? $liStyle12 = ' class="naviActive"' : $liStyle12 = ''; echo"".$liStyle12." href=\"".$url."admin/admin.php?action=style&#38;show=default_style&#38;".session_name()."=".session_id()."\">".$amsg[8]."</a><br />
				<a"; ($_GET['show']=="edit_style" OR $_GET['show']=="edit_style_action") ? $liStyle13 = ' class="naviActive"' : $liStyle13 = ''; echo"".$liStyle13." href=\"".$url."admin/admin.php?action=style&#38;show=edit_style&#38;".session_name()."=".session_id()."\">".$amsg[11]."</a><br />
				<a"; ($_GET['show']=="make_style") ? $liStyle14 = ' class="naviActive"' : $liStyle14 = ''; echo"".$liStyle14." href=\"".$url."admin/admin.php?action=style&#38;show=make_style&#38;".session_name()."=".session_id()."\">".$amsg[9]."</a><br />
				<a"; ($_GET['show']=="delete_style") ? $liStyle15 = ' class="naviActive"' : $liStyle15 = ''; echo"".$liStyle15." href=\"".$url."admin/admin.php?action=style&#38;show=delete_style&#38;".session_name()."=".session_id()."\">".$amsg[10]."</a><br />
			</fieldset>
			<fieldset>
				<legend><strong>".$amsg[371]."</strong></legend>
				<a"; ($_GET['show']=="view_banner" OR $_GET['show']=="edit_banner") ? $liStyle16 = ' class="naviActive"' : $liStyle16 = ''; echo"".$liStyle16." href=\"".$url."admin/admin.php?action=banner&#38;show=view_banner&#38;".session_name()."=".session_id()."\">".$amsg[372]."</a>".$checkBanner."<br />
				<a"; ($_GET['show']=="insert_banner") ? $liStyle17 = ' class="naviActive"' : $liStyle17 = ''; echo"".$liStyle17." href=\"".$url."admin/admin.php?action=banner&#38;show=insert_banner&#38;".session_name()."=".session_id()."\">".$amsg[373]."</a><br />
			</fieldset>
			<fieldset>
				<legend><strong>".$amsg[17]."</strong></legend>
				<a"; ($_GET['show']=="view_smilies" OR $_GET['show']=="edit_smilies") ? $liStyle18 = ' class="naviActive"' : $liStyle18 = ''; echo"".$liStyle18." href=\"".$url."admin/admin.php?action=smilies&#38;show=view_smilies&#38;".session_name()."=".session_id()."\">".$amsg[18]."</a><br />
				<a"; ($_GET['show']=="insert_smilies") ? $liStyle19 = ' class="naviActive"' : $liStyle19 = ''; echo"".$liStyle19." href=\"".$url."admin/admin.php?action=smilies&#38;show=insert_smilies&#38;".session_name()."=".session_id()."\">".$amsg[19]."</a><br />
			</fieldset>
			<fieldset>
				<legend><strong>".$amsg[20]."</strong></legend>
				<a"; ($_GET['show']=="view_badwords") ? $liStyle20 = ' class="naviActive"' : $liStyle20 = ''; echo"".$liStyle20." href=\"".$url."admin/admin.php?action=badwords&#38;show=view_badwords&#38;".session_name()."=".session_id()."\">".$amsg[21]."</a><br />
				<a"; ($_GET['show']=="insert_badwords") ? $liStyle21 = ' class="naviActive"' : $liStyle21 = ''; echo"".$liStyle21." href=\"".$url."admin/admin.php?action=badwords&#38;show=insert_badwords&#38;".session_name()."=".session_id()."\">".$amsg[22]."</a><br />
			</fieldset>
			<fieldset>
				<legend><strong>".$amsg[38]."</strong></legend>
				<a"; ($_GET['show']=="view_spam") ? $liStyle22 = ' class="naviActive"' : $liStyle22 = ''; echo"".$liStyle22." href=\"".$url."admin/admin.php?action=spamwords&#38;show=view_spam&#38;".session_name()."=".session_id()."\">".$amsg[35]."</a><br />
				<a"; ($_GET['show']=="insert_spam") ? $liStyle23 = ' class="naviActive"' : $liStyle23 = ''; echo"".$liStyle23." href=\"".$url."admin/admin.php?action=spamwords&#38;show=insert_spam&#38;".session_name()."=".session_id()."\">".$amsg[36]."</a><br />
				<a"; ($_GET['show']=="ip_forbidden") ? $liStyle24 = ' class="naviActive"' : $liStyle24 = ''; echo"".$liStyle24." href=\"".$url."admin/admin.php?action=spamwords&#38;show=ip_forbidden&#38;".session_name()."=".session_id()."\">".$amsg[37]."</a><br />
			</fieldset>";
	}

	if (AdminLogin || ModLogin) {
		echo"
			<fieldset>
				<legend><strong>".$amsg[23]."</strong></legend>
				<a"; ($_GET['show']=="restore_backup") ? $liStyle25 = ' class="naviActive"' : $liStyle25 = ''; echo"".$liStyle25." href=\"".$url."admin/admin.php?action=backup&#38;show=restore_backup&#38;".session_name()."=".session_id()."\">".$amsg[25]."</a><br />
				<a"; ($_GET['show']=="make_backup") ? $liStyle26 = ' class="naviActive"' : $liStyle26 = ''; echo"".$liStyle26." href=\"".$url."admin/admin.php?action=backup&#38;show=make_backup&#38;".session_name()."=".session_id()."\">".$amsg[24]."</a>".$backup_warning."<br />
			</fieldset>
			<fieldset>		
				<legend><strong>".$amsg[26]."</strong></legend>
				<a"; ($_GET['action']=="statistic") ? $liStyle27 = ' class="naviActive"' : $liStyle27 = ''; echo"".$liStyle27." href=\"".$url."admin/admin.php?action=statistic&#38;".session_name()."=".session_id()."\">".$amsg[27]."</a><br />
				<a"; ($_GET['action']=="check_update") ? $liStyle28 = ' class="naviActive"' : $liStyle28 = ''; echo"".$liStyle28." href=\"".$url."admin/admin.php?action=check_update&#38;".session_name()."=".session_id()."\">".$amsg[326]."</a><br />
				<a"; ($_GET['action']=="help") ? $liStyle29 = ' class="naviActive"' : $liStyle29 = ''; echo"".$liStyle29." href=\"".$url."admin/admin.php?action=help&#38;".session_name()."=".session_id()."\">".$amsg[82]."</a><br />
				<span class=\"logout\"><a href=\"".$url."admin/admin.php?action=logout&#38;".session_name()."=".session_id()."\">".$amsg[29]."</a></span> 
			</fieldset>
		</div>";
	}

	echo"
		<div class=\"content\">";

	(!AdminLogin && !ModLogin) ? $file = "login.php" : $file = "guestbook.php";

	switch($_GET['action']) {

		case "admin_options";
		require_once("admin_options.php");
		break;

		case "backup";
		require_once("backup.php");
		break;

		case "banner";
		require_once("banner.php");
		break;

		case "badwords";
		require_once("badwords.php");
		break;

		case "spamwords";
		require_once("spamwords.php");
		break;

		case "template";
		require_once("template.php");
		break;

		case "guestbook_options";
		require_once("guestbook_options.php");
		break;

		case "upload_options";
		require_once("upload_options.php");
		break;

		case "thanks_email";
		require_once("edit_thanks_email.php");
		break;

		case "smilies";
		require_once("smilies.php");
		break;

		case "style";
		require_once("style.php");
		break;

		case "adminblog";
		require_once("admin_blog.php");
		break;

		case "comment";
		require_once("comment.php");
		break;

		case "edit";
		require_once("edit.php");
		break;

		case "guestbook";
		require_once("guestbook.php");
		break;

		case "guest_pictures";
		require_once("guest_pictures.php");
		break;

		case "edit_guest_pictures";
		require_once("edit_guest_pictures.php");
		break;

		case "help";
		require_once("help.php");
		break;

		case "password_forget";
		require_once("login.php");
		break;

		case "statistic";
		require_once("statistic.php");
		break;

		case "check_update";
		require_once("check_update.php");
		break;

		default:
		require_once($file);
		break;
	}

	echo"
		</div>
		</div>
		<div class=\"break\"></div>
		<div id=\"footer\">
			<p style=\"padding-top:10px;\"><a href=\"https://www.php-guestbook.de\" title=\"Download myPHP Guestbook\" rel=\"external\"><img title=\"Download 'myPHP Guestbook'\" src=\"".$url."images/myphpGuestbook.png\" width=\"110\" height=\"20\" alt=\"myPHP Guestbook\" /></a></p>
		</div>
		<div><a id=\"adminTop\" href=\"javascript:scrollToTop()\" title=\"To Top\"></a></div>
	</div>
	<script src=\"".$url."js/gbook.func-00-05032021.js\"></script>
	<script>window.onscroll=function(){myStickyFunc();scrollPage()}</script>
	</body>
</html>";
?>