<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/

	require_once("".$gbook_folder."/includes/functions.inc.php");

	//Exclusion of permanently blocked IPs according to the table with redirection to the guestbook
	$ip_sperre = $gbook->query("SELECT `ip` FROM `".$table."_forbidden_ip` WHERE `ip` = '".$_SERVER['REMOTE_ADDR']."'") or die();

	if ($ip_sperre != ""){
		$sperre = $ip_sperre->num_rows;
	}

	$showErrors = $mark_name = $mark_email = $mark_hp = $mark_town = $mark_country = $mark_subject = $mark_text = $mark_name2 = $mark_email2 = $mark_hp2 = $mark_town2 = $mark_country2 = $mark_subject2 = $mark_text2 = $mark_priv2 = $mark_info2 = "";
	$bad = $good = $count_entries = $separated_red = $separated_gray = $origin = $slash = $output = $user_info = $js_limit = $text_quote = $email_quote = $textareaMarg = $privMargLe = $hpSpam = $emailRepeat = $emojiNote = $textCounter = "";
	$div_c = $div_t = $div_hp = $div_em = "dsR3";
	$class_stars01 = $class_stars02 = $class_stars03 = $class_stars04 = $class_stars05 = "stars";
	$free_email = $id_quote = $new_marker = 0;
	$short_town = 30;
	$maxlenght = "<br />";
	$startzeit = $time = time();
	$ratingMarg = "marg-15-5";
	$emailSpam = "<div class=\"dsR3\">
					<label>E-Mail:</label><br /> 
					<input id=\"repeat_email\" type=\"text\" name=\"repeat_email\" size=\"25\" value=\"\" />
				</div>";

	$_POST['betreff'] 		= isset($_POST['betreff']) ? $_POST['betreff'] : "";
	$_POST['email'] 		= isset($_POST['email']) ? $_POST['email'] : "";
	$_POST['homepage'] 		= isset($_POST['homepage']) ? $_POST['homepage'] : "";
	$_POST['town'] 			= isset($_POST['town']) ? $_POST['town'] : "";
	$_POST['country'] 		= isset($_POST['country']) ? $_POST['country'] : "";
	$_POST['email_quote'] 	= isset($_POST['email_quote']) ? $_POST['email_quote'] : "";
	$_POST['quote_id'] 		= isset($_POST['quote_id']) ?  $_POST['quote_id'] : "";
	$_POST['quote_marker'] 	= isset($_POST['quote_marker']) ? $_POST['quote_marker'] : "";

	$_POST['free_email'] 	= isset($_POST['free_email']) ? $_POST['free_email'] : 0;
	$_POST['star'] 			= isset($_POST['star']) ? $_POST['star'] : 0;

	$_POST['comment_info'] 	= (isset($_POST['comment_info']) && ($_POST['comment_info'] == 1)) ? 1 : 0;
	$_POST['agree'] 		= (isset($_POST['agree']) && ($_POST['agree'] == 1)) ? 1 : 0;

	$woher 		= isset($_SERVER['HTTP_REFERER']) ? htmlspecialchars($_SERVER['HTTP_REFERER']) : "";
	$hostname 	= isset($_SERVER['SERVER_NAME']) ? htmlspecialchars($_SERVER['SERVER_NAME']) : "";
	$quoteFirst = isset($quoteFirst) ? $quoteFirst : true;

	require_once("".$gbook_folder."/includes/lang.inc02.php");

	$sql_properties = $gbook->query("SELECT `admin_email`, `antiflood_ban`, `bbcode`, `check_email`, `check_homepage`, `deactivate_html`, `default_style`, `default_template`, `entry_length_limit`, `entry_length_maximum`, `entry_length_minimum`, `guestbook_status`, `no_spam_entries`, `spam_marker`, `no_spam_links`, `max_links`, `guestbook_title`,  
											`images_in_entries`, `max_word_length`, `notification_entries`, `release_entries`, `smilies`, `thanks_email`, `statistic`, `statistic_ban`, `quote_func`, `check_subject`, `check_town`, `check_country`, `check_free`, `button_link`, `rating`, `rating_text`, `title_subject`, `administration`, `check_banner`, `privacy_hint`, `privacy_url` 
									 FROM `".$table."_properties`") or die();
	$properties = $sql_properties->fetch_assoc();
	$default_style = $properties['default_style'];

	$properties['rating_text'] = $properties['rating_text'] === NULL ? "" : $properties['rating_text'];
	$properties['title_subject'] = $properties['title_subject'] === NULL ? "" : $properties['title_subject'];
	$properties['privacy_url'] = $properties['privacy_url'] === NULL ? "" : $properties['privacy_url'];

	$entry_release = time()-($properties['antiflood_ban']*60);
	$gbook->query("DELETE FROM `".$table."_ip_ban` WHERE `time` <= '$entry_release' AND `type` = 'entry'");

	$ip_release = time()-($delete_spamIps*86400);
	$gbook->query("DELETE FROM `".$table."_forbidden_ip` WHERE `www_time` <= '$ip_release' AND `no_del` != '1'");

	$upload_release = time()-1200;
	$gbook->query("DELETE FROM `".$table."_upload_counter` WHERE `upload_time` <= '$upload_release'");

	header("X-Robots-Tag: noindex");
	header("content-type: text/html; charset=\"".$encoding."\"" );
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate");
	header("Pragma: no-cache");

	if ($properties['button_link'] > 1 OR $sperre){
		header("Location: ".$url02."gbook.php");
		die();
	}

	$placeholderEMail = $placeholderCountry = $placeholderTown = $fmsg[337];
	$entrie_headline = $fmsg[5];

	SCROLL_TO_TOP ? $scrollTop = 'onclick="mygbTop()"' : $scrollTop = '';

	if (isset($_GET['action']))	{
		$_GET['action'] = strip_tags(trim($_GET['action']));
		$_GET['action'] = $gbook->real_escape_string($_GET['action']);
		$_GET['action'] = ($_GET['action'] == "quote") ? "quote" : "";
	}
	else {
		$_GET['action'] = "";
	}

	$_GET['id'] = ($_GET['action'] == "quote" && isset($_GET['id']) && preg_match("/^\d{1,6}$/", $_GET['id'])) ? trim($_GET['id']) : "";

	$id_quote = preg_match("/^\d{1,6}$/", $_POST['quote_id']) ? $_POST['quote_id'] : 0;
	$_GET['id'] = $id_quote == 0 ? $_GET['id'] : $id_quote;

	if ($properties['quote_func']) {
		if (!empty($_GET['id'])) {
			session_start();

			$quote_entries = $gbook->prepare("SELECT `comment`, `email`, `date`, `id`, `name`, `text`, `time`, `marker`, `check_time`  FROM  `".$table."_entries`  WHERE  `id` = ?");
			$quote_entries->bind_param('i', $_GET['id']);
			$quote_entries->execute();
			$quote_entries->store_result();
			$quote_entries->bind_result($comment_quote, $email_quote, $date_quote, $id_quote, $name_quote, $text_quote, $time_quote, $marker_quote, $usTime_quote);

			while ($quote_entries->fetch()) {
				if (!empty($comment_quote)) {
					$comment_quote = preg_replace("/\[img\](.*?)\[\/img\]/si", " ![IMAGE]! ", $comment_quote);
					$comment_quote = "[comment]".$comment_quote."[/comment]";
				}
				else {
					$comment_quote = "";
				}

				$email_quote = noSpam02($email_quote);

				if (!empty($name_quote)) {
					$name_quote = nobadwords($name_quote);
					$name_headline = stripslashes(htmlentities(strip_tags($name_quote), ENT_QUOTES, "UTF-8"));
				}
				else {
					$name_headline = $name_quote = 'Admin';
				}

				$text_quote = nobadwords($text_quote);
				$text_quote = str_replace("  ", " ", $text_quote);
				$text_quote = preg_replace("/\[img\](.*?)\[\/img\]/si", " ![IMAGE]! ", $text_quote);

				$usTime_quote = intval($usTime_quote);

				if ($dateFormat !== "us" && $dateFormat !== "sv") {
					!empty($usTime_quote) ? $time_quote = date("H:i", $usTime_quote) : ((!empty($time_quote) && preg_match("/^[0-9:]*$/is", $time_quote)) ? "" : $time_quote = "n.a.");
					!empty($usTime_quote) ? $date_quote = date("d.m.Y", $usTime_quote) : ((!empty($date_quote) && preg_match("/^[0-9.\/-]*$/is", $date_quote)) ? "" : $date_quote = "n.a.");
				}
				elseif ($dateFormat === "sv") {
					!empty($usTime_quote) ? $time_quote = date("H:i", $usTime_quote) : ((!empty($time_quote) && preg_match("/^[0-9:]*$/is", $time_quote)) ? "" : $time_quote = "n.a.");
					!empty($usTime_quote) ? $date_quote = date("Y-m-d", $usTime_quote) : ((!empty($date_quote) && preg_match("/^[0-9.\/-]*$/is", $date_quote)) ? "" : $date_quote = "n.a.");
				}
				else {
					!empty($usTime_quote) ? $time_quote = date("h:i A", $usTime_quote) : ((!empty($time_quote) && preg_match("/^[0-9:]*$/is", $time_quote)) ? "" : $time_quote = "n.a.");
					!empty($usTime_quote) ? $date_quote = date("m-d-Y", $usTime_quote) : ((!empty($date_quote) && preg_match("/^[0-9.\/-]*$/is", $date_quote)) ? "" : $date_quote = "n.a.");
				}

				if (($marker_quote == 1 || $marker_quote == 2) && !empty($email_quote)) {
					$free_email = 1;
					$marker_quote == 1 ? $new_marker = 3 : $new_marker = 0;
				}
				else {
					$email_quote = "";
				}
			}

			$quote_entries->free_result();
			$quote_entries->close();

			if (isset($text_quote) AND $text_quote != "") {
				$_SESSION['entrie_quote'] = "[zitat=".$name_quote." ".$amsg[86]." ".$date_quote." | ".$time_quote."]".$text_quote."".$comment_quote."[/zitat]";
				$entrie_headline = ''.$fmsg[190].' <span class="italic">'.$name_headline.' <span class="nowrap">('.$date_quote.', '.$time_quote.'):</span></span>';
			}
		}
		else {
			$_GET['id'] = "";

			if (isset($_SESSION['entrie_quote'])) {
				unset($_SESSION['entrie_quote']);
			}
		}
	}

	if ($properties['release_entries'] == 1 || $properties['release_entries'] == 3) {
		$user_info = "<p class=\"text-center small-02\">(".$fmsg[351].")</p>";
	}

	if ($properties['check_town'] != 1 && $properties['check_country'] == 1) {
		$div_t = "i-max";
	}
	elseif ($properties['check_town'] == 1 && $properties['check_country'] != 1) {
		$div_c = "i-max";
	}
	elseif ($properties['check_town'] != 1 && $properties['check_country'] != 1) {
		$div_t = "i-left";
		$div_c = "i-right";
	}

	if (($properties['check_homepage'] == 0 && $properties['check_email'] == 4) OR ($properties['check_homepage'] == 1 && $properties['check_email'] < 4)) {
		$div_em = $div_hp = "i-max";
	}
	elseif ($properties['check_homepage'] == 0 && $properties['check_email'] < 4) {
		$div_em = "i-left";
		$div_hp = "i-right";
	}

	if ($properties['check_homepage'] == 0 && ($properties['check_email'] == 2 OR $properties['check_email'] == 3)) {
		$asteriskMail = " mark-mail";
		$asteriskHPcorr = " mark-hp";
		$hidden_email_01 = "";
		$hidden_email_02 = "<span class=\"mark-mail\" style=\"display:inline-block;position:relative;left:-3px;\"></span> <span class=\"small-02\">".$fmsg[151]." ".$fmsg[125].".</span>";
	}
	elseif ($properties['check_homepage'] == 1 && ($properties['check_email'] == 2 OR $properties['check_email'] == 3)) {
		$asteriskMail = "";
		$asteriskHPcorr = "";
		$hidden_email_01 = " <span class=\"small-02\" style=\"font-weight:normal;\">(".$fmsg[125].")</span>";
		$hidden_email_02 = "";
	}
	else {
		$asteriskMail = $asteriskHPcorr = $hidden_email_01 = $hidden_email_02 = "";
	}

	$properties['statistic'] ? require_once("".$gbook_folder."/includes/stats.inc.php") : "";

	if ($properties['entry_length_limit']){
		$maxlenght 	= "<p class=\"aligncenter marg-five ".$fontsizeClass."\">(".$fmsg[316]." <span id=\"charleft\">".$properties['entry_length_maximum']."</span>)</p>";
		$textCounter = "textCounter();";
		$jsMaxInput = $properties['entry_length_maximum'];
		$jsMinInput = $properties['entry_length_minimum']-1;
	}

	$sql_template = $gbook->query("SELECT `bgcolor`, `bgimage`, `fontcolor`, `html`, `image_email`, `image_homepage`, `divalign`, `tablewidth`, `tdcolor`, `td2color`, `image_star`, `fontfamily`, `fontsize`, `linkcolor`, `hovercolor`, `insert_width` FROM `".$table."_template` WHERE `id` = '".$properties['default_template']."'");
	$template = $sql_template->fetch_assoc();
	$star_ico = $template['image_star'];

	($template['insert_width'] == 1) ? $formWidth = "myphpgb" : $formWidth = "insert-width";

	$gbFontSize = $template['fontsize'];
	$checkSize = substr($gbFontSize, -2);
	$myFontSize = str_replace($checkSize,"",$gbFontSize);

	(($myFontSize < 15 && $myFontSize > 5) || $myFontSize < 1) ? $fontsizeClass = 'normal-size' : '';

	if ($myFontSize > 18 OR ($myFontSize < 5 && $myFontSize > 1.1)) {
		$linkSymClass = 'external-large';
		$fontsizeClass = 'small-03';
	}

	(empty($properties['rating_text'])) ? ($rating_entry = $fmsg[352]) : ($rating_entry = $properties['rating_text']);
	($setLang !== $langFile) ? ($rating_entry = $fmsg[352]) : "";

?>