<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	Teile des Quellcodes des Spamfilters stammen von www.naturfotografie-digital.de/impressum/gaestebuch-spam-php-tipps.php

	02.01.2022
*/

	$nameVoc = true;		// Checks if there is at least one (or more) vowel(s) in the name of the author of an entry 	-> disable: false
	$ref = true;			// Checks the referrer of the "insert.php" page 												-> disable: false
	$fastClick = true;		// Checks if an entry was written with more than 30 keystrokes per second 						-> disable: false

	$filtered = $count_spamwords = $count_http = $count_https = $count_ftp = $count_www = $count_both1 = $count_both2 = $count_both3 = $check_redirect = $check_redirect1 = $check_redirect2 = $check_redirect3 = 0;
	$gefiltert = $warning = "";
	$hostname = $_SERVER['SERVER_NAME'];

	(isset($_COOKIE['myphpgb-language'])) ? include("".$gbook_folder."/lang/".$langFile.".php") : "";

	if($properties['no_spam_entries']) {
		$website = str_replace ("http://","", $_POST['homepage']);
		$eintrag = " ".$_POST['name']." ".$_POST['email']." ".$_POST['town']." ".$_POST['country']." ".$website." ".$_POST['betreff']." ".$_POST['text']." ";

		$erlaubte = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".$allowed_characters." 0123456789.";

		$anzahl = strlen($eintrag);

		for ($i=0; $i<$anzahl; $i++) {
			$zeichen = substr ( $eintrag, $i, 1 );
			$c = substr_count($erlaubte, $zeichen);

			if ($c < 1)	{
				$eintrag = str_replace ($zeichen, " ", $eintrag);
			}
		}

		while (substr_count ($eintrag, "  ") > 0) {
			$eintrag = str_replace ("  "," ", $eintrag);
		}

		$sql_select_spam = $gbook->query("SELECT `spamword`  FROM  `".$table."_spam`");

		while ($blacklist = $sql_select_spam->fetch_assoc()) {
			$spamword = $blacklist['spamword'];

			$count_spamwords = substr_count(strtolower($eintrag), $spamword, 0);

			if ($count_spamwords > 0) {
				$filtered = $filtered + $count_spamwords;
				$gefiltert = $gefiltert.$spamword."<br />";
			}
		}

		if ($filtered > 0) {
			$warning .= "".$fmsg[252]."<br /><br />".$fmsg[253]."<br /><br />".$gefiltert."<br />".$fmsg[254]." -".$filtered."- <br /><br />";
		}
	}

	if((isset($_POST['repeat_email']) && $_POST['repeat_email']) OR (isset($_POST['website_url']) && $_POST['website_url']) OR (isset($_POST['star']) && $_POST['star'] == 6)) {
		$filtered = $filtered + 5;
		$warning .= "".$fmsg[251]."<br /><br />";
	}

	if ($nameVoc){
		$voc = array('a','à','á','â','ã','ä','å','æ','e','è','é','ê','ě','ë','i','ì','í','î','ï','o','ð','ò','ó','ô','õ','ö','ø','u','ů','ù','ú','û','ü','y','ý','þ','ÿ');

		$inputName = $_POST['name'];
		$checkName = str_ireplace($voc, "", $inputName);

		$count_inputName = $inputName != "" ? strlen($inputName) : 0;
		$count_checkName = $checkName != "" ? strlen($checkName) : 0;

		if ($count_checkName == $count_inputName) {
			$filtered = $filtered + 1;
			$warning .= "".$fmsg[211]."<br /><br />";
		}
	}

	if ($ref){
		$insert_referrer = $_POST['woher'];

		if (substr_count($insert_referrer, $hostname) != 1) {
			$filtered = $filtered + 3;
			$warning .= "".$fmsg[278]."<br /><br />";
		}
	}

	if($properties['no_spam_links']) {
		$count_http	= substr_count(strtolower($_POST['text']), 'http://', 0);
		$count_https = substr_count(strtolower($_POST['text']), 'https://', 0);
		$count_ftp = substr_count(strtolower($_POST['text']), 'ftp://', 0);
		$count_www = substr_count(strtolower($_POST['text']), 'www.', 0);
		$count_both1 = substr_count(strtolower($_POST['text']), 'http://www.', 0);
		$count_both2 = substr_count(strtolower($_POST['text']), 'https://www.', 0);
		$count_both3 = substr_count(strtolower($_POST['text']), 'ftp://www.', 0);

		$count_links 	= $count_http + $count_https + $count_ftp + $count_www - $count_both1 - $count_both2 - $count_both3;
		$max_links 		= $properties['max_links'];
		$spam_links 	= $count_links - $max_links;

		if ($count_links > $max_links) {
			$filtered = $filtered + $spam_links;
			$warning .= "".$fmsg[242]."".$spam_links."-.<br /><br />";
		}
	}

	$check_redirect1	= substr_count(strtolower($_POST['homepage']), 'http://', 0);
	$check_redirect2	= substr_count(strtolower($_POST['homepage']), 'https://', 0);
	$check_redirect3	= substr_count(strtolower($_POST['homepage']), 'ftp://', 0);

	$check_redirect = $check_redirect1 + $check_redirect2 + $check_redirect3;

	if ($check_redirect > 1) {
		$filtered = $filtered + 4;
		$warning .= "".$fmsg[229]."<br /><br />";
	}

	$findUrl = '[url=';
	$posUrl = stripos(($_POST['text']), $findUrl);

	if ($posUrl === 0) {
    	$filtered = $filtered + 1;
    	$warning .= "".$amsg[182]."<br /><br />";
	}

	$time_start = $_POST['startzeit'];
	$time_diff =  $time - $time_start;

	if ($time_diff == 0) {
		$time_diff = 0.1;
	}
	elseif ($time_diff < 0)	{
		$time_diff = 300;
	}

	if ($time_diff < 4)	{
		$filtered = $filtered + 5;
		$warning .= "".$fmsg[243]."<br /><br />";
	}
	elseif ($time_diff >= 4 AND $time_diff < 9)	{
		$filtered++;
		$warning .= "".$fmsg[244]."<br /><br />";
	}

	if ($time_diff > 3600) {
		$filtered++;
		$warning .= "".$fmsg[245]."<br /><br />";
	}

	if ($fastClick){
		$gesamteintr = $_POST['name'].$_POST['town'].$_POST['country'].$_POST['email'].$_POST['homepage'].$_POST['betreff'].$_POST['text'];

		$laenge_eintrag = strlen($gesamteintr);
		$chars_per_second= $laenge_eintrag/$time_diff;

		if ($chars_per_second > 30)	{
			$filtered++;
			$warning .= "".$fmsg[246]."<br /><br />".$fmsg[247]." ".$time_diff." ".$fmsg[248]."<br />".$fmsg[249]." ".$laenge_eintrag."<br />".$fmsg[250]." ".$chars_per_second."<br /><br />";
		}
	}

	(isset($_COOKIE['myphpgb-language'])) ? include("".$gbook_folder."/lang/".$setLang.".php") : "";

?>