<?php
/*
	myPHP Guestbook Copyright (C) 2003 - 2006  Claudio Pose
	myPHP Guestbook was an open source project of Networkarea.ch

	Version 3.x Copyright (C) 2011 - 2014 Christian Thomas, www.hostonline.de

	Version 4.x (MySQLi) Copyright (C) 2014 - 2022 Wolfgang Leverberg, www.php-guestbook.de

	This file is a part of myPHP Guestbook.
	myPHP Guestbook is free software; you can redistribute it and/or modify it under the terms of the 
	GNU General Public License as published by the Free Software Foundation; either version 3 of the 
	License, or (at your option) any later version.

	myPHP Guestbook is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
	even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

	See the GNU General Public License for more details.

	02.01.2022
*/
	$thisGBPage = array('myPHPGBook' => 1);

	require_once("".$gbook_folder."/includes/functions.inc.php");

	$_GET['userlang'] = isset($_GET['userlang']) ? htmlspecialchars($_GET['userlang'], ENT_QUOTES) : "";

	if(in_array($_GET['userlang'], $langArray, true)) {
		setcookie("myphpgb-language",$_GET['userlang'],0,"/","","",true);
		header("Location: ".$url02."gbook.php");
	}
	else {
		$_GET['userlang'] = "";
	}

	if (isset($_SESSION['entrie_quote'])) {
		unset($_SESSION['entrie_quote']);
	}

	$sql_properties = $gbook->query("SELECT `admin_email`,`bbcode`,`check_email`,`check_homepage`,`deactivate_html`,`default_style`,`default_template`,`entries_per_site`,`guestbook_status`,`guestbook_title`,`images_in_entries`,`links_in_sitefunction`,`max_word_length`,`release_entries`,
									`smilies`,`statistic`,`statistic_ban`,`quote_func`,`link_entry`,`check_town`,`check_country`,`button_link`,`rating`,`rating_text`,`choose_lang`, `administration`,`check_banner`,`privacy_hint`,`privacy_url`,`search_func`,`permalink` 
									FROM `".$table."_properties`") or die();
	$properties    = $sql_properties->fetch_assoc();
	$default_style = $properties['default_style'];

	$bad = $good = $separated_red = $separated_gray = $rating_entry = $show_rating_infos = $privMargLe = $star_ico = $quotation01 = $quotation02 = $quotation03 = $quotation04 = $copSign = "";
	$buttonReset = $errorSearch = $error_msg = $countMySearch = $search = $mySearch = $mySearchResult = $noSearch = $searchResult = $searchInfo = $pl_hind = $js_gbook = $oninput = $inputClass = "";
	$short_town = "30";
	$numSearch = 0;
	$show_default = true;

	$properties['link_entry'] = $properties['link_entry'] === NULL ? "" : $properties['link_entry'];
	$properties['rating_text'] = $properties['rating_text'] === NULL ? "" : $properties['rating_text'];
	$properties['privacy_url'] = $properties['privacy_url'] === NULL ? "" : $properties['privacy_url'];

	$query_count_entries = $gbook->query("SELECT `id` FROM `".$table."_entries` WHERE `status` != '0'");
	$count_entries       = $query_count_entries->num_rows;

	require_once("".$gbook_folder."/includes/lang.inc02.php");

	if (!empty($properties['search_func'])) {
		session_start();
		include("".$gbook_folder."/includes/search.inc.php");
	}

	$_SESSION['mysearch'] = isset($_SESSION['mysearch']) ? stripslashes(htmlspecialchars(strip_tags($_SESSION['mysearch']))) : "";

	$numSearch > 0 ? $count_entries = $numSearch : "";

	SCROLL_TO_TOP ? $scrollTop = 'onclick="mygbTop();"' : $scrollTop = '';

	(empty($properties['link_entry'])) ? ($link_entry = $fmsg[13]) : ($link_entry = $properties['link_entry']);
	($setLang !== $langFile) ? ($link_entry = $fmsg[13]) : "";

	if ($properties['button_link'] == 0) {
		$html_entry = "<p class=\"margtop-dyn\"><strong><a class=\"navi-page\" ".$scrollTop." href=\"".$url02."gbook_insert.php#anchor-gbooktop02\">".$link_entry."</a></strong></p>";
	}
	elseif ($properties['button_link'] == 1) {
		$html_entry = "<p class=\"button-marg\"><a class=\"button-gb insert-button\" style=\"font-size:1em;line-height:1.6em;\" ".$scrollTop." href=\"".$url02."gbook_insert.php#anchor-gbooktop02\"><span class=\"dynLine\">".$link_entry."</span></a></p>";
	}
	else {
		$html_entry = "<br />";
	}

	header("content-type: text/html; charset=\"".$encoding."\"" );
	header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate");
	header("Pragma: no-cache");

	if (isset($_GET['action']))	{
		$_GET['action'] = strip_tags(trim($_GET['action']));
		$_GET['action'] = $gbook->real_escape_string($_GET['action']);

		if ($_GET['action'] == "deactivate_entry") {
			include_once("".$gbook_folder."/admin/deactivate_entry.php");
		}
		elseif ($_GET['action'] == "activate_entry") {
			include_once("".$gbook_folder."/admin/activate_entry.php");
		}
		elseif ($_GET['action'] == "post") {
			$_GET['action'] = "post";
		}
		else {
			$_GET['action'] = "";
		}
	}
	else {
		$_GET['action'] = "";
	}

	if (isset($_GET['id']) && isset($_GET['number'])) {
		$_GET['id'] 	= trim($_GET['id']);
		$_GET['number'] = trim($_GET['number']);

		if (empty($_GET['id']) OR (!is_numeric($_GET['id']) OR intval($_GET['id']) != $_GET['id'])) {
			$_GET['id'] = $_GET['number'] = "";
		}
		elseif (empty($_GET['number']) OR (!is_numeric($_GET['number']) OR intval($_GET['number']) != $_GET['number'])) {
			$_GET['id'] = $_GET['number'] = "";
		}
	}
	else {
		$_GET['id'] = $_GET['number'] = "";
	}

	if ($properties['permalink'] && $_GET['action'] == "post" && $_GET['id'] != "") {
		$pl_hind = "<p class=\"button-marg\"><a class=\"button-gb insert-button\" href=\"".$url02."gbook.php#anchor-gbooktop\">".$fmsg[195]."</a></p>";
		$show_default = false;
		unset($_SESSION['mysearch']);
		$mySearch = $_POST['search'] = "";
	}

	$sql_template = $gbook->query("SELECT `bgcolor`, `bgimage`, `fontcolor`, `html`, `image_email`, `image_homepage`, `divalign`, `tablewidth`, `tdcolor`, `td2color`, `image_star`, `fontfamily`, `fontsize`, `linkcolor`, `hovercolor` FROM `".$table."_template` WHERE `id` = '".$properties['default_template']."'");
	$template = $sql_template->fetch_assoc();

	$gbFontSize = $template['fontsize'];
	$checkSize = substr($gbFontSize, -2);
	$myFontSize = str_replace($checkSize,"",$gbFontSize);

	(($myFontSize < 15 && $myFontSize > 5) || $myFontSize < 1) ? $fontsizeClass = 'normal-size' : '';

	if ($myFontSize > 18 OR ($myFontSize < 5 && $myFontSize > 1.1)) {
		$linkSymClass = 'external-large';
		$fontsizeClass = 'small-03';
	}

	if ($properties['rating']) {
		$star_ico = $template['image_star'];

		(empty($properties['rating_text'])) ? ($rating_entry = $fmsg[352]) : ($rating_entry = $properties['rating_text']);
		($setLang !== $langFile) ? ($rating_entry = $fmsg[352]) : "";

		$sql_show_rating = $gbook->query("SELECT `count_rating`, `average_rating` FROM `".$table."_rating`");
		list($count_rating, $average_rating) = $sql_show_rating->fetch_row();

		($properties['rating'] == 2) ? ($show_rating_infos = "<br />".$fmsg[358].": ".$average_rating." ".$fmsg[359]." ".$count_rating." ".$fmsg[360]."") : "";
	}

	if (!empty($properties['quote_func'])) {
		if ($properties['default_template'] < 9) {
			$quotation01 = "<div class=\"quote\"><a ".$scrollTop." href=\"".$url02."gbook_insert.php?action=quote&#38;id=";
			$quotation02 = "#anchor-gbooktop02\" title=\"".$fmsg[321]."\"><img title=\"".$fmsg[321]."\" src=\"".$url."images/quote.png\" width=\"20\" height=\"20\" alt=\"".$fmsg[321]."\" /></a></div>";
		}
		else {
			$quotation01 = "<a class=\"reply\" ".$scrollTop." href=\"".$url02."gbook_insert.php?action=quote&#38;id=";
			$quotation02 = "#anchor-gbooktop02\" title=\"".$fmsg[322]."\">".$fmsg[200]."</a>";
		}
		$quotation03 = "<a class=\"reply\" ".$scrollTop." href=\"".$url02."gbook_insert.php?action=quote&#38;id=";
		$quotation04 = "#anchor-gbooktop02\" title=\"".$fmsg[322]."\"></a>";
	}

	$quotes = array("<\$quote_ico\$>","<\$new_quote\$>");

	($properties['statistic'] == 1) ? require_once("".$gbook_folder."/includes/stats.inc.php") : "";

	if (!empty($properties['choose_lang']) && !empty($properties['search_func'])) {
		$startLeft = "i-left";
		$startRight = "i-right";
	}
	else {
		$startLeft = "i-mid";
		$startRight = "i-max";
	}

	if (isset($_GET['page'])) {
		(!is_numeric($_GET['page']) OR empty($_GET['page'])) ? $page = 1 : $page = $_GET['page'];
	}
	else {
		$page = 1;
	}

	$page = $gbook->real_escape_string($page);
	$pages_total = ceil($count_entries/$properties['entries_per_site']) ;
	$page_start = floor($page - $properties['links_in_sitefunction']/2) ;
	$page_start = $page_start <= 0 ?  1 : $page_start ;
	$page_end = ($page_start + $properties['links_in_sitefunction']-1) ;
	$page_end = $page_end >= $pages_total ?  $pages_total : $page_end ;
	$page_max = $page*$properties['entries_per_site'];
	$max_minus_per_page = $page_max-$properties['entries_per_site'];
	$page_entry_start = $count_entries-$max_minus_per_page+1;

?>